/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.event.ActionBarRenderEvent;
import com.wynntils.handlers.actionbar.event.ActionBarUpdatedEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.models.characterstats.actionbar.matchers.HealthBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.HealthTextSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.HotbarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.LevelSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.ManaBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.ManaTextSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.MeterBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.MeterEdgeAnimationSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.MeterTransitionSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.PowderSpecialSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.matchers.ProfessionExperienceSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.CombatExperienceSegment;
import com.wynntils.models.characterstats.actionbar.segments.HealthBarSegment;
import com.wynntils.models.characterstats.actionbar.segments.HealthTextSegment;
import com.wynntils.models.characterstats.actionbar.segments.LevelSegment;
import com.wynntils.models.characterstats.actionbar.segments.ManaBarSegment;
import com.wynntils.models.characterstats.actionbar.segments.ManaTextSegment;
import com.wynntils.models.characterstats.actionbar.segments.MeterBarSegment;
import com.wynntils.models.characterstats.actionbar.segments.PowderSpecialSegment;
import com.wynntils.models.characterstats.actionbar.segments.ProfessionExperienceSegment;
import com.wynntils.models.characterstats.type.MeterBarInfo;
import com.wynntils.models.characterstats.type.PowderSpecialInfo;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.wynn.InventoryUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import net.neoforged.bus.api.SubscribeEvent;

public final class CharacterStatsModel
extends Model {
    private final Set<Class<? extends ActionBarSegment>> hiddenSegments = new HashSet<Class<? extends ActionBarSegment>>();
    private int level = 0;
    private CappedValue health = CappedValue.EMPTY;
    private CappedValue mana = CappedValue.EMPTY;
    private CappedValue sprint = CappedValue.EMPTY;
    private PowderSpecialInfo powderSpecialInfo = PowderSpecialInfo.EMPTY;
    private boolean isProfessionExperience = false;

    public CharacterStatsModel() {
        super(List.of());
        Handlers.ActionBar.registerSegment(new HotbarSegmentMatcher());
        Handlers.ActionBar.registerSegment(new MeterBarSegmentMatcher());
        Handlers.ActionBar.registerSegment(new MeterEdgeAnimationSegmentMatcher());
        Handlers.ActionBar.registerSegment(new MeterTransitionSegmentMatcher());
        Handlers.ActionBar.registerSegment(new LevelSegmentMatcher());
        Handlers.ActionBar.registerSegment(new ManaBarSegmentMatcher());
        Handlers.ActionBar.registerSegment(new HealthBarSegmentMatcher());
        Handlers.ActionBar.registerSegment(new ManaTextSegmentMatcher());
        Handlers.ActionBar.registerSegment(new HealthTextSegmentMatcher());
        Handlers.ActionBar.registerSegment(new PowderSpecialSegmentMatcher());
        Handlers.ActionBar.registerSegment(new ProfessionExperienceSegmentMatcher());
    }

    @SubscribeEvent
    public void onActionBarRender(ActionBarRenderEvent event) {
        this.hiddenSegments.forEach(segment -> event.setSegmentEnabled((Class<? extends ActionBarSegment>)segment, false));
    }

    @SubscribeEvent
    public void onActionBarUpdate(ActionBarUpdatedEvent event) {
        event.runIfPresent(HealthTextSegment.class, this::updateHealth);
        event.runIfPresent(ManaTextSegment.class, this::updateMana);
        event.runIfPresent(MeterBarSegment.class, this::updateSprint);
        event.runIfPresent(PowderSpecialSegment.class, this::updatePowderSpecial);
        event.runIfPresent(CombatExperienceSegment.class, this::updateCombatExperience);
        event.runIfPresent(ProfessionExperienceSegment.class, this::updateProfessionExperience);
        event.runIfPresent(LevelSegment.class, this::updateLevel);
    }

    @SubscribeEvent
    public void onHeldItemChanged(ChangeCarriedItemEvent event) {
        this.powderSpecialInfo = PowderSpecialInfo.EMPTY;
    }

    public double getBlocksAboveGround() {
        double endY = (int)Math.ceil(McUtils.player().method_19538().field_1351) - 1;
        while (McUtils.mc().field_1687.method_8320(new class_2338(McUtils.player().method_24515().method_10263(), (int)endY, McUtils.player().method_24515().method_10260())).method_26215()) {
            if (!((endY -= 1.0) < (double)McUtils.mc().field_1687.method_31607())) continue;
            return -1.0;
        }
        endY += McUtils.mc().field_1687.method_30347(new class_2338(McUtils.player().method_24515().method_10263(), (int)endY, McUtils.player().method_24515().method_10260()));
        return McUtils.player().method_19538().field_1351 - endY;
    }

    public CappedValue getItemCooldownTicks(class_1799 itemStack) {
        class_1796 cooldowns = McUtils.player().method_7357();
        class_2960 resourceLocation = cooldowns.method_62836(itemStack);
        class_1796.class_1797 cooldown = (class_1796.class_1797)cooldowns.field_8024.get(resourceLocation);
        if (cooldown == null || cooldown.comp_3083 >= cooldown.comp_3084) {
            return CappedValue.EMPTY;
        }
        int remaining = cooldown.comp_3084 - cooldowns.field_8025;
        if (remaining <= 0) {
            return CappedValue.EMPTY;
        }
        return new CappedValue(remaining, cooldown.comp_3084 - cooldown.comp_3083);
    }

    public List<GearInfo> getWornGear() {
        GearInfo gearInfo;
        class_746 player = McUtils.player();
        ArrayList<GearInfo> wornGear = new ArrayList<GearInfo>();
        Optional<GearItem> mainHandGearItem = Models.Item.asWynnItem(player.method_6047(), GearItem.class);
        if (mainHandGearItem.isPresent() && (gearInfo = mainHandGearItem.get().getItemInfo()).type().isValidWeapon(Models.Character.getClassType()) && Models.CombatXp.getCombatLevel().current() >= gearInfo.requirements().level()) {
            wornGear.add(gearInfo);
        }
        player.method_5661().forEach(itemStack -> {
            Optional<GearItem> armorGearItem = Models.Item.asWynnItem((class_1799)itemStack, GearItem.class);
            if (armorGearItem.isPresent()) {
                GearInfo gearInfo = armorGearItem.get().getItemInfo();
                wornGear.add(gearInfo);
            }
        });
        InventoryUtils.getAccessories((class_1657)player).forEach(itemStack -> {
            Optional<GearItem> accessoryGearItem = Models.Item.asWynnItem((class_1799)itemStack, GearItem.class);
            if (accessoryGearItem.isPresent()) {
                GearInfo gearInfo = accessoryGearItem.get().getItemInfo();
                wornGear.add(gearInfo);
            }
        });
        return wornGear;
    }

    public int getLevel() {
        return this.level;
    }

    public Optional<CappedValue> getHealth() {
        if (this.health == CappedValue.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(this.health);
    }

    public Optional<CappedValue> getMana() {
        if (this.mana == CappedValue.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(this.mana);
    }

    public Optional<CappedValue> getSprint() {
        if (this.sprint == CappedValue.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(this.sprint);
    }

    public Optional<PowderSpecialInfo> getPowderSpecialInfo() {
        if (this.powderSpecialInfo == PowderSpecialInfo.EMPTY) {
            return Optional.empty();
        }
        return Optional.of(this.powderSpecialInfo);
    }

    public void setHideHealth(boolean shouldHide) {
        if (shouldHide) {
            this.hiddenSegments.add(HealthTextSegment.class);
            this.hiddenSegments.add(HealthBarSegment.class);
        } else {
            this.hiddenSegments.remove(HealthTextSegment.class);
            this.hiddenSegments.remove(HealthBarSegment.class);
        }
    }

    public void setHideMana(boolean shouldHide) {
        if (shouldHide) {
            this.hiddenSegments.add(ManaTextSegment.class);
            this.hiddenSegments.add(ManaBarSegment.class);
        } else {
            this.hiddenSegments.remove(ManaTextSegment.class);
            this.hiddenSegments.remove(ManaBarSegment.class);
        }
    }

    public void setHidePowder(boolean shouldHide) {
        if (shouldHide) {
            this.hiddenSegments.add(PowderSpecialSegment.class);
        } else {
            this.hiddenSegments.remove(PowderSpecialSegment.class);
        }
    }

    private void updateLevel(LevelSegment segment) {
        if (this.isProfessionExperience) {
            return;
        }
        this.level = segment.getLevel();
    }

    private void updateHealth(HealthTextSegment segment) {
        this.health = segment.getHealth();
    }

    private void updateMana(ManaTextSegment segment) {
        this.mana = segment.getMana();
    }

    private void updateSprint(MeterBarSegment segment) {
        MeterBarInfo meterBarInfo = segment.getMeterBarInfo();
        if (meterBarInfo.type() != MeterBarInfo.MeterActionType.SPRINT && meterBarInfo.type() != MeterBarInfo.MeterActionType.BOTH) {
            return;
        }
        this.sprint = meterBarInfo.value();
    }

    private void updatePowderSpecial(PowderSpecialSegment segment) {
        this.powderSpecialInfo = segment.getPowderSpecialInfo();
    }

    private void updateCombatExperience(CombatExperienceSegment combatExperienceSegment) {
        this.isProfessionExperience = false;
    }

    private void updateProfessionExperience(ProfessionExperienceSegment professionExperienceSegment) {
        this.isProfessionExperience = true;
    }
}

