/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear.type;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.StringUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public enum GearTier {
    NORMAL(class_124.field_1068, 0, 0.0f, "common"),
    UNIQUE(class_124.field_1054, 3, 0.5f),
    RARE(class_124.field_1076, 8, 1.2f),
    SET(class_124.field_1060, 8, 1.2f),
    LEGENDARY(class_124.field_1075, 12, 4.5f),
    FABLED(class_124.field_1061, 16, 8.0f),
    MYTHIC(class_124.field_1064, 90, 18.0f),
    CRAFTED(class_124.field_1062, 0, 0.0f);

    private final class_124 chatFormatting;
    private final int baseCost;
    private final float costMultiplier;
    private final String apiName;

    private GearTier(class_124 chatFormatting, int baseCost, float costMultiplier) {
        this.chatFormatting = chatFormatting;
        this.baseCost = baseCost;
        this.costMultiplier = costMultiplier;
        this.apiName = this.name().toLowerCase(Locale.ROOT);
    }

    private GearTier(class_124 chatFormatting, int baseCost, float costMultiplier, String apiName) {
        this.chatFormatting = chatFormatting;
        this.baseCost = baseCost;
        this.costMultiplier = costMultiplier;
        this.apiName = apiName;
    }

    public static GearTier fromString(String typeStr) {
        for (GearTier type : GearTier.values()) {
            if (!type.apiName.equals(typeStr.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        return null;
    }

    public static GearTier fromStyledText(StyledText text) {
        Optional<class_124> chatFormatting = Arrays.stream(class_124.values()).filter(class_124::method_543).filter(c -> c.method_532().intValue() == text.getFirstPart().getPartStyle().getStyle().method_10973().method_27716()).findFirst();
        if (chatFormatting.isPresent()) {
            return GearTier.fromChatFormatting(chatFormatting.get());
        }
        return null;
    }

    public static GearTier fromComponent(class_2561 component) {
        return GearTier.fromStyledText(StyledText.fromComponent(component));
    }

    public static GearTier fromChatFormatting(class_124 formatting) {
        return Arrays.stream(GearTier.values()).filter(t -> t.getChatFormatting() == formatting).findFirst().orElse(null);
    }

    public static GearTier fromBoxDamage(int damage) {
        if (damage > 6) {
            return NORMAL;
        }
        return GearTier.values()[damage];
    }

    public class_124 getChatFormatting() {
        return this.chatFormatting;
    }

    public int getGearIdentificationCost(int level) {
        return this.baseCost + (int)Math.ceil((float)level * this.costMultiplier);
    }

    public String getName() {
        return StringUtils.capitalizeFirst(this.name().toLowerCase(Locale.ROOT));
    }

    public String toString() {
        return this.getName();
    }
}

