/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.guild;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.container.scriptedquery.QueryBuilder;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.models.guild.event.GuildEvent;
import com.wynntils.models.guild.label.GuildSeasonLeaderboardLabelParser;
import com.wynntils.models.guild.profile.GuildProfile;
import com.wynntils.models.guild.type.DiplomacyInfo;
import com.wynntils.models.guild.type.GuildInfo;
import com.wynntils.models.guild.type.GuildMemberInfo;
import com.wynntils.models.guild.type.GuildRank;
import com.wynntils.models.players.event.HadesRelationsUpdateEvent;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.screens.guildlog.GuildLogHolder;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.CappedValue;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.neoforged.bus.api.SubscribeEvent;

public final class GuildModel
extends Model {
    private static final Gson GUILD_PROFILE_GSON = new GsonBuilder().registerTypeHierarchyAdapter(GuildProfile.class, (Object)new GuildProfile.GuildProfileDeserializer()).registerTypeHierarchyAdapter(GuildInfo.class, (Object)new GuildInfo.GuildDeserializer()).create();
    private static final Pattern GUILD_NAME_MATCHER = Pattern.compile("^\u00a7[3a](\u00a7l)?(?<name>[a-zA-Z\\s]+?)(\u00a7b)? \\[[a-zA-Z]{3,4}\\]$");
    private static final Pattern GUILD_RANK_MATCHER = Pattern.compile("^\u00a77Rank: \u00a7f(Recruit|Recruiter|Captain|Strategist|Chief|Owner)$");
    private static final Pattern MSG_LEFT_GUILD = Pattern.compile("^\u00a73You have left \u00a7b[a-zA-Z\\s]+\u00a73!$");
    private static final Pattern MSG_JOINED_GUILD = Pattern.compile("^\u00a73You have joined \u00a7b([a-zA-Z\\s]+)\u00a73!$");
    private static final Pattern MEMBER_LEFT = Pattern.compile("\u00a7b(\ue006\ue002|\ue001) (.+) has left the guild");
    private static final Pattern MEMBER_JOIN = Pattern.compile("\u00a7b(\ue006\ue002|\ue001) (.+) has joined the guild, say hello!");
    private static final Pattern MEMBER_KICKED = Pattern.compile("\u00a7b(\ue006\ue002|\ue001) .+ has kicked (.+) from the guild");
    private static final Pattern MSG_RANK_CHANGED = Pattern.compile("\u00a7b(\ue006\ue002|\ue001) [\\w]{1,16} has set ([\\w]{1,16}) guild rank from \u00a73(?: )?(?:Recruit|Recruiter|Captain|Strategist|Chief|Owner)\u00a7b to \u00a73(?: )?(Recruit|Recruiter|Captain|Strategist|Chief|Owner)$");
    private static final Pattern MSG_OBJECTIVE_COMPLETED = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b (?<player>[\\w]{1,16}) has finished their weekly objective\\.$");
    private static final Pattern MSG_NEW_OBJECTIVES = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b New Weekly Guild Objectives are being assigned\\.$");
    private static final Pattern MSG_TRIBUTE_SCHEDULED = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b (?<sender>[\\w\\s]+) scheduled (?<resource>[\u24bf\u24c0\u24b8\u24b7]?) ?(?<amount>\\d+) (Ore|Wood|Fish|Crops?|Emeralds?) per hour to (?<recipient>[a-zA-Z\\s]+)$");
    private static final Pattern MSG_TRIBUTE_STOPPED = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b (?<sender>[\\w\\s]+) stopped scheduling (?<resource>Emeralds|Fish|Ore|Wood|Crops) to (?<recipient>[a-zA-Z\\s]+)$");
    private static final Pattern MSG_ALLIANCE_FORMED = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b (?<actor>[\\w\\s]+) formed an alliance with (?<guild>[a-zA-Z\\s]+)$");
    private static final Pattern MSG_ALLIANCE_REVOKED = Pattern.compile("^\u00a73\\[INFO\\]\u00a7b (?<actor>[\\w\\s]+) revoked the alliance with (?<guild>[a-zA-Z\\s]+)$");
    private static final Pattern LEVEL_MATCHER = Pattern.compile("^\u00a7b\u00a7l[a-zA-Z\\s]+\u00a73\u00a7l \\[Lv\\. (?<level>\\d+)\\]$");
    private static final Pattern LEVEL_PROGRESS_MATCHER = Pattern.compile("^\u00a7f(?<current>[\\d\\,]+)\u00a77/(?<required>[\\d\\,]+) XP$");
    private static final Pattern OBJECTIVES_COMPLETED_PATTERN = Pattern.compile("^\u00a76Current Guild Goal: \u00a7f(?<completed>\\d+)\u00a77/(?<goal>\\d+)$");
    private static final Pattern OBJECTIVE_STREAK_PATTERN = Pattern.compile("^\u00a7a- \u00a77Streak: \u00a7f(?<streak>\\d+)$");
    private static final Pattern TRIBUTE_PATTERN = Pattern.compile("^\u00a7[abef6](?<symbol>[\u24b7\u24b8\u24c0\u24bf]?) ?(?<amount>[+-]\\d+) (Ore|Wood|Fish|Crops?|Emeralds?) per Hour$");
    private static final Pattern ALLIED_GUILD_PATTERN = Pattern.compile("\u00a7a- \u00a77(?<name>[a-zA-Z\\s]+) \\[[a-zA-Z]{3,4}\\]");
    private static final int MEMBERS_SLOT = 0;
    private static final int OBJECTIVES_SLOT = 13;
    private static final int DIPLOMACY_MENU_SLOT = 26;
    private static final List<Integer> DIPLOMACY_SLOTS = List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8));
    private static final List<Integer> OBJECTIVE_GOALS = List.of(Integer.valueOf(5), Integer.valueOf(15), Integer.valueOf(30));
    private Map<String, GuildProfile> guildProfileMap = new HashMap<String, GuildProfile>();
    private final Map<String, DiplomacyInfo> guildDiplomacyMap = new HashMap<String, DiplomacyInfo>();
    private String guildName = "";
    private GuildRank guildRank;
    private int guildLevel = -1;
    private Set<String> guildMembers = new TreeSet<String>();
    private CappedValue guildLevelProgress = CappedValue.EMPTY;
    private CappedValue objectivesCompletedProgress = CappedValue.EMPTY;
    private int objectiveStreak = 0;
    private static final int REQUEST_RATELIMIT = 300000;
    private long lastGuildRequest = 0L;

    public GuildModel() {
        super(List.of());
        Handlers.Label.registerParser(new GuildSeasonLeaderboardLabelParser());
        Handlers.WrappedScreen.registerWrappedScreen(new GuildLogHolder());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_ATHENA_GUILD_LIST).handleJsonArray(this::handleGuildList);
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match e) {
        StyledText message = e.getMessage();
        if (message.matches(MSG_LEFT_GUILD)) {
            this.leaveGuild();
            WynntilsMod.info("User left guild");
            return;
        }
        Matcher joinedGuildMatcher = message.getMatcher(MSG_JOINED_GUILD);
        if (joinedGuildMatcher.matches()) {
            this.guildName = joinedGuildMatcher.group(1);
            this.guildRank = GuildRank.RECRUIT;
            WynntilsMod.info("User joined guild " + this.guildName + " as a " + String.valueOf((Object)this.guildRank));
            WynntilsMod.postEvent(new GuildEvent.Joined(this.guildName));
            this.requestGuildMembers();
            return;
        }
        StyledText unwrapped = StyledTextUtils.unwrap(message).stripAlignment();
        Matcher memberLeftMatcher = unwrapped.getMatcher(MEMBER_LEFT);
        if (memberLeftMatcher.matches()) {
            String playerName = memberLeftMatcher.group(2);
            WynntilsMod.info("Player " + playerName + " left guild");
            this.guildMembers.remove(playerName);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(Set.of(playerName), HadesRelationsUpdateEvent.ChangeType.REMOVE));
            return;
        }
        Matcher memberJoinedMatcher = unwrapped.getMatcher(MEMBER_JOIN);
        if (memberJoinedMatcher.matches()) {
            String playerName = memberJoinedMatcher.group(2);
            WynntilsMod.info("Player " + playerName + " joined guild");
            this.guildMembers.add(playerName);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(Set.of(playerName), HadesRelationsUpdateEvent.ChangeType.ADD));
            return;
        }
        Matcher memberKickedMatcher = unwrapped.getMatcher(MEMBER_KICKED);
        if (memberKickedMatcher.matches()) {
            String playerName = memberKickedMatcher.group(2);
            if (playerName.equals(McUtils.playerName())) {
                this.leaveGuild();
                WynntilsMod.info("User kicked from guild");
                return;
            }
            WynntilsMod.info("Player " + playerName + " kicked from guild");
            this.guildMembers.remove(playerName);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(Set.of(playerName), HadesRelationsUpdateEvent.ChangeType.REMOVE));
            return;
        }
        Matcher rankChangedMatcher = message.getMatcher(MSG_RANK_CHANGED);
        if (rankChangedMatcher.matches()) {
            if (!rankChangedMatcher.group(2).equals(McUtils.playerName())) {
                return;
            }
            this.guildRank = GuildRank.valueOf(rankChangedMatcher.group(4).toUpperCase(Locale.ROOT));
            WynntilsMod.info("User's guild rank changed to " + String.valueOf((Object)this.guildRank));
            return;
        }
        Matcher objectiveCompletedMatcher = message.getMatcher(MSG_OBJECTIVE_COMPLETED);
        if (objectiveCompletedMatcher.matches()) {
            int currentGoal = this.objectivesCompletedProgress.max();
            int completed = this.objectivesCompletedProgress.current() + 1;
            for (int goal : OBJECTIVE_GOALS) {
                if (completed < currentGoal) break;
                currentGoal = goal;
            }
            this.objectivesCompletedProgress = new CappedValue(completed, currentGoal);
            if (objectiveCompletedMatcher.group("player").equals(McUtils.playerName())) {
                ++this.objectiveStreak;
            }
            return;
        }
        if (message.matches(MSG_NEW_OBJECTIVES)) {
            this.objectivesCompletedProgress = new CappedValue(0, OBJECTIVE_GOALS.getFirst());
            return;
        }
        Matcher tributeScheduledMatcher = message.getMatcher(MSG_TRIBUTE_SCHEDULED);
        if (tributeScheduledMatcher.matches()) {
            String recipient = tributeScheduledMatcher.group("recipient");
            GuildResource resource = GuildResource.fromSymbol(tributeScheduledMatcher.group("resource"));
            int amount = Integer.parseInt(tributeScheduledMatcher.group("amount"));
            if (recipient.equals(this.guildName)) {
                this.guildDiplomacyMap.get(tributeScheduledMatcher.group("sender")).storeReceivedTribute(resource, amount);
            } else {
                this.guildDiplomacyMap.get(recipient).storeSentTribute(resource, amount);
            }
            return;
        }
        Matcher tributeStoppedMatcher = message.getMatcher(MSG_TRIBUTE_STOPPED);
        if (tributeStoppedMatcher.matches()) {
            String recipient = tributeStoppedMatcher.group("recipient");
            GuildResource resource = GuildResource.fromName(tributeStoppedMatcher.group("resource"));
            if (recipient.equals(this.guildName)) {
                this.guildDiplomacyMap.get(tributeStoppedMatcher.group("sender")).removeReceivedTribute(resource);
            } else {
                this.guildDiplomacyMap.get(recipient).removeSentTribute(resource);
            }
            return;
        }
        Matcher allianceFormedMatcher = message.getMatcher(MSG_ALLIANCE_FORMED);
        if (allianceFormedMatcher.matches()) {
            String guild = allianceFormedMatcher.group("guild");
            if (guild.equals(this.guildName)) {
                guild = allianceFormedMatcher.group("actor");
            }
            this.guildDiplomacyMap.put(guild, new DiplomacyInfo(guild));
            return;
        }
        Matcher allianceRevokedMatcher = message.getMatcher(MSG_ALLIANCE_REVOKED);
        if (allianceRevokedMatcher.matches()) {
            String guild = allianceRevokedMatcher.group("guild");
            if (guild.equals(this.guildName)) {
                guild = allianceRevokedMatcher.group("actor");
            }
            this.guildDiplomacyMap.remove(guild);
            return;
        }
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Pre event) {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 containerScreen = (class_476)class_4372;
        StyledText title = StyledText.fromComponent(containerScreen.method_25440());
        if (!title.matches(Pattern.compile("[a-zA-Z\\s]+: Diplomacy"))) {
            return;
        }
        this.parseDiplomacyContent(event.getItems());
    }

    @SubscribeEvent
    public void onAuth(HadesEvent.Authenticated event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        this.requestGuildMembers();
    }

    public void parseGuildInfoFromGuildMenu(class_1799 guildInfoItem) {
        LinkedList<StyledText> lore = LoreUtils.getLore(guildInfoItem);
        for (StyledText line : lore) {
            Matcher guildNameMatcher = line.getMatcher(GUILD_NAME_MATCHER);
            if (guildNameMatcher.matches()) {
                this.guildName = guildNameMatcher.group("name");
                continue;
            }
            Matcher rankMatcher = line.getMatcher(GUILD_RANK_MATCHER);
            if (!rankMatcher.matches()) continue;
            this.guildRank = GuildRank.valueOf(rankMatcher.group(1).toUpperCase(Locale.ROOT));
            break;
        }
        WynntilsMod.info("Successfully parsed guild name and rank, " + String.valueOf((Object)this.guildRank) + " of " + this.guildName);
        this.requestGuildMembers();
    }

    public void addGuildContainerQuerySteps(QueryBuilder builder) {
        builder.conditionalThen(container -> !this.guildName.isEmpty(), QueryStep.clickOnSlot(26).expectContainerTitle("[a-zA-Z\\s]+: Manage").processIncomingContainer(this::parseGuildContainer)).conditionalThen(container -> !this.guildName.isEmpty(), QueryStep.clickOnSlot(26).expectContainerTitle("[a-zA-Z\\s]+: Diplomacy").processIncomingContainer(content -> this.parseDiplomacyContent(content.items())));
    }

    private void parseGuildContainer(ContainerContent container) {
        class_1799 membersItem = container.items().get(0);
        class_1799 objectivesItem = container.items().get(13);
        class_1799 diplomacyItem = container.items().get(26);
        Matcher levelMatcher = StyledText.fromComponent(membersItem.method_7964()).getNormalized().getMatcher(LEVEL_MATCHER);
        if (!levelMatcher.matches()) {
            WynntilsMod.warn("Could not parse guild level from item: " + String.valueOf(LoreUtils.getLore(membersItem)));
            return;
        }
        this.guildLevel = Integer.parseInt(levelMatcher.group("level"));
        Matcher levelProgressMatcher = LoreUtils.matchLoreLine(membersItem, 0, LEVEL_PROGRESS_MATCHER);
        if (!levelMatcher.matches()) {
            WynntilsMod.warn("Could not parse guild level progress from item: " + String.valueOf(LoreUtils.getLore(membersItem)));
            return;
        }
        long current = Long.parseLong(levelProgressMatcher.group("current").replace(",", ""));
        long required = Long.parseLong(levelProgressMatcher.group("required").replace(",", ""));
        this.guildLevelProgress = new CappedValue((int)((double)current / (double)required * 100.0), 100);
        for (StyledText line : LoreUtils.getLore(objectivesItem)) {
            Matcher objectivesCompletedMatcher = line.getMatcher(OBJECTIVES_COMPLETED_PATTERN);
            if (objectivesCompletedMatcher.matches()) {
                this.objectivesCompletedProgress = new CappedValue(Integer.parseInt(objectivesCompletedMatcher.group("completed")), Integer.parseInt(objectivesCompletedMatcher.group("goal")));
                continue;
            }
            Matcher objectiveStreakMatcher = line.getMatcher(OBJECTIVE_STREAK_PATTERN);
            if (!objectiveStreakMatcher.matches()) continue;
            this.objectiveStreak = Integer.parseInt(objectiveStreakMatcher.group("streak"));
            break;
        }
        for (StyledText line : LoreUtils.getLore(diplomacyItem)) {
            Matcher alliedGuildMatcher = line.getMatcher(ALLIED_GUILD_PATTERN);
            if (!alliedGuildMatcher.matches()) continue;
            String alliedGuildName = alliedGuildMatcher.group("name");
            this.guildDiplomacyMap.put(alliedGuildName, new DiplomacyInfo(alliedGuildName));
        }
        WynntilsMod.info("Successfully parsed guild info for guild " + this.guildName);
    }

    private void parseDiplomacyContent(List<class_1799> items) {
        this.guildDiplomacyMap.clear();
        for (int slot : DIPLOMACY_SLOTS) {
            class_1799 diplomacyItem = items.get(slot);
            if (diplomacyItem.method_7960()) continue;
            Matcher alliedGuildNameMatcher = StyledText.fromComponent(diplomacyItem.method_7964()).getNormalized().getMatcher(GUILD_NAME_MATCHER);
            if (!alliedGuildNameMatcher.matches()) {
                WynntilsMod.warn("Could not parse allied guild from item: " + String.valueOf(LoreUtils.getLore(diplomacyItem)));
                continue;
            }
            String alliedGuildName = alliedGuildNameMatcher.group("name");
            DiplomacyInfo diplomacyInfo = this.guildDiplomacyMap.computeIfAbsent(alliedGuildName, DiplomacyInfo::new);
            for (StyledText line : LoreUtils.getLore(diplomacyItem)) {
                Matcher tributeMatcher = line.getMatcher(TRIBUTE_PATTERN);
                if (!tributeMatcher.matches()) continue;
                GuildResource resource = GuildResource.fromSymbol(tributeMatcher.group("symbol"));
                int amount = Integer.parseInt(tributeMatcher.group("amount"));
                if (amount > 0) {
                    diplomacyInfo.storeReceivedTribute(resource, amount);
                    continue;
                }
                diplomacyInfo.storeSentTribute(resource, Math.abs(amount));
            }
        }
        WynntilsMod.info("Successfully parsed tributes for guild " + this.guildName);
    }

    public Set<String> getGuildMembers() {
        return Collections.unmodifiableSet(this.guildMembers);
    }

    public boolean isGuildMember(String username) {
        return this.guildMembers.contains(username);
    }

    public void requestGuildMembers() {
        if (this.guildName != null && !this.guildName.isEmpty()) {
            if (System.currentTimeMillis() - this.lastGuildRequest > 300000L || this.guildMembers.isEmpty()) {
                CompletableFuture<GuildInfo> completableFuture = this.getGuild(this.guildName);
                completableFuture.whenComplete((guild, throwable) -> {
                    if (throwable != null) {
                        WynntilsMod.error("Failed to retrieve players guild (" + this.guildName + ") info", throwable);
                    } else {
                        this.guildMembers = guild.guildMembers().stream().map(GuildMemberInfo::username).collect(Collectors.toSet());
                        this.lastGuildRequest = System.currentTimeMillis();
                        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(this.guildMembers, HadesRelationsUpdateEvent.ChangeType.RELOAD));
                    }
                });
            } else {
                WynntilsMod.info("Skipping guild member list update request because it was requested recently.");
                WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(this.guildMembers, HadesRelationsUpdateEvent.ChangeType.RELOAD));
            }
        }
    }

    private void leaveGuild() {
        WynntilsMod.postEvent(new GuildEvent.Left(this.guildName));
        this.guildName = "";
        this.guildRank = null;
        this.guildLevel = -1;
        this.guildMembers = new TreeSet<String>();
        this.guildLevelProgress = CappedValue.EMPTY;
        this.objectivesCompletedProgress = CappedValue.EMPTY;
        this.objectiveStreak = 0;
        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.GuildMemberList(this.guildMembers, HadesRelationsUpdateEvent.ChangeType.RELOAD));
    }

    public String getGuildName() {
        return this.guildName;
    }

    public GuildRank getGuildRank() {
        return this.guildRank;
    }

    public boolean isInGuild() {
        return !this.guildName.isEmpty();
    }

    public int getGuildLevel() {
        return this.guildLevel;
    }

    public void setGuildLevel(int guildLevel) {
        this.guildLevel = guildLevel;
    }

    public CappedValue getGuildLevelProgress() {
        return this.guildLevelProgress;
    }

    public void setGuildLevelProgress(CappedValue guildLevelProgress) {
        this.guildLevelProgress = guildLevelProgress;
    }

    public CappedValue getObjectivesCompletedProgress() {
        return this.objectivesCompletedProgress;
    }

    public int getObjectiveStreak() {
        return this.objectiveStreak;
    }

    public Optional<GuildProfile> getGuildProfile(String name) {
        return Optional.ofNullable(this.guildProfileMap.get(name));
    }

    public Set<String> getAllGuilds() {
        return this.guildProfileMap.keySet();
    }

    public int getReceivedTributesForResource(GuildResource resource) {
        return this.guildDiplomacyMap.values().stream().map(DiplomacyInfo::getReceivedTributes).mapToInt(tributes -> tributes.getOrDefault((Object)resource, 0)).sum();
    }

    public int getSentTributesForResource(GuildResource resource) {
        return this.guildDiplomacyMap.values().stream().map(DiplomacyInfo::getSentTributes).mapToInt(tributes -> tributes.getOrDefault((Object)resource, 0)).sum();
    }

    public boolean isAllied(String guildName) {
        return this.guildDiplomacyMap.containsKey(guildName);
    }

    public String getGuildNameFromString(String input) {
        if (this.guildProfileMap.containsKey(input)) {
            return input;
        }
        for (String key : this.guildProfileMap.keySet()) {
            if (!key.equalsIgnoreCase(input)) continue;
            return key;
        }
        for (GuildProfile profile : this.guildProfileMap.values()) {
            if (!profile.prefix().equals(input)) continue;
            return profile.name();
        }
        for (GuildProfile profile : this.guildProfileMap.values()) {
            if (!profile.prefix().equalsIgnoreCase(input)) continue;
            return profile.name();
        }
        return input;
    }

    public CompletableFuture<GuildInfo> getGuild(String inputName) {
        CompletableFuture<GuildInfo> future = new CompletableFuture<GuildInfo>();
        String guildToSearch = this.getGuildNameFromString(inputName);
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.DATA_WYNNCRAFT_GUILD, Map.of("name", guildToSearch));
        apiResponse.handleJsonObject(json -> {
            Type type = new TypeToken<GuildInfo>(){}.getType();
            future.complete((GuildInfo)GUILD_PROFILE_GSON.fromJson((JsonElement)json, type));
        }, onError -> future.complete(null));
        return future;
    }

    public CustomColor getColor(String guildName) {
        return this.getGuildProfile(guildName).map(GuildProfile::color).orElse(CustomColor.colorForStringHash(guildName));
    }

    private void handleGuildList(JsonArray json) {
        Type type = new TypeToken<List<GuildProfile>>(){}.getType();
        List guildProfiles = (List)GUILD_PROFILE_GSON.fromJson((JsonElement)json, type);
        Map<String, GuildProfile> profileMap = guildProfiles.stream().filter(Objects::nonNull).collect(Collectors.toMap(GuildProfile::name, guildProfile -> guildProfile));
        this.guildProfileMap = profileMap;
    }
}

