/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.items.items.gui.SkillPointItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class SkillPointAnnotator
implements GuiItemAnnotator {
    private static final Pattern SKILL_POINT_PATTERN = Pattern.compile("^[\udb00\udc00-\udb00\udc0f]\u00a7dUpgrade your \u00a7[2ebcf][\ue001\ue003\ue004\ue002\ue000] (.*)\u00a7d skill$");
    private static final Pattern LORE_PATTERN = Pattern.compile("^.*\u00a77(-?\\d+) points\u00a7r.*\u00a76-?\\d+ points$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = name.getMatcher(SKILL_POINT_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        String skillName = matcher.group(1);
        Skill skill = Skill.fromString(skillName);
        Matcher m = LoreUtils.matchLoreLine(itemStack, 3, LORE_PATTERN);
        if (!m.matches()) {
            return null;
        }
        int skillPoints = Integer.parseInt(m.group(1));
        return new SkillPointItem(skill, skillPoints);
    }
}

