/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.npcdialogue;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.overlays.NpcDialogueFeature;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueRemoved;
import com.wynntils.models.npcdialogue.type.NpcDialogue;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;

public final class NpcDialogueModel
extends Model {
    private static final Pattern NEW_QUEST_STARTED = Pattern.compile("^\u00a76\u00a7lNew Quest Started: \u00a7e\u00a7l(.*)$");
    private final Set<Feature> dialogExtractionDependents = new HashSet<Feature>();
    private NpcDialogue currentDialogue = NpcDialogue.EMPTY;
    private ConcurrentLinkedQueue<NpcDialogue> confirmationlessDialogues = new ConcurrentLinkedQueue();

    public NpcDialogueModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        this.currentDialogue = NpcDialogue.EMPTY;
        this.confirmationlessDialogues = new ConcurrentLinkedQueue();
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        long now = System.currentTimeMillis();
        this.confirmationlessDialogues.removeIf(dialogue -> now >= dialogue.removeTime());
    }

    public void addNpcDialogExtractionDependent(Feature feature) {
        this.dialogExtractionDependents.add(feature);
    }

    public boolean isNpcDialogExtractionRequired() {
        return !this.dialogExtractionDependents.isEmpty() && this.dialogExtractionDependents.stream().allMatch(Feature::isEnabled);
    }

    public long calculateMessageReadTime(List<StyledText> msg) {
        NpcDialogueFeature feature = Managers.Feature.getFeatureInstance(NpcDialogueFeature.class);
        int words = StyledText.join(" ", msg).split(" ").length;
        long delay = (long)((Integer)feature.dialogAutoProgressDefaultTime.get()).intValue() + (long)words * (long)((Integer)feature.dialogAutoProgressAdditionalTimePerWord.get()).intValue();
        return delay;
    }

    public boolean isInDialogue() {
        return this.currentDialogue != NpcDialogue.EMPTY && !this.currentDialogue.isEmpty();
    }

    public NpcDialogue getCurrentDialogue() {
        return this.currentDialogue;
    }

    public List<NpcDialogue> getConfirmationlessDialogues() {
        return List.copyOf(this.confirmationlessDialogues);
    }

    public void handleDialogue(List<StyledText> chatMessage, boolean protectedDialogue, NpcDialogueType type) {
        WynntilsMod.info("[NPC] Type: " + String.valueOf((Object)type) + (protectedDialogue ? " <protected>" : " <not protected>") + (chatMessage.isEmpty() ? " <empty>" : ""));
        chatMessage.forEach(s -> WynntilsMod.info("[NPC] " + String.valueOf(s.isEmpty() ? "<empty>" : s)));
        this.confirmationlessDialogues.removeIf(d -> d.currentDialogue().equals(chatMessage));
        if (type == NpcDialogueType.NONE) {
            NpcDialogue oldDialogue = this.currentDialogue;
            this.currentDialogue = NpcDialogue.EMPTY;
            WynntilsMod.postEvent(new NpcDialogueRemoved(oldDialogue));
            return;
        }
        if (type == NpcDialogueType.NORMAL && this.currentDialogue.currentDialogue().equals(chatMessage)) {
            return;
        }
        NpcDialogue dialogue = new NpcDialogue(chatMessage, type, protectedDialogue, System.currentTimeMillis(), System.currentTimeMillis() + this.calculateMessageReadTime(chatMessage));
        if (type == NpcDialogueType.CONFIRMATIONLESS) {
            this.confirmationlessDialogues.add(dialogue);
        } else {
            this.currentDialogue = dialogue;
        }
        if (!chatMessage.isEmpty() && chatMessage.getFirst().getMatcher(NEW_QUEST_STARTED).find()) {
            Managers.Notification.queueMessage(chatMessage.getFirst());
        }
        NpcDialogueProcessingEvent.Pre event = new NpcDialogueProcessingEvent.Pre(dialogue);
        WynntilsMod.postEvent(event);
        event.addProcessingStep(future -> future.whenComplete((styledTexts, throwable) -> {
            if (throwable != null) {
                WynntilsMod.error("Failed to process NPC dialogue.", throwable);
                return;
            }
            if (styledTexts.isEmpty()) {
                WynntilsMod.warn("Dialogue processing returned an empty list.");
                WynntilsMod.postEvent(new NpcDialogueProcessingEvent.Post(dialogue, dialogue.currentDialogue()));
                return;
            }
            if (dialogue.currentDialogue().equals(styledTexts)) {
                WynntilsMod.postEvent(new NpcDialogueProcessingEvent.Post(dialogue, (List<StyledText>)styledTexts));
                return;
            }
            styledTexts.forEach(styledText -> WynntilsMod.info("[Translated NPC] " + styledText.getString()));
            NpcDialogue newDialogue = new NpcDialogue((List<StyledText>)styledTexts, dialogue.dialogueType(), dialogue.isProtected(), dialogue.addTime(), dialogue.removeTime());
            if (dialogue == this.currentDialogue) {
                this.currentDialogue = newDialogue;
            } else if (this.confirmationlessDialogues.remove(dialogue)) {
                this.confirmationlessDialogues.add(newDialogue);
            }
            Managers.TickScheduler.scheduleNextTick(() -> {
                NpcDialogueProcessingEvent.Post postEvent = new NpcDialogueProcessingEvent.Post(newDialogue, (List<StyledText>)styledTexts);
                WynntilsMod.postEvent(postEvent);
            });
        }));
    }
}

