/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.PlayerJoinedWorldEvent;
import com.wynntils.mc.event.PlayerTeamEvent;
import com.wynntils.models.players.WynntilsUser;
import com.wynntils.models.players.type.WynnPlayerInfo;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.TimedSet;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_268;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.neoforged.bus.api.SubscribeEvent;

public final class PlayerModel
extends Model {
    private static final Gson PLAYER_GSON = new GsonBuilder().registerTypeHierarchyAdapter(WynnPlayerInfo.class, (Object)new WynnPlayerInfo.WynnPlayerInfoDeserializer()).create();
    private static final String ATHENA_USER_NOT_FOUND = "User not found";
    private static final Pattern GHOST_WORLD_PATTERN = Pattern.compile("^_([A-Z]+)(\\d+)$");
    private static final int ERROR_TIMEOUT_MINUTE = 5;
    private static final int MAX_ERRORS = 5;
    private static final int MAX_USER_ERRORS = 3;
    private final Map<UUID, WynntilsUser> users = new ConcurrentHashMap<UUID, WynntilsUser>();
    private final Set<UUID> usersWithoutWynntilsAccount = ConcurrentHashMap.newKeySet();
    private final Set<UUID> fetching = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Integer> ghosts = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, String> nameMap = new ConcurrentHashMap<UUID, String>();
    private final TimedSet<Object> errors = new TimedSet(5L, TimeUnit.MINUTES, true, ConcurrentHashMap::newKeySet);
    private final Map<UUID, Integer> userFailures = new ConcurrentHashMap<UUID, Integer>();

    public PlayerModel() {
        super(List.of());
        this.errors.clear();
        this.userFailures.clear();
    }

    public boolean isLocalPlayer(class_1657 player) {
        return player.method_5667().version() == 4;
    }

    public boolean isLocalPlayer(String name) {
        return !this.isNpcName(StyledText.fromString(name)) && McUtils.mc().field_1687.method_8428().method_1196().contains(name);
    }

    public boolean isNpc(class_1657 player) {
        StyledText scoreboardName = StyledText.fromString(player.method_5820());
        return this.isNpcName(scoreboardName);
    }

    public boolean isDisplayPlayer(class_1657 player) {
        UUID uuid = player.method_5667();
        if (uuid.version() == 4) {
            return false;
        }
        if (this.isNpc(player)) {
            return false;
        }
        return !this.isPlayerGhost(player);
    }

    public boolean isPlayerGhost(class_1657 player) {
        return this.ghosts.containsKey(player.method_5667());
    }

    public UUID getUserUUID(class_1657 player) {
        UUID uuid = player.method_5667();
        if (uuid == null) {
            return null;
        }
        if (uuid.version() == 4) {
            return uuid;
        }
        UUID uuidV4 = new UUID(uuid.getMostSignificantBits() & 0xFFFFFFFFFFFF0FFFL | 0x4000L, uuid.getLeastSignificantBits());
        return uuidV4;
    }

    public WynntilsUser getWynntilsUser(class_1657 player) {
        return this.users.getOrDefault(this.getUserUUID(player), null);
    }

    public Stream<String> getAllPlayerNames() {
        return this.nameMap.values().stream();
    }

    public void reset() {
        this.fetching.clear();
        this.errors.clear();
        this.userFailures.clear();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            this.clearNameMap();
            this.reset();
        }
        if (event.getNewState() == WorldState.WORLD) {
            this.clearGhostCache();
            this.loadSelf();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerJoinedWorldEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        class_1657 player = event.getPlayer();
        if (player == null || player.method_5667() == null) {
            return;
        }
        StyledText name = StyledText.fromString(player.method_7334().getName());
        if (this.isNpc(player) || this.isDisplayPlayer(player)) {
            return;
        }
        this.loadUser(Models.Player.getUserUUID(player), name.getString());
    }

    @SubscribeEvent
    public void onAddPlayerToTeam(PlayerTeamEvent.Added event) {
        class_640 playerInfo = McUtils.mc().method_1562().method_2874(event.getUsername());
        if (playerInfo == null) {
            return;
        }
        UUID uuid = playerInfo.method_2966().getId();
        if (uuid == null) {
            return;
        }
        class_268 playerTeam = event.getPlayerTeam();
        Matcher matcher = GHOST_WORLD_PATTERN.matcher(playerTeam.method_1197());
        if (!matcher.matches()) {
            this.ghosts.remove(uuid);
            return;
        }
        int world = Integer.parseInt(matcher.group(2));
        this.ghosts.put(uuid, world);
    }

    public void loadSelf() {
        class_746 player = McUtils.player();
        if (player == null) {
            return;
        }
        UUID uuid = player.method_5667();
        if (uuid == null) {
            return;
        }
        this.users.remove(uuid);
        this.usersWithoutWynntilsAccount.remove(uuid);
        this.userFailures.remove(uuid);
        this.loadUser(uuid, player.method_5820());
    }

    private void loadUser(UUID uuid, String userName) {
        if (this.fetching.contains(uuid)) {
            return;
        }
        if (this.users.containsKey(uuid) || this.usersWithoutWynntilsAccount.contains(uuid)) {
            return;
        }
        if (this.errors.getEntries().size() >= 5) {
            return;
        }
        if (this.userFailures.getOrDefault(uuid, 0) >= 3) {
            return;
        }
        this.fetching.add(uuid);
        this.nameMap.put(uuid, userName);
        ApiResponse apiResponse = Services.WynntilsAccount.callApi(UrlId.API_ATHENA_USER_INFO, Map.of("uuid", uuid.toString()));
        apiResponse.handleJsonObject(json -> {
            if (json.has("error") && json.get("error").getAsString().equals(ATHENA_USER_NOT_FOUND)) {
                this.usersWithoutWynntilsAccount.add(uuid);
                this.fetching.remove(uuid);
                return;
            }
            if (!json.has("user")) {
                this.fetching.remove(uuid);
                this.saveUserFailures(uuid, userName);
                return;
            }
            WynntilsUser user = (WynntilsUser)WynntilsMod.GSON.fromJson((JsonElement)json.getAsJsonObject("user"), WynntilsUser.class);
            this.users.put(uuid, user);
            this.fetching.remove(uuid);
            RenderSystem.recordRenderCall(() -> Services.Cosmetics.loadCosmeticTextures(uuid, user));
        }, onError -> {
            this.errors.put(System.currentTimeMillis());
            this.saveUserFailures(uuid, userName);
        });
    }

    public CompletableFuture<WynnPlayerInfo> getPlayer(String username) {
        CompletableFuture<WynnPlayerInfo> future = new CompletableFuture<WynnPlayerInfo>();
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.DATA_WYNNCRAFT_PLAYER, Map.of("username", username));
        apiResponse.handleJsonObject(json -> {
            Type type = new TypeToken<WynnPlayerInfo>(){}.getType();
            future.complete((WynnPlayerInfo)PLAYER_GSON.fromJson((JsonElement)json, type));
        }, onError -> future.complete(null));
        return future;
    }

    private void saveUserFailures(UUID uuid, String userName) {
        this.userFailures.putIfAbsent(uuid, 0);
        this.userFailures.compute(uuid, (k, v) -> v + 1);
        if (this.errors.getEntries().size() == 5) {
            WynntilsMod.error("Athena user lookup has repeating failures. Disabling future lookups temporarily.");
        }
        if (this.userFailures.get(uuid) == 3) {
            WynntilsMod.error("Athena user lookup has repeating failures for user " + userName + ". Disabling future lookups for the user, until a reset.");
        }
    }

    private void clearNameMap() {
        this.nameMap.clear();
    }

    private void clearGhostCache() {
        this.ghosts.clear();
    }

    private boolean isNpcName(StyledText name) {
        return name.equals("\ue000");
    }

    private boolean isNpcUuid(UUID uuid) {
        return uuid.version() == 2;
    }
}

