/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.Download;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.AdvancementUpdateEvent;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.TerritoryInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.territories.type.TerritoryConnectionType;
import com.wynntils.screens.territorymanagement.TerritoryManagementHolder;
import com.wynntils.services.map.pois.TerritoryPoi;
import com.wynntils.services.map.type.TerritoryDefenseFilterType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_161;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2374;
import net.minecraft.class_8779;
import net.neoforged.bus.api.SubscribeEvent;

public final class TerritoryModel
extends Model {
    private static final int IN_GUILD_TERRITORY_UPDATE_MS = 15000;
    private static final int NO_GUILD_TERRITORY_UPDATE_MS = 300000;
    private static final Gson TERRITORY_PROFILE_GSON = new GsonBuilder().registerTypeHierarchyAdapter(TerritoryProfile.class, (Object)new TerritoryProfile.TerritoryDeserializer()).create();
    private final Map<String, TerritoryPoi> territoryPoiMap = new ConcurrentHashMap<String, TerritoryPoi>();
    private Map<String, TerritoryProfile> territoryProfileMap = new HashMap<String, TerritoryProfile>();
    private Set<TerritoryPoi> allTerritoryPois = new HashSet<TerritoryPoi>();
    private ScheduledFuture<?> scheduledFuture;
    private final ScheduledExecutorService timerExecutor = new ScheduledThreadPoolExecutor(1);
    private long lastGuildUpdate = 0L;
    private static final int MAX_ERRORS = 3;
    private int athenaCheckErrors = 0;
    private UrlId lookupUrl = UrlId.DATA_ATHENA_TERRITORY_LIST_V2;

    public TerritoryModel() {
        super(List.of());
        Handlers.WrappedScreen.registerWrappedScreen(new TerritoryManagementHolder());
    }

    @Override
    public void reloadData() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = this.timerExecutor.scheduleWithFixedDelay(this::updateTerritoryProfileMap, 0L, 15000L, TimeUnit.MILLISECONDS);
    }

    public TerritoryProfile getTerritoryProfile(String name) {
        return this.territoryProfileMap.get(name);
    }

    public TerritoryProfile getTerritoryProfileFromShortName(String shortName, Collection<String> excludedTerritories) {
        return this.territoryProfileMap.values().stream().filter(profile -> excludedTerritories.stream().noneMatch(ex -> ex.equals(profile.getName()))).filter(profile -> profile.getName().startsWith(shortName)).min(Comparator.comparing(TerritoryProfile::getName)).orElse(null);
    }

    public Stream<String> getTerritoryNames() {
        return this.territoryProfileMap.keySet().stream();
    }

    public Set<TerritoryPoi> getTerritoryPois() {
        return this.allTerritoryPois;
    }

    public List<TerritoryPoi> getTerritoryPoisFromAdvancement() {
        return new ArrayList<TerritoryPoi>(this.territoryPoiMap.values());
    }

    public List<TerritoryPoi> getFilteredTerritoryPoisFromAdvancement(int filterLevel, TerritoryDefenseFilterType filterType) {
        return switch (filterType) {
            default -> throw new MatchException(null, null);
            case TerritoryDefenseFilterType.HIGHER -> this.territoryPoiMap.values().stream().filter(poi -> poi.getTerritoryInfo().getDefences().getLevel() >= filterLevel).collect(Collectors.toList());
            case TerritoryDefenseFilterType.LOWER -> this.territoryPoiMap.values().stream().filter(poi -> poi.getTerritoryInfo().getDefences().getLevel() <= filterLevel).collect(Collectors.toList());
            case TerritoryDefenseFilterType.DEFAULT -> this.territoryPoiMap.values().stream().filter(poi -> poi.getTerritoryInfo().getDefences().getLevel() == filterLevel).collect(Collectors.toList());
        };
    }

    private TerritoryPoi getTerritoryPoiFromAdvancement(String name) {
        return this.territoryPoiMap.get(name);
    }

    public TerritoryProfile getTerritoryProfileForPosition(class_2374 position) {
        return this.territoryProfileMap.values().stream().filter(profile -> profile.insideArea(position)).findFirst().orElse(null);
    }

    @SubscribeEvent
    public void onAdvancementUpdate(AdvancementUpdateEvent event) {
        HashMap<String, TerritoryInfo> tempMap = new HashMap<String, TerritoryInfo>();
        for (class_8779 class_87792 : event.getAdded()) {
            class_185 displayInfo;
            String territoryName;
            class_161 advancement = class_87792.comp_1920();
            if (advancement.comp_1913().isEmpty() || tempMap.containsKey(territoryName = StyledText.fromComponent((displayInfo = (class_185)advancement.comp_1913().get()).method_811()).replaceAll("\\[", "").replaceAll("\\]", "").trim().getStringWithoutFormatting()) || territoryName.isEmpty()) continue;
            boolean headquarters = displayInfo.method_815() == class_189.field_1250;
            StyledText description = StyledText.fromComponent(displayInfo.method_817());
            StyledText[] colored = description.split("\n");
            String[] raw = description.getStringWithoutFormatting().split("\n");
            TerritoryInfo container = new TerritoryInfo(raw, colored, headquarters);
            tempMap.put(territoryName, container);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            TerritoryProfile territoryProfile = this.getTerritoryProfile((String)entry.getKey());
            if (territoryProfile == null) continue;
            this.territoryPoiMap.put((String)entry.getKey(), new TerritoryPoi(() -> this.getTerritoryProfile((String)entry.getKey()), (TerritoryInfo)entry.getValue()));
        }
    }

    public Map<TerritoryItem, TerritoryConnectionType> getTerritoryConnections(List<TerritoryItem> territoryItems) {
        TerritoryItem hqTerritory = territoryItems.stream().filter(TerritoryItem::isHeadquarters).findFirst().orElse(null);
        if (hqTerritory == null) {
            return territoryItems.stream().collect(Collectors.toMap(item -> item, item -> TerritoryConnectionType.UNCONNECTED));
        }
        HashSet<TerritoryItem> hqConnectedTerritories = new HashSet<TerritoryItem>();
        HashSet<TerritoryItem> connectedTerritories = new HashSet<TerritoryItem>();
        connectedTerritories.add(hqTerritory);
        LinkedList<TerritoryItem> queue = new LinkedList<TerritoryItem>();
        queue.add(hqTerritory);
        while (!queue.isEmpty()) {
            TerritoryItem current = (TerritoryItem)queue.poll();
            for (TerritoryItem territoryItem : territoryItems) {
                if (connectedTerritories.contains(territoryItem)) continue;
                TerritoryInfo currentTerritoryInfo = this.getTerritoryPoiFromAdvancement(current.getName()).getTerritoryInfo();
                TerritoryInfo territoryInfo = this.getTerritoryPoiFromAdvancement(territoryItem.getName()).getTerritoryInfo();
                if ((territoryInfo == null || !territoryInfo.getTradingRoutes().contains(current.getName())) && (currentTerritoryInfo == null || !currentTerritoryInfo.getTradingRoutes().contains(territoryItem.getName()))) continue;
                connectedTerritories.add(territoryItem);
                queue.add(territoryItem);
                if (!territoryItem.isHeadquarters() && !current.isHeadquarters()) continue;
                hqConnectedTerritories.add(territoryItem);
            }
        }
        return territoryItems.stream().collect(Collectors.toMap(item -> item, item -> {
            if (item.isHeadquarters()) {
                return TerritoryConnectionType.HEADQUARTERS;
            }
            if (hqConnectedTerritories.contains(item)) {
                return TerritoryConnectionType.HEADQUARTERS_CONNECTION;
            }
            return connectedTerritories.contains(item) ? TerritoryConnectionType.CONNECTED : TerritoryConnectionType.UNCONNECTED;
        }));
    }

    private void updateTerritoryProfileMap() {
        if (!Models.Guild.isInGuild() && System.currentTimeMillis() - this.lastGuildUpdate < 300000L) {
            return;
        }
        Download dl = Managers.Net.download(this.lookupUrl);
        dl.handleJsonObject(json -> {
            HashMap<String, TerritoryProfile> tempMap = new HashMap<String, TerritoryProfile>();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                JsonObject territoryObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                territoryObject.addProperty("name", (String)entry.getKey());
                TerritoryProfile territoryProfile = (TerritoryProfile)TERRITORY_PROFILE_GSON.fromJson((JsonElement)territoryObject, TerritoryProfile.class);
                tempMap.put((String)entry.getKey(), territoryProfile);
            }
            this.territoryProfileMap = tempMap;
            this.allTerritoryPois = this.territoryProfileMap.values().stream().map(TerritoryPoi::new).collect(Collectors.toSet());
            this.lastGuildUpdate = System.currentTimeMillis();
        }, onError -> {
            WynntilsMod.warn("Failed to update territory data.");
            if (this.lookupUrl == UrlId.DATA_ATHENA_TERRITORY_LIST_V2) {
                ++this.athenaCheckErrors;
                if (this.athenaCheckErrors >= 3) {
                    WynntilsMod.warn("Reached maximum errors for Athena territory lookup, switching to Wynncraft API.");
                    this.lookupUrl = UrlId.DATA_WYNNCRAFT_TERRITORY_LIST;
                }
            }
        });
    }
}

