/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.war;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.models.war.bossbar.WarTowerBar;
import com.wynntils.models.war.event.GuildWarEvent;
import com.wynntils.models.war.event.GuildWarTowerEffectEvent;
import com.wynntils.models.war.type.WarBattleInfo;
import com.wynntils.models.war.type.WarTowerState;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.List;
import java.util.Optional;
import net.neoforged.bus.api.SubscribeEvent;

public final class GuildWarTowerModel
extends Model {
    private static final int EFFECT_PROC_MS = 3200;
    private static final StyledText AURA_TITLE = StyledText.fromString("\u00a74\u00a7n[!]\u00a77 Tower \u00a76Aura");
    private static final StyledText VOLLEY_TITLE = StyledText.fromString("\u00a74\u00a7n[!]\u00a77 Tower \u00a7dVolley");
    private final TrackedBar WarTowerBar = new WarTowerBar();
    private WarBattleInfo warBattleInfo = null;
    private long lastAuraProc = 0L;
    private long lastVolleyProc = 0L;

    public GuildWarTowerModel() {
        super(List.of());
        Handlers.BossBar.registerBar(this.WarTowerBar);
    }

    @SubscribeEvent
    public void onSubtitle(SubtitleSetTextEvent event) {
        StyledText styledText = StyledText.fromComponent(event.getComponent());
        if (styledText.equals(AURA_TITLE)) {
            this.lastAuraProc = System.currentTimeMillis();
            WynntilsMod.postEvent(new GuildWarTowerEffectEvent.AuraSpawned());
            return;
        }
        if (styledText.equals(VOLLEY_TITLE)) {
            this.lastVolleyProc = System.currentTimeMillis();
            WynntilsMod.postEvent(new GuildWarTowerEffectEvent.VolleySpawned());
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.resetTowerState();
    }

    public long getLastAuraProc() {
        return this.lastAuraProc;
    }

    public long getLastVolleyProc() {
        return this.lastVolleyProc;
    }

    public int getEffectLength() {
        return 3200;
    }

    public long getRemainingTimeUntilAura() {
        return Math.max(-1L, (long)this.getEffectLength() - (System.currentTimeMillis() - this.getLastAuraProc()));
    }

    public long getRemainingTimeUntilVolley() {
        return Math.max(-1L, (long)this.getEffectLength() - (System.currentTimeMillis() - this.getLastVolleyProc()));
    }

    public Optional<WarBattleInfo> getWarBattleInfo() {
        return Optional.ofNullable(this.warBattleInfo);
    }

    public void onTowerDamaged(String guild, String territory, WarTowerState towerState) {
        if (this.warBattleInfo != null && !this.warBattleInfo.getTerritory().equals(territory)) {
            WynntilsMod.warn("War tower territory was not reset correctly, warBattleInfo has %s, war bar has %s".formatted(this.warBattleInfo.getTerritory(), territory));
            this.resetTowerState();
        }
        if (this.warBattleInfo == null) {
            this.warBattleInfo = new WarBattleInfo(territory, guild, towerState);
            WynntilsMod.postEvent(new GuildWarEvent.Started(this.warBattleInfo));
        } else {
            this.warBattleInfo.addNewState(towerState);
        }
    }

    public void resetTowerState() {
        if (this.warBattleInfo == null) {
            return;
        }
        WarBattleInfo oldBattleInfo = this.warBattleInfo;
        this.warBattleInfo = null;
        WynntilsMod.postEvent(new GuildWarEvent.Ended(oldBattleInfo));
    }
}

