/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnitem;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.festival.type.FestivalType;
import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.gear.type.GearMajorId;
import com.wynntils.models.gear.type.GearMetaInfo;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.FixedStats;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.type.DropRestriction;
import com.wynntils.models.wynnitem.type.ItemMaterial;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import com.wynntils.models.wynnitem.type.ItemObtainType;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import com.wynntils.utils.wynn.WynnUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractItemInfoDeserializer<T>
implements JsonDeserializer<T> {
    protected Pair<String, String> parseNames(JsonObject json) {
        String normalizedApiName;
        String internalName;
        String displayName = json.get("name").getAsString();
        if (displayName.equals(internalName = JsonUtils.getNullableJsonString(json, "internalName")) && !(normalizedApiName = WynnUtils.normalizeBadString(displayName)).equals(displayName)) {
            displayName = normalizedApiName;
        }
        return Pair.of(displayName, internalName);
    }

    protected GearType parseType(JsonObject json) {
        String typeString = json.has("accessoryType") ? json.get("accessoryType").getAsString() : (json.has("weaponType") ? json.get("weaponType").getAsString() : (json.has("armourType") ? json.get("armourType").getAsString() : json.get("type").getAsString()));
        return GearType.fromString(typeString);
    }

    protected GearMetaInfo parseMetaInfo(JsonObject json, String apiName, GearType type) {
        GearRestrictions restrictions = this.parseRestrictions(json);
        ItemMaterial material = this.parseMaterial(json);
        if (material == null || material.itemStack().method_7960()) {
            WynntilsMod.warn("Failed to parse material for " + json.get("name").getAsString());
            material = ItemMaterial.fromItemId("minecraft:air", 0);
        }
        List<ItemObtainInfo> obtainInfo = this.parseObtainInfo(json);
        Optional<StyledText> loreOpt = this.parseLore(json);
        Optional<String> apiNameOpt = Optional.ofNullable(apiName);
        boolean allowCraftsman = JsonUtils.getNullableJsonBoolean(json, "allowCraftsman");
        boolean preIdentifiedItem = JsonUtils.getNullableJsonBoolean(json, "identified");
        return new GearMetaInfo(restrictions, material, obtainInfo, loreOpt, apiNameOpt, allowCraftsman, preIdentifiedItem);
    }

    protected List<ItemObtainInfo> parseObtainInfo(JsonObject json) {
        ArrayList<ItemObtainInfo> obtainInfo = new ArrayList<ItemObtainInfo>();
        DropRestriction dropRestriction = DropRestriction.NEVER;
        if (json.has("dropRestriction")) {
            dropRestriction = DropRestriction.fromApiName(json.get("dropRestriction").getAsString());
        }
        ArrayList<ItemObtainType> itemObtainTypes = new ArrayList<ItemObtainType>();
        if (json.has("dropMeta")) {
            List<String> dropMetaTypes = JsonUtils.getStringOrStringArray(JsonUtils.getNullableJsonObject(json, "dropMeta"), "type");
            for (String dropMetaType : dropMetaTypes) {
                ItemObtainType itemObtainType = ItemObtainType.fromApiName(dropMetaType);
                if (itemObtainType != null) {
                    itemObtainTypes.add(itemObtainType);
                    continue;
                }
                WynntilsMod.warn("Unknown drop meta type: " + dropMetaType);
            }
        }
        if (itemObtainTypes.isEmpty()) {
            JsonObject requirements = JsonUtils.getNullableJsonObject(json, "requirements");
            int level = requirements.get("level").getAsInt();
            String levelRange = "Between level " + Math.max(level - 4, 1) + " and " + (level + 4);
            if (dropRestriction == DropRestriction.NORMAL) {
                obtainInfo.add(new ItemObtainInfo(ItemObtainType.NORMAL_MOB_DROP, Optional.of(levelRange)));
                obtainInfo.add(new ItemObtainInfo(ItemObtainType.LOOT_CHEST, Optional.of(levelRange)));
            } else if (dropRestriction == DropRestriction.LOOT_CHEST) {
                obtainInfo.add(new ItemObtainInfo(ItemObtainType.CAVE_LOOT_CHEST, Optional.of(levelRange)));
            }
        } else {
            JsonObject dropMeta = json.getAsJsonObject("dropMeta");
            if (dropMeta != null && !dropMeta.isJsonNull()) {
                for (ItemObtainType itemObtainType : itemObtainTypes) {
                    if (itemObtainType == ItemObtainType.UNKNOWN) continue;
                    if (itemObtainType == ItemObtainType.EVENT) {
                        FestivalType festivalType = FestivalType.valueOf(dropMeta.get("event").getAsString().toUpperCase(Locale.ROOT));
                        obtainInfo.add(new ItemObtainInfo(ItemObtainType.EVENT, Optional.of(festivalType.getFullName())));
                        continue;
                    }
                    obtainInfo.add(new ItemObtainInfo(itemObtainType, Optional.of(dropMeta.get("name").getAsString())));
                }
            } else if (dropRestriction == DropRestriction.DUNGEON) {
                obtainInfo.add(new ItemObtainInfo(ItemObtainType.FORGERY_CHEST, Optional.empty()));
            }
        }
        if (obtainInfo.isEmpty()) {
            obtainInfo.add(ItemObtainInfo.UNKNOWN);
        }
        return List.copyOf(obtainInfo);
    }

    private Optional<StyledText> parseLore(JsonObject json) {
        String lore = JsonUtils.getNullableJsonString(json, "lore");
        if (lore == null) {
            return Optional.empty();
        }
        return Optional.of(StyledText.fromString(lore));
    }

    protected GearRestrictions parseRestrictions(JsonObject json) {
        String restrictions = JsonUtils.getNullableJsonString(json, "restrictions");
        if (restrictions == null) {
            return GearRestrictions.NONE;
        }
        return GearRestrictions.fromString(restrictions);
    }

    private List<ItemObtainType> parseObtainTypes(JsonObject json) {
        ArrayList<ItemObtainType> types = new ArrayList<ItemObtainType>();
        JsonObject dropMeta = JsonUtils.getNullableJsonObject(json, "dropMeta");
        if (dropMeta.has("type")) {
            JsonElement type = dropMeta.get("type");
            try {
                if (type.isJsonArray()) {
                    for (JsonElement typeElement : type.getAsJsonArray()) {
                        types.add(ItemObtainType.fromApiName(typeElement.getAsString()));
                    }
                } else {
                    types.add(ItemObtainType.fromApiName(type.getAsString()));
                }
            }
            catch (Exception e) {
                WynntilsMod.warn("Failed to parse obtain types for " + json.get("name").getAsString());
                WynntilsMod.warn("Obtain types: " + type.toString());
                return List.of();
            }
        }
        return List.copyOf(types);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ItemMaterial parseMaterial(JsonObject json) {
        String iconFormat;
        if (!json.has("icon")) {
            WynntilsMod.warn("Item DB does not contain an icon for " + json.get("name").getAsString());
            return ItemMaterial.fromItemId("minecraft:air", 0);
        }
        JsonObject icon = json.getAsJsonObject("icon");
        switch (iconFormat = icon.get("format").getAsString()) {
            case "attribute": {
                int customModelDataInt;
                JsonObject value = icon.get("value").getAsJsonObject();
                JsonElement customModelData = value.get("customModelData");
                if (customModelData.isJsonObject()) {
                    JsonObject customModelDataObject = customModelData.getAsJsonObject();
                    JsonArray floats = customModelDataObject.getAsJsonArray("rangeDispatch");
                    if (floats != null && !floats.isEmpty()) {
                        customModelDataInt = floats.get(0).getAsInt();
                        return ItemMaterial.fromItemId(value.get("id").getAsString(), customModelDataInt);
                    }
                    WynntilsMod.warn("Item DB does not contain custom model data for " + json.get("name").getAsString());
                    return ItemMaterial.fromItemId("minecraft:air", 0);
                }
                if (!customModelData.isJsonPrimitive()) {
                    WynntilsMod.warn("Unexpected custom model data format for " + json.get("name").getAsString());
                    return ItemMaterial.fromItemId("minecraft:air", 0);
                }
                if (customModelData.getAsJsonPrimitive().isNumber()) {
                    customModelDataInt = customModelData.getAsInt();
                    return ItemMaterial.fromItemId(value.get("id").getAsString(), customModelDataInt);
                }
                customModelDataInt = Integer.parseInt(customModelData.getAsString());
                return ItemMaterial.fromItemId(value.get("id").getAsString(), customModelDataInt);
            }
            case "skin": {
                return ItemMaterial.fromPlayerHeadUUID(icon.get("value").getAsString());
            }
            case "legacy": {
                String material = icon.get("value").getAsString();
                String[] materialArray = material.split(":");
                int itemTypeCode = Integer.parseInt(materialArray[0]);
                int damageCode = materialArray.length > 1 ? Integer.parseInt(materialArray[1]) : 0;
                return ItemMaterial.fromItemTypeCode(itemTypeCode, damageCode);
            }
        }
        return null;
    }

    protected GearRequirements parseRequirements(JsonObject json, GearType type) {
        JsonObject requirements = JsonUtils.getNullableJsonObject(json, "requirements");
        if (requirements == null) {
            return new GearRequirements(0, Optional.empty(), List.of(), Optional.empty());
        }
        int level = requirements.get("level").getAsInt();
        Optional<ClassType> classType = this.parseClassType(requirements, type);
        List<Pair<Skill, Integer>> skills = this.parseSkills(requirements);
        Optional<String> quest = this.parseQuest(requirements);
        return new GearRequirements(level, classType, skills, quest);
    }

    private Optional<ClassType> parseClassType(JsonObject json, GearType type) {
        if (type.isWeapon()) {
            return Optional.of(type.getClassReq());
        }
        String classReq = JsonUtils.getNullableJsonString(json, "classRequirement");
        if (classReq == null) {
            return Optional.empty();
        }
        return Optional.of(ClassType.fromName(classReq));
    }

    private List<Pair<Skill, Integer>> parseSkills(JsonObject json) {
        ArrayList<Pair<Skill, Integer>> list = new ArrayList<Pair<Skill, Integer>>();
        for (Skill skill : Skill.values()) {
            int minPoints = JsonUtils.getNullableJsonInt(json, skill.getApiName());
            if (minPoints == 0) continue;
            list.add(Pair.of(skill, minPoints));
        }
        return List.copyOf(list);
    }

    private Optional<String> parseQuest(JsonObject json) {
        String questName = JsonUtils.getNullableJsonString(json, "quest");
        if (questName == null) {
            return Optional.empty();
        }
        return Optional.of(WynnUtils.normalizeBadString(questName));
    }

    protected FixedStats parseFixedStats(JsonObject json) {
        JsonObject baseStats = JsonUtils.getNullableJsonObject(json, "base");
        JsonObject identifications = JsonUtils.getNullableJsonObject(json, "identifications");
        int healthBuff = JsonUtils.getNullableJsonInt(baseStats, "baseHealth");
        String attackSpeedStr = JsonUtils.getNullableJsonString(json, "attackSpeed");
        Optional<GearAttackSpeed> attackSpeed = Optional.ofNullable(GearAttackSpeed.fromString(attackSpeedStr));
        Optional<GearMajorId> majorIds = this.parseMajorIds(json);
        List<Pair<DamageType, RangedValue>> damages = this.parseDamages(baseStats);
        List<Pair<Element, Integer>> defences = this.parseDefences(baseStats);
        return new FixedStats(healthBuff, attackSpeed, majorIds, damages, defences);
    }

    private Optional<GearMajorId> parseMajorIds(JsonObject json) {
        JsonObject majorIdsJson = JsonUtils.getNullableJsonObject(json, "majorIds");
        if (majorIdsJson == null || majorIdsJson.isJsonNull() || majorIdsJson.isEmpty()) {
            return Optional.empty();
        }
        Map majorIdMap = majorIdsJson.asMap();
        if (majorIdMap.size() > 1) {
            WynntilsMod.warn("Item DB contains multiple major IDs for " + json.get("name").getAsString());
        }
        if (majorIdMap.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry majorIdElement = majorIdMap.entrySet().iterator().next();
        StyledText description = StyledText.fromString(((JsonElement)majorIdElement.getValue()).getAsString().replaceAll("<[^>]*>", ""));
        return Optional.of(new GearMajorId((String)majorIdElement.getKey(), description));
    }

    private List<Pair<DamageType, RangedValue>> parseDamages(JsonObject json) {
        ArrayList<Pair<DamageType, RangedValue>> list = new ArrayList<Pair<DamageType, RangedValue>>();
        this.addDamageStat(list, DamageType.NEUTRAL, json.get("baseDamage"));
        for (Element element : Models.Element.getGearElementOrder()) {
            String damageName = "base" + EnumUtils.toNiceString(element) + "Damage";
            this.addDamageStat(list, DamageType.fromElement(element), json.get(damageName));
        }
        return List.copyOf(list);
    }

    private void addDamageStat(List<Pair<DamageType, RangedValue>> list, DamageType damageType, JsonElement damageJson) {
        if (damageJson == null) {
            return;
        }
        JsonObject rangeObject = damageJson.getAsJsonObject();
        RangedValue range = RangedValue.of(rangeObject.get("min").getAsInt(), rangeObject.get("max").getAsInt());
        if (range.equals(RangedValue.NONE)) {
            return;
        }
        list.add(Pair.of(damageType, range));
    }

    private List<Pair<Element, Integer>> parseDefences(JsonObject json) {
        ArrayList<Pair<Element, Integer>> list = new ArrayList<Pair<Element, Integer>>();
        for (Element element : Models.Element.getGearElementOrder()) {
            String defenceApiName = "base" + element.getDisplayName() + "Defence";
            int minPoints = JsonUtils.getNullableJsonInt(json, defenceApiName);
            if (minPoints == 0) continue;
            list.add(Pair.of(element, minPoints));
        }
        return List.copyOf(list);
    }

    protected List<Pair<StatType, StatPossibleValues>> parseVariableStats(JsonObject json, String identificationsObjectKey) {
        ArrayList<Pair<StatType, StatPossibleValues>> list = new ArrayList<Pair<StatType, StatPossibleValues>>();
        if (!json.has(identificationsObjectKey)) {
            return List.of();
        }
        JsonObject identificationsJson = json.get(identificationsObjectKey).getAsJsonObject();
        boolean preIdentifiedItem = JsonUtils.getNullableJsonBoolean(json, "identified");
        for (Map.Entry entry : identificationsJson.entrySet()) {
            RangedValue apiRange;
            boolean preIdentified;
            int baseValue;
            StatType statType;
            String statApiName = (String)entry.getKey();
            if (statApiName.equals("elementalDefense")) {
                statApiName = "elementalDefence";
            }
            if ((statType = Models.Stat.fromApiName(statApiName)) == null) {
                WynntilsMod.warn("Item DB contains invalid stat type " + statApiName);
                continue;
            }
            if (preIdentifiedItem || identificationsJson.get((String)entry.getKey()).isJsonPrimitive()) {
                baseValue = JsonUtils.getNullableJsonInt(identificationsJson, (String)entry.getKey());
                preIdentified = true;
                apiRange = RangedValue.of(baseValue, baseValue);
            } else {
                JsonObject statObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                baseValue = JsonUtils.getNullableJsonInt(statObject, "raw");
                preIdentified = false;
                apiRange = statObject.has("min") && statObject.has("max") ? RangedValue.of(statObject.get("min").getAsInt(), statObject.get("max").getAsInt()) : RangedValue.NONE;
            }
            if (baseValue == 0) continue;
            if (statType.calculateAsInverted()) {
                baseValue = -baseValue;
                apiRange = RangedValue.of(-apiRange.low(), -apiRange.high());
            }
            RangedValue range = StatCalculator.calculatePossibleValuesRange(baseValue, preIdentified, statType);
            if (apiRange.equals(RangedValue.NONE)) {
                WynntilsMod.warn(json.get("name").getAsString() + "'s stat " + statType.getApiName() + " has it's min-max range missing in the API");
            } else if (!apiRange.equals(range)) {
                WynntilsMod.warn(json.get("name").getAsString() + "'s stat " + statType.getApiName() + " has a range mismatch: API " + String.valueOf(apiRange) + " vs calculated " + String.valueOf(range));
            }
            StatPossibleValues possibleValues = new StatPossibleValues(statType, range, baseValue, preIdentified);
            list.add(Pair.of(statType, possibleValues));
        }
        return List.copyOf(list);
    }
}

