/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnitem.parsing;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.SetInfo;
import com.wynntils.models.gear.type.SetInstance;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.SkillStatType;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.parsing.CraftedItemParseResults;
import com.wynntils.models.wynnitem.parsing.WynnItemParseResult;
import com.wynntils.models.wynnitem.type.ConsumableEffect;
import com.wynntils.models.wynnitem.type.ItemEffect;
import com.wynntils.models.wynnitem.type.NamedItemEffect;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public final class WynnItemParser {
    private static final Pattern HEALTH_PATTERN = Pattern.compile("^\u00a74\u2764 Health: ([+-]\\d+)(?:\u00a7r)?$");
    private static final Pattern ITEM_ATTACK_SPEED_PATTERN = Pattern.compile("^\u00a77(.+ Attack Speed)(?:\u00a7r)?$");
    private static final Pattern ITEM_DAMAGE_PATTERN = Pattern.compile("^\u00a7.(?<symbol>[\ue005\ue001\ue003\ue004\ue002\ue000]+) (?<type>.+) Damage: (?<range>(\\d+)-(\\d+))(?:\u00a7r)?$");
    private static final Pattern ITEM_DEFENCE_PATTERN = Pattern.compile("^\u00a7.(?<symbol>[\ue001\ue003\ue004\ue002\ue000]+) (?<type>.+)\u00a77 Defence: (?<value>[+-]?\\d+)(?:\u00a7r)?$");
    public static final Pattern IDENTIFICATION_STAT_PATTERN = Pattern.compile("^\u00a7[ac]([-+]\\d+)(?:\u00a7[24] to \u00a7[ac](-?\\d+))?(%| tier|\\/[35]s)?(?:\u00a78\\/([-+]?\\d+)(?:%| tier|\\/[35]s)?)?(?:\u00a7(?:2|4)(\\*{1,3}))? ?\u00a77 ?(.*)$");
    private static final Pattern TIER_AND_REROLL_PATTERN = Pattern.compile("^(\u00a7fNormal|\u00a7eUnique|\u00a7dRare|\u00a7bLegendary|\u00a7cFabled|\u00a75Mythic|\u00a7aSet|\u00a73Crafted) ([A-Za-z\\d _]+)(?: \u00a78)?(?:\\[(\\d+)(?:\\/(\\d+) Durability)?\\])?(?:\u00a7r)?$");
    private static final Pattern POWDER_PATTERN = Pattern.compile("^\u00a77\\[(\\d+)\\/(\\d+)\\] Powder Slots(?: \\[\u00a7(.*)\u00a77\\])?(?:\u00a7r)?$");
    private static final Pattern EFFECT_LINE_PATTERN = Pattern.compile("^\u00a7(.)- \u00a77(.*): \u00a7f([+-]?\\d+)(?:\u00a7.\u00a7.)? ?(.*)$");
    private static final Pattern MIN_LEVEL_PATTERN = Pattern.compile("^\u00a7(c\u2716|a\u2714) ?\u00a77 ?Combat Lv. Min: (?:\u00a7f)?(?<level>\\d+)(?:\u00a7r)?$");
    private static final Pattern CLASS_REQ_PATTERN = Pattern.compile("^\u00a7(c\u2716|a\u2714) ?\u00a77 ?Class Req: (?:\u00a7f)?(?<name>.+)\\/(?<skinned>.+)(?:\u00a7r)?$");
    private static final Pattern SKILL_REQ_PATTERN = Pattern.compile("^\u00a7(c\u2716|a\u2714) ?\u00a77 ?(?<skill>[a-zA-Z]+) Min: (?:\u00a7f)?(?<value>-?\\d+)(?:\u00a7r)?$");
    private static final Pattern QUEST_REQ_PATTERN = Pattern.compile("^\u00a7(c\u2716|a\u2714) ?\u00a77 ?Quest Req: (.+)(?:\u00a7r)?$");
    private static final Pattern MISC_REQ_PATTERN = Pattern.compile("^\u00a7(c\u2716|a\u2714) ?\u00a77 ?(.+)$");
    private static final Pattern EFFECT_HEADER_PATTERN = Pattern.compile("^\u00a7(.)Effect:$");
    private static final Pattern POWDER_MARKERS = Pattern.compile("[^\ue001\ue003\ue004\ue002\ue000]");
    public static final Pattern SET_PATTERN = Pattern.compile("\u00a7a(.+) Set \u00a77\\((\\d)/\\d\\)");
    public static final Pattern SET_BONUS_PATTERN = Pattern.compile("^\u00a7aSet Bonus:(?:\u00a7r)?$");
    public static final Pattern SET_ITEM_PATTERN = Pattern.compile("^\u00a7[a7]- \u00a7([28])(.+)");
    private static final Pattern SET_BONUS_IDENTIFICATION_PATTERN = Pattern.compile("\u00a7[ac]([-+]\\d+)(%| tier|/[35]s)? ?\u00a77 ?(.*)");
    private static final Pattern SHINY_STAT_PATTERN = Pattern.compile("^\u00a7f\u2b21 \u00a77(?: )?([a-zA-Z ]+): \u00a7f(\\d+)(?:\u00a78 \\[(\\d+)\\])?$");
    public static final Pattern CRAFTED_ITEM_NAME_PATTERN = Pattern.compile("^\u00a73(?:\u00a7o)?(?<name>.+) \u00a7b(?:\u00a7o)?\\[(((?<effectStrength>\\d+)%)|((?<currentUses>\\d+)\\/(?<maxUses>\\d+)))\\]\u00c0*$");

    public static WynnItemParseResult parseItemStack(class_1799 itemStack, Map<StatType, StatPossibleValues> possibleValuesMap) {
        ArrayList<StatActualValue> identifications = new ArrayList<StatActualValue>();
        ArrayList<NamedItemEffect> namedEffects = new ArrayList<NamedItemEffect>();
        ArrayList<ItemEffect> effects = new ArrayList<ItemEffect>();
        ArrayList<Powder> powders = new ArrayList<Powder>();
        int powderSlots = 0;
        int health = 0;
        GearAttackSpeed attackSpeed = null;
        ArrayList<Pair<DamageType, RangedValue>> damages = new ArrayList<Pair<DamageType, RangedValue>>();
        ArrayList<Pair<Element, Integer>> defences = new ArrayList<Pair<Element, Integer>>();
        int levelReq = 0;
        ArrayList<Pair<Skill, Integer>> skillReqs = new ArrayList<Pair<Skill, Integer>>();
        ClassType classReq = null;
        String questReq = null;
        int tierCount = 0;
        int durabilityMax = 0;
        GearTier tier = null;
        String itemType = "";
        boolean setBonusStats = false;
        boolean parsingEffects = false;
        Optional<ShinyStat> shinyStat = Optional.empty();
        String effectsColorCode = "";
        boolean allRequirementsMet = true;
        SetInfo setInfo = null;
        HashMap<String, Boolean> activeItems = new HashMap<String, Boolean>();
        int setWynnCount = 0;
        HashMap<StatType, Integer> wynnBonuses = new HashMap<StatType, Integer>();
        List<class_2561> lore = ComponentUtils.stripDuplicateBlank(LoreUtils.getTooltipLines(itemStack));
        lore.removeFirst();
        for (class_2561 loreLine : lore) {
            Matcher shinyStatMatcher;
            Matcher statMatcher;
            Matcher powderMatcher;
            StyledText coded = StyledText.fromComponent(loreLine);
            StyledText normalizedCoded = coded.getNormalized();
            if (setBonusStats) {
                if (normalizedCoded.isEmpty()) {
                    setBonusStats = false;
                    continue;
                }
                Matcher setBonusIdentificationMatcher = normalizedCoded.getMatcher(SET_BONUS_IDENTIFICATION_PATTERN);
                if (!setBonusIdentificationMatcher.matches()) {
                    WynntilsMod.warn("Item " + itemStack.method_7964().getString() + " has unknown set bonus stat line: " + String.valueOf(loreLine));
                    continue;
                }
                int value = Integer.parseInt(setBonusIdentificationMatcher.group(1));
                String unit = setBonusIdentificationMatcher.group(2);
                String statDisplayName = setBonusIdentificationMatcher.group(3);
                StatType statType = Models.Stat.fromDisplayName(statDisplayName, unit);
                if (statType == null) {
                    WynntilsMod.warn("Item " + itemStack.method_7964().getString() + " has unknown identified set bonus stat " + statDisplayName);
                    continue;
                }
                wynnBonuses.put(statType, value);
            }
            if ((powderMatcher = normalizedCoded.getMatcher(POWDER_PATTERN)).matches()) {
                int usedSlots = Integer.parseInt(powderMatcher.group(1));
                powderSlots = Integer.parseInt(powderMatcher.group(2));
                String codedPowders = powderMatcher.group(3);
                if (codedPowders == null) continue;
                String powderString = POWDER_MARKERS.matcher(codedPowders).replaceAll("");
                if (powderString.length() != usedSlots) {
                    WynntilsMod.warn("Mismatch between powder slot count " + usedSlots + " and actual powder symbols: " + codedPowders + " for " + itemStack.method_7964().getString());
                }
                codedPowders.chars().forEach(ch -> {
                    Powder powder = Powder.getFromSymbol(Character.toString(ch));
                    if (powder != null) {
                        powders.add(powder);
                    }
                });
                continue;
            }
            Matcher tierMatcher = normalizedCoded.getMatcher(TIER_AND_REROLL_PATTERN);
            if (tierMatcher.matches()) {
                String tierString = tierMatcher.group(1);
                tier = GearTier.fromStyledText(StyledText.fromString(tierString));
                itemType = tierMatcher.group(2);
                String tierCountString = tierMatcher.group(3);
                tierCount = tierCountString != null ? Integer.parseInt(tierCountString) : 0;
                String durabilityMaxString = tierMatcher.group(4);
                durabilityMax = durabilityMaxString != null ? Integer.parseInt(durabilityMaxString) : 0;
                continue;
            }
            Matcher healthMatcher = normalizedCoded.getMatcher(HEALTH_PATTERN);
            if (healthMatcher.matches()) {
                health = Integer.parseInt(healthMatcher.group(1));
                continue;
            }
            Matcher attackSpeedMatcher = coded.getMatcher(ITEM_ATTACK_SPEED_PATTERN);
            if (attackSpeedMatcher.matches()) {
                String speedName = attackSpeedMatcher.group(1);
                attackSpeed = GearAttackSpeed.fromString(speedName);
                continue;
            }
            Matcher damageMatcher = coded.getMatcher(ITEM_DAMAGE_PATTERN);
            if (damageMatcher.matches()) {
                String symbol = damageMatcher.group("symbol");
                RangedValue range = RangedValue.fromString(damageMatcher.group("range"));
                damages.add(Pair.of(DamageType.fromSymbol(symbol), range));
                continue;
            }
            Matcher defenceMatcher = coded.getMatcher(ITEM_DEFENCE_PATTERN);
            if (defenceMatcher.matches()) {
                String symbol = defenceMatcher.group("symbol");
                int value = Integer.parseInt(defenceMatcher.group("value"));
                defences.add(Pair.of(Element.fromSymbol(symbol), value));
                continue;
            }
            Matcher levelMatcher = normalizedCoded.getMatcher(MIN_LEVEL_PATTERN);
            if (levelMatcher.matches()) {
                levelReq = Integer.parseInt(levelMatcher.group("level"));
                String mark = levelMatcher.group(1);
                if (!mark.contains("\u2716")) continue;
                allRequirementsMet = false;
                continue;
            }
            Matcher classMatcher = normalizedCoded.getMatcher(CLASS_REQ_PATTERN);
            if (classMatcher.matches()) {
                String className = classMatcher.group("name");
                classReq = ClassType.fromName(className);
                String mark = classMatcher.group(1);
                if (!mark.contains("\u2716")) continue;
                allRequirementsMet = false;
                continue;
            }
            Matcher skillMatcher = normalizedCoded.getMatcher(SKILL_REQ_PATTERN);
            if (skillMatcher.matches()) {
                String skillName = skillMatcher.group("skill");
                Skill skill = Skill.fromString(skillName);
                int value = Integer.parseInt(skillMatcher.group("value"));
                skillReqs.add(Pair.of(skill, value));
                String mark = skillMatcher.group(1);
                if (!mark.contains("\u2716")) continue;
                allRequirementsMet = false;
                continue;
            }
            Matcher questMatcher = normalizedCoded.getMatcher(QUEST_REQ_PATTERN);
            if (questMatcher.matches()) {
                questReq = questMatcher.group(2);
                String mark = questMatcher.group(1);
                if (!mark.contains("\u2716")) continue;
                allRequirementsMet = false;
                continue;
            }
            Matcher miscMatcher = normalizedCoded.getMatcher(MISC_REQ_PATTERN);
            if (miscMatcher.matches()) {
                String mark = miscMatcher.group(1);
                if (!mark.contains("\u2716")) continue;
                allRequirementsMet = false;
                continue;
            }
            Matcher setMatcher = normalizedCoded.getMatcher(SET_PATTERN);
            if (setMatcher.matches()) {
                String setName = setMatcher.group(1);
                setInfo = Models.Set.getSetInfo(setName);
                setWynnCount = Integer.parseInt(setMatcher.group(2));
                continue;
            }
            Matcher setItemMatcher = normalizedCoded.getMatcher(SET_ITEM_PATTERN);
            if (setItemMatcher.matches()) {
                boolean active = setItemMatcher.group(1).equals("2");
                String itemName = setItemMatcher.group(2);
                activeItems.put(itemName, active);
                continue;
            }
            Matcher setBonusMatcher = normalizedCoded.getMatcher(SET_BONUS_PATTERN);
            if (setBonusMatcher.matches()) {
                setBonusStats = true;
                continue;
            }
            Matcher effectHeaderMatcher = normalizedCoded.getMatcher(EFFECT_HEADER_PATTERN);
            if (effectHeaderMatcher.matches()) {
                effectsColorCode = effectHeaderMatcher.group(1);
                parsingEffects = true;
                continue;
            }
            if (parsingEffects) {
                Matcher effectMatcher = normalizedCoded.getMatcher(EFFECT_LINE_PATTERN);
                if (effectMatcher.matches()) {
                    String colorCode = effectMatcher.group(1);
                    String type = effectMatcher.group(2);
                    int value = Integer.parseInt(effectMatcher.group(3));
                    String suffix = effectMatcher.group(4);
                    if (colorCode.equals(effectsColorCode)) {
                        ConsumableEffect consumableEffect;
                        if (type.equals("Effect")) {
                            type = suffix;
                        }
                        if ((consumableEffect = ConsumableEffect.fromString(type)) != null) {
                            namedEffects.add(new NamedItemEffect(consumableEffect, value));
                            continue;
                        }
                        effects.add(new ItemEffect(type, value));
                        continue;
                    }
                }
                parsingEffects = false;
            }
            if ((statMatcher = normalizedCoded.getMatcher(IDENTIFICATION_STAT_PATTERN)).matches() && !setBonusStats) {
                StatPossibleValues possibleValues;
                int value = Integer.parseInt(statMatcher.group(1));
                String unit = statMatcher.group(3);
                String starString = statMatcher.group(5);
                String statDisplayName = statMatcher.group(6);
                StatType statType = Models.Stat.fromDisplayName(statDisplayName, unit);
                if (statType == null) {
                    WynntilsMod.warn("Item " + String.valueOf(itemStack.method_7964()) + " has unknown identified stat " + statDisplayName);
                    continue;
                }
                if (statType.calculateAsInverted()) {
                    value = -value;
                }
                int stars = starString == null ? 0 : starString.length();
                StatPossibleValues statPossibleValues = possibleValues = possibleValuesMap != null ? possibleValuesMap.get(statType) : null;
                if (statMatcher.group(4) != null && possibleValuesMap != null) {
                    int maxValue = Integer.parseInt(statMatcher.group(4));
                    int minValue = (int)Math.round((double)maxValue * 0.1);
                    StatPossibleValues calculatedPossibleValues = new StatPossibleValues(statType, RangedValue.of(minValue, maxValue), maxValue, false);
                    possibleValuesMap.put(statType, calculatedPossibleValues);
                }
                StatActualValue actualValue = Models.Stat.buildActualValue(statType, value, stars, possibleValues);
                identifications.add(actualValue);
            }
            if (!(shinyStatMatcher = normalizedCoded.getMatcher(SHINY_STAT_PATTERN)).matches() || !shinyStat.isEmpty()) continue;
            String shinyName = shinyStatMatcher.group(1);
            int shinyValue = Integer.parseInt(shinyStatMatcher.group(2));
            int shinyRerolls = shinyStatMatcher.group(3) != null ? Integer.parseInt(shinyStatMatcher.group(3)) : 0;
            shinyStat = Optional.of(new ShinyStat(Models.Shiny.getShinyStat(shinyName), shinyValue, shinyRerolls));
        }
        return new WynnItemParseResult(tier, itemType, health, levelReq, attackSpeed, damages, defences, new GearRequirements(levelReq, Optional.ofNullable(classReq), skillReqs, Optional.ofNullable(questReq)), identifications, namedEffects, effects, powders, powderSlots, tierCount, tierCount, durabilityMax, shinyStat, allRequirementsMet, Optional.of(new SetInstance(setInfo, activeItems, setWynnCount, wynnBonuses)));
    }

    public static WynnItemParseResult parseInternalRolls(GearInfo gearInfo, JsonObject itemData) {
        ArrayList<StatActualValue> identifications = new ArrayList<StatActualValue>();
        if (itemData.has("identifications")) {
            JsonArray ids = itemData.getAsJsonArray("identifications");
            for (int i = 0; i < ids.size(); ++i) {
                JsonObject idInfo = ids.get(i).getAsJsonObject();
                String id = idInfo.get("type").getAsString();
                int internalRoll = idInfo.get("percent").getAsInt();
                StatType statType = Models.Stat.fromInternalRollId(id);
                if (statType == null) {
                    WynntilsMod.warn("Remote player's " + gearInfo.name() + " contains unknown stat type " + id);
                    continue;
                }
                StatActualValue actualValue = WynnItemParser.getStatActualValue(gearInfo, statType, internalRoll);
                if (actualValue == null) continue;
                identifications.add(actualValue);
            }
        }
        ArrayList<Powder> powders = new ArrayList<Powder>();
        if (itemData.has("powders")) {
            JsonArray powderData = itemData.getAsJsonArray("powders");
            for (int i = 0; i < powderData.size(); ++i) {
                String type = powderData.get(i).getAsJsonObject().get("type").getAsString();
                Powder powder = Powder.valueOf(type.toUpperCase(Locale.ROOT));
                powders.add(powder);
            }
        }
        int rerolls = itemData.has("identification_rolls") ? itemData.get("identification_rolls").getAsInt() : 0;
        return WynnItemParseResult.fromInternalRoll(identifications, powders, rerolls);
    }

    public static CraftedItemParseResults parseCraftedItem(class_1799 itemStack) {
        List<class_2561> lore = ComponentUtils.stripDuplicateBlank(LoreUtils.getTooltipLines(itemStack));
        String name = "";
        int effectStrength = -1;
        CappedValue uses = null;
        if (!lore.isEmpty()) {
            Matcher nameMatcher = StyledText.fromComponent(lore.getFirst()).getMatcher(CRAFTED_ITEM_NAME_PATTERN);
            if (nameMatcher.matches()) {
                name = nameMatcher.group(1);
                if (nameMatcher.group("effectStrength") != null) {
                    effectStrength = Integer.parseInt(nameMatcher.group("effectStrength"));
                } else {
                    int currentUses = Integer.parseInt(nameMatcher.group("currentUses"));
                    int maxUses = Integer.parseInt(nameMatcher.group("maxUses"));
                    uses = new CappedValue(currentUses, maxUses);
                }
            } else {
                nameMatcher = StyledText.fromComponent(itemStack.method_7964()).getMatcher(CRAFTED_ITEM_NAME_PATTERN);
                if (nameMatcher.matches()) {
                    name = nameMatcher.group(1);
                    if (nameMatcher.group("effectStrength") != null) {
                        effectStrength = Integer.parseInt(nameMatcher.group("effectStrength"));
                    } else {
                        int currentUses = Integer.parseInt(nameMatcher.group("currentUses"));
                        int maxUses = Integer.parseInt(nameMatcher.group("maxUses"));
                        uses = new CappedValue(currentUses, maxUses);
                    }
                } else {
                    WynntilsMod.warn("Crafted item " + StyledText.fromComponent(itemStack.method_7964()).getString() + " has no parsable name in lore, or as a custom name: " + lore.stream().map(StyledText::fromComponent).map(StyledText::getString).collect(Collectors.joining("\n")));
                    return null;
                }
            }
        }
        return new CraftedItemParseResults(name, effectStrength, uses);
    }

    private static StatActualValue getStatActualValue(GearInfo gearInfo, StatType statType, int internalRoll) {
        StatPossibleValues possibleValue = gearInfo.getPossibleValues(statType);
        if (possibleValue == null) {
            if (!(statType instanceof SkillStatType)) {
                WynntilsMod.warn("Remote player's " + gearInfo.name() + " claims to have " + String.valueOf(statType));
            }
            return null;
        }
        int value = StatCalculator.calculateStatValue(internalRoll, possibleValue);
        int stars = value > 0 ? StatCalculator.calculateStarsFromInternalRoll(statType, possibleValue.baseValue(), internalRoll) : 0;
        return new StatActualValue(statType, value, stars, RangedValue.of(internalRoll, internalRoll));
    }
}

