/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.overlays.ContainerOverlay;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.players.event.HadesRelationsUpdateEvent;
import com.wynntils.models.players.event.PartyEvent;
import com.wynntils.models.players.scoreboard.PartyScoreboardPart;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.hades.event.HadesUserEvent;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.SkinUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HealthTexture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.ManaTexture;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class PartyMembersOverlay
extends ContainerOverlay<PartyMemberOverlay> {
    private static final HadesUser DUMMY_USER_1 = new HadesUser("Player 1", new CappedValue(12432, 13120), new CappedValue(65, 123));
    private static final HadesUser DUMMY_USER_2 = new HadesUser("Player 2", new CappedValue(4561, 9870), new CappedValue(98, 170));
    @Persisted
    private final Config<Boolean> disablePartyMembersOnScoreboard = new Config<Boolean>(false);
    @Persisted
    private final Config<Integer> maxPartyMembers = new Config<Integer>(4);
    @Persisted
    private final Config<Boolean> showHeads = new Config<Boolean>(true);
    @Persisted
    private final Config<HealthTexture> healthTexture = new Config<HealthTexture>(HealthTexture.A);
    @Persisted
    private final Config<ManaTexture> manaTexture = new Config<ManaTexture>(ManaTexture.A);

    public PartyMembersOverlay() {
        super(new OverlayPosition(70.0f, 5.0f, VerticalAlignment.TOP, HorizontalAlignment.LEFT, OverlayPosition.AnchorSection.MIDDLE_LEFT), new OverlaySize(162.0f, 50.0f), ContainerOverlay.GrowDirection.DOWN, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    @Override
    protected List<PartyMemberOverlay> getPreviewChildren() {
        return List.of(new PartyMemberOverlay(DUMMY_USER_1), new PartyMemberOverlay(DUMMY_USER_2));
    }

    @SubscribeEvent
    public void onHadesUserAdded(HadesUserEvent.Added event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onHadesUserRemoved(HadesUserEvent.Removed event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(HadesRelationsUpdateEvent.PartyList event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.Invited event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.Listed event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.PriorityChanged event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.OtherDisconnected event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.OtherJoined event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.OtherLeft event) {
        this.updateChildren();
    }

    @SubscribeEvent
    public void onPartyChange(PartyEvent.OtherReconnected event) {
        this.updateChildren();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disablePartyMembersOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof PartyScoreboardPart) {
            event.setCanceled(true);
        }
    }

    private void updateChildren() {
        this.clearChildren();
        List<HadesUser> warUsers = Models.War.getHadesUsers();
        if (!warUsers.isEmpty()) {
            warUsers.forEach(hadesUser -> this.addChild(new PartyMemberOverlay((HadesUser)hadesUser)));
            return;
        }
        List<HadesUser> hadesUsers = Services.Hades.getHadesUsers().toList();
        List<String> partyMembers = Models.Party.getPartyMembers();
        List hadesUsingPartyMembers = hadesUsers.stream().filter(hadesUser -> partyMembers.contains(hadesUser.getName())).sorted(Comparator.comparing(element -> partyMembers.indexOf(element.getName()))).collect(Collectors.toList());
        hadesUsingPartyMembers = hadesUsingPartyMembers.subList(0, Math.min(hadesUsingPartyMembers.size(), (Integer)this.maxPartyMembers.get()));
        for (HadesUser hadesUser2 : hadesUsingPartyMembers) {
            this.addChild(new PartyMemberOverlay(hadesUser2));
        }
    }

    public final class PartyMemberOverlay
    extends Overlay {
        private static final int HEAD_SIZE = 26;
        private final HadesUser hadesUser;

        private PartyMemberOverlay(HadesUser hadesUser) {
            super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.TOP, HorizontalAlignment.LEFT, OverlayPosition.AnchorSection.TOP_LEFT), new OverlaySize(162.0f, 50.0f));
            this.hadesUser = hadesUser;
        }

        @Override
        public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            float renderX = this.getRenderX();
            float renderY = this.getRenderY();
            poseStack.method_46416(renderX, renderY, 0.0f);
            if (((Boolean)PartyMembersOverlay.this.showHeads.get()).booleanValue()) {
                class_2960 skin = SkinUtils.getSkin(this.hadesUser.getUuid());
                BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, skin, 0.0f, 0.0f, 0.0f, 26.0f, 26.0f, 8, 8, 8, 8, 64, 64);
                BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, skin, 0.0f, 0.0f, 1.0f, 26.0f, 26.0f, 40, 8, 8, 8, 64, 64);
            }
            poseStack.method_46416(26.0f, 0.0f, 0.0f);
            poseStack.method_46416(3.0f, 0.0f, 0.0f);
            BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString(this.hadesUser.getName()), 0.0f, 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
            poseStack.method_46416(0.0f, 12.0f, 0.0f);
            double healthProgress = this.hadesUser.getHealth().getProgress();
            double manaProgress = this.hadesUser.getMana().getProgress();
            HealthTexture healthTexture = (HealthTexture)PartyMembersOverlay.this.healthTexture.get();
            BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.HEALTH_BAR, 0.0f, 0.0f, 68.85f, (float)healthTexture.getHeight() * 0.85f, 0, healthTexture.getTextureY1(), 81, healthTexture.getTextureY2(), (float)healthProgress);
            if (healthProgress > 1.0) {
                BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.HEALTH_BAR_OVERFLOW, 0.0f, 0.0f, 68.85f, (float)healthTexture.getHeight() * 0.85f, 0, healthTexture.getTextureY1(), 81, healthTexture.getTextureY2(), (float)healthProgress - 1.0f);
            }
            poseStack.method_46416(0.0f, (float)healthTexture.getHeight() * 0.85f, 0.0f);
            ManaTexture manaTexture = (ManaTexture)PartyMembersOverlay.this.manaTexture.get();
            BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.MANA_BAR, 0.0f, 2.0f, 68.85f, 2.0f + (float)manaTexture.getHeight() * 0.85f, 0, manaTexture.getTextureY1(), 81, manaTexture.getTextureY2(), (float)manaProgress);
            poseStack.method_22909();
        }
    }
}

