/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.WynntilsMenuScreenBase;
import com.wynntils.screens.base.WynntilsPagedScreen;
import com.wynntils.screens.base.widgets.ListSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public abstract class WynntilsListScreen<E, B extends WynntilsButton>
extends WynntilsMenuScreenBase
implements WynntilsPagedScreen {
    private double currentScroll = 0.0;
    protected int currentPage = 0;
    protected int maxPage = 0;
    protected final List<E> elements = new ArrayList();
    private final List<B> elementButtons = new ArrayList<B>();
    protected SearchWidget searchWidget;
    protected class_4068 hovered = null;
    protected int originalSearchWidgetX = (int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f);
    protected int originalSearchWidgetY = 0;

    @Override
    protected void doInit() {
        super.doInit();
        this.searchWidget.method_46421(this.originalSearchWidgetX + this.offsetX);
        this.searchWidget.method_46419(this.originalSearchWidgetY + this.offsetY);
        this.method_37063((class_364)this.searchWidget);
        this.reloadElements(this.searchWidget.getTextBoxInput());
    }

    protected WynntilsListScreen(class_2561 component) {
        super(component);
        this.searchWidget = new ListSearchWidget(this.originalSearchWidgetX, 0, Texture.LIST_SEARCH.width(), Texture.LIST_SEARCH.height(), s -> this.reloadElements(), this);
    }

    protected void renderWidgets(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = null;
        for (class_4068 renderable : new ArrayList(this.field_33816)) {
            WynntilsButton button;
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable instanceof WynntilsButton) || !(button = (WynntilsButton)renderable).method_25405(mouseX, mouseY)) continue;
            this.hovered = button;
        }
    }

    protected void renderPageInfo(class_4587 poseStack, int currentPage, int maxPage) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(currentPage + " / " + maxPage), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY), 0.0f, CommonColors.BLACK, HorizontalAlignment.CENTER, TextShadow.NONE);
    }

    protected void renderNoElementsHelper(class_4587 poseStack, String key) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(key), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX, (float)Texture.CONTENT_BOOK_BACKGROUND.width() - 15.0f + (float)this.offsetX, this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.height() + this.offsetY, (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NONE);
    }

    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        List<Object> tooltipLines = List.of();
        class_4068 class_40682 = this.hovered;
        if (class_40682 instanceof TooltipProvider) {
            TooltipProvider tooltipWidget = (TooltipProvider)class_40682;
            tooltipLines = tooltipWidget.getTooltipLines();
        }
        if (tooltipLines.isEmpty()) {
            return;
        }
        guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 child : new ArrayList(this.method_25396())) {
            if (!child.method_25405(mouseX, mouseY)) continue;
            child.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (class_364 child : new ArrayList(this.method_25396())) {
            child.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (class_364 child : new ArrayList(this.method_25396())) {
            child.method_25406(mouseX, mouseY, button);
        }
        return true;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        if (this.searchWidget != null) {
            return this.searchWidget.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchWidget != null) {
            return this.searchWidget.method_25400(codePoint, modifiers);
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Math.abs(deltaY) == 1.0) {
            this.setCurrentPage(this.getCurrentPage() - (int)deltaY);
            return true;
        }
        this.currentScroll -= deltaY / 10.0;
        if (Math.abs(this.currentScroll) < 1.0) {
            return true;
        }
        int scroll = (int)this.currentScroll;
        this.currentScroll %= 1.0;
        this.setCurrentPage(this.getCurrentPage() + scroll);
        return true;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = MathUtils.clamp(currentPage, 0, this.maxPage);
        this.reloadElements(this.searchWidget.getTextBoxInput());
    }

    @Override
    public int getMaxPage() {
        return this.maxPage;
    }

    private void reloadElements(String searchTerm) {
        int start;
        this.elements.clear();
        this.reloadElementsList(searchTerm);
        this.maxPage = Math.max(0, this.elements.size() / this.getElementsPerPage() + (this.elements.size() % this.getElementsPerPage() != 0 ? 1 : 0) - 1);
        for (WynntilsButton button : this.elementButtons) {
            this.method_37066((class_364)button);
        }
        this.elementButtons.clear();
        for (int i = start = Math.max(0, this.currentPage * this.getElementsPerPage()); i < Math.min(this.elements.size(), start + this.getElementsPerPage()); ++i) {
            B button = this.getButtonFromElement(i);
            this.elementButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    protected abstract B getButtonFromElement(int var1);

    protected abstract void reloadElementsList(String var1);

    public void reloadElements() {
        this.reloadElements(this.searchWidget.getTextBoxInput());
        this.setCurrentPage(this.getCurrentPage());
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.searchWidget;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
    }

    protected int getElementsPerPage() {
        return 13;
    }
}

