/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;

public class SearchWidget
extends TextInputBoxWidget {
    private static final class_2561 DEFAULT_TEXT = class_2561.method_43471((String)"screens.wynntils.searchWidget.defaultSearchText");
    protected static final float VERTICAL_OFFSET = 6.5f;

    public SearchWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Search Box"), onUpdateConsumer, textboxScreen);
        this.textPadding = 5;
    }

    @Override
    protected void doRenderWidget(class_4587 poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, class_327 font, int firstWidth, int highlightedWidth, int lastWidth) {
        boolean defaultText = Objects.equals(this.textBoxInput, "");
        this.renderBackground(poseStack);
        this.renderText(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth, defaultText);
    }

    protected void renderText(class_4587 poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, class_327 font, int firstWidth, int highlightedWidth, int lastWidth, boolean defaultText) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(defaultText ? DEFAULT_TEXT.getString() : firstPortion), (float)(this.method_46426() + this.textPadding), (float)(this.method_46426() + this.field_22758 - this.textPadding - lastWidth - highlightedWidth), (float)this.method_46427() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        if (!defaultText) {
            FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, StyledText.fromString(highlightedPortion), this.method_46426() + this.textPadding + firstWidth, this.method_46426() + this.field_22758 - this.textPadding - lastWidth, (float)this.method_46427() + 6.5f, (float)this.method_46427() + 6.5f, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(lastPortion), (float)(this.method_46426() + this.textPadding + firstWidth + highlightedWidth), (float)(this.method_46426() + this.field_22758 - this.textPadding), (float)this.method_46427() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        }
        this.drawCursor(poseStack, this.method_46426() + font.method_1727(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))) + this.textPadding - 2, (float)this.method_46427() + 6.5f, VerticalAlignment.TOP, false);
    }

    protected void renderBackground(class_4587 poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        RenderUtils.drawRectBorders(poseStack, this.field_22762 ? CommonColors.LIGHT_GRAY : CommonColors.GRAY, this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0.0f, 1.0f);
    }

    @Override
    protected int getMaxTextWidth() {
        return this.field_22758 - 18;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.field_22759)) {
            McUtils.playSoundUI((class_3414)class_3417.field_15015.comp_349());
            if (button == 1) {
                this.setTextBoxInput("");
                this.setCursorAndHighlightPositions(0);
            } else {
                this.setCursorAndHighlightPositions(this.getIndexAtPosition(mouseX));
            }
            this.isDragging = true;
            this.textboxScreen.setFocusedTextInput(this);
            return true;
        }
        this.textboxScreen.setFocusedTextInput(null);
        return false;
    }

    @Override
    protected void removeFocus() {
        this.setTextBoxInput("");
        super.removeFocus();
    }

    public void opened() {
        this.setCursorPosition(this.textBoxInput.length());
        this.setHighlightPosition(0);
    }
}

