/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.crowdsourcing.widgets;

import com.wynntils.core.components.Managers;
import com.wynntils.core.crowdsource.CrowdSourcedDataManager;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.wynntils.DataCrowdSourcingFeature;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.crowdsourcing.WynntilsCrowdSourcingSettingsScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ConfirmedBoolean;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class CrowdSourcedDataWidget
extends WynntilsButton
implements TooltipProvider {
    private static final Pair<CustomColor, CustomColor> BUTTON_COLOR = Pair.of(new CustomColor(181, 174, 151), new CustomColor(121, 116, 101));
    private final CrowdSourcedDataType crowdSourcedDataType;
    private final WynntilsCrowdSourcingSettingsScreen crowdSourcingSettingsScreen;

    public CrowdSourcedDataWidget(int x, int y, int width, int height, CrowdSourcedDataType crowdSourcedDataType, WynntilsCrowdSourcingSettingsScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)crowdSourcedDataType.name()));
        this.crowdSourcedDataType = crowdSourcedDataType;
        this.crowdSourcingSettingsScreen = screen;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        CustomColor backgroundColor = this.field_22762 ? BUTTON_COLOR.b() : BUTTON_COLOR.a();
        RenderUtils.drawRect(poseStack, backgroundColor, this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.crowdSourcedDataType.getTranslatedName()), this.method_46426() + 14, this.method_46427() + 1, this.field_22758 - 15, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
        Texture stateTexture = switch (Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType)) {
            default -> throw new MatchException(null, null);
            case ConfirmedBoolean.FALSE -> Texture.ACTIVITY_CANNOT_START;
            case ConfirmedBoolean.TRUE -> Texture.ACTIVITY_FINISHED;
            case ConfirmedBoolean.UNCONFIRMED -> Texture.QUESTION_MARK;
        };
        RenderUtils.drawTexturedRect(poseStack, stateTexture.resource(), this.method_46426() + 1, this.method_46427() + 1, stateTexture.width(), stateTexture.height(), stateTexture.width(), stateTexture.height());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType) == ConfirmedBoolean.TRUE) {
                ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.FALSE);
                Managers.Config.saveConfig();
                return true;
            }
            if (!Managers.CrowdSourcedData.isDataCollectionEnabled()) {
                Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).userEnabled.setValue(true);
            }
            ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.TRUE);
            Managers.Config.saveConfig();
            return true;
        }
        if (button == 1) {
            ConfirmedBoolean dataCollectionState = Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType);
            if (dataCollectionState == ConfirmedBoolean.UNCONFIRMED) {
                ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.FALSE);
                Managers.Config.saveConfig();
                return true;
            }
            Set data = Managers.CrowdSourcedData.getData(this.crowdSourcedDataType);
            String jsonString = JsonManager.GSON.toJson(Map.of(CrowdSourcedDataManager.CURRENT_GAME_VERSION, data));
            McUtils.mc().field_1774.method_1455(jsonString);
            return true;
        }
        return false;
    }

    public void method_25306() {
    }

    @Override
    public List<class_2561> getTooltipLines() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add((class_2561)class_2561.method_43470((String)this.crowdSourcedDataType.getTranslatedName()).method_27692(class_124.field_1067).method_27692(class_124.field_1065));
        lines.add((class_2561)class_2561.method_43473());
        lines.add((class_2561)class_2561.method_43470((String)this.crowdSourcedDataType.getTranslatedDescription()).method_27692(class_124.field_1080));
        lines.add((class_2561)class_2561.method_43473());
        ConfirmedBoolean dataCollectionState = Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType);
        if (!Managers.CrowdSourcedData.isDataCollectionEnabled()) {
            lines.add((class_2561)class_2561.method_43471((String)"feature.wynntils.dataCrowdSourcing.button.enableWithFeature").method_27692(class_124.field_1067).method_27692(class_124.field_1077));
        } else if (dataCollectionState != ConfirmedBoolean.TRUE) {
            lines.add((class_2561)class_2561.method_43471((String)"feature.wynntils.dataCrowdSourcing.button.enable").method_27692(class_124.field_1067).method_27692(class_124.field_1060));
        } else {
            lines.add((class_2561)class_2561.method_43471((String)"feature.wynntils.dataCrowdSourcing.button.disable").method_27692(class_124.field_1067).method_27692(class_124.field_1061));
        }
        if (dataCollectionState == ConfirmedBoolean.UNCONFIRMED) {
            lines.add((class_2561)class_2561.method_43471((String)"feature.wynntils.dataCrowdSourcing.button.disableUnconfirmed").method_27692(class_124.field_1067).method_27692(class_124.field_1061));
        } else {
            lines.add((class_2561)class_2561.method_43471((String)"feature.wynntils.dataCrowdSourcing.button.copy").method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        }
        return ComponentUtils.wrapTooltips(lines, 200);
    }
}

