/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemsharing;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemsharing.ItemSharingScreen;
import com.wynntils.screens.itemsharing.SavedItemsMenu;
import com.wynntils.screens.itemsharing.widgets.SavedCategoryButton;
import com.wynntils.screens.itemsharing.widgets.SavedItemsButton;
import com.wynntils.services.itemrecord.type.SavedItem;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public final class SavedItemsScreen
extends WynntilsContainerScreen<SavedItemsMenu> {
    private static final int ITEMS_PER_ROW = 7;
    private static final int MAX_ITEMS = 49;
    private static final int SCROLL_AREA_HEIGHT = 129;
    private boolean addingCategory = false;
    private boolean draggingScroll = false;
    private boolean editingCategory = false;
    private int itemScrollOffset = 0;
    private List<Integer> selectedSlots = new ArrayList<Integer>();
    private Map<Integer, SavedItem> encodedItems = new TreeMap<Integer, SavedItem>();
    private String currentCategory = Services.ItemRecord.getDefaultCategory();
    private TextInputBoxWidget categoryInput;
    private List<Pair<String, String>> selectedItems = new ArrayList<Pair<String, String>>();
    private int dragSelectionStartIndex = -1;

    private SavedItemsScreen(SavedItemsMenu abstractContainerMenu) {
        super(abstractContainerMenu, McUtils.inventory(), (class_2561)class_2561.method_43470((String)"Saved Items Screen"));
    }

    public static class_437 create() {
        return new SavedItemsScreen(SavedItemsMenu.create());
    }

    @Override
    protected void doInit() {
        super.doInit();
        Services.ItemRecord.cleanupItemRecord();
        this.field_2776 = (this.field_22789 - Texture.ITEM_RECORD.width()) / 2;
        this.field_2800 = (this.field_22790 - Texture.ITEM_RECORD.height()) / 2;
        this.method_37063((class_364)new SavedItemsButton(this.field_2776 + 9, this.field_2800 + 20, b -> {
            if (b == 0) {
                if (!this.addingCategory && !this.editingCategory) {
                    this.addingCategory = true;
                    this.addCategoryInput();
                } else {
                    this.addCategory(KeyboardUtils.isShiftDown());
                    this.addingCategory = false;
                    this.editingCategory = false;
                }
            }
        }, List.of(class_2561.method_43471((String)"screens.wynntils.savedItems.addTooltip1"), class_2561.method_43471((String)"screens.wynntils.savedItems.addTooltip2"), class_2561.method_43471((String)"screens.wynntils.savedItems.addTooltip3"), class_2561.method_43471((String)"screens.wynntils.savedItems.addTooltip4")), Texture.ITEM_RECORD_ADD));
        this.method_37063((class_364)new SavedItemsButton(this.field_2776 + 9, this.field_2800 + 31, b -> {
            this.selectedItems = new ArrayList<Pair<String, String>>();
            this.addingCategory = false;
            this.editingCategory = false;
            this.deleteCategory();
        }, List.of(class_2561.method_43471((String)"screens.wynntils.savedItems.deleteTooltip1"), class_2561.method_43471((String)"screens.wynntils.savedItems.deleteTooltip2")), Texture.ITEM_RECORD_DELETE));
        this.method_37063((class_364)new SavedItemsButton(this.field_2776 + 9, this.field_2800 + 42, b -> {
            if (b == 0) {
                this.moveSelectedItems();
            } else if (b == 1) {
                this.selectedItems = new ArrayList<Pair<String, String>>();
                this.selectedSlots = new ArrayList<Integer>();
            }
        }, List.of(class_2561.method_43471((String)"screens.wynntils.savedItems.changeCategoryTooltip1"), class_2561.method_43471((String)"screens.wynntils.savedItems.changeCategoryTooltip2"), class_2561.method_43471((String)"screens.wynntils.savedItems.changeCategoryTooltip3")), Texture.ITEM_RECORD_CONFIRM));
        this.method_37063((class_364)new SavedItemsButton(this.field_2776 + 9, this.field_2800 + 144, null, List.of(class_2561.method_43471((String)"screens.wynntils.savedItems.help").method_27692(class_124.field_1073), class_2561.method_43471((String)"screens.wynntils.savedItems.help1"), class_2561.method_43471((String)"screens.wynntils.savedItems.help2"), class_2561.method_43471((String)"screens.wynntils.savedItems.help3"), class_2561.method_43471((String)"screens.wynntils.savedItems.help4"), class_2561.method_43471((String)"screens.wynntils.savedItems.help5")), Texture.ITEM_RECORD_HELP));
        this.method_37063((class_364)new SavedCategoryButton(this.field_2776 + 21, this.field_2800 + 9, this, false));
        this.method_37063((class_364)new SavedCategoryButton(this.field_2776 + 139, this.field_2800 + 9, this, true));
        if (this.addingCategory) {
            this.addCategoryInput();
        }
        this.populateItems();
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.method_51448(), (class_4597)guiGraphics.field_44658, Texture.ITEM_RECORD, this.field_2776, this.field_2800);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        if (slot == null) {
            return;
        }
        if (slot.method_7677() == class_1799.field_8037) {
            return;
        }
        if (mouseButton == 1) {
            if (KeyboardUtils.isShiftDown()) {
                this.deleteItem(this.encodedItems.get(slot.field_7874).base64());
            } else {
                Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(slot.method_7677());
                if (wynnItemOpt.isPresent()) {
                    McUtils.setScreen(ItemSharingScreen.create(wynnItemOpt.get(), slot.method_7677(), true));
                } else {
                    McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"screens.wynntils.savedItems.unableToShare"));
                }
            }
        } else if (mouseButton == 0) {
            int index;
            int rowOffset = 7 * this.itemScrollOffset;
            this.dragSelectionStartIndex = index = slot.field_7874 + rowOffset;
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        if (!this.addingCategory && !this.editingCategory) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(this.currentCategory), this.field_2776 + 37, this.field_2776 + 37 + 97, this.field_2800 + 10, this.field_2800 + 10 + 8, 97.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NONE);
        }
        for (int selectedSlot : this.selectedSlots) {
            BufferedRenderUtils.drawRectBorders(poseStack, (class_4597)guiGraphics.field_44658, CommonColors.WHITE, this.field_2776 + ((SavedItemsMenu)this.method_17577()).method_7611((int)selectedSlot).field_7873, this.field_2800 + ((SavedItemsMenu)this.method_17577()).method_7611((int)selectedSlot).field_7872, this.field_2776 + ((SavedItemsMenu)this.method_17577()).method_7611((int)selectedSlot).field_7873 + 16, this.field_2800 + ((SavedItemsMenu)this.method_17577()).method_7611((int)selectedSlot).field_7872 + 16, 200.0f, 1.0f);
        }
        this.renderScrollButton(poseStack);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        float scrollButtonRenderX = this.field_2776 + 155;
        float scrollButtonRenderY = (float)(this.field_2800 + 18) + MathUtils.map(this.itemScrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 129.0f);
        if (MathUtils.isInside((int)mouseX, (int)mouseY, (int)scrollButtonRenderX, (int)(scrollButtonRenderX + (float)Texture.ITEM_RECORD_SCROLL.width()), (int)scrollButtonRenderY, (int)(scrollButtonRenderY + (float)Texture.ITEM_RECORD_SCROLL.height()))) {
            this.draggingScroll = true;
            return true;
        }
        float categoryRenderX = this.field_2776 + 36;
        float categoryRenderY = this.field_2800 + 10;
        if (!this.currentCategory.equals(Services.ItemRecord.getDefaultCategory()) && !this.editingCategory && !this.addingCategory && MathUtils.isInside((int)mouseX, (int)mouseY, (int)categoryRenderX, (int)(categoryRenderX + 97.0f), (int)categoryRenderY, (int)(categoryRenderY + 8.0f))) {
            this.editingCategory = true;
            this.addCategoryInput();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        int renderY = this.field_2800 + 18;
        int newValue = Math.round(MathUtils.map((float)mouseY, renderY, renderY + 129, 0.0f, this.getMaxScrollOffset()));
        this.scrollItems(newValue - this.itemScrollOffset);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        class_1735 dragSelectionEndSlot = this.method_64240(mouseX, mouseY);
        if (this.dragSelectionStartIndex != -1) {
            int dragSelectionEndIndex = dragSelectionEndSlot == null ? this.dragSelectionStartIndex : dragSelectionEndSlot.field_7874;
            int index = Math.min(this.dragSelectionStartIndex, dragSelectionEndIndex);
            int endIndex = Math.max(this.dragSelectionStartIndex, dragSelectionEndIndex);
            for (int i = index; i <= endIndex && i < this.encodedItems.size(); ++i) {
                SavedItem savedItem = this.encodedItems.get(i);
                if (this.selectedItems.contains(new Pair<String, String>(this.currentCategory, savedItem.base64()))) {
                    this.selectedItems.remove(new Pair<String, String>(this.currentCategory, savedItem.base64()));
                    this.selectedSlots.remove((Object)i);
                    continue;
                }
                this.selectedItems.add(new Pair<String, String>(this.currentCategory, savedItem.base64()));
                this.selectedSlots.add(i);
            }
            this.dragSelectionStartIndex = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        if (mouseY < (double)(this.field_2800 + 18)) {
            this.scrollCategories((int)scrollValue);
        } else {
            this.scrollItems((int)scrollValue);
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if ((this.addingCategory || this.editingCategory) && keyCode == 257) {
            this.addCategory(KeyboardUtils.isShiftDown());
            if (this.addingCategory) {
                this.addingCategory = false;
            } else if (this.editingCategory) {
                this.editingCategory = false;
            }
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void scrollCategories(int scrollDirection) {
        ArrayList categories = new ArrayList((Collection)Services.ItemRecord.categories.get());
        this.addingCategory = false;
        this.editingCategory = false;
        this.method_37066((class_364)this.categoryInput);
        this.categoryInput = null;
        int currentIndex = categories.indexOf(this.currentCategory);
        int newIndex = currentIndex + scrollDirection;
        this.currentCategory = newIndex >= categories.size() ? (String)categories.getFirst() : (newIndex < 0 ? (String)categories.getLast() : (String)categories.get(newIndex));
        this.itemScrollOffset = 0;
        this.populateItems();
    }

    private void renderScrollButton(class_4587 poseStack) {
        float renderX = this.field_2776 + 155;
        float renderY = (float)(this.field_2800 + 18) + MathUtils.map(this.itemScrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 129.0f);
        RenderUtils.drawTexturedRect(poseStack, Texture.ITEM_RECORD_SCROLL, renderX, renderY);
    }

    private void addCategoryInput() {
        if (this.categoryInput != null) {
            this.method_37066((class_364)this.categoryInput);
        }
        this.categoryInput = new TextInputBoxWidget(this.field_2776 + 37, this.field_2800 + 5, 97, 16, null, (TextboxScreen)McUtils.screen(), this.categoryInput);
        if (this.editingCategory) {
            this.categoryInput.setTextBoxInput(this.currentCategory);
        }
        this.method_37063((class_364)this.categoryInput);
    }

    private void addCategory(boolean keepOriginals) {
        String newCategory = this.categoryInput.getTextBoxInput();
        this.method_37066((class_364)this.categoryInput);
        this.categoryInput = null;
        if (newCategory.isEmpty()) {
            return;
        }
        if (this.addingCategory) {
            Services.ItemRecord.addCategory(newCategory, this.selectedItems, keepOriginals);
            if (!this.selectedItems.isEmpty()) {
                this.currentCategory = newCategory;
                this.selectedItems = new ArrayList<Pair<String, String>>();
                this.populateItems();
            }
        } else if (this.editingCategory && !this.currentCategory.equals(newCategory)) {
            Services.ItemRecord.renameCategory(this.currentCategory, newCategory);
            this.currentCategory = newCategory;
            this.populateItems();
        }
    }

    private void deleteCategory() {
        Services.ItemRecord.deleteCategory(this.currentCategory);
        if (this.categoryInput != null) {
            this.method_37066((class_364)this.categoryInput);
            this.categoryInput = null;
        }
        this.currentCategory = Services.ItemRecord.getDefaultCategory();
        this.populateItems();
    }

    private void moveSelectedItems() {
        Services.ItemRecord.moveSelectedItems(this.selectedItems, this.currentCategory, KeyboardUtils.isShiftDown());
        this.selectedItems = new ArrayList<Pair<String, String>>();
        this.populateItems();
    }

    private void deleteItem(String base64) {
        Services.ItemRecord.deleteItem(base64);
        if ((((SavedItemsMenu)this.field_2797).method_7602().size() - 1) % 7 == 0 && this.itemScrollOffset > 0) {
            --this.itemScrollOffset;
        }
        this.populateItems();
    }

    private void populateItems() {
        int rowOffset;
        int i;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        ArrayList<class_1799> selected = new ArrayList<class_1799>();
        this.encodedItems = new TreeMap<Integer, SavedItem>();
        this.selectedSlots = new ArrayList<Integer>();
        ((SavedItemsMenu)this.field_2797).clear();
        List<SavedItem> savedItems = ((Set)Services.ItemRecord.savedItems.get()).stream().filter(savedItem -> savedItem.categories().contains(this.currentCategory)).toList();
        if (savedItems.isEmpty()) {
            return;
        }
        this.encodedItems = savedItems.stream().collect(TreeMap::new, (map, savedItem) -> map.put(map.size(), savedItem), TreeMap::putAll);
        for (i = rowOffset = 7 * this.itemScrollOffset; i < 49 + rowOffset && i < savedItems.size(); ++i) {
            class_1799 itemStack;
            SavedItem savedItem2 = savedItems.get(i);
            WynnItem wynnItem = savedItem2.wynnItem();
            if (wynnItem instanceof GearItem) {
                GearItem gearItem = (GearItem)wynnItem;
                itemStack = gearItem.getItemInfo().metaInfo().material().itemStack();
            } else {
                itemStack = savedItem2.itemStack();
            }
            itemStack = new FakeItemStack(savedItem2.wynnItem(), itemStack, "From " + McUtils.playerName() + "'s Item Record");
            for (Pair<String, String> selectedItem : this.selectedItems) {
                if (!selectedItem.a().equals(this.currentCategory) || !selectedItem.b().equals(savedItem2.base64())) continue;
                selected.add(itemStack);
                break;
            }
            items.add(itemStack);
        }
        for (i = 0; i < 49 && i <= items.size() - 1; ++i) {
            ((SavedItemsMenu)this.field_2797).method_7619(i, 0, (class_1799)items.get(i));
            if (!selected.contains(items.get(i))) continue;
            this.selectedSlots.add(i);
        }
    }

    private void scrollItems(int scrollDirection) {
        int maxValue = this.getMaxScrollOffset();
        this.itemScrollOffset = MathUtils.clamp(this.itemScrollOffset + scrollDirection, 0, maxValue);
        this.populateItems();
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, ((Set)Services.ItemRecord.savedItems.get()).stream().filter(savedItem -> savedItem.categories().contains(this.currentCategory)).toList().size() - 49);
        return maxItemOffset / 7 + (maxItemOffset % 7 > 0 ? 1 : 0);
    }
}

