/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.lootrunpaths;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.base.widgets.ReloadButton;
import com.wynntils.screens.lootrunpaths.widgets.LootrunPathButton;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.event.LootrunPathCacheRefreshEvent;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.TaskUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

public final class WynntilsLootrunPathsScreen
extends WynntilsListScreen<LootrunPathInstance, LootrunPathButton> {
    private WynntilsLootrunPathsScreen() {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.lootruns.name"));
        WynntilsMod.registerEventListener(this);
    }

    public static class_437 create() {
        return new WynntilsLootrunPathsScreen();
    }

    public void method_25419() {
        WynntilsMod.unregisterEventListener(this);
        super.method_25419();
    }

    @SubscribeEvent
    public void onLootrunCacheRefresh(LootrunPathCacheRefreshEvent event) {
        this.reloadElements();
    }

    @Override
    protected void doInit() {
        super.doInit();
        TaskUtils.runAsync(Services.LootrunPaths::refreshLootrunCache);
        this.method_37063((class_364)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f + (float)this.offsetX), 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsMenuScreen.create()));
        this.method_37063((class_364)new ReloadButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + this.offsetY, (int)((float)Texture.RELOAD_ICON_OFFSET.width() / 2.0f / 1.7f), (int)((float)Texture.RELOAD_ICON_OFFSET.height() / 1.7f), "lootrun", () -> TaskUtils.runAsync(Services.LootrunPaths::refreshLootrunCache)));
        this.method_37063((class_364)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.method_37063((class_364)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
    }

    @Override
    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_4068 class_40682 = this.hovered;
        if (class_40682 instanceof LootrunPathButton) {
            LootrunPathButton lootrunPathButton = (LootrunPathButton)class_40682;
            LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
            List<class_5250> tooltipLines = currentLootrun != null && Objects.equals(lootrunPathButton.getLootrun().name(), currentLootrun.name()) ? List.of(class_2561.method_43470((String)lootrunPathButton.getLootrun().name()).method_27692(class_124.field_1067), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.loaded").method_27692(class_124.field_1054), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.viewInFolder").method_27692(class_124.field_1065), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.openOnMap").method_27692(class_124.field_1078), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.unload").method_27692(class_124.field_1060)) : List.of(class_2561.method_43470((String)lootrunPathButton.getLootrun().name()).method_27692(class_124.field_1067), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.load").method_27692(class_124.field_1060), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.viewInFolder").method_27692(class_124.field_1065), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.openOnMap").method_27692(class_124.field_1078), class_2561.method_43471((String)"screens.wynntils.lootruns.lootrunButton.remove").method_27692(class_124.field_1061));
            guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
            return;
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, class_1074.method_4662((String)"screens.wynntils.lootruns.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        if (this.elements.isEmpty()) {
            this.renderNoElementsHelper(poseStack, class_1074.method_4662((String)"screens.wynntils.lootruns.noLootruns", (Object[])new Object[0]));
        }
        this.renderDescription(poseStack);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderDescription(class_4587 poseStack) {
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        if (currentLootrun != null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(currentLootrun.name()), (float)(20 + this.offsetX), (float)(80 + this.offsetY), CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.4f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.chests", (Object[])new Object[0]) + ": " + currentLootrun.chests().size()), 20 + this.offsetX, 99 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.notes", (Object[])new Object[0]) + ": " + currentLootrun.notes().size()), 20 + this.offsetX, 109 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            class_2374 start = (class_2374)currentLootrun.path().points().getFirst();
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.start", (Object[])new Object[0]) + ": " + String.format("[%d, %d, %d]", (int)start.method_10216(), (int)start.method_10214(), (int)start.method_10215())), 20 + this.offsetX, 119 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            class_2374 end = (class_2374)currentLootrun.path().points().getLast();
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.end", (Object[])new Object[0]) + ": " + String.format("[%d, %d, %d]", (int)end.method_10216(), (int)end.method_10214(), (int)end.method_10215())), 20 + this.offsetX, 129 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.description1", (Object[])new Object[0])), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetX, (float)(80 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.lootruns.description2", (Object[])new Object[0])), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetX, (float)(155 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
        }
    }

    @Override
    protected LootrunPathButton getButtonFromElement(int i) {
        int offset = i % this.getElementsPerPage();
        return new LootrunPathButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX), offset * 13 + 25 + this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 37, 9, (LootrunPathInstance)this.elements.get(i), this);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(Services.LootrunPaths.getLootruns().stream().filter(lootrunInstance -> StringUtils.partialMatch(lootrunInstance.name(), searchTerm)).toList());
    }
}

