/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.features.debug.MappingProgressFeature;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.marker.type.DynamicLocationSupplier;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.services.hades.type.PlayerRelation;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.services.map.pois.IconPoi;
import com.wynntils.services.map.pois.PlayerMainMapPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.TerritoryPoi;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.wynn.LocationUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class MainMapScreen
extends AbstractMapScreen {
    private MarkerInfo focusedMarker;
    private boolean showTerrs = false;

    private MainMapScreen() {
        this.centerMapAroundPlayer();
    }

    private MainMapScreen(float mapCenterX, float mapCenterZ) {
        super(mapCenterX, mapCenterZ);
        this.updateMapCenter(mapCenterX, mapCenterZ);
    }

    public static class_437 create() {
        return new MainMapScreen();
    }

    public static class_437 create(float mapCenterX, float mapCenterZ) {
        return new MainMapScreen(mapCenterX, mapCenterZ);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.method_37063((class_364)new BasicTexturedButton(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 7 + 120, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 10, 16, Texture.HELP_ICON, b -> {}, List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.name")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description1")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description2")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description3")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description4")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description5")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description6")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description7")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description8")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description9")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.help.description10")))));
        this.method_37063((class_364)new BasicTexturedButton(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6 + 60, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 12, 16, Texture.WAYPOINT_MANAGER_ICON, b -> McUtils.setScreen(PoiManagementScreen.create(this)), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.manager.name")), class_2561.method_43471((String)"screens.wynntils.map.manager.description").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new BasicTexturedButton(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 4 + 40, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 16, 14, Texture.SHARE_ICON, this::shareLocationOrCompass, List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.share.name")), class_2561.method_43471((String)"screens.wynntils.map.share.description1_1").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.share.description1_2").method_27692(class_124.field_1080)), class_2561.method_43471((String)"screens.wynntils.map.share.description2_1").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.share.description2_2").method_27692(class_124.field_1080)), class_2561.method_43471((String)"screens.wynntils.map.share.description3_1").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.share.description3_2").method_27692(class_124.field_1080)))));
        this.method_37063((class_364)new BasicTexturedButton(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6 + 20, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 12, 16, Texture.WAYPOINT_FOCUS_ICON, b -> {
            if (KeyboardUtils.isShiftDown()) {
                this.centerMapAroundPlayer();
                return;
            }
            List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
            if (!markers.isEmpty()) {
                MarkerInfo markerInfo;
                int index = markers.indexOf(this.focusedMarker);
                this.focusedMarker = markerInfo = markers.get((index + 1) % markers.size());
                Location location = markerInfo.location();
                this.updateMapCenter(location.x, location.z);
            }
        }, List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.focus.name")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.focus.description1")), class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.focus.description2")))));
        this.method_37063((class_364)new BasicTexturedButton(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 14, 14, Texture.ADD_ICON, b -> McUtils.setScreen(PoiCreationScreen.create(this)), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.map.waypoints.add.name")), class_2561.method_43471((String)"screens.wynntils.map.waypoints.add.description").method_27692(class_124.field_1080))));
        if (this.firstInit) {
            BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.field_22789 / this.zoomRenderScale, (float)this.field_22790 / this.zoomRenderScale);
            if (((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).centerWhenUnmapped.get()).booleanValue() && Services.Map.getMapsForBoundingBox(textureBoundingBox).isEmpty()) {
                this.centerMapOnWorld();
            }
            this.firstInit = false;
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        if (this.holdingMapKey && !Managers.Feature.getFeatureInstance(MainMapFeature.class).openMapKeybind.getKeyMapping().method_1434()) {
            this.method_25419();
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.renderMap(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        this.renderPois(poseStack, mouseX, mouseY);
        if (Managers.Feature.getFeatureInstance(MappingProgressFeature.class).isEnabled()) {
            this.renderChunkBorders(poseStack);
            BUFFER_SOURCE.method_22993();
        }
        this.renderCursor(poseStack, ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).playerPointerScale.get()).floatValue(), (CustomColor)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerColor.get(), (PointerType)((Object)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerType.get()));
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        if (currentLootrun != null) {
            MapRenderer.renderLootrunLine(currentLootrun, 2.0f, 3.0f, poseStack, this.centerX, this.centerZ, this.mapCenterX, this.mapCenterZ, this.zoomRenderScale, CommonColors.LIGHT_BLUE.asInt(), CommonColors.BLACK.asInt());
        }
        RenderUtils.disableScissor(guiGraphics);
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCoordinates(poseStack, mouseX, mouseY);
        this.renderZoomWidget(poseStack, mouseX, mouseY);
        this.renderMapButtons(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderPois(class_4587 poseStack, int mouseX, int mouseY) {
        Stream<Poi> pois = Services.Poi.getServicePois();
        pois = Stream.concat(pois, Services.Poi.getCombatPois());
        pois = Stream.concat(pois, Services.Poi.getLabelPois());
        pois = Stream.concat(pois, ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream());
        pois = Stream.concat(pois, Services.Poi.getProvidedCustomPois().stream());
        pois = Stream.concat(pois, Models.Marker.getAllPois());
        pois = Stream.concat(pois, this.getPlayerPois((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemotePartyPlayers.get(), (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemoteFriendPlayers.get(), (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemoteGuildPlayers.get()));
        if (this.showTerrs) {
            pois = Stream.concat(pois, Models.Territory.getTerritoryPois().stream());
        }
        this.renderPois(pois.collect(Collectors.toList()), poseStack, BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.field_22789 / this.zoomRenderScale, (float)this.field_22790 / this.zoomRenderScale), ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).poiScale.get()).floatValue(), mouseX, mouseY);
    }

    private Stream<PlayerMainMapPoi> getPlayerPois(boolean renderRemotePartyPlayers, boolean renderRemoteFriendPlayers, boolean renderRemoteGuildPlayers) {
        return Services.Hades.getHadesUsers().filter(hadesUser -> hadesUser.getRelation() == PlayerRelation.PARTY && renderRemotePartyPlayers || hadesUser.getRelation() == PlayerRelation.FRIEND && renderRemoteFriendPlayers || hadesUser.getRelation() == PlayerRelation.GUILD && renderRemoteGuildPlayers).map(PlayerMainMapPoi::new);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.showTerrs = (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).holdGuildMapOpen.get() != false ? true : !this.showTerrs;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341 && ((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).holdGuildMapOpen.get()).booleanValue()) {
            this.showTerrs = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY)) continue;
            child.method_25402(mouseX, mouseY, button);
            return true;
        }
        if (button == 1) {
            List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
            if (KeyboardUtils.isShiftDown() && !markers.isEmpty()) {
                MarkerInfo markerInfo;
                int index = markers.indexOf(this.focusedMarker);
                this.focusedMarker = markerInfo = markers.get((index + 1) % markers.size());
                Location location = markerInfo.location();
                this.updateMapCenter(location.x, location.z);
                return true;
            }
            this.centerMapAroundPlayer();
        } else if (button == 0) {
            if (this.hovered instanceof WaypointPoi) {
                MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(this.hovered.getLocation().asLocation());
                return true;
            }
            if (this.hovered != null && !(this.hovered instanceof TerritoryPoi)) {
                McUtils.playSoundUI(class_3417.field_14627);
                if (!KeyboardUtils.isShiftDown()) {
                    MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
                }
                if (this.hovered.hasStaticLocation()) {
                    Poi index = this.hovered;
                    if (index instanceof IconPoi) {
                        IconPoi iconPoi = (IconPoi)index;
                        if (iconPoi instanceof CustomPoi) {
                            customPoi = (CustomPoi)iconPoi;
                            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), iconPoi.getIcon(), ((CustomPoi)customPoi).getColor(), ((CustomPoi)customPoi).getColor(), this.hovered.getName());
                        } else {
                            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), iconPoi.getIcon(), this.hovered.getName());
                        }
                    } else {
                        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), this.hovered.getName());
                    }
                } else {
                    Poi finalHovered = this.hovered;
                    MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new DynamicLocationSupplier(() -> finalHovered.getLocation().asLocation()), finalHovered.getName());
                }
                return true;
            }
        } else if (button == 2) {
            if (KeyboardUtils.isShiftDown()) {
                customPoi = this.hovered;
                if (customPoi instanceof CustomPoi && !Services.Poi.isPoiProvided(customPoi = (CustomPoi)customPoi)) {
                    McUtils.setScreen(PoiCreationScreen.create(this, customPoi));
                } else {
                    int gameX = (int)((mouseX - (double)this.centerX) / (double)this.zoomRenderScale + (double)this.mapCenterX);
                    int gameZ = (int)((mouseY - (double)this.centerZ) / (double)this.zoomRenderScale + (double)this.mapCenterZ);
                    McUtils.setScreen(PoiCreationScreen.create(this, new Location(gameX, 0, gameZ)));
                }
            } else if (KeyboardUtils.isAltDown()) {
                Poi gameX = this.hovered;
                if (gameX instanceof CustomPoi && !Services.Poi.isPoiProvided(customPoi = (CustomPoi)gameX)) {
                    HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
                    ((List)customPois.get()).remove(customPoi);
                    customPois.touched();
                }
            } else {
                this.setCompassToMouseCoords(mouseX, mouseY, true);
                return true;
            }
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    private void shareLocationOrCompass(int button) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        boolean shareCompass = KeyboardUtils.isShiftDown() && !markers.isEmpty();
        String target = null;
        if (button == 0) {
            target = "guild";
        } else if (button == 1) {
            target = "party";
        }
        if (target == null) {
            return;
        }
        if (shareCompass) {
            LocationUtils.shareCompass(target, markers.getFirst().location());
        } else {
            LocationUtils.shareLocation(target);
        }
    }

    public void setHovered(Poi hovered) {
        this.hovered = hovered;
    }
}

