/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.selection.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.text.StyledText;
import com.wynntils.overlays.custombars.CustomBarOverlayBase;
import com.wynntils.overlays.infobox.InfoBoxOverlay;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class OverlayButton
extends WynntilsButton {
    private static final CustomColor ENABLED_COLOR = new CustomColor(0, 220, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER = new CustomColor(0, 116, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER_HOVERED = new CustomColor(0, 66, 0, 255);
    private static final CustomColor DISABLED_COLOR = new CustomColor(0, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER = new CustomColor(60, 60, 60, 255);
    private static final CustomColor DISABLED_COLOR_BORDER_HOVERED = new CustomColor(10, 10, 10, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR = new CustomColor(255, 0, 0, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR_BORDER = new CustomColor(120, 0, 0, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR_BORDER_HOVERED = new CustomColor(70, 0, 0, 255);
    private static final List<class_2561> EDIT_NAME_TOOLTIP = List.of(class_2561.method_43471((String)"screens.wynntils.overlaySelection.editName"));
    private static final List<class_2561> SAVE_NAME_TOOLTIP = List.of(class_2561.method_43471((String)"screens.wynntils.overlaySelection.stopEdit"));
    private static final List<class_2561> VIEW_TOOLTIP = List.of(class_2561.method_43471((String)"screens.wynntils.overlaySelection.viewTooltip"));
    private final List<class_2561> descriptionTooltip;
    private final Overlay overlay;
    private final OverlaySelectionScreen selectionScreen;
    private String textToRender;
    private TextInputBoxWidget editInput;

    public OverlayButton(int x, int y, int width, int height, Overlay overlay, OverlaySelectionScreen selectionScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)overlay.getTranslatedName()));
        CustomNameProperty customNameProperty;
        this.overlay = overlay;
        this.selectionScreen = selectionScreen;
        this.textToRender = overlay instanceof CustomNameProperty ? (!((String)(customNameProperty = (CustomNameProperty)((Object)overlay)).getCustomName().get()).isEmpty() ? (String)customNameProperty.getCustomName().get() : overlay.getTranslatedName()) : overlay.getTranslatedName();
        this.descriptionTooltip = overlay instanceof InfoBoxOverlay ? ComponentUtils.wrapTooltips(Streams.concat((Stream[])new Stream[]{VIEW_TOOLTIP.stream(), EDIT_NAME_TOOLTIP.stream()}).toList(), 150) : (overlay instanceof CustomBarOverlayBase ? ComponentUtils.wrapTooltips(Streams.concat((Stream[])new Stream[]{VIEW_TOOLTIP.stream(), EDIT_NAME_TOOLTIP.stream()}).toList(), 150) : ComponentUtils.wrapTooltips(VIEW_TOOLTIP, 150));
        if (overlay instanceof CustomNameProperty) {
            CustomNameProperty customNameOverlay = (CustomNameProperty)((Object)overlay);
            this.editInput = new TextInputBoxWidget(x, y, width, height, null, selectionScreen);
            this.editInput.field_22764 = false;
            String currentName = (String)customNameOverlay.getCustomName().get();
            if (currentName.isEmpty()) {
                this.editInput.setTextBoxInput(overlay.getTranslatedName());
            } else {
                this.editInput.setTextBoxInput(currentName);
            }
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        boolean enabled = Managers.Overlay.isEnabled(this.overlay);
        RenderUtils.drawRect(poseStack, this.getRectColor(enabled).withAlpha(100), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(enabled), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.textToRender), this.method_46426() + 2, (float)this.method_46427() + (float)this.field_22759 / 2.0f, this.field_22758 - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        if (this.editInput != null) {
            this.editInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.field_22762 && (mouseY <= this.selectionScreen.getConfigMaskTopY() || mouseY >= this.selectionScreen.getConfigMaskBottomY())) {
            this.field_22762 = false;
        }
        if (this.field_22762) {
            if (!this.overlay.isParentEnabled()) {
                McUtils.screen().method_47414(Lists.transform(ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.overlaySelection.parentDisabled", (Object[])new Object[]{this.overlay.getParentTranslatedName()})), 200), class_2561::method_30937));
            } else {
                McUtils.screen().method_47414(Lists.transform(this.editInput != null && this.editInput.field_22764 ? SAVE_NAME_TOOLTIP : this.descriptionTooltip, class_2561::method_30937));
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.selectionScreen.getConfigMaskTopY() || mouseY >= (double)this.selectionScreen.getConfigMaskBottomY()) {
            return false;
        }
        if (this.editInput != null && this.editInput.field_22764 && this.editInput.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            if (this.isSelected() && this.editInput != null) {
                this.editInput.field_22764 = true;
                this.selectionScreen.setFocusedTextInput(this.editInput);
            } else {
                this.selectionScreen.selectOverlay(this.overlay);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.selectionScreen.getConfigMaskTopY() || mouseY >= (double)this.selectionScreen.getConfigMaskBottomY()) {
            return false;
        }
        if (this.editInput != null) {
            this.editInput.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25306() {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.editInput != null && this.editInput.field_22764) {
            this.editInput.field_22764 = false;
            Overlay overlay = this.overlay;
            if (overlay instanceof CustomNameProperty) {
                CustomNameProperty customNameOverlay = (CustomNameProperty)((Object)overlay);
                customNameOverlay.setCustomName(this.editInput.getTextBoxInput());
                this.textToRender = this.editInput.getTextBoxInput().isEmpty() ? this.overlay.getTranslatedName() : this.editInput.getTextBoxInput();
            }
            return true;
        }
        return false;
    }

    public void method_46419(int y) {
        super.method_46419(y);
        if (this.editInput != null) {
            this.editInput.method_46419(y);
        }
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void hideEditInput() {
        if (this.editInput != null) {
            this.editInput.field_22764 = false;
        }
    }

    private CustomColor getRectColor(boolean enabled) {
        if (this.isSelected()) {
            return CommonColors.GRAY;
        }
        if (!this.overlay.isParentEnabled()) {
            return DISABLED_FEATURE_COLOR;
        }
        return enabled ? ENABLED_COLOR : DISABLED_COLOR;
    }

    private CustomColor getBorderColor(boolean enabled) {
        if (this.isSelected()) {
            return this.field_22762 ? CommonColors.LIGHT_GRAY : CommonColors.WHITE;
        }
        if (!this.overlay.isParentEnabled()) {
            return this.field_22762 ? DISABLED_FEATURE_COLOR_BORDER_HOVERED : DISABLED_FEATURE_COLOR_BORDER;
        }
        return enabled ? (this.field_22762 ? ENABLED_COLOR_BORDER_HOVERED : ENABLED_COLOR_BORDER) : (this.field_22762 ? DISABLED_COLOR_BORDER_HOVERED : DISABLED_COLOR_BORDER);
    }

    private boolean isSelected() {
        return this.selectionScreen.getSelectedOverlay() == this.overlay;
    }
}

