/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.territorymanagement.TerritoryManagementHolder;
import com.wynntils.screens.territorymanagement.type.TerritoryColor;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class TerritoryWidget
extends class_339
implements TooltipProvider {
    private final TerritoryManagementHolder holder;
    private final TerritoryColor territoryColor;
    private final class_1799 itemStack;
    private final TerritoryItem territoryItem;

    public TerritoryWidget(int x, int y, int width, int height, TerritoryManagementHolder holder, TerritoryColor territoryColor, class_1799 itemStack, TerritoryItem territoryItem) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)territoryItem.getName()));
        this.holder = holder;
        this.territoryColor = territoryColor;
        this.itemStack = itemStack;
        this.territoryItem = territoryItem;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.territoryColor.backgroundColors().isEmpty()) {
            RenderUtils.drawMulticoloredRect(guiGraphics.method_51448(), this.territoryColor.backgroundColors(), this.method_46426(), this.method_46427(), 0.0f, this.method_25368(), this.method_25364());
        }
        if (this.territoryColor.borderColor() != CustomColor.NONE) {
            RenderUtils.drawRectBorders(guiGraphics.method_51448(), this.territoryColor.borderColor(), (float)this.method_46426() + 0.75f, (float)this.method_46427() + 0.75f, (float)(this.method_46426() + this.method_25368()) - 0.75f, (float)(this.method_46427() + this.method_25364()) - 0.75f, 0.0f, 1.5f);
        }
        guiGraphics.method_51448().method_22903();
        Texture texture = Texture.TERRITORY_ITEM;
        if (this.territoryItem.isSelected()) {
            texture = Texture.CHECKMARK_GREEN;
        } else if (this.territoryItem.isHeadquarters()) {
            texture = Texture.TERRITORY_ITEM_HQ;
        } else if (!this.territoryItem.getAlerts().isEmpty()) {
            texture = Texture.TERRITORY_ITEM_ALERT;
        }
        int itemWidth = (int)((float)this.method_25368() * 0.9f);
        int itemHeight = (int)((float)this.method_25364() * 0.9f);
        int itemRenderX = this.method_46426() + (this.method_25368() - itemWidth) / 2;
        int itemRenderY = this.method_46427() + (this.method_25364() - itemHeight) / 2;
        RenderUtils.drawScalingTexturedRect(guiGraphics.method_51448(), texture.resource(), itemRenderX, itemRenderY, 0.0f, itemWidth, itemHeight, texture.width(), texture.height());
        guiGraphics.method_51448().method_22909();
        Set productionTypes = this.territoryItem.getProduction().keySet().stream().filter(GuildResource::isMaterialResource).collect(Collectors.toUnmodifiableSet());
        if (!productionTypes.isEmpty()) {
            if (productionTypes.size() <= 2) {
                GuildResource productionType = (GuildResource)((Object)productionTypes.iterator().next());
                Object symbol = productionType.getPrettySymbol().trim();
                symbol = (String)symbol + (productionTypes.size() == 2 ? ((GuildResource)((Object)productionTypes.iterator().next())).getPrettySymbol().trim() : "");
                FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromString((String)symbol), this.method_46426(), this.method_46426() + this.method_25368(), this.method_46427(), this.method_46427() + this.method_25364(), 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
            } else {
                int i = 0;
                for (GuildResource productionType : productionTypes) {
                    String symbol = productionType.getPrettySymbol().trim();
                    FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(symbol), this.method_46426() + i % 2 * 8, this.method_46427() + i / 2 * 8, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
                    ++i;
                }
            }
            String shortTerritoryName = Arrays.stream(this.territoryItem.getName().split(" ")).map(s -> s.substring(0, 1)).collect(Collectors.joining());
            int maxTextWidth = (int)((float)this.method_25368() * 0.85f);
            int textWidth = FontRenderer.getInstance().getFont().method_1727(shortTerritoryName);
            float textScale = Math.min(0.95f, (float)maxTextWidth / (float)textWidth);
            FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromString(shortTerritoryName), (float)this.method_46426(), (float)(this.method_46426() + this.method_25368()), (float)this.method_46427(), (float)(this.method_46427() + this.method_25364()), 0.0f, CommonColors.ORANGE, HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, TextShadow.OUTLINE, textScale);
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        this.holder.territoryItemClicked(this.territoryItem);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    @Override
    public List<class_2561> getTooltipLines() {
        return this.itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)McUtils.mc().field_1687), (class_1657)McUtils.player(), (class_1836)class_1836.field_41070);
    }
}

