/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.trademarket;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchHelperWidget;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.trademarket.TradeMarketSearchResultHolder;
import com.wynntils.screens.trademarket.widgets.PresetButton;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class TradeMarketSearchResultScreen
extends WynntilsContainerScreen<class_1707>
implements WrappedScreen {
    private static final int FAKE_CONTAINER_ID = 454545;
    private static final class_2960 CONTAINER_BACKGROUND = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    private static final int SCROLL_AREA_HEIGHT = 110;
    private static final int ITEMS_PER_PAGE = 54;
    private final TradeMarketSearchResultHolder holder;
    private final WrappedScreenInfo wrappedScreenInfo;
    private ItemSearchWidget itemSearchWidget;
    private BasicTexturedButton sortOptionsButton;
    private class_2561 currentState = class_2561.method_43473();
    private int scrollOffset = 0;
    private boolean holdingScrollbar = false;

    protected TradeMarketSearchResultScreen(WrappedScreenInfo wrappedScreenInfo, TradeMarketSearchResultHolder holder) {
        super(class_1707.method_19251((int)454545, (class_1661)McUtils.inventory()), McUtils.inventory(), (class_2561)class_2561.method_43470((String)"Trade Market Search Result Wrapped Screen"));
        this.field_2779 = 114 + ((class_1707)this.method_17577()).method_17388() * 18;
        this.field_25270 = this.field_2779 - 94;
        this.holder = holder;
        this.wrappedScreenInfo = wrappedScreenInfo;
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }

    @Override
    protected void doInit() {
        super.doInit();
        int renderX = (this.field_22789 - this.field_2792) / 2;
        int renderY = (this.field_22790 - this.field_2779) / 2 - 22;
        this.itemSearchWidget = new ItemSearchWidget(renderX, renderY, 155, 20, ItemProviderType.normalTypes(), true, query -> {
            this.saveSearchFilter((ItemSearchQuery)query);
            this.reloadElements();
        }, (TextboxScreen)((Object)this));
        this.method_37063((class_364)this.itemSearchWidget);
        this.itemSearchWidget.setTextBoxInput(Models.TradeMarket.getLastSearchFilter());
        this.method_37063((class_364)new ItemFilterUIButton(renderX + 157, renderY, this.itemSearchWidget, (class_437)this, true, Arrays.stream(ItemProviderType.values()).toList()));
        BasicTexturedButton backButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height(), Texture.ARROW_LEFT_ICON.width(), Texture.ARROW_LEFT_ICON.height(), Texture.ARROW_LEFT_ICON, button -> this.holder.goBackToSearch(), List.of(class_2561.method_43471((String)"screens.wynntils.tradeMarketSearchResult.backToSearch").method_27692(class_124.field_1067)));
        this.method_37063((class_364)backButton);
        BasicTexturedButton loadMoreButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height() - 17, Texture.SMALL_ADD_ICON.width(), Texture.SMALL_ADD_ICON.height(), Texture.SMALL_ADD_ICON, button -> this.holder.loadNextPageBatch(), List.of(class_2561.method_43469((String)"screens.wynntils.tradeMarketSearchResult.loadNextBatch", (Object[])new Object[]{this.holder.getPageLoadBatchSize()}).method_27692(class_124.field_1067)));
        this.method_37063((class_364)loadMoreButton);
        this.sortOptionsButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height() - 34, Texture.SORT.width(), Texture.SORT.height(), Texture.SORT, this.holder::changeSortingMode, this.holder.getSortingItemTooltip());
        this.method_37063((class_364)this.sortOptionsButton);
        for (int i = 0; i < 4; ++i) {
            this.method_37063((class_364)new PresetButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + 25 + i * (Texture.PRESET.height() + 2), Texture.PRESET.width(), Texture.PRESET.height(), i, this));
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.updateItems();
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollButton(poseStack);
        this.field_33816.forEach(c -> c.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        super.method_2380(guiGraphics, mouseX, mouseY);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.method_25405((double)mouseX, (double)mouseY)) continue;
            guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            break;
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(FontRenderer.getInstance().getFont(), this.currentState, this.field_25267, this.field_25268, CommonColors.TITLE_GRAY.asInt(), false);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        class_4587 poseStack = guiGraphics.method_51448();
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        RenderUtils.drawTexturedRect(poseStack, CONTAINER_BACKGROUND, x, y, this.field_2792, ((class_1707)this.field_2797).method_17388() * 18 + 17, 256, 256);
        RenderUtils.drawTexturedRect(poseStack, CONTAINER_BACKGROUND, x, y + ((class_1707)this.field_2797).method_17388() * 18 + 17, 0.0f, this.field_2792, 96.0f, 0, 126, this.field_2792, 96, 256, 256);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLLBAR_BACKGROUND, x + this.field_2792 - 7, y);
        RenderUtils.drawTexturedRect(poseStack, Texture.CONTAINER_SIDEBAR, x - Texture.CONTAINER_SIDEBAR.width() + 7, y);
    }

    private void renderScrollButton(class_4587 poseStack) {
        float renderX = (this.field_22789 - this.field_2792) / 2 + this.field_2792 + Texture.SCROLLBAR_BACKGROUND.width() / 2 - 14;
        float renderY = (float)((this.field_22790 - this.field_2779) / 2 + Texture.SCROLLBAR_BUTTON.height() / 2) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 110.0f);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLLBAR_BUTTON, renderX, renderY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        float scrollBarRenderX = (this.field_22789 - this.field_2792) / 2 + this.field_2792 + Texture.SCROLLBAR_BACKGROUND.width() / 2 - 14;
        float scrollBarRenderY = (float)((this.field_22790 - this.field_2779) / 2 + Texture.SCROLLBAR_BUTTON.height() / 2) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 110.0f);
        if (mouseX >= (double)scrollBarRenderX && mouseX <= (double)(scrollBarRenderX + (float)Texture.SCROLLBAR_BUTTON.width()) && mouseY >= (double)scrollBarRenderY && mouseY <= (double)(scrollBarRenderY + (float)Texture.SCROLLBAR_BUTTON.height())) {
            this.holdingScrollbar = true;
            return true;
        }
        if (this.field_2787 != null) {
            this.holder.clickOnItem(this.field_2787.method_7677());
            return true;
        }
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof ItemSearchHelperWidget) || !child.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.holdingScrollbar) {
            return false;
        }
        int renderY = (this.field_22790 - this.field_2779) / 2;
        int scrollAreaStartY = renderY + 14;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + 110, 0.0f, this.getMaxScrollOffset()));
        this.scroll(newValue - this.scrollOffset);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.holdingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void setSearchQuery(String query) {
        this.itemSearchWidget.setTextBoxInput(query);
    }

    public ItemSearchQuery getSearchQuery() {
        return this.itemSearchWidget.getSearchQuery();
    }

    public void onSortingModeChanged() {
        this.sortOptionsButton.setTooltip(this.holder.getSortingItemTooltip());
    }

    private void scroll(int delta) {
        int maxValue = this.getMaxScrollOffset();
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, maxValue);
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, this.holder.getFilteredItems().size() - 54);
        int maxValue = maxItemOffset / 9 + (maxItemOffset % 9 > 0 ? 1 : 0);
        return maxValue;
    }

    private void updateItems() {
        List<class_1799> filteredItems = this.holder.getFilteredItems();
        for (int i = 0; i < 54; ++i) {
            ((class_1707)this.field_2797).method_7619(i, 0, class_1799.field_8037);
        }
        int itemIndex = this.scrollOffset * 9;
        for (int currentSlot = 0; itemIndex < filteredItems.size() && currentSlot < 54; ++itemIndex, ++currentSlot) {
            class_1799 itemStack = filteredItems.get(itemIndex);
            ((class_1707)this.field_2797).method_7619(currentSlot, 0, itemStack);
        }
    }

    protected void setCurrentState(class_2561 currentState) {
        this.currentState = currentState;
    }

    private void reloadElements() {
        this.holder.updateDisplayItems(this.itemSearchWidget.getSearchQuery());
        this.scrollOffset = 0;
    }

    private void saveSearchFilter(ItemSearchQuery query) {
        Models.TradeMarket.setLastSearchFilter(query.queryString());
    }
}

