/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.chat.ChatTabsFeature;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.chat.WrappingChatComponent;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.services.chat.type.ChatTabData;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_338;
import net.minecraft.class_5250;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import net.neoforged.bus.api.SubscribeEvent;

public final class ChatTabService
extends Service {
    private final Map<ChatTab, ChatTabData> tabDataMap = new HashMap<ChatTab, ChatTabData>();
    private final List<ChatTab> chatTabs = new ArrayList<ChatTab>();
    private class_338 vanillaChatComponent = null;
    private ChatTab focusedTab = null;

    public ChatTabService() {
        super(List.of());
    }

    public List<ChatTab> getChatTabs() {
        return this.chatTabs;
    }

    public ChatTab getTab(int index) {
        return this.getChatTabs().get(index);
    }

    public int getTabCount() {
        return this.getChatTabs().size();
    }

    public int getTabIndex(ChatTab edited) {
        return this.getChatTabs().indexOf(edited);
    }

    public int getTabIndexAfterFocused() {
        return (this.getTabIndex(this.getFocusedTab()) + 1) % this.getTabCount();
    }

    public int getTabIndexBeforeFocused() {
        int tabIndex = this.getTabIndex(this.getFocusedTab());
        return (tabIndex - 1 + this.getTabCount()) % this.getTabCount();
    }

    public void addTab(int insertIndex, ChatTab chatTab) {
        this.getChatTabs().add(insertIndex, chatTab);
        HiddenConfig<List<ChatTab>> configChatTabs = Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs;
        ((List)configChatTabs.get()).add(insertIndex, chatTab);
        configChatTabs.touched();
        this.tabDataMap.put(chatTab, new ChatTabData(new class_338(McUtils.mc()), false, chatTab.customRegexString()));
    }

    public void removeTab(ChatTab chatTab) {
        this.getChatTabs().remove(chatTab);
        HiddenConfig<List<ChatTab>> configChatTabs = Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs;
        ((List)configChatTabs.get()).remove(chatTab);
        configChatTabs.touched();
        this.tabDataMap.remove(chatTab);
    }

    public class_338 getChatComponent(ChatTab tab) {
        return this.tabDataMap.get(tab).getChatComponent();
    }

    public boolean hasUnreadMessages(ChatTab tab) {
        return this.tabDataMap.get(tab).hasUnreadMessages();
    }

    public ChatTab getFocusedTab() {
        return this.focusedTab;
    }

    public void setFocusedTab(int index) {
        this.setFocusedTab(this.getTab(index));
    }

    public void setFocusedTab(ChatTab focused) {
        this.focusedTab = focused;
        ChatTabData focusedChatTabData = this.tabDataMap.get(focused);
        focusedChatTabData.setUnreadMessages(false);
        McUtils.mc().field_1705.field_2021.field_2061 = focusedChatTabData.getChatComponent().field_2061;
        McUtils.mc().field_1705.field_2021.field_2064 = focusedChatTabData.getChatComponent().field_2064;
        McUtils.mc().field_1705.field_2021.method_44813();
    }

    public void enable() {
        if (this.isEnabled()) {
            return;
        }
        if (this.getTabCount() == 0) {
            WynntilsMod.warn("Cannot enable Chat Tabs: no tabs configured");
            return;
        }
        this.reset();
        this.getChatTabs().forEach(chatTab -> this.tabDataMap.put((ChatTab)chatTab, new ChatTabData(new class_338(McUtils.mc()), false, chatTab.customRegexString())));
        McUtils.mc().field_1705.field_2021.field_2061.reversed().forEach(msg -> {
            class_2561 component = msg.comp_893();
            StyledText styledText = StyledText.fromComponent(component);
            RecipientType recipientType = Handlers.Chat.getRecipientType(styledText, MessageType.FOREGROUND);
            List<ChatTab> recipientTabs = Services.ChatTab.getRecipientTabs(recipientType, styledText);
            recipientTabs.forEach(tab -> Services.ChatTab.getChatComponent((ChatTab)tab).method_1812(component));
        });
        this.vanillaChatComponent = McUtils.mc().field_1705.field_2021;
        McUtils.mc().field_1705.field_2021 = new WrappingChatComponent(McUtils.mc());
        this.setFocusedTab(this.getChatTabs().getFirst());
    }

    public void disable() {
        if (!this.isEnabled()) {
            return;
        }
        McUtils.mc().field_1705.field_2021 = this.vanillaChatComponent;
        this.vanillaChatComponent = null;
        this.reset();
        this.focusedTab = null;
    }

    public boolean isEnabled() {
        return this.focusedTab != null;
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            this.reset();
        }
    }

    void clearMessages(boolean clearSentMsgHistory) {
        this.vanillaChatComponent.method_1808(clearSentMsgHistory);
        this.tabDataMap.values().forEach(chatTabData -> chatTabData.getChatComponent().method_1808(clearSentMsgHistory));
    }

    void addMessage(class_2561 component, class_7469 headerSignature, class_7591 tag) {
        try {
            this.vanillaChatComponent.method_44811(component, headerSignature, tag);
            StyledText styledText = StyledText.fromComponent(component);
            RecipientType recipientType = Handlers.Chat.getRecipientType(styledText, MessageType.FOREGROUND);
            List<ChatTab> recipientTabs = this.getRecipientTabs(recipientType, styledText);
            recipientTabs.forEach(tab -> {
                this.getChatComponent((ChatTab)tab).method_1812(component);
                this.markAsNewMessages((ChatTab)tab);
            });
        }
        catch (Throwable t) {
            this.warnAboutBrokenMod(component, t);
        }
    }

    private void warnAboutBrokenMod(class_2561 component, Throwable t) {
        class_5250 warning = class_2561.method_43470((String)"<< WARNING: A chat message was lost due to a crash in a mod other than Wynntils. See log for details. >>").method_27692(class_124.field_1061);
        this.vanillaChatComponent.method_1812((class_2561)warning);
        this.getChatComponent(this.focusedTab).method_1812((class_2561)warning);
        WynntilsMod.warn("Another mod has caused an exception in ChatComponent.addMessage()");
        WynntilsMod.warn("The message that could not be displayed is:" + StyledText.fromComponent(component).getString());
        WynntilsMod.warn("This is not a Wynntils bug. Here is the exception that we caught.", t);
    }

    private void reset() {
        this.tabDataMap.clear();
    }

    private void markAsNewMessages(ChatTab tab) {
        if (tab != this.focusedTab) {
            this.tabDataMap.get(tab).setUnreadMessages(true);
        }
    }

    private List<ChatTab> getRecipientTabs(RecipientType recipientType, StyledText styledText) {
        ArrayList<ChatTab> recipientTabs = new ArrayList<ChatTab>();
        for (ChatTab chatTab : this.getChatTabs()) {
            if (!chatTab.consuming() || !this.matchMessage(chatTab, recipientType, styledText)) continue;
            recipientTabs.add(chatTab);
            return recipientTabs;
        }
        for (ChatTab chatTab : this.getChatTabs()) {
            if (chatTab.consuming() || !this.matchMessage(chatTab, recipientType, styledText)) continue;
            recipientTabs.add(chatTab);
        }
        return recipientTabs;
    }

    private boolean matchMessage(ChatTab chatTab, RecipientType recipientType, StyledText originalStyledText) {
        if (chatTab.filteredTypes() != null && !chatTab.filteredTypes().isEmpty() && !chatTab.filteredTypes().contains((Object)recipientType)) {
            return false;
        }
        Optional<Pattern> regex = this.tabDataMap.get(chatTab).getCustomRegex();
        if (regex.isEmpty()) {
            return true;
        }
        return originalStyledText.matches(regex.get());
    }

    public void modifyChatHistory(Consumer<List<class_303>> allMessagesConsumer) {
        if (!this.isEnabled()) {
            class_338 chatComponent2 = McUtils.mc().field_1705.field_2021;
            allMessagesConsumer.accept(chatComponent2.field_2061);
            chatComponent2.method_44813();
            return;
        }
        Stream.concat(Stream.of(this.vanillaChatComponent), this.tabDataMap.values().stream().map(ChatTabData::getChatComponent)).forEach(chatComponent -> {
            allMessagesConsumer.accept(chatComponent.field_2061);
            chatComponent.method_44813();
        });
    }

    public void sendChat(String message) {
        if (message.isBlank()) {
            return;
        }
        if (!this.isEnabled()) {
            McUtils.sendChat(message);
            return;
        }
        String autoCommand = this.getFocusedTab().autoCommand();
        if (autoCommand != null && !autoCommand.isBlank()) {
            autoCommand = autoCommand.startsWith("/") ? autoCommand.substring(1) : autoCommand;
            Handlers.Command.sendCommandImmediately(autoCommand + " " + message);
        } else {
            McUtils.sendChat(message);
        }
    }

    public void setChatTabs(List<ChatTab> chatTabs) {
        this.chatTabs.clear();
        this.chatTabs.addAll(chatTabs);
        HashMap<ChatTab, ChatTabData> oldMap = new HashMap<ChatTab, ChatTabData>(this.tabDataMap);
        this.tabDataMap.clear();
        chatTabs.forEach(chatTab -> this.tabDataMap.put((ChatTab)chatTab, oldMap.containsKey(chatTab) ? (ChatTabData)oldMap.get(chatTab) : new ChatTabData(new class_338(McUtils.mc()), false, chatTab.customRegexString())));
        if (this.focusedTab != null) {
            this.setFocusedTab(chatTabs.getFirst());
        }
    }
}

