/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hades;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.hades.protocol.packets.server.HSPacketUpdateMutual;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.services.hades.type.PlayerRelation;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;

public class HadesUser {
    private final UUID uuid;
    private final String name;
    private PlayerRelation relation;
    private float x;
    private float y;
    private float z;
    private PoiLocation poiLocation;
    private CappedValue health;
    private CappedValue mana;
    private NavigableMap<InventoryArmor, WynnItem> armor = new TreeMap<InventoryArmor, WynnItem>();
    private NavigableMap<InventoryAccessory, WynnItem> accessories = new TreeMap<InventoryAccessory, WynnItem>();
    private WynnItem heldItem = null;
    private Map<InventoryArmor, String> armorCache = new TreeMap<InventoryArmor, String>();
    private Map<InventoryAccessory, String> accessoriesCache = new TreeMap<InventoryAccessory, String>();
    private String heldItemCache = "";

    public HadesUser(HSPacketUpdateMutual packet) {
        this.uuid = packet.getUser();
        this.name = packet.getName();
        this.updateFromPacket(packet);
    }

    public HadesUser(String name, CappedValue health, CappedValue mana) {
        this.uuid = UUID.fromString("8667ba71-b85a-4004-af54-457a9734eed7");
        this.name = name;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.poiLocation = new PoiLocation(0, 0, 0);
        this.relation = PlayerRelation.FRIEND;
        this.health = health;
        this.mana = mana;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public PoiLocation getMapLocation() {
        return this.poiLocation;
    }

    public CappedValue getHealth() {
        return this.health;
    }

    public CappedValue getMana() {
        return this.mana;
    }

    public NavigableMap<InventoryArmor, WynnItem> getArmor() {
        return Collections.unmodifiableNavigableMap(this.armor);
    }

    public NavigableMap<InventoryAccessory, WynnItem> getAccessories() {
        return Collections.unmodifiableNavigableMap(this.accessories);
    }

    public WynnItem getHeldItem() {
        return this.heldItem;
    }

    public void updateFromPacket(HSPacketUpdateMutual packet) {
        this.x = packet.getX();
        this.y = packet.getY();
        this.z = packet.getZ();
        this.poiLocation = new PoiLocation((int)this.x, (int)this.y, (int)this.z);
        this.health = new CappedValue(packet.getHealth(), packet.getMaxHealth());
        this.mana = new CappedValue(packet.getMana(), packet.getMaxMana());
        this.handleArmorData(InventoryArmor.HELMET, GearType.HELMET, packet.getHelmet());
        this.handleArmorData(InventoryArmor.CHESTPLATE, GearType.CHESTPLATE, packet.getChestplate());
        this.handleArmorData(InventoryArmor.LEGGINGS, GearType.LEGGINGS, packet.getLeggings());
        this.handleArmorData(InventoryArmor.BOOTS, GearType.BOOTS, packet.getBoots());
        this.handleAccessoryData(InventoryAccessory.RING_1, GearType.RING, packet.getRingOne());
        this.handleAccessoryData(InventoryAccessory.RING_2, GearType.RING, packet.getRingTwo());
        this.handleAccessoryData(InventoryAccessory.BRACELET, GearType.BRACELET, packet.getBracelet());
        this.handleAccessoryData(InventoryAccessory.NECKLACE, GearType.NECKLACE, packet.getNecklace());
        if (packet.getHeldItem().isEmpty()) {
            this.heldItem = null;
            this.heldItemCache = "";
        } else if (!this.heldItemCache.equals(packet.getHeldItem())) {
            ErrorOr<WynnItem> errorOrDecodedItem = this.decodeItem(packet.getHeldItem());
            if (errorOrDecodedItem.hasError()) {
                WynntilsMod.warn("Failed to decode Hades user held item: " + errorOrDecodedItem.getError());
            } else {
                GearTypeItemProperty gearItemType;
                WynnItem item = errorOrDecodedItem.getValue();
                if (item instanceof GearTypeItemProperty && (gearItemType = (GearTypeItemProperty)((Object)item)).getGearType().isWeapon()) {
                    this.heldItem = item;
                    this.heldItemCache = packet.getHeldItem();
                }
            }
        }
        this.relation = packet.isPartyMember() ? PlayerRelation.PARTY : (packet.isMutualFriend() ? PlayerRelation.FRIEND : (packet.isGuildMember() ? PlayerRelation.GUILD : PlayerRelation.OTHER));
    }

    public CustomColor getRelationColor() {
        return this.relation != null ? this.relation.getRelationColor() : CommonColors.WHITE;
    }

    public PlayerRelation getRelation() {
        return this.relation;
    }

    private void handleArmorData(InventoryArmor armor, GearType expectedGearType, String armorData) {
        if (armorData.isEmpty()) {
            this.armor.remove((Object)armor);
            this.armorCache.remove((Object)armor);
        } else if (!this.armorCache.getOrDefault((Object)armor, "").equals(armorData)) {
            ErrorOr<WynnItem> errorOrDecodedItem = this.decodeItem(armorData);
            if (errorOrDecodedItem.hasError()) {
                WynntilsMod.warn("Failed to decode Hades user " + String.valueOf((Object)armor) + ": " + errorOrDecodedItem.getError());
            } else {
                GearTypeItemProperty gearItemType;
                WynnItem item = errorOrDecodedItem.getValue();
                if (item instanceof GearTypeItemProperty && (gearItemType = (GearTypeItemProperty)((Object)item)).getGearType() == expectedGearType) {
                    this.armor.put(armor, errorOrDecodedItem.getValue());
                    this.armorCache.put(armor, armorData);
                }
            }
        }
    }

    private void handleAccessoryData(InventoryAccessory accessory, GearType expectedGearType, String accessoryData) {
        if (accessoryData.isEmpty()) {
            this.accessories.remove((Object)accessory);
            this.accessoriesCache.remove((Object)accessory);
        } else if (!this.accessoriesCache.getOrDefault((Object)accessory, "").equals(accessoryData)) {
            ErrorOr<WynnItem> errorOrDecodedItem = this.decodeItem(accessoryData);
            if (errorOrDecodedItem.hasError()) {
                WynntilsMod.warn("Failed to decode Hades user " + String.valueOf((Object)accessory) + ": " + errorOrDecodedItem.getError());
            } else {
                GearTypeItemProperty gearItemType;
                WynnItem item = errorOrDecodedItem.getValue();
                if (item instanceof GearTypeItemProperty && (gearItemType = (GearTypeItemProperty)((Object)item)).getGearType() == expectedGearType) {
                    this.accessories.put(accessory, errorOrDecodedItem.getValue());
                    this.accessoriesCache.put(accessory, accessoryData);
                }
            }
        }
    }

    private ErrorOr<WynnItem> decodeItem(String encodedData) {
        Matcher encodedMatcher = Models.ItemEncoding.getEncodedDataPattern().matcher(encodedData);
        if (!encodedMatcher.find()) {
            return ErrorOr.error("Failed to match encoded pattern for Hades user data: " + encodedData);
        }
        EncodedByteBuffer encodedByteBuffer = EncodedByteBuffer.fromUtf16String(encodedMatcher.group("data"));
        return Models.ItemEncoding.decodeItem(encodedByteBuffer, encodedMatcher.group("name"));
    }
}

