/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.secrets;

import com.google.gson.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.services.secrets.type.WynntilsSecret;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class SecretsService
extends Service {
    private static final File SECRETS_DIR = WynntilsMod.getModStorageDir("secrets");
    private static final String SECRETS_FILE_NAME = "secrets.json";
    private static final String MASTER_KEY_FILE_NAME = "master_key";
    private static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final String KEY_ALGORITHM = "AES";
    private static final int AES_KEY_SIZE = 256;
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private SecureRandom secureRandom = new SecureRandom();
    private SecretKey masterKey;
    private Map<WynntilsSecret, String> secrets = new HashMap<WynntilsSecret, String>();

    public SecretsService() {
        super(List.of());
        this.loadOrCreateMasterKey();
        this.loadSecrets();
    }

    public void setSecret(WynntilsSecret key, String value) {
        try {
            String encrypted = this.encryptSecret(value);
            this.secrets.put(key, encrypted);
            this.saveSecrets();
        }
        catch (Exception e) {
            WynntilsMod.error("Failed to encrypt and save secret for " + String.valueOf((Object)key), e);
        }
    }

    public String getSecret(WynntilsSecret key) {
        String encrypted = this.secrets.getOrDefault((Object)key, "");
        if (encrypted.isEmpty()) {
            return "";
        }
        try {
            return this.decryptSecret(encrypted);
        }
        catch (Exception e) {
            WynntilsMod.warn("Secret for " + String.valueOf((Object)key) + " is invalid and will be removed: " + e.getMessage());
            this.secrets.remove((Object)key);
            this.saveSecrets();
            return "";
        }
    }

    private void loadOrCreateMasterKey() {
        File keyFile = new File(SECRETS_DIR, MASTER_KEY_FILE_NAME);
        try {
            if (keyFile.exists()) {
                String base64 = FileUtils.readFileToString((File)keyFile, (Charset)StandardCharsets.UTF_8).trim();
                byte[] keyBytes = Base64.getDecoder().decode(base64);
                this.masterKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
                return;
            }
            this.createMasterKey();
            return;
        }
        catch (Exception e) {
            WynntilsMod.warn("Master key load failed: " + e.getMessage());
            WynntilsMod.error("Master key could not be recovered; clearing secrets and regenerating.");
            File secretsFile = new File(SECRETS_DIR, SECRETS_FILE_NAME);
            keyFile.delete();
            secretsFile.delete();
            this.secrets.clear();
            try {
                this.createMasterKey();
            }
            catch (Exception e2) {
                WynntilsMod.error("Failed to regenerate master key", e2);
            }
            return;
        }
    }

    private void createMasterKey() throws Exception {
        File keyFile = new File(SECRETS_DIR, MASTER_KEY_FILE_NAME);
        KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGen.init(256);
        this.masterKey = keyGen.generateKey();
        String base64 = Base64.getEncoder().encodeToString(this.masterKey.getEncoded());
        FileUtils.writeStringToFile((File)keyFile, (String)base64, (Charset)StandardCharsets.UTF_8);
    }

    private void loadSecrets() {
        File file = new File(SECRETS_DIR, SECRETS_FILE_NAME);
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
            Type type = new TypeToken<Map<WynntilsSecret, String>>(this){}.getType();
            this.secrets = (Map)WynntilsMod.GSON.fromJson((Reader)reader, type);
            if (this.secrets == null) {
                this.secrets = new HashMap<WynntilsSecret, String>();
            }
        }
        catch (IOException e) {
            WynntilsMod.warn("Could not parse secrets file.", e);
        }
    }

    private void saveSecrets() {
        try {
            File f = new File(SECRETS_DIR, SECRETS_FILE_NAME);
            String json = WynntilsMod.GSON.toJson(this.secrets);
            FileUtils.writeStringToFile((File)f, (String)json, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            WynntilsMod.error("Error when trying to save secrets.", e);
        }
    }

    private String encryptSecret(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        byte[] nonce = new byte[12];
        this.secureRandom.nextBytes(nonce);
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        cipher.init(1, (Key)this.masterKey, spec);
        byte[] cipherText = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] combined = new byte[nonce.length + cipherText.length];
        System.arraycopy(nonce, 0, combined, 0, nonce.length);
        System.arraycopy(cipherText, 0, combined, nonce.length, cipherText.length);
        return Base64.getEncoder().encodeToString(combined);
    }

    private String decryptSecret(String base64CipherText) throws Exception {
        byte[] combined = Base64.getDecoder().decode(base64CipherText);
        byte[] nonce = new byte[12];
        System.arraycopy(combined, 0, nonce, 0, nonce.length);
        byte[] cipherText = new byte[combined.length - nonce.length];
        System.arraycopy(combined, nonce.length, cipherText, 0, cipherText.length);
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        cipher.init(2, (Key)this.masterKey, spec);
        byte[] plainText = cipher.doFinal(cipherText);
        return new String(plainText, StandardCharsets.UTF_8);
    }
}

