/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render.buffered;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.CustomRenderType;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class BufferedRenderUtils {
    public static void drawLine(class_4587 poseStack, class_4597 bufferSource, CustomColor color, float x1, float y1, float x2, float y2, float z, float width) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float halfWidth = width / 2.0f;
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.POSITION_COLOR_TRIANGLE_STRIP);
        if (x1 == x2) {
            if (y2 < y1) {
                float tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            buffer.method_22918(matrix, x1 - halfWidth, y1, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 - halfWidth, y2, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x1 + halfWidth, y1, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 + halfWidth, y2, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else if (y1 == y2) {
            if (x2 < x1) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            buffer.method_22918(matrix, x1, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x1, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else if (x1 < x2 && y1 < y2 || x2 < x1 && y2 < y1) {
            if (x2 < x1) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            buffer.method_22918(matrix, x1 + halfWidth, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x1 - halfWidth, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 + halfWidth, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 - halfWidth, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else {
            if (x1 < x2) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            buffer.method_22918(matrix, x1 + halfWidth, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x1 - halfWidth, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 + halfWidth, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, x2 - halfWidth, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        }
    }

    public static void drawRectBorders(class_4587 poseStack, class_4597 bufferSource, CustomColor color, float x1, float y1, float x2, float y2, float z, float lineWidth) {
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x1, y1, x2, y1, z, lineWidth);
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x2, y1, x2, y2, z, lineWidth);
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x2, y2, x1, y2, z, lineWidth);
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x1, y2, x1, y1, z, lineWidth);
    }

    public static void drawRect(class_4587 poseStack, class_4597 bufferSource, CustomColor color, float x, float y, float z, float width, float height) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.POSITION_COLOR_QUAD);
        buffer.method_22918(matrix, x, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x + width, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x + width, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
    }

    public static void drawMulticoloredRectBorders(class_4587 poseStack, class_4597 bufferSource, List<CustomColor> colors, float x, float y, float z, float width, float height, float externalLineWidth, float internalLineWidth) {
        if (colors.size() == 1) {
            BufferedRenderUtils.drawRectBorders(poseStack, bufferSource, colors.getFirst(), x, y, x + width, y + height, z, externalLineWidth);
            return;
        }
        float splitX = width / (float)(colors.size() - 1);
        for (int i = 0; i < colors.size(); ++i) {
            CustomColor color = colors.get(i);
            float leftX = class_3532.method_15363((float)(x + splitX * (float)(i - 1)), (float)x, (float)(x + width));
            float centerX = class_3532.method_15363((float)(x + splitX * (float)i), (float)x, (float)(x + width));
            float rightX = class_3532.method_15363((float)(x + splitX * (float)(i + 1)), (float)x, (float)(x + width));
            BufferedRenderUtils.drawLine(poseStack, bufferSource, color, leftX, y + height, centerX, y + height, z, externalLineWidth);
            BufferedRenderUtils.drawLine(poseStack, bufferSource, color, centerX, y + height, rightX, y, z, i == colors.size() - 1 ? externalLineWidth : internalLineWidth);
            BufferedRenderUtils.drawLine(poseStack, bufferSource, color, rightX, y, centerX, y, z, externalLineWidth);
            BufferedRenderUtils.drawLine(poseStack, bufferSource, color, centerX, y, leftX, y + height, z, i != 0 ? internalLineWidth : externalLineWidth);
        }
    }

    public static void drawMulticoloredRect(class_4587 poseStack, class_4597 bufferSource, List<CustomColor> colors, float x, float y, float z, float width, float height) {
        if (colors.size() == 1) {
            BufferedRenderUtils.drawRect(poseStack, bufferSource, colors.getFirst(), x, y, z, width, height);
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.POSITION_COLOR_QUAD);
        float splitX = width / (float)(colors.size() - 1);
        for (int i = 0; i < colors.size(); ++i) {
            CustomColor color = colors.get(i);
            float leftX = class_3532.method_15363((float)(x + splitX * (float)(i - 1)), (float)x, (float)(x + width));
            float centerX = class_3532.method_15363((float)(x + splitX * (float)i), (float)x, (float)(x + width));
            float rightX = class_3532.method_15363((float)(x + splitX * (float)(i + 1)), (float)x, (float)(x + width));
            buffer.method_22918(matrix, leftX, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, centerX, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, rightX, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
            buffer.method_22918(matrix, centerX, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
        }
    }

    public static void drawColoredTexturedRect(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, CustomColor color, float alpha, float x, float y, float z, float width, float height) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionColorTextureQuad(tex));
        float[] colorArray = color.asFloatArray();
        buffer.method_22918(matrix, x, y + height, z).method_22913(0.0f, 1.0f).method_22915(colorArray[0], colorArray[1], colorArray[2], alpha);
        buffer.method_22918(matrix, x + width, y + height, z).method_22913(1.0f, 1.0f).method_22915(colorArray[0], colorArray[1], colorArray[2], alpha);
        buffer.method_22918(matrix, x + width, y, z).method_22913(1.0f, 0.0f).method_22915(colorArray[0], colorArray[1], colorArray[2], alpha);
        buffer.method_22918(matrix, x, y, z).method_22913(0.0f, 0.0f).method_22915(colorArray[0], colorArray[1], colorArray[2], alpha);
    }

    public static void drawScalingTexturedRect(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, float x, float y, float z, float width, float height, int textureWidth, int textureHeight) {
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, tex, x, y, z, width, height, 0, 0, textureWidth, textureHeight, textureWidth, textureHeight);
    }

    public static void drawTexturedRect(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x, float y) {
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, texture.resource(), x, y, texture.width(), texture.height(), texture.width(), texture.height());
    }

    public static void drawHoverableTexturedRect(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x, float y, boolean hovered) {
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, texture.resource(), x, y, 0.0f, texture.width(), (float)texture.height() / 2.0f, 0, hovered ? texture.height() / 2 : 0, texture.width(), texture.height() / 2, texture.width(), texture.height());
    }

    public static void drawTexturedRect(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, float x, float y, float z, float width, float height, int textureWidth, int textureHeight) {
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, tex, x, y, z, width, height, 0, 0, (int)width, (int)height, textureWidth, textureHeight);
    }

    private static void drawTexturedRect(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, float x, float y, float width, float height, int textureWidth, int textureHeight) {
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, tex, x, y, 0.0f, width, height, 0, 0, (int)width, (int)height, textureWidth, textureHeight);
    }

    public static void drawTexturedRect(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, float x, float y, float z, float width, float height, int uOffset, int vOffset, int u, int v, int textureWidth, int textureHeight) {
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionTextureQuad(tex));
        buffer.method_22918(matrix, x, y + height, z).method_22913((float)uOffset * uScale, (float)(vOffset + v) * vScale);
        buffer.method_22918(matrix, x + width, y + height, z).method_22913((float)(uOffset + u) * uScale, (float)(vOffset + v) * vScale);
        buffer.method_22918(matrix, x + width, y, z).method_22913((float)(uOffset + u) * uScale, (float)vOffset * vScale);
        buffer.method_22918(matrix, x, y, z).method_22913((float)uOffset * uScale, (float)vOffset * vScale);
    }

    public static void drawTexturedRectWithColor(class_4587 poseStack, class_4597 bufferSource, Texture tex, CustomColor color, float x, float y) {
        BufferedRenderUtils.drawTexturedRectWithColor(poseStack, bufferSource, tex.resource(), color, x, y, 0.0f, tex.width(), tex.height(), 0, 0, tex.width(), tex.height(), tex.width(), tex.height());
    }

    public static void drawTexturedRectWithColor(class_4587 poseStack, class_4597 bufferSource, class_2960 tex, CustomColor color, float x, float y, float z, float width, float height, int uOffset, int vOffset, int u, int v, int textureWidth, int textureHeight) {
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionColorTextureQuad(tex));
        buffer.method_22918(matrix, x, y + height, z).method_22913((float)uOffset * uScale, (float)(vOffset + v) * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x + width, y + height, z).method_22913((float)(uOffset + u) * uScale, (float)(vOffset + v) * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x + width, y, z).method_22913((float)(uOffset + u) * uScale, (float)vOffset * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        buffer.method_22918(matrix, x, y, z).method_22913((float)uOffset * uScale, (float)vOffset * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
    }

    public static void drawColoredProgressBar(class_4587 poseStack, class_4597 bufferSource, Texture texture, CustomColor customColor, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
        BufferedRenderUtils.drawProgressBarBackground(poseStack, bufferSource, texture, x1, y1, x2, y2, textureX1, textureY1, textureX2, half);
        BufferedRenderUtils.drawProgressBarForegroundWithColor(poseStack, bufferSource, texture, customColor, x1, y1, x2, y2, textureX1, half, textureX2, textureY2 + (textureY2 - textureY1) % 2, progress);
    }

    private static void drawProgressBarForegroundWithColor(class_4587 poseStack, class_4597 bufferSource, Texture texture, CustomColor customColor, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        if (progress == 0.0f) {
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionColorTextureQuad(texture.resource()));
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        if (progress < 1.0f && progress > -1.0f) {
            if (progress < 0.0f) {
                xMin += (1.0f + progress) * (xMax - xMin);
                txMin += (1.0f + progress) * (txMax - txMin);
            } else {
                xMax -= (1.0f - progress) * (xMax - xMin);
                txMax -= (1.0f - progress) * (txMax - txMin);
            }
        }
        buffer.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin).method_39415(customColor.asInt());
        buffer.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax).method_39415(customColor.asInt());
        buffer.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax).method_39415(customColor.asInt());
        buffer.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin).method_39415(customColor.asInt());
    }

    public static void drawProgressBar(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
        BufferedRenderUtils.drawProgressBarBackground(poseStack, bufferSource, texture, x1, y1, x2, y2, textureX1, textureY1, textureX2, half);
        BufferedRenderUtils.drawProgressBarForeground(poseStack, bufferSource, texture, x1, y1, x2, y2, textureX1, half, textureX2, textureY2 + (textureY2 - textureY1) % 2, progress);
    }

    public static void drawProgressBarForeground(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        if (progress == 0.0f) {
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionTextureQuad(texture.resource()));
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        if (progress < 1.0f && progress > -1.0f) {
            if (progress < 0.0f) {
                xMin += (1.0f + progress) * (xMax - xMin);
                txMin += (1.0f + progress) * (txMax - txMin);
            } else {
                xMax -= (1.0f - progress) * (xMax - xMin);
                txMax -= (1.0f - progress) * (txMax - txMin);
            }
        }
        buffer.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin);
        buffer.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax);
        buffer.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax);
        buffer.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin);
    }

    public static void drawProgressBarBackground(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 buffer = bufferSource.getBuffer(CustomRenderType.getPositionTextureQuad(texture.resource()));
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        buffer.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin);
        buffer.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax);
        buffer.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax);
        buffer.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin);
    }

    public static void createMask(class_4587 poseStack, class_4597 bufferSource, Texture texture, int x1, int y1, int x2, int y2) {
        BufferedRenderUtils.createMask(poseStack, bufferSource, texture, x1, y1, x2, y2, 0, 0, texture.width(), texture.height());
    }

    private static void createMask(class_4587 poseStack, class_4597 bufferSource, Texture texture, float x1, float y1, float x2, float y2, int tx1, int ty1, int tx2, int ty2) {
        GL11.glEnable((int)2960);
        RenderSystem.stencilMask((int)255);
        RenderSystem.clear((int)1024);
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        int width = texture.width();
        int height = texture.height();
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, texture.resource(), x1, y1, 0.0f, x2 - x1, y2 - y1, tx1, ty1, tx2 - tx1, ty2 - ty1, width, height);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }
}

