/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

public record RangedValue(int low, int high) {
    public static final RangedValue NONE = new RangedValue(0, 0);

    public static RangedValue of(int low, int high) {
        return new RangedValue(low, high);
    }

    public static RangedValue fromString(String range) {
        String[] pair = range.split("-");
        return new RangedValue(Integer.parseInt(pair[0]), Integer.parseInt(pair[1]));
    }

    public boolean isFixed() {
        return this.low == this.high;
    }

    public boolean inRange(int value) {
        return value >= this.low && value <= this.high;
    }

    public String asString() {
        return this.low + "-" + this.high;
    }

    @Override
    public String toString() {
        return "<" + this.low + "-" + this.high + ">";
    }
}

