/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.offline_skins;

import com.hindustani_gamer_fardin.offline_skins.ConfigManager;
import com.hindustani_gamer_fardin.offline_skins.OfflineSkinsClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public final class SkinStorage {
    private static final Path SKINS_DIR = FabricLoader.getInstance().getConfigDir().resolve("offlineskins");
    private static final Map<String, class_2960> registeredSkins = new HashMap<String, class_2960>();
    private static class_2960 activeSkinIdentifier = null;

    private SkinStorage() {
    }

    public static void ensureDirs() {
        try {
            Files.createDirectories(SKINS_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            OfflineSkinsClient.LOGGER.error("Failed to create skins directory: " + String.valueOf(SKINS_DIR), (Throwable)e);
        }
    }

    public static Path getSkinsDir() {
        return SKINS_DIR;
    }

    public static List<String> listAvailableSkins() {
        if (!Files.isDirectory(SKINS_DIR, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.list(SKINS_DIR).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".png")).map(p -> {
                String fname = p.getFileName().toString();
                int dot = fname.lastIndexOf(46);
                return dot > 0 ? fname.substring(0, dot) : fname;
            }).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static boolean setActiveSkin(String skinName) {
        Path file = SKINS_DIR.resolve(skinName + ".png");
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        class_2960 id = SkinStorage.registerOrGetSkin(skinName, file);
        if (id != null) {
            activeSkinIdentifier = id;
            return true;
        }
        return false;
    }

    public static void clearActiveSkin() {
        activeSkinIdentifier = null;
    }

    public static void tryAutoLoadForLocalPlayer(String username) {
        ConfigManager.ConfigData cfg = ConfigManager.getConfig();
        if (cfg.selectedSkinName != null && !cfg.selectedSkinName.isBlank()) {
            SkinStorage.setActiveSkin(cfg.selectedSkinName);
            return;
        }
        if (!SkinStorage.setActiveSkin(username)) {
            SkinStorage.clearActiveSkin();
        }
    }

    public static class_2960 getActiveSkinIdentifier() {
        return activeSkinIdentifier;
    }

    public static class_2960 getDefaultSkinIdentifier() {
        String model = ConfigManager.getConfig().defaultModel;
        if ("alex".equalsIgnoreCase(model)) {
            return class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/slim/alex.png");
        }
        return class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    }

    private static class_2960 registerOrGetSkin(String skinName, Path skinPath) {
        class_2960 class_29602;
        block9: {
            class_2960 cached = registeredSkins.get(skinName);
            if (cached != null) {
                return cached;
            }
            InputStream inputStream = Files.newInputStream(skinPath, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)inputStream);
                class_1043 texture = new class_1043(() -> "offline-skins/" + skinName.toLowerCase(Locale.ROOT), image);
                class_2960 id = class_2960.method_60655((String)"offline-skins", (String)("skins/" + skinName.toLowerCase(Locale.ROOT)));
                class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
                registeredSkins.put(skinName, id);
                class_29602 = id;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    OfflineSkinsClient.LOGGER.error("Failed to load skin image: " + skinName + " -> " + String.valueOf(skinPath), (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return class_29602;
    }
}

