/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.offline_skins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hindustani_gamer_fardin.offline_skins.OfflineSkinsClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("offlineskins").resolve("config.json");
    private static ConfigData config = new ConfigData();

    public static void load() {
        block9: {
            try {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
                if (!Files.exists(CONFIG_FILE, new LinkOption[0])) break block9;
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
                    ConfigData loaded = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                    if (loaded != null) {
                        config = loaded;
                    }
                }
            }
            catch (IOException e) {
                OfflineSkinsClient.LOGGER.error("Failed to load config: " + String.valueOf(CONFIG_FILE), (Throwable)e);
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            OfflineSkinsClient.LOGGER.error("Failed to save config: " + String.valueOf(CONFIG_FILE), (Throwable)e);
        }
    }

    public static ConfigData getConfig() {
        return config;
    }

    public static class ConfigData {
        public String selectedSkinName = "";
        public String defaultModel = "steve";
    }
}

