/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardin.offline_skins;

import com.hindustani_gamer_fardin.offline_skins.ConfigManager;
import com.hindustani_gamer_fardin.offline_skins.SkinStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public final class OfflineSkinsCommands {
    private OfflineSkinsCommands() {
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"offlineskins").then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            List<String> skinNames = SkinStorage.listAvailableSkins();
            if (skinNames.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("No skins found in: " + String.valueOf(SkinStorage.getSkinsDir().toAbsolutePath()))));
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Skins: " + String.join((CharSequence)", ", skinNames))));
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"change").then(ClientCommandManager.argument((String)"skin_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String skinName = StringArgumentType.getString((CommandContext)ctx, (String)"skin_name");
            boolean ok = SkinStorage.setActiveSkin(skinName);
            if (ok) {
                ConfigManager.getConfig().selectedSkinName = skinName;
                ConfigManager.save();
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Changed skin to '" + skinName + "'")));
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("Skin file not found: " + skinName + ".png in " + String.valueOf(SkinStorage.getSkinsDir().toAbsolutePath()))));
            }
            return ok ? 1 : 0;
        })))).then(ClientCommandManager.literal((String)"default").then(ClientCommandManager.argument((String)"model", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String model = StringArgumentType.getString((CommandContext)ctx, (String)"model").toLowerCase();
            if (!model.equals("alex") && !model.equals("steve")) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid model. Use 'alex' or 'steve'."));
                return 0;
            }
            ConfigManager.getConfig().defaultModel = model;
            ConfigManager.save();
            SkinStorage.clearActiveSkin();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Default skin model set to '" + model + "'.")));
            return 1;
        }))));
    }
}

