package fun.wich.mixin;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_11580;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9791;

@Mixin(class_1799.class)
public abstract class ItemStackMixin implements class_9322 {
	@Inject(method="appendTooltip", at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;appendTooltip(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/Item$TooltipContext;Lnet/minecraft/component/type/TooltipDisplayComponent;Ljava/util/function/Consumer;Lnet/minecraft/item/tooltip/TooltipType;)V", shift= At.Shift.AFTER))
	private void InjectTooltips(class_1792.class_9635 context, class_10712 displayComponent, @Nullable class_1657 player, class_1836 type, Consumer<class_2561> textConsumer, CallbackInfo ci) {
		//Check components
		class_5455 manager = player != null ? player.method_56673() : null;
		TryAppendSimpleVariant(textConsumer, class_9334.field_56140, "axolotl");
		TryAppendVariant(textConsumer, class_9334.field_56141, "cat");
		TryAppendTooltipDyeColor(textConsumer, class_9334.field_56142, "tooltip.collar_color");
		TryAppendTooltipLazyRegistryEntryReference(manager, textConsumer, class_9334.field_56595, "chicken");
		TryAppendVariant(textConsumer, class_9334.field_56508, "cow");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56148, "fox");
		TryAppendVariant(textConsumer, class_9334.field_56136, "frog");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56137, "horse");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56139, "llama");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56133, "mooshroom");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56150, "parrot");
		TryAppendVariant(textConsumer, class_9334.field_56135, "pig");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56134, "rabbit");
		TryAppendSimpleVariant(textConsumer, class_9334.field_56149, "salmon");
		TryAppendTooltipDyeColor(textConsumer, class_9334.field_56144, null);
		TryAppendTooltipDyeColor(textConsumer, class_9334.field_56143, null);
		TryAppendVariant(textConsumer, class_9334.field_56146, "wolf");
		TryAppendVariant(textConsumer, class_9334.field_57109, "wolf_sound");
		TryAppendTooltipDyeColor(textConsumer, class_9334.field_56147, "tooltip.collar_color");
		//Check Raw Entity Data
		class_11580<class_1299<?>> typedEntityData = method_58695(class_9334.field_49609, null);
		if (typedEntityData != null) {
			class_1299<?> entityType = typedEntityData.method_72530();
			class_2487 nbt = typedEntityData.method_72540();
			if (entityType == class_1299.field_6146) {
				nbt.method_10558("MainGene").ifPresent(gene -> textConsumer.accept(class_2561.method_43471("tooltip.panda.variant." + gene)));
			}
			//General Variant Keys
			String key = entityType.method_5882().replace("entity.minecraft.","");
			nbt.method_10558("Variant").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("Variant").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("variant").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("variant").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("Type").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("Type").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("type").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("type").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("RabbitType").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("RabbitType").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("rabbitType").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.replace(':','.'))));
			nbt.method_10550("rabbitType").ifPresent(variant -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant)));
			nbt.method_10558("Color").ifPresent(color -> textConsumer.accept(class_2561.method_43471("color.minecraft." + color)));
			nbt.method_10550("Color").ifPresent(color -> textConsumer.accept(class_2561.method_43471("color.minecraft." + class_1767.method_7791(color).method_7792())));
			nbt.method_10558("color").ifPresent(color -> textConsumer.accept(class_2561.method_43471("color.minecraft." + color)));
			nbt.method_10550("color").ifPresent(color -> textConsumer.accept(class_2561.method_43471("color.minecraft." + class_1767.method_7791(color).method_7792())));
			nbt.method_10558("CollarColor").ifPresent(color -> textConsumer.accept(class_2561.method_43471("tooltip.collar_color").method_10852(class_2561.method_43471("color.minecraft." + color))));
			nbt.method_10550("CollarColor").ifPresent(color -> textConsumer.accept(class_2561.method_43471("tooltip.collar_color").method_10852(class_2561.method_43471("color.minecraft." + class_1767.method_7791(color).method_7792()))));
			nbt.method_10558("collarColor").ifPresent(color -> textConsumer.accept(class_2561.method_43471("tooltip.collar_color").method_10852(class_2561.method_43471("color.minecraft." + color))));
			nbt.method_10550("collarColor").ifPresent(color -> textConsumer.accept(class_2561.method_43471("tooltip.collar_color").method_10852(class_2561.method_43471("color.minecraft." + class_1767.method_7791(color).method_7792()))));
			//Generic Information Keys
			nbt.method_10558("Size").ifPresent(size -> textConsumer.accept(class_2561.method_43471("tooltip.size").method_27693(size)));
			nbt.method_10550("Size").ifPresent(size -> textConsumer.accept(class_2561.method_43471("tooltip.size").method_27693(size.toString())));
			nbt.method_10558("size").ifPresent(size -> textConsumer.accept(class_2561.method_43471("tooltip.size").method_27693(size)));
			nbt.method_10550("size").ifPresent(size -> textConsumer.accept(class_2561.method_43471("tooltip.size").method_27693(size.toString())));
			nbt.method_10577("Invisible").ifPresent(invisible -> {
				if (invisible) textConsumer.accept(class_2561.method_43471("tooltip.invisible"));
			});
		}
	}
	@Unique
	private <T> void TryAppendTooltipLazyRegistryEntryReference(class_5455 manager, Consumer<class_2561> textConsumer, class_9331<class_9791<T>> component, String key) {
		if (manager != null) {
			class_9791<T> entry = method_58695(component, null);
			if (entry != null) {
				entry.method_60739(manager).ifPresent(tRegistryEntry -> textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + class_2960.method_60654(tRegistryEntry.method_55840()).method_42094())));
			}
		}
	}
	@Unique
	private <T extends class_3542> void TryAppendSimpleVariant(Consumer<class_2561> textConsumer, class_9331<T> component, String key) {
		T variant = method_58695(component, null);
		if (variant != null) textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + variant.method_15434()));
	}
	@Unique
	private <T> void TryAppendVariant(Consumer<class_2561> textConsumer, class_9331<class_6880<T>> component, String key) {
		class_6880<T> entry = method_58695(component, null);
		if (entry != null) textConsumer.accept(class_2561.method_43471("tooltip." + key + ".variant." + class_2960.method_60654(entry.method_55840()).method_42094()));
	}
	@Unique
	private void TryAppendTooltipDyeColor(Consumer<class_2561> textConsumer, class_9331<class_1767> component, String translationKey) {
		class_1767 dye;
		if ((dye = this.method_58695(component, null)) != null) {
			class_2561 text = class_2561.method_43471("color.minecraft." + dye.method_7792());
			if (translationKey != null) text = class_2561.method_43471(translationKey).method_10852(text);
			textConsumer.accept(text);
		}
	}
}
