/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.hudlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.wooferz.hudlib.HudAnchor;
import dev.wooferz.hudlib.HudLibClient;
import dev.wooferz.hudlib.config.ColorTypeAdapter;
import dev.wooferz.hudlib.config.Config;
import dev.wooferz.hudlib.config.ConfigElementInformation;
import dev.wooferz.hudlib.config.ConfigManager;
import dev.wooferz.hudlib.config.ElementConfig;
import dev.wooferz.hudlib.hud.HUDConfig;
import dev.wooferz.hudlib.hud.HUDElement;
import dev.wooferz.hudlib.screens.EditScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class HudManager {
    public static Gson gson = new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    public static ArrayList<HUDElement> hudElements = new ArrayList();
    public static HashMap<String, class_768> hudPositions = new HashMap();
    public static HashMap<String, Boolean> hudShown = new HashMap();
    public static HashMap<String, Boolean> hudEnabled = new HashMap();
    public static HashMap<String, HudAnchor> hudAnchors = new HashMap();
    public static boolean isElementsConfigLoaded = false;

    public static void addConfigOptionGroups(ConfigCategory.Builder builder) {
        for (int i = 0; i < hudElements.size(); ++i) {
            HUDElement element = hudElements.get(i);
            OptionGroup optionGroup = element.generateConfig();
            if (optionGroup == null) continue;
            builder.group(optionGroup);
        }
    }

    public static void render(class_332 context, class_9779 counter) {
        int width = context.method_51421();
        int height = context.method_51443();
        for (int i = 0; i < hudElements.size(); ++i) {
            HUDElement element = hudElements.get(i);
            if (!hudShown.get(element.identifier).booleanValue() && !(class_310.method_1551().field_1755 instanceof EditScreen) || !hudEnabled.get(element.identifier).booleanValue()) continue;
            class_768 positionUnanchored = hudPositions.get(element.identifier);
            class_768 position = hudAnchors.get(element.identifier).convert(positionUnanchored);
            element.setTransform(position);
            element.render(position.method_3321(), position.method_3322(), position.method_3319(), position.method_3320(), context, counter.method_60638());
        }
    }

    public static void openEditor(class_310 minecraftClient) {
        if (HudLibClient.openEditorKey.method_1436()) {
            minecraftClient.method_1507((class_437)new EditScreen(class_2561.method_30163((String)"")));
        }
    }

    public static void registerHudElement(HUDElement hudElement) {
        class_768 position;
        ConfigManager.getInstance().read();
        hudElements.add(hudElement);
        Config config = ConfigManager.getInstance().config;
        boolean shown = true;
        HudAnchor anchor = null;
        boolean enabled = true;
        if (config.getElement(hudElement.identifier) != null) {
            position = config.getElement((String)hudElement.identifier).position;
            if (!hudElement.canResize()) {
                position.method_35782(hudElement.defaultWidth);
                position.method_35783(hudElement.defaultHeight);
            }
            if (config.getElement((String)hudElement.identifier).anchor != null) {
                anchor = config.getElement((String)hudElement.identifier).anchor;
            }
            enabled = config.getElement((String)hudElement.identifier).enabled;
            shown = config.getElement((String)hudElement.identifier).shown;
        } else {
            position = new class_768(hudElement.defaultX, hudElement.defaultY, hudElement.defaultWidth, hudElement.defaultHeight);
        }
        if (anchor == null) {
            anchor = new HudAnchor(hudElement.defaultHorizontalAnchor, hudElement.defaultVerticalAnchor);
        }
        hudPositions.put(hudElement.identifier, position);
        hudShown.put(hudElement.identifier, shown);
        hudAnchors.put(hudElement.identifier, anchor);
        hudEnabled.put(hudElement.identifier, enabled);
        if (!isElementsConfigLoaded) {
            ElementConfig.HANDLER.load();
            isElementsConfigLoaded = true;
        }
        String elementConfigString = ((ElementConfig)ElementConfig.HANDLER.instance()).elementConfigs.get(hudElement.identifier);
        HUDConfig elementConfig = (HUDConfig)gson.fromJson(elementConfigString, hudElement.getConfigType());
        hudElement.setConfig(elementConfig);
        Collections.sort(hudElements);
        HudLibClient.LOGGER.info("Successfully registered {}.", (Object)hudElement.displayName);
    }

    public static void saveConfig() {
        ArrayList<HUDElement> elements = hudElements;
        for (int i = 0; i < elements.size(); ++i) {
            HUDElement element = elements.get(i);
            HUDConfig config = element.getConfig();
            if (config == null) continue;
            ElementConfig elementConfig = (ElementConfig)ElementConfig.HANDLER.instance();
            String configString = gson.toJson((Object)config);
            elementConfig.elementConfigs.put(element.identifier, configString);
        }
        ElementConfig.HANDLER.save();
    }

    public static void addGenericConfigOptions(ConfigCategory.Builder genericHudOptions) {
        for (int i = 0; i < hudElements.size(); ++i) {
            HUDElement element = hudElements.get(i);
            OptionGroup optionGroup = OptionGroup.createBuilder().name(class_2561.method_30163((String)element.displayName)).option(Option.createBuilder().name(class_2561.method_30163((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Turning this off will remove it from the editor.")})).binding((Object)true, () -> hudEnabled.get(element.identifier), value -> {
                hudEnabled.put(element.identifier, (Boolean)value);
                HudManager.saveElementBaseConfig(element);
            }).controller(TickBoxControllerBuilder::create).build()).option((Option)ButtonOption.createBuilder().name(class_2561.method_30163((String)"Reset Position")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"This will reset its position on the screen to its default.")})).action((yaclScreen, buttonOption) -> {
                class_768 position = new class_768(element.defaultX, element.defaultY, element.defaultWidth, element.defaultHeight);
                HudAnchor anchor = new HudAnchor(element.defaultHorizontalAnchor, element.defaultVerticalAnchor);
                hudPositions.put(element.identifier, position);
                hudAnchors.put(element.identifier, anchor);
            }).build()).build();
            genericHudOptions.group(optionGroup);
        }
    }

    public static void saveElementBaseConfig(HUDElement element) {
        ConfigElementInformation information = new ConfigElementInformation();
        information.shown = hudShown.get(element.identifier);
        information.position = hudPositions.get(element.identifier);
        information.anchor = hudAnchors.get(element.identifier);
        information.enabled = hudEnabled.get(element.identifier);
        ConfigManager.getInstance().config.saveElement(element.identifier, information);
        ConfigManager.getInstance().saveConfig();
    }
}

