/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.hudlib.screens;

import dev.wooferz.hudlib.HudAnchor;
import dev.wooferz.hudlib.HudManager;
import dev.wooferz.hudlib.hud.HUDElement;
import dev.wooferz.hudlib.screens.EditScreen;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public class DraggableWidget
extends class_339 {
    double realX;
    double realY;
    double realWidth;
    double realHeight;
    HUDElement element;
    Boolean enabled;
    boolean pressed = false;
    boolean resizing = false;
    EditScreen screen;

    public DraggableWidget(int x, int y, int width, int height, Boolean enabled, HUDElement element, EditScreen screen) {
        super(x - element.padding, y - element.padding, width + element.padding * 2, height + element.padding * 2, (class_2561)class_2561.method_43473());
        this.realX = x;
        this.realY = y;
        this.realWidth = width;
        this.realHeight = height;
        this.element = element;
        this.enabled = enabled;
        this.screen = screen;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int borderColor = -1;
        int disabledOverlay = 0x55000000;
        if (!this.enabled.booleanValue()) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), disabledOverlay);
        }
        context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), borderColor);
        if (this.element.canResize()) {
            context.method_25294(this.method_46426() + this.method_25368() - 5, this.method_46427() + this.method_25364() - 5, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), borderColor);
        }
    }

    private boolean isResizing(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + this.method_25368() - 5) && mouseY >= (double)(this.method_46427() + this.method_25364() - 5) && mouseX <= (double)(this.method_46426() + this.method_25368()) && mouseY <= (double)(this.method_46427() + this.method_25364());
    }

    public void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        class_1041 window = class_310.method_1551().method_22683();
        int wwidth = window.method_4486();
        int wheight = window.method_4502();
        if (this.resizing) {
            this.realWidth += deltaX;
            this.realHeight += deltaY;
            if (this.realWidth < 5.0) {
                this.realWidth = 5.0;
            }
            if (this.realHeight < 5.0) {
                this.realHeight = 5.0;
            }
            this.method_25358((int)this.realWidth);
            this.field_22759 = (int)this.realHeight;
        } else {
            this.realX += deltaX;
            this.realY += deltaY;
            if (this.realX + this.realWidth > (double)wwidth) {
                this.realX = (double)wwidth - this.realWidth;
            }
            if (this.realY + this.realHeight > (double)wheight) {
                this.realY = (double)wheight - this.realHeight;
            }
            if (this.realX < 0.0) {
                this.realX = 0.0;
            }
            if (this.realY < 0.0) {
                this.realY = 0.0;
            }
            int snappedX = (int)this.realX;
            int snappedY = (int)this.realY;
            if (!this.screen.isCtrlHeld) {
                ArrayList<Integer> snapPointsX = new ArrayList<Integer>();
                snapPointsX.add(wwidth / 2 - this.field_22758 / 2);
                for (int i = 0; i < HudManager.hudElements.size(); ++i) {
                    HUDElement el = HudManager.hudElements.get(i);
                    if (el.equals(this.element) || !HudManager.hudEnabled.get(el.identifier).booleanValue()) continue;
                    class_768 transform = el.getTransform();
                    class_768 transform2 = this.element.getTransform();
                    snapPointsX.add(transform.method_3321() - el.padding);
                    snapPointsX.add(transform.method_3321() + transform.method_3319() - el.padding);
                    snapPointsX.add(transform.method_3321() - el.padding - transform2.method_3319());
                    snapPointsX.add(transform.method_3321() + transform.method_3319() - el.padding - transform2.method_3319());
                }
                Integer finalPointX = null;
                Integer bestDistanceX = null;
                for (int i = 0; i < snapPointsX.size(); ++i) {
                    Integer point = (Integer)snapPointsX.get(i);
                    int distance = Math.abs(snappedX - point);
                    if (bestDistanceX != null && distance >= bestDistanceX) continue;
                    bestDistanceX = distance;
                    finalPointX = point;
                }
                if (finalPointX != null && bestDistanceX < 8) {
                    snappedX = finalPointX;
                }
                ArrayList<Integer> snapPointsY = new ArrayList<Integer>();
                snapPointsY.add(wheight / 2 - this.field_22759 / 2);
                for (int i = 0; i < HudManager.hudElements.size(); ++i) {
                    HUDElement el = HudManager.hudElements.get(i);
                    if (el.equals(this.element) || !HudManager.hudEnabled.get(el.identifier).booleanValue()) continue;
                    class_768 transform = el.getTransform();
                    class_768 transform2 = this.element.getTransform();
                    snapPointsY.add(transform.method_3322() - el.padding);
                    snapPointsY.add(transform.method_3322() + transform.method_3320() - el.padding);
                    snapPointsY.add(transform.method_3322() - el.padding - transform2.method_3320());
                    snapPointsY.add(transform.method_3322() + transform.method_3320() - el.padding - transform2.method_3320());
                }
                Integer finalPointY = null;
                Integer bestDistanceY = null;
                for (int i = 0; i < snapPointsY.size(); ++i) {
                    Integer point = (Integer)snapPointsY.get(i);
                    int distance = Math.abs(snappedY - point);
                    if (bestDistanceY != null && distance >= bestDistanceY) continue;
                    bestDistanceY = distance;
                    finalPointY = point;
                }
                if (finalPointY != null && bestDistanceY < 8) {
                    snappedY = finalPointY;
                }
            }
            this.method_46421(snappedX);
            this.method_46419(snappedY);
        }
        this.pressed = false;
        class_768 position = this.getRect();
        class_768 fixedPosition = HudManager.hudAnchors.get(this.element.identifier).convertBack(position);
        HudManager.hudPositions.put(this.element.identifier, fixedPosition);
    }

    public class_768 getRect() {
        return new class_768(this.method_46426() + this.element.padding, this.method_46427() + this.element.padding, this.method_25368() - this.element.padding * 2, this.method_25364() - this.element.padding * 2);
    }

    public void method_25354(class_1144 soundManager) {
    }

    public void method_25348(double mouseX, double mouseY) {
        this.pressed = true;
        this.resizing = this.isResizing(mouseX, mouseY) && this.element.canResize();
        super.method_25348(mouseX, mouseY);
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.pressed && !this.resizing) {
            this.enabled = this.enabled == false;
            if (this.enabled.booleanValue()) {
                this.element.onEnable();
            } else {
                this.element.onDisable();
            }
            HudManager.hudShown.put(this.element.identifier, this.enabled);
        }
        if (!this.pressed && !this.resizing) {
            HudAnchor anchor = HudManager.hudAnchors.get(this.element.identifier);
            class_1041 window = class_310.method_1551().method_22683();
            int centerX = (this.method_25368() + this.method_46426() + this.method_46426()) / 2;
            int centerY = (this.method_25364() + this.method_46427() + this.method_46427()) / 2;
            int width = window.method_4486();
            int height = window.method_4502();
            anchor.horizontalAnchor = centerX < width / 3 ? HudAnchor.HorizontalAnchor.LEFT : (centerX < 2 * width / 3 ? HudAnchor.HorizontalAnchor.CENTER : HudAnchor.HorizontalAnchor.RIGHT);
            anchor.verticalAnchor = centerY < height / 3 ? HudAnchor.VerticalAnchor.TOP : (centerY < 2 * height / 3 ? HudAnchor.VerticalAnchor.MIDDLE : HudAnchor.VerticalAnchor.BOTTOM);
            HudManager.hudPositions.put(this.element.identifier, anchor.convertBack(this.getRect()));
        }
        super.method_25357(mouseX, mouseY);
    }

    protected void method_47399(class_6382 builder) {
    }
}

