/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.hudlib.config;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorTypeAdapter
extends TypeAdapter<Color> {
    public void write(JsonWriter out, Color color) throws IOException {
        if (color == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("r").value((long)color.getRed());
        out.name("g").value((long)color.getGreen());
        out.name("b").value((long)color.getBlue());
        out.name("a").value((long)color.getAlpha());
        out.endObject();
    }

    public Color read(JsonReader in) throws IOException {
        in.beginObject();
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "r": {
                    r = in.nextInt();
                    break;
                }
                case "g": {
                    g = in.nextInt();
                    break;
                }
                case "b": {
                    b = in.nextInt();
                    break;
                }
                case "a": {
                    a = in.nextInt();
                }
            }
        }
        in.endObject();
        return new Color(r, g, b, a);
    }
}

