/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.hudlib.config;

import com.google.gson.Gson;
import dev.wooferz.hudlib.HudLibClient;
import dev.wooferz.hudlib.config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Scanner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static ConfigManager instance = null;
    public Config config;
    boolean read = false;

    private ConfigManager() {
    }

    public Path fileLocation() {
        return FabricLoader.getInstance().getConfigDir().resolve("hudlib-base.json5");
    }

    public void read() {
        if (this.read) {
            return;
        }
        this.read = true;
        File config = this.fileLocation().toFile();
        try {
            Scanner configReader = new Scanner(config);
            StringBuilder jsonString = new StringBuilder();
            while (configReader.hasNextLine()) {
                jsonString.append(configReader.nextLine());
            }
            Gson gson = new Gson();
            this.config = (Config)gson.fromJson(jsonString.toString(), Config.class);
        }
        catch (FileNotFoundException e) {
            HudLibClient.LOGGER.info("Config File Not Found!!");
            this.saveConfig();
        }
    }

    public void saveConfig() {
        File configFile = this.fileLocation().toFile();
        try {
            configFile.createNewFile();
            FileWriter writer = new FileWriter(configFile);
            if (this.config == null) {
                this.config = new Config();
            }
            Gson gson = new Gson();
            String json = gson.toJson((Object)this.config);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            HudLibClient.LOGGER.error("Unexpected Error.");
        }
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }
}

