/*
 * Decompiled with CFR 0.152.
 */
package com.bouncingelf10.animatedLogo.mixin;

import com.bouncingelf10.animatedLogo.AnimatedLogo;
import com.bouncingelf10.animatedLogo.DarkLoadingScreenCompat;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_425.class})
public class SplashOverlayMixin {
    @Mutable
    @Shadow
    @Final
    private class_4011 field_17767;
    @Shadow
    private float field_17770;
    @Unique
    private int count = 0;
    @Unique
    private class_2960[] frames;
    @Unique
    private boolean inited = false;
    @Unique
    private static final int FRAMES = 12;
    @Unique
    private static final int IMAGE_PER_FRAME = 4;
    @Unique
    private static final int FRAMES_PER_FRAME = 2;
    @Unique
    private float f = 0.0f;
    @Unique
    private boolean animationDone = false;
    @Shadow
    @Final
    private static IntSupplier field_25041;
    @Unique
    private static int whiteARGB;
    @Unique
    private static IntSupplier LOADING_FILL;
    @Unique
    private static IntSupplier LOADING_BORDER;
    @Unique
    private static IntSupplier TEXT_COLOR;
    @Unique
    private boolean soundPlayed = false;
    @Unique
    private boolean animationReady = false;
    @Unique
    private boolean isFadingOut = false;
    @Unique
    private boolean isFadingFinished = false;
    @Unique
    private long animationStartTime = -1L;
    @Unique
    private static final float TOTAL_ANIMATION_DURATION = 3.0f;
    @Unique
    private long animationDelayStartTime = -1L;
    @Unique
    private static final long ANIMATION_DELAY_MS = 1L;
    @Unique
    private long fadeOutStartTime = -1L;
    @Unique
    private static final long FADE_OUT_DURATION_MS = 1000L;
    @Unique
    private static float loadingBarProgress;
    @Unique
    private long postLogoStartTime = -1L;
    @Unique
    private static final long POST_LOGO_DELAY_MS = 500L;
    @Unique
    private static final long POST_LOGO_FADE_DURATION_MS = 1000L;
    @Unique
    private float postLogoAlpha = 1.0f;
    @Unique
    private static boolean HAS_LOADED_ONCE;

    @Unique
    private void drawLoadingBar(class_332 context, float opacity, float progress) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int centerX = screenWidth / 2;
        int progressBarY = (int)((double)screenHeight * 0.8325);
        double logoHeight = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double logoWidth = logoHeight * 4.0;
        int halfLogoWidth = (int)(logoWidth * 0.5);
        int minX = centerX - halfLogoWidth;
        int maxX = centerX + halfLogoWidth;
        int minY = progressBarY - 5;
        int maxY = progressBarY + 5;
        int filled = class_3532.method_15386((float)((float)(maxX - minX - 2) * progress));
        int colorFilled = SplashOverlayMixin.applyAlphaToColor(LOADING_FILL.getAsInt(), opacity);
        int colorOutline = SplashOverlayMixin.applyAlphaToColor(LOADING_BORDER.getAsInt(), opacity);
        context.method_25294(minX + 2, minY + 2, minX + filled, maxY - 2, colorFilled);
        context.method_25294(minX + 1, minY, maxX - 1, minY + 1, colorOutline);
        context.method_25294(minX + 1, maxY, maxX - 1, maxY - 1, colorOutline);
        context.method_25294(minX, minY, minX + 1, maxY, colorOutline);
        context.method_25294(maxX, minY, maxX - 1, maxY, colorOutline);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_310 client, class_4011 monitor, Consumer<Throwable> exceptionHandler, boolean reloading, CallbackInfo ci) {
        if (HAS_LOADED_ONCE) {
            AnimatedLogo.LOGGER.warn("Animated Mojang Logo has already been loaded once, skipping initialization.");
            return;
        }
        this.animationDelayStartTime = System.currentTimeMillis();
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIFFIIIIIII)V", ordinal=0), index=7)
    private int removeText1(int i) {
        return HAS_LOADED_ONCE ? i : 0;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIFFIIIIIII)V", ordinal=1), index=7)
    private int removeText2(int u) {
        return HAS_LOADED_ONCE ? u : 0;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/SplashOverlay;renderProgressBar(Lnet/minecraft/client/gui/DrawContext;IIIIF)V", ordinal=0), index=5)
    private float removeBar(float opacity) {
        return HAS_LOADED_ONCE ? opacity : 0.0f;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;setOverlay(Lnet/minecraft/client/gui/screen/Overlay;)V")}, cancellable=true)
    private void preventEarlyRemoval(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!HAS_LOADED_ONCE) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (HAS_LOADED_ONCE) {
            return;
        }
        long elapsed = System.currentTimeMillis() - this.animationDelayStartTime;
        if (elapsed < 1L) {
            context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), context.method_51443(), class_9848.method_61330((int)((int)(elapsed * 255L / 1L / 10L)), (int)SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f)));
            ci.cancel();
            return;
        }
        if (!this.animationDone) {
            this.drawAnimatedIntro(context);
            ci.cancel();
        }
    }

    @Unique
    private void drawAnimatedIntro(class_332 context) {
        if (!(this.field_17767.method_18787() || this.isFadingOut || this.isFadingFinished)) {
            context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            this.drawLoadingBar(context, 1.0f, Math.max(loadingBarProgress, this.field_17767.method_18229()));
            loadingBarProgress = this.field_17767.method_18229();
            return;
        }
        if (this.field_17767.method_18787() && !this.isFadingOut && !this.isFadingFinished) {
            this.isFadingOut = true;
            this.fadeOutStartTime = System.currentTimeMillis();
        }
        if (this.isFadingOut && !this.isFadingFinished) {
            long elapsedFade = System.currentTimeMillis() - this.fadeOutStartTime;
            float fadeFactor = 1.0f - class_3532.method_15363((float)((float)elapsedFade / 1000.0f), (float)0.0f, (float)1.0f);
            context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            this.drawLoadingBar(context, fadeFactor, 1.0f);
            loadingBarProgress = this.field_17767.method_18229();
            if ((double)fadeFactor <= 0.0) {
                this.isFadingFinished = true;
            }
            return;
        }
        if (this.isFadingFinished && !this.animationReady) {
            this.animationReady = true;
            this.animationStartTime = System.nanoTime();
            if (!this.soundPlayed) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AnimatedLogo.STARTUP_SOUND_EVENT, (float)1.0f));
                AnimatedLogo.LOGGER.info("Playing startup sound");
                this.soundPlayed = true;
            }
            if (!this.inited) {
                this.frames = new class_2960[12];
                for (int i = 0; i < 12; ++i) {
                    this.frames[i] = class_2960.method_60655((String)"animated-mojang-logo", (String)("textures/gui/frame_" + i + ".png"));
                }
                this.inited = true;
            }
        }
        if (this.animationReady) {
            double elapsedSeconds = (double)(System.nanoTime() - this.animationStartTime) / 1.0E9;
            double animationProgress = Math.min(elapsedSeconds / 3.0, 1.0);
            int totalFrameCount = 96;
            this.count = (int)(animationProgress * (double)totalFrameCount);
            if (animationProgress >= 1.0) {
                this.animationDone = true;
                this.count = totalFrameCount - 1;
            }
            int screenWidth = context.method_51421();
            int screenHeight = context.method_51443();
            int width = screenWidth / 2;
            int height = width * 256 / 1024;
            int x = (screenWidth - width) / 2;
            int y = (screenHeight - height) / 2;
            int frameIndex = this.count / 4 / 2;
            int subFrameY = 256 * (this.count % 8 / 2);
            context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            context.method_25293(class_10799.field_56883, this.frames[frameIndex], x, y, 0.0f, (float)subFrameY, width, height, 1024, 256, 1024, 1024, SplashOverlayMixin.applyAlphaToColor(TEXT_COLOR.getAsInt(), 1.0f));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIFFIIIIIII)V", ordinal=1, shift=At.Shift.AFTER)})
    private void onAfterRenderLogo(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci, @Local(ordinal=2) int scaledWidth, @Local(ordinal=3) int scaledHeight, @Local(ordinal=3) float alpha, @Local(ordinal=4) int x, @Local(ordinal=5) int y, @Local(ordinal=0) double height, @Local(ordinal=6) int halfHeight, @Local(ordinal=1) double width, @Local(ordinal=7) int halfWidth) {
        long elapsedSincePostLogo;
        if (!this.animationDone || HAS_LOADED_ONCE) {
            return;
        }
        int finalFrameScreenWidth = context.method_51421();
        int finalFrameScreenHeight = context.method_51443();
        int finalFrameWidth = finalFrameScreenWidth / 2;
        int finalFrameHeight = finalFrameWidth * 256 / 1024;
        int finalFrameX = (finalFrameScreenWidth - finalFrameWidth) / 2;
        int finalFrameY = (finalFrameScreenHeight - finalFrameHeight) / 2;
        int finalSubFrameY = 256 * (this.count % 8 / 2);
        class_2960 finalFrame = this.frames[11];
        context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), this.postLogoAlpha));
        float progress = class_3532.method_15363((float)(this.field_17770 * 0.95f + this.field_17767.method_18229() * 0.050000012f), (float)0.0f, (float)1.0f);
        if (progress >= 0.8f && this.postLogoStartTime == -1L) {
            this.postLogoStartTime = System.currentTimeMillis();
        }
        if (this.postLogoStartTime != -1L && (elapsedSincePostLogo = System.currentTimeMillis() - this.postLogoStartTime) > 500L) {
            float fadeProgress = class_3532.method_15363((float)((float)(elapsedSincePostLogo - 500L) / 1000.0f), (float)0.0f, (float)1.0f);
            this.postLogoAlpha = 1.0f - fadeProgress;
        }
        int effectiveAlpha = SplashOverlayMixin.applyAlphaToColor(TEXT_COLOR.getAsInt(), this.postLogoAlpha);
        context.method_25293(class_10799.field_56883, finalFrame, finalFrameX, finalFrameY, 0.0f, (float)finalSubFrameY, finalFrameWidth, finalFrameHeight, 1024, 256, 1024, 1024, effectiveAlpha);
        if ((double)progress >= 0.8) {
            this.f = Math.min(this.postLogoAlpha, this.f + 0.2f);
            int sw = (int)(width * 0.45);
            context.method_25293(class_10799.field_56883, class_2960.method_60655((String)"animated-mojang-logo", (String)"textures/gui/studios.png"), x - sw / 2, (int)((double)(y - halfHeight) + height - height / 12.0), 0.0f, 0.0f, sw, (int)(height / 5.0), 450, 50, 512, 512, SplashOverlayMixin.applyAlphaToColor(TEXT_COLOR.getAsInt(), this.f * this.postLogoAlpha));
        }
        if (this.postLogoAlpha <= 0.0f) {
            HAS_LOADED_ONCE = true;
        }
    }

    @Unique
    private static int applyAlphaToColor(int color, float alpha) {
        int rgb = color & 0xFFFFFF;
        int a = class_3532.method_15340((int)((int)(alpha * 255.0f)), (int)0, (int)255);
        return a << 24 | rgb;
    }

    static {
        whiteARGB = class_9848.method_61324((int)255, (int)255, (int)255, (int)255);
        LOADING_FILL = () -> DarkLoadingScreenCompat.getBarColor(whiteARGB);
        LOADING_BORDER = () -> DarkLoadingScreenCompat.getBorderColor(whiteARGB);
        TEXT_COLOR = () -> SplashOverlayMixin.applyAlphaToColor(DarkLoadingScreenCompat.getLogoColor(whiteARGB), 1.0f);
        loadingBarProgress = 0.0f;
        HAS_LOADED_ONCE = false;
    }
}

