/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.commands.ScoreCommand;
import org.mods.gd656killicon.data.BanListData;
import org.mods.gd656killicon.data.ScoreData;
import org.mods.gd656killicon.data.ScoreExpressionManager;
import org.mods.gd656killicon.data.ScoreboardBindingData;
import org.mods.gd656killicon.events.PlayerEventHandler;
import org.mods.gd656killicon.network.DamageScorePacket;
import org.mods.gd656killicon.network.KillPacket;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.ScoreSyncPacket;
import org.mods.gd656killicon.util.ScoreExpressionCalculator;

public class Gd656killicon
implements ModInitializer {
    public static final String MOD_ID = "gd656killicon";
    public static final class_3414 ASSIST_KILL_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "assistkill_sound_vanilla"));
    public static final class_3414 CARD_KILL_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "cardkill_sound_vanilla"));
    public static final class_3414 COMBO_1_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_1_vanilla"));
    public static final class_3414 COMBO_2_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_2_vanilla"));
    public static final class_3414 COMBO_3_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_3_vanilla"));
    public static final class_3414 COMBO_4_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_4_vanilla"));
    public static final class_3414 COMBO_5_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_5_vanilla"));
    public static final class_3414 COMBO_6_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_6_vanilla"));
    public static final class_3414 KILL_SOUND_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "kill_sound_vanilla"));
    public static final class_3414 ULTIMATE_KILL_VANILLA = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "ultimatekill_sound_vanilla"));
    public static final class_3414 ASSIST_KILL_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "assistkill_sound_modern"));
    public static final class_3414 CARD_KILL_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "cardkill_sound_modern"));
    public static final class_3414 COMBO_1_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_1_modern"));
    public static final class_3414 COMBO_2_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_2_modern"));
    public static final class_3414 COMBO_3_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_3_modern"));
    public static final class_3414 COMBO_4_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_4_modern"));
    public static final class_3414 COMBO_5_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_5_modern"));
    public static final class_3414 COMBO_6_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "combo_6_modern"));
    public static final class_3414 KILL_SOUND_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "kill_sound_modern"));
    public static final class_3414 ULTIMATE_KILL_MODERN = class_3414.method_47908((class_2960)new class_2960("gd656killicon", "ultimatekill_sound_modern"));
    private static final Map<UUID, Map<UUID, AssistData>> assistDataMap = new HashMap<UUID, Map<UUID, AssistData>>();
    private static final Map<UUID, Long> lastDamageTimeMap = new HashMap<UUID, Long>();
    private static final Map<UUID, Boolean> playerCritMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> playerComboCount = new HashMap<UUID, Integer>();
    private static final Map<class_2960, Long> soundCooldowns = new HashMap<class_2960, Long>();
    private static final int SOUND_COOLDOWN_MS = 100;
    private static final long ASSIST_TIMEOUT = 60000L;

    public void onInitialize() {
        NetworkHandler.register();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            this.onLivingDamage(entity, source, amount);
            return true;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> this.onLivingDeath(entity, source));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ScoreCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        PlayerEventHandler.registerPlayerEvents();
        this.registerSoundEvents();
    }

    private void registerSoundEvents() {
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ASSIST_KILL_VANILLA.method_14833(), (Object)ASSIST_KILL_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CARD_KILL_VANILLA.method_14833(), (Object)CARD_KILL_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_1_VANILLA.method_14833(), (Object)COMBO_1_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_2_VANILLA.method_14833(), (Object)COMBO_2_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_3_VANILLA.method_14833(), (Object)COMBO_3_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_4_VANILLA.method_14833(), (Object)COMBO_4_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_5_VANILLA.method_14833(), (Object)COMBO_5_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_6_VANILLA.method_14833(), (Object)COMBO_6_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)KILL_SOUND_VANILLA.method_14833(), (Object)KILL_SOUND_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ULTIMATE_KILL_VANILLA.method_14833(), (Object)ULTIMATE_KILL_VANILLA);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ASSIST_KILL_MODERN.method_14833(), (Object)ASSIST_KILL_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CARD_KILL_MODERN.method_14833(), (Object)CARD_KILL_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_1_MODERN.method_14833(), (Object)COMBO_1_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_2_MODERN.method_14833(), (Object)COMBO_2_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_3_MODERN.method_14833(), (Object)COMBO_3_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_4_MODERN.method_14833(), (Object)COMBO_4_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_5_MODERN.method_14833(), (Object)COMBO_5_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)COMBO_6_MODERN.method_14833(), (Object)COMBO_6_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)KILL_SOUND_MODERN.method_14833(), (Object)KILL_SOUND_MODERN);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ULTIMATE_KILL_MODERN.method_14833(), (Object)ULTIMATE_KILL_MODERN);
    }

    private void onLivingDamage(class_1309 entity, class_1282 source, float amount) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_1309 target = entity;
        class_2960 entityId = class_7923.field_41177.method_10221((Object)target.method_5864());
        boolean isBanned = BanListData.get(target.method_5682()).isBanned(entityId.toString());
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            float damageAmount = amount;
            byte damageType = this.getDamageType(player, source);
            String reason = this.getDamageReason(damageType);
            if (!isBanned) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkHandler.DAMAGE_SCORE_PACKET_ID, (class_2540)new DamageScorePacket(damageAmount, reason).toBuf());
            }
            lastDamageTimeMap.put(player.method_5667(), System.currentTimeMillis());
            playerCritMap.put(player.method_5667(), this.isPlayerCritical(player));
            if (!isBanned) {
                this.handleDamageScore(player, target, damageAmount, damageType);
            }
            this.handleAssistData(target, player, damageAmount);
            this.cleanupExpiredAssistData();
        }
    }

    private void onLivingDeath(class_1309 entity, class_1282 source) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_1309 target = entity;
        class_2960 entityId = class_7923.field_41177.method_10221((Object)target.method_5864());
        boolean isBanned = BanListData.get(target.method_5682()).isBanned(entityId.toString());
        MinecraftServer server = target.method_37908().method_8503();
        if (server == null) {
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 killer = (class_3222)class_12972;
            this.handleKillEvent(killer, target, source, isBanned);
        }
        this.handleAssistKills(target, source, server, isBanned);
    }

    private void onServerStarting(MinecraftServer server) {
        ScoreData.get(server);
        BanListData.get(server);
        ScoreExpressionManager.get(server);
        ScoreboardBindingData.get(server);
        this.startScoreboardSyncTask(server);
    }

    private void handleDamageScore(class_3222 player, class_1309 target, float damageAmount, byte damageType) {
        ScoreData scoreData = ScoreData.get(player.method_5682());
        ScoreExpressionManager expressionManager = ScoreExpressionManager.get(player.method_5682());
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("damage", Double.valueOf(damageAmount));
        variables.put("health", Double.valueOf(target.method_6063()));
        String expressionKey = this.getDamageExpressionKey(damageType);
        double calculatedScore = ScoreExpressionCalculator.calculate(expressionManager.getExpression(expressionKey), variables);
        scoreData.addScore(player.method_5667(), (float)calculatedScore, player.method_5682());
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkHandler.SCORE_SYNC_PACKET_ID, (class_2540)new ScoreSyncPacket(scoreData.getScore(player.method_5667())).toBuf());
    }

    private void handleKillEvent(class_3222 killer, class_1309 target, class_1282 source, boolean isBanned) {
        ScoreExpressionManager expressionManager = ScoreExpressionManager.get(killer.method_5682());
        String targetKey = this.getTargetName(target);
        boolean isCritical = playerCritMap.getOrDefault(killer.method_5667(), false);
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("health", Double.valueOf(target.method_6063()));
        double killScore = ScoreExpressionCalculator.calculate(expressionManager.getExpression("kill"), variables);
        if (isCritical) {
            variables.put("killscore", killScore);
            double critBonus = ScoreExpressionCalculator.calculate(expressionManager.getExpression("critical"), variables);
            killScore += critBonus;
        }
        byte damageType = this.getDamageType(killer, source);
        int displayScore = isBanned ? 0 : (int)Math.round(killScore);
        ServerPlayNetworking.send((class_3222)killer, (class_2960)NetworkHandler.KILL_PACKET_ID, (class_2540)new KillPacket(targetKey, isCritical, isCritical, displayScore, false, damageType).toBuf());
        if (!isBanned) {
            ScoreData scoreData = ScoreData.get(killer.method_5682());
            scoreData.addScore(killer.method_5667(), (float)killScore, killer.method_5682());
            ServerPlayNetworking.send((class_3222)killer, (class_2960)NetworkHandler.SCORE_SYNC_PACKET_ID, (class_2540)new ScoreSyncPacket(scoreData.getScore(killer.method_5667())).toBuf());
            this.updateComboCount(killer.method_5667());
        }
        this.handleLongRangeKill(killer, target, isBanned);
        playerCritMap.remove(killer.method_5667());
    }

    private void handleAssistKills(class_1309 target, class_1282 source, MinecraftServer server, boolean isBanned) {
        UUID uUID;
        UUID targetId = target.method_5667();
        if (!assistDataMap.containsKey(targetId)) {
            return;
        }
        Map<UUID, AssistData> targetAssists = assistDataMap.get(targetId);
        float maxHealth = target.method_6063();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 killer = (class_3222)class_12972;
            uUID = killer.method_5667();
        } else {
            uUID = null;
        }
        UUID killerId = uUID;
        for (AssistData assist : targetAssists.values()) {
            class_3222 assister;
            if (assist.attackerId.equals(killerId) || (assister = server.method_3760().method_14602(assist.attackerId)) == null) continue;
            ScoreExpressionManager expressionManager = ScoreExpressionManager.get(server);
            HashMap<String, Double> variables = new HashMap<String, Double>();
            variables.put("damagedealt", Double.valueOf(assist.damageDealt));
            variables.put("health", Double.valueOf(maxHealth));
            double assistScore = ScoreExpressionCalculator.calculate(expressionManager.getExpression("assist"), variables);
            if (isBanned) {
                assistScore = 0.0;
            }
            byte damageType = this.getDamageType(assister, source);
            ServerPlayNetworking.send((class_3222)assister, (class_2960)NetworkHandler.KILL_PACKET_ID, (class_2540)new KillPacket(this.getTargetName(target), false, false, (int)Math.round(assistScore), true, damageType).toBuf());
            if (isBanned) continue;
            ScoreData scoreData = ScoreData.get(server);
            scoreData.addScore(assister.method_5667(), (float)assistScore, server);
            ServerPlayNetworking.send((class_3222)assister, (class_2960)NetworkHandler.SCORE_SYNC_PACKET_ID, (class_2540)new ScoreSyncPacket(scoreData.getScore(assister.method_5667())).toBuf());
            this.updateComboCount(assister.method_5667());
        }
        assistDataMap.remove(targetId);
    }

    private void handleLongRangeKill(class_3222 killer, class_1309 target, boolean isBanned) {
        double distance = killer.method_5739((class_1297)target);
        if (distance >= 20.0) {
            ScoreExpressionManager expressionManager = ScoreExpressionManager.get(killer.method_5682());
            HashMap<String, Double> variables = new HashMap<String, Double>();
            variables.put("distance", distance);
            double distanceScore = ScoreExpressionCalculator.calculate(expressionManager.getExpression("longrange"), variables);
            if (!isBanned) {
                String reason = "\u8fdc\u8ddd\u79bb\u51fb\u8d25 " + (int)distance + "m";
                ServerPlayNetworking.send((class_3222)killer, (class_2960)NetworkHandler.DAMAGE_SCORE_PACKET_ID, (class_2540)new DamageScorePacket((float)distanceScore, reason).toBuf());
                ScoreData scoreData = ScoreData.get(killer.method_5682());
                scoreData.addScore(killer.method_5667(), (float)distanceScore, killer.method_5682());
                ServerPlayNetworking.send((class_3222)killer, (class_2960)NetworkHandler.SCORE_SYNC_PACKET_ID, (class_2540)new ScoreSyncPacket(scoreData.getScore(killer.method_5667())).toBuf());
            }
        }
    }

    private void handleAssistData(class_1309 target, class_3222 player, float damageAmount) {
        Map<UUID, AssistData> targetAssists;
        UUID targetId = target.method_5667();
        UUID attackerId = player.method_5667();
        if (!assistDataMap.containsKey(targetId)) {
            assistDataMap.put(targetId, new HashMap());
        }
        if ((targetAssists = assistDataMap.get(targetId)).containsKey(attackerId)) {
            targetAssists.computeIfPresent(attackerId, (k, existing) -> new AssistData(attackerId, existing.damageDealt + damageAmount));
        } else {
            targetAssists.put(attackerId, new AssistData(attackerId, damageAmount));
        }
    }

    private void cleanupExpiredAssistData() {
        long currentTime = System.currentTimeMillis();
        assistDataMap.values().removeIf(targetAssists -> {
            targetAssists.entrySet().removeIf(e -> currentTime - ((AssistData)e.getValue()).timestamp > 60000L);
            return targetAssists.isEmpty();
        });
    }

    private void startScoreboardSyncTask(MinecraftServer server) {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            if (server.method_3806()) {
                server.execute(() -> ScoreCommand.syncScoresToScoreboard(server));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void updateComboCount(UUID playerId) {
        long currentTime = System.currentTimeMillis();
        int comboCount = playerComboCount.getOrDefault(playerId, 0);
        if (currentTime - lastDamageTimeMap.getOrDefault(playerId, 0L) > (long)Config.comboTimeoutMs) {
            comboCount = 0;
        }
        playerComboCount.put(playerId, ++comboCount);
        lastDamageTimeMap.put(playerId, currentTime);
    }

    private byte getDamageType(class_3222 player, class_1282 source) {
        if (this.isMagicDamage(source)) {
            return 1;
        }
        if (player.method_6047().method_7960()) {
            return 2;
        }
        return 0;
    }

    private String getDamageReason(byte damageType) {
        return switch (damageType) {
            case 1 -> "\u9b54\u6cd5\u4f24\u5bb3";
            case 2 -> "\u7a7a\u624b\u653b\u51fb";
            default -> "\u9020\u6210\u4f24\u5bb3";
        };
    }

    private String getDamageExpressionKey(byte damageType) {
        return switch (damageType) {
            case 1 -> "magic";
            case 2 -> "hand";
            default -> "damage";
        };
    }

    private boolean isPlayerCritical(class_3222 player) {
        return player.field_6017 > 0.0f && !player.method_24828() && !player.method_6128() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765() && !player.method_18276();
    }

    private boolean isMagicDamage(class_1282 source) {
        String msgId = source.method_5525();
        return msgId.contains("magic") || msgId.contains("potion") || msgId.contains("indirect") || msgId.contains("thrown") || msgId.contains("wither") || msgId.contains("dragon");
    }

    private String getTargetName(class_1309 target) {
        return target instanceof class_3222 ? target.method_5477().getString() : target.method_5864().method_5882();
    }

    public static class_3414 getCardKillSound() {
        return Config.iconStyle == Config.IconStyle.VANILLA ? CARD_KILL_VANILLA : CARD_KILL_MODERN;
    }

    static class AssistData {
        public final UUID attackerId;
        public final float damageDealt;
        public final long timestamp;

        public AssistData(UUID attackerId, float damageDealt) {
            this.attackerId = attackerId;
            this.damageDealt = damageDealt;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

