/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;

public class HelpScreen
extends class_437 {
    private final class_437 parent;
    private static final int CATEGORY_BUTTON_HEIGHT = 25;
    private static final int CATEGORY_BUTTON_WIDTH = 120;
    private static final int CONTENT_MARGIN = 15;
    private static final int SEARCH_HEIGHT = 30;
    private static final int TITLE_HEIGHT = 40;
    private List<CategoryButton> categoryButtons;
    private HelpContentArea contentArea;
    private HelpCategory currentCategory = HelpCategory.BASIC;
    private class_342 searchBox;

    public HelpScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"\u5e2e\u52a9\u4e2d\u5fc3"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.initCategoryButtons();
        this.initSearchBox();
        this.initContentArea();
        this.initBackButton();
        this.updateContent();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderCategoryButtons(guiGraphics, mouseX, mouseY);
        this.contentArea.render(guiGraphics);
        if (this.searchBox.method_1882().isEmpty() && !this.searchBox.method_25370()) {
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"\u641c\u7d22\u547d\u4ee4\u6216\u529f\u80fd...").method_27692(class_124.field_1080), this.searchBox.method_46426() + 4, this.searchBox.method_46427() + (this.searchBox.method_25364() - 8) / 2, 0x808080, false);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (CategoryButton catButton : this.categoryButtons) {
            if (!catButton.contains(mouseX, mouseY)) continue;
            this.currentCategory = catButton.category;
            this.updateContent();
            return true;
        }
        if (this.contentArea.contains(mouseX, mouseY) && this.contentArea.handleMouseClick(mouseX)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.contentArea.handleMouseDrag(dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.contentArea.handleMouseRelease();
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.contentArea.contains(mouseX, mouseY)) {
            this.contentArea.scroll(delta);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void addAdvancedFeatures(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u9ad8\u7ea7\u529f\u80fd").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u5e2e\u52a9\u7cfb\u7edf").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
        this.addCommandEntry(content, "/gdscore help", "\u67e5\u770b\u547d\u4ee4\u5e2e\u52a9", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore help");
        this.addCommandEntry(content, "/gdscore help <\u9875\u7801>", "\u67e5\u770b\u6307\u5b9a\u9875\u7801\u7684\u5e2e\u52a9", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore help 2");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u6743\u9650\u8bf4\u660e").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)"0: \u6240\u6709\u73a9\u5bb6").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"2: \u64cd\u4f5c\u5458/\u7ba1\u7406\u5458").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"3: \u670d\u52a1\u5668\u7ba1\u7406\u5458").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u6a21\u7ec4\u4fe1\u606f").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u6a21\u7ec4\u7248\u672c: 1.0.0 \u516c\u6d4b\u7248 RC5 *Fabric*").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u652f\u6301Minecraft: 1.20.1").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u5f00\u53d1\u8005: Minecraft_GD656").method_27692(class_124.field_1080));
    }

    private void addBasicCommands(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u57fa\u7840\u67e5\u8be2\u547d\u4ee4").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore", "\u67e5\u770b\u81ea\u5df1\u7684\u5f53\u524d\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore");
        this.addCommandEntry(content, "/gdscore top", "\u67e5\u770b\u670d\u52a1\u5668\u5206\u6570\u6392\u884c\u699c", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore top");
        this.addCommandEntry(content, "/gdscore get <\u73a9\u5bb6>", "\u67e5\u770b\u6307\u5b9a\u73a9\u5bb6\u7684\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore get Steve");
        this.addCommandEntry(content, "/gdscore cardclear", "\u6e05\u9664\u5f53\u524d\u6240\u6709\u5361\u724c", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore cardclear");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u63d0\u793a: \u6240\u6709\u73a9\u5bb6\u90fd\u53ef\u4ee5\u67e5\u770b\u81ea\u5df1\u7684\u5206\u6570\u548c\u6392\u884c\u699c").method_27692(class_124.field_1080));
    }

    private void addBonusSystemContent(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u52a0\u5206\u9879\u7cfb\u7edf").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u7ba1\u7406\u547d\u4ee4").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
        this.addCommandEntry(content, "/gdscore bonuspoints list", "\u5217\u51fa\u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f", "\u6743\u9650\u7b49\u7ea7: 2", "");
        this.addCommandEntry(content, "/gdscore bonuspoints reset", "\u91cd\u7f6e\u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u4e3a\u9ed8\u8ba4\u503c", "\u6743\u9650\u7b49\u7ea7: 2", "");
        this.addCommandEntry(content, "/gdscore bonuspoints edit <\u52a0\u5206\u9879> <\u8868\u8fbe\u5f0f>", "\u7f16\u8f91\u52a0\u5206\u9879\u7684\u8868\u8fbe\u5f0f", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore bonuspoints edit kill health * 5");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u53ef\u7528\u53d8\u91cf").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
        this.addVariableEntry(content, "health", "\u76ee\u6807\u751f\u547d\u503c");
        this.addVariableEntry(content, "distance", "\u653b\u51fb\u8ddd\u79bb");
        this.addVariableEntry(content, "damage", "\u5355\u6b21\u4f24\u5bb3");
        this.addVariableEntry(content, "damagedealt", "\u603b\u4f24\u5bb3");
        this.addVariableEntry(content, "combo", "\u8fde\u6740\u6570");
        this.addVariableEntry(content, "killscore", "\u51fb\u6740\u57fa\u7840\u5206\u6570");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u8fd0\u7b97\u7b26: +  -  *  /").method_27692(class_124.field_1080));
    }

    private void addCommandEntry(List<class_2561> content, String command, String description, String permission, String example) {
        content.add((class_2561)class_2561.method_43470((String)command).method_27692(class_124.field_1075));
        content.add((class_2561)class_2561.method_43470((String)("  " + description)).method_27692(class_124.field_1068));
        content.add((class_2561)class_2561.method_43470((String)("  " + permission)).method_27692(class_124.field_1063));
        if (!example.isEmpty()) {
            content.add((class_2561)class_2561.method_43470((String)("  " + example)).method_27692(class_124.field_1077));
        }
        content.add((class_2561)class_2561.method_43470((String)""));
    }

    private void addEntityManagementCommands(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u5b9e\u4f53\u7ba1\u7406\u547d\u4ee4").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore ban <\u5b9e\u4f53ID>", "\u7981\u6b62\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore ban minecraft:zombie");
        this.addCommandEntry(content, "/gdscore allow <\u5b9e\u4f53ID>", "\u5141\u8bb8\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore allow minecraft:skeleton");
        this.addCommandEntry(content, "/gdscore banlist", "\u67e5\u770b\u7981\u6b62\u7206\u51fa\u5206\u6570\u7684\u5b9e\u4f53\u5217\u8868", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore banlist");
        this.addCommandEntry(content, "/gdscore ban all", "\u7981\u6b62\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u7279\u6b8a\u547d\u4ee4");
        this.addCommandEntry(content, "/gdscore allow all", "\u5141\u8bb8\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u7279\u6b8a\u547d\u4ee4");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u5b9e\u4f53ID\u683c\u5f0f: minecraft:\u5b9e\u4f53\u540d\u79f0").method_27692(class_124.field_1080));
    }

    private void addRuleCommands(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u89c4\u5219\u8bbe\u7f6e").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore rule RankingList <true/false>", "\u5f00\u542f\u6216\u5173\u95ed\u6392\u884c\u699c\u529f\u80fd", "\u6743\u9650\u7b49\u7ea7: 3", "\u793a\u4f8b: /gdscore rule RankingList false");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u529f\u80fd\u8bf4\u660e").method_27692(class_124.field_1068));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u63a7\u5236\u670d\u52a1\u5668\u6392\u884c\u699c\u7684\u663e\u793a\u72b6\u6001").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u5173\u95ed\u540e\u73a9\u5bb6\u65e0\u6cd5\u67e5\u770b/top\u6392\u884c\u699c").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u4e0d\u5f71\u54cd\u5b9e\u9645\u5206\u6570\u8ba1\u7b97").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u4f7f\u7528\u573a\u666f").method_27692(class_124.field_1068));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u73a9\u5bb6\u8fc7\u591a\u907f\u514d\u8fc7\u591a\u8bbf\u95ee\u9020\u6210\u670d\u52a1\u5668\u5e26\u5bbd\u4e0d\u8db3").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore rule CardComboKillDurationTime < x >", "\u4fee\u6539\u5361\u724c\u8fde\u6740\u663e\u793a\u5224\u5b9a\u65f6\u95f4", "\u6743\u9650\u7b49\u7ea7: 3", "\u793a\u4f8b: /gdscore rule CardComboKillDurationTime 60\uff0860\u79d2\uff09");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u529f\u80fd\u8bf4\u660e").method_27692(class_124.field_1068));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u9ed8\u8ba4\u503c\u4e3a60\u79d2\u5373\u4e00\u5206\u949f").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u5168\u670d\u73a9\u5bb6\u7edf\u4e00").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u4e0d\u5f71\u54cd\u5b9e\u9645\u5206\u6570\u8ba1\u7b97").method_27692(class_124.field_1080));
    }

    private void addScoreManagementCommands(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u5206\u6570\u7ba1\u7406\u547d\u4ee4").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore add <\u73a9\u5bb6> <\u5206\u6570>", "\u7ed9\u6307\u5b9a\u73a9\u5bb6\u589e\u52a0\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore add Steve 100");
        this.addCommandEntry(content, "/gdscore reduce <\u73a9\u5bb6> <\u5206\u6570>", "\u7ed9\u6307\u5b9a\u73a9\u5bb6\u51cf\u5c11\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore reduce Steve 50");
        this.addCommandEntry(content, "/gdscore set <\u73a9\u5bb6> <\u5206\u6570>", "\u8bbe\u7f6e\u6307\u5b9a\u73a9\u5bb6\u7684\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore set Steve 1000");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u6ce8\u610f: \u8fd9\u4e9b\u547d\u4ee4\u9700\u8981\u64cd\u4f5c\u5458\u6743\u9650").method_27692(class_124.field_1061));
    }

    private void addScoreboardCommands(List<class_2561> content) {
        content.add((class_2561)class_2561.method_43470((String)"\u8ba1\u5206\u677f\u96c6\u6210").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        this.addCommandEntry(content, "/gdscore scoreboard binding <\u8ba1\u5206\u677fID> <\u663e\u793a\u540d\u79f0>", "\u5c06\u6a21\u7ec4\u5206\u6570\u7ed1\u5b9a\u5230\u539f\u7248\u8ba1\u5206\u677f", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore scoreboard binding killpoints \u51fb\u6740\u5206\u6570");
        this.addCommandEntry(content, "/gdscore scoreboard unbind", "\u89e3\u9664\u8ba1\u5206\u677f\u7ed1\u5b9a", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore scoreboard unbind");
        content.add((class_2561)class_2561.method_43470((String)""));
        content.add((class_2561)class_2561.method_43470((String)"\u529f\u80fd\u8bf4\u660e").method_27692(class_124.field_1068));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u81ea\u52a8\u540c\u6b65\u73a9\u5bb6\u5206\u6570\u5230\u539f\u7248\u8ba1\u5206\u677f").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u652f\u6301\u8ba1\u5206\u677f\u663e\u793a\u540d\u79f0\u81ea\u5b9a\u4e49").method_27692(class_124.field_1080));
        content.add((class_2561)class_2561.method_43470((String)"\u2022 \u5b9e\u65f6\u66f4\u65b0\u5206\u6570\u53d8\u5316").method_27692(class_124.field_1080));
    }

    private void addVariableEntry(List<class_2561> content, String variable, String description) {
        content.add((class_2561)class_2561.method_43470((String)("  " + variable)).method_27692(class_124.field_1060));
        content.add((class_2561)class_2561.method_43470((String)("    - " + description)).method_27692(class_124.field_1080));
    }

    private List<class_2561> generateCategoryContent(HelpCategory category) {
        ArrayList<class_2561> content = new ArrayList<class_2561>();
        content.add((class_2561)class_2561.method_43470((String)(category.displayName + "\u6307\u5357")).method_27695(new class_124[]{category.color, class_124.field_1067}));
        content.add((class_2561)class_2561.method_43470((String)""));
        switch (category.ordinal()) {
            case 1: {
                this.addBasicCommands(content);
                break;
            }
            case 5: {
                this.addScoreManagementCommands(content);
                break;
            }
            case 3: {
                this.addEntityManagementCommands(content);
                break;
            }
            case 2: {
                this.addBonusSystemContent(content);
                break;
            }
            case 6: {
                this.addScoreboardCommands(content);
                break;
            }
            case 4: {
                this.addRuleCommands(content);
                break;
            }
            case 0: {
                this.addAdvancedFeatures(content);
                break;
            }
            default: {
                content.add((class_2561)class_2561.method_43470((String)"\u6b64\u5206\u7c7b\u5185\u5bb9\u6b63\u5728\u5f00\u53d1\u4e2d...").method_27692(class_124.field_1054));
            }
        }
        return content;
    }

    private void initBackButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(this.field_22789 - 80 - 15, 15, 80, 20).method_46431());
    }

    private void initCategoryButtons() {
        this.categoryButtons = new ArrayList<CategoryButton>();
        int startY = 80;
        for (HelpCategory category : HelpCategory.values()) {
            this.categoryButtons.add(new CategoryButton(15, startY, 120, 25, category));
            startY += 30;
        }
    }

    private void initContentArea() {
        int contentX = 150;
        int contentY = 80;
        int contentWidth = this.field_22789 - contentX - 15;
        int contentHeight = this.field_22790 - contentY - 50;
        this.contentArea = new HelpContentArea(contentX, contentY, contentWidth, contentHeight);
    }

    private void initSearchBox() {
        int searchWidth = this.field_22789 - 120 - 45;
        this.searchBox = new class_342(this.field_22793, 150, 40, searchWidth, 30, (class_2561)class_2561.method_43470((String)"\u641c\u7d22\u547d\u4ee4\u6216\u529f\u80fd..."));
        this.searchBox.method_1880(50);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
    }

    private void onSearchTextChanged(String searchText) {
        if (searchText.isEmpty()) {
            this.updateContent();
        } else {
            this.performSearch(searchText);
        }
    }

    private void performSearch(String searchText) {
        ArrayList<class_2561> searchResults = new ArrayList<class_2561>();
        String lowerSearch = searchText.toLowerCase();
        for (HelpCategory category : HelpCategory.values()) {
            for (class_2561 line : this.generateCategoryContent(category)) {
                if (!line.getString().toLowerCase().contains(lowerSearch)) continue;
                if (searchResults.isEmpty()) {
                    searchResults.add((class_2561)class_2561.method_43470((String)("\u641c\u7d22\u7ed3\u679c: \"" + searchText + "\"")).method_27692(class_124.field_1065));
                    searchResults.add((class_2561)class_2561.method_43470((String)""));
                }
                searchResults.add(line);
            }
        }
        if (searchResults.isEmpty()) {
            searchResults.add((class_2561)class_2561.method_43470((String)("\u672a\u627e\u5230\u5305\u542b \"" + searchText + "\" \u7684\u5185\u5bb9")).method_27692(class_124.field_1061));
            searchResults.add((class_2561)class_2561.method_43470((String)"\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u5173\u952e\u8bcd").method_27692(class_124.field_1080));
        }
        this.contentArea.setContent(searchResults);
    }

    private void renderCategoryButtons(class_332 guiGraphics, int mouseX, int mouseY) {
        for (CategoryButton button : this.categoryButtons) {
            button.render(guiGraphics, mouseX, mouseY, button.category == this.currentCategory);
        }
    }

    private void updateContent() {
        this.contentArea.setContent(this.generateCategoryContent(this.currentCategory));
    }

    private static enum HelpCategory {
        ADVANCED("\u9ad8\u7ea7\u529f\u80fd", class_124.field_1064),
        BASIC("\u57fa\u7840\u6307\u4ee4", class_124.field_1061),
        BONUS_SYSTEM("\u52a0\u5206\u7cfb\u7edf", class_124.field_1060),
        ENTITY_MANAGEMENT("\u5b9e\u4f53\u7ba1\u7406", class_124.field_1054),
        RULE("\u89c4\u5219\u8bbe\u7f6e", class_124.field_1078),
        SCORE_MANAGEMENT("\u5206\u6570\u7ba1\u7406", class_124.field_1065),
        SCOREBOARD("\u8ba1\u5206\u677f", class_124.field_1062);

        public final String displayName;
        public final class_124 color;

        private HelpCategory(String displayName, class_124 color) {
            this.displayName = displayName;
            this.color = color;
        }
    }

    private class HelpContentArea {
        private final int height;
        private final int width;
        private final int x;
        private final int y;
        private List<class_2561> content;
        private boolean isScrolling;
        private double maxScroll;
        private double scrollOffset;

        public HelpContentArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.content = new ArrayList<class_2561>();
            this.scrollOffset = 0.0;
            this.maxScroll = 0.0;
        }

        private void calculateMaxScroll() {
            int n = this.content.size();
            Objects.requireNonNull(HelpScreen.this.field_22793);
            int totalHeight = n * (9 + 2) + 20;
            this.maxScroll = Math.max(0, totalHeight - this.height);
        }

        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public boolean handleMouseClick(double mouseX) {
            int scrollBarX = this.x + this.width - 8;
            if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 8)) {
                this.isScrolling = true;
                return true;
            }
            return false;
        }

        public boolean handleMouseDrag(double deltaY) {
            if (this.isScrolling) {
                double dragRatio = deltaY / (double)(this.height - 20);
                this.scroll(dragRatio * this.maxScroll * 2.0);
                return true;
            }
            return false;
        }

        public void handleMouseRelease() {
            this.isScrolling = false;
        }

        public void render(class_332 guiGraphics) {
            guiGraphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            guiGraphics.method_49601(this.x, this.y, this.width, this.height, -12566464);
            guiGraphics.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
            int textY = this.y + 10 - (int)this.scrollOffset;
            for (class_2561 line : this.content) {
                Objects.requireNonNull(HelpScreen.this.field_22793);
                if (textY + 9 >= this.y && textY <= this.y + this.height) {
                    guiGraphics.method_51439(HelpScreen.this.field_22793, line, this.x + 10, textY, 0xFFFFFF, false);
                }
                Objects.requireNonNull(HelpScreen.this.field_22793);
                textY += 9 + 2;
            }
            guiGraphics.method_44380();
            if (this.maxScroll > 0.0) {
                this.renderScrollBar(guiGraphics);
            }
        }

        private void renderScrollBar(class_332 guiGraphics) {
            int scrollBarWidth = 6;
            int scrollBarX = this.x + this.width - scrollBarWidth - 2;
            double visibleRatio = (double)this.height / ((double)this.height + this.maxScroll);
            int scrollBarHeight = Math.max(20, Math.min((int)((double)this.height * visibleRatio), this.height - 4));
            int scrollBarY = this.y + 2 + (int)((double)(this.height - 4 - scrollBarHeight) * (this.scrollOffset / this.maxScroll));
            guiGraphics.method_25294(scrollBarX, this.y + 1, scrollBarX + scrollBarWidth, this.y + this.height - 1, -2143272896);
            guiGraphics.method_25294(scrollBarX, scrollBarY, scrollBarX + scrollBarWidth, scrollBarY + scrollBarHeight, -8355712);
            guiGraphics.method_49601(scrollBarX, scrollBarY, scrollBarWidth, scrollBarHeight, -4144960);
        }

        public void scroll(double delta) {
            this.scrollOffset = Math.max(0.0, Math.min(this.scrollOffset - delta * 10.0, this.maxScroll));
        }

        public void setContent(List<class_2561> content) {
            this.content = content;
            this.scrollOffset = 0.0;
            this.calculateMaxScroll();
        }
    }

    private class CategoryButton {
        public final HelpCategory category;
        public final int height;
        public final int width;
        public final int x;
        public final int y;

        public CategoryButton(int x, int y, int width, int height, HelpCategory category) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.category = category;
        }

        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public void render(class_332 guiGraphics, int mouseX, int mouseY, boolean isSelected) {
            int fillColor = isSelected ? -12566464 : (this.contains(mouseX, mouseY) ? -13619152 : -14671840);
            int borderColor = isSelected ? -1 : -8355712;
            guiGraphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
            guiGraphics.method_49601(this.x, this.y, this.width, this.height, borderColor);
            int textColor = isSelected ? (this.category.color.method_532() == null ? 0xFFFFFF : this.category.color.method_532()) : 0xFFFFFF;
            guiGraphics.method_25300(HelpScreen.this.field_22793, this.category.displayName, this.x + this.width / 2, this.y + (this.height - 8) / 2, textColor);
        }
    }
}

