/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.iconrenderer.ComboIconRenderer;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    public void loadResources() {
        this.loadIconResources();
        this.loadCardResources();
        KillIconRenderer.currentIconStyle = Config.iconStyle;
        KillIconRenderer.currentCardIconStyle = Config.cardIconStyle;
    }

    @NotNull
    public static String getString(String reason) {
        return switch (reason) {
            case "\u9020\u6210\u4f24\u5bb3" -> "\u9020\u6210\u4f24\u5bb3 +";
            case "\u8fdc\u8ddd\u79bb\u51fb\u8d25" -> "\u8fdc\u8ddd\u79bb\u51fb\u8d25 +";
            case "\u52a9\u653b\u51fb\u8d25" -> "\u52a9\u653b\u51fb\u8d25 +";
            case "\u66b4\u51fb\u52a0\u6210" -> "\u66b4\u51fb\u52a0\u6210 +";
            case "\u9b54\u6cd5\u4f24\u5bb3" -> "\u9b54\u6cd5\u4f24\u5bb3 +";
            case "\u7a7a\u624b\u653b\u51fb" -> "\u7a7a\u624b\u653b\u51fb +";
            case "\u51fb\u8d25\u751f\u7269" -> "\u51fb\u8d25\u751f\u7269 +";
            default -> "";
        };
    }

    public static boolean isElementVisible(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconVisible;
                case Config.IconMode.COMBO -> Config.comboIconVisible;
                case Config.IconMode.CARD -> Config.cardIconVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleVisible;
                case Config.IconMode.COMBO -> Config.comboSubtitleVisible;
                case Config.IconMode.CARD -> Config.cardSubtitleVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreVisible;
                case Config.IconMode.COMBO -> Config.comboScoreVisible;
                case Config.IconMode.CARD -> Config.cardScoreVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusVisible;
                case Config.IconMode.COMBO -> Config.comboBonusVisible;
                case Config.IconMode.CARD -> Config.cardBonusVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BOTTOMBAR) {
            return Config.iconMode == Config.IconMode.CARD && Config.cardBottombarVisible;
        }
        return true;
    }

    public static int getElementSize(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconSize;
                case Config.IconMode.COMBO -> Config.comboIconSize;
                case Config.IconMode.CARD -> Config.cardIconSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleSize;
                case Config.IconMode.COMBO -> Config.comboSubtitleSize;
                case Config.IconMode.CARD -> Config.cardSubtitleSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreSize;
                case Config.IconMode.COMBO -> Config.comboScoreSize;
                case Config.IconMode.CARD -> Config.cardScoreSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusSize;
                case Config.IconMode.COMBO -> Config.comboBonusSize;
                case Config.IconMode.CARD -> Config.cardBonusSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BOTTOMBAR) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING, Config.IconMode.COMBO -> 100;
                case Config.IconMode.CARD -> Config.cardBottombarSize;
            };
        }
        return 100;
    }

    private void loadIconResources() {
        if (KillIconRenderer.scrollingRenderer != null) {
            KillIconRenderer.scrollingRenderer.loadResources();
        }
        if (KillIconRenderer.comboRenderer != null) {
            ComboIconRenderer.loadResources();
        }
    }

    private void loadCardResources() {
        String cardStylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        KillIconRenderer.currentCardIcons = new ResourceLocation[5];
        for (int i = 0; i < 5; ++i) {
            String cardFileName = i < 4 ? "killcard_" + (i + 1) + ".png" : "killcard_ace.png";
            KillIconRenderer.currentCardIcons[i] = new ResourceLocation("gd656killicon", "textures/gui/" + cardStylePath + "/cardmode/" + cardFileName);
        }
    }

    public static class PositionConfig {
        public int bonusX;
        public int bonusY;
        public int iconX;
        public int iconY;
        public int scoreX;
        public int scoreY;
        public int subtitleX;
        public int subtitleY;
    }
}

