/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class BanListData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_banlist";
    private final Set<String> bannedEntities = new HashSet<String>();

    public BanListData() {
    }

    public BanListData(CompoundTag nbt) {
        ListTag banList = nbt.m_128437_("bannedEntities", 8);
        for (int i = 0; i < banList.size(); ++i) {
            this.bannedEntities.add(banList.m_128778_(i));
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag banList = new ListTag();
        for (String entityId : this.bannedEntities) {
            banList.add((Object)StringTag.m_129297_((String)entityId));
        }
        compound.m_128365_("bannedEntities", (Tag)banList);
        return compound;
    }

    public static BanListData get() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return new BanListData();
        }
        ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (overworld == null) {
            return new BanListData();
        }
        return (BanListData)overworld.m_8895_().m_164861_(new SavedData.Factory(BanListData::new, BanListData::new, null), DATA_NAME);
    }

    public boolean isBanned(String entityId) {
        return this.bannedEntities.contains(entityId) || this.bannedEntities.contains("all");
    }

    public void banEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        }
        this.bannedEntities.add(entityId);
        this.m_77762_();
    }

    public void unbanEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        } else {
            this.bannedEntities.remove(entityId);
        }
        this.m_77762_();
    }

    public Set<String> getBannedEntities() {
        return new HashSet<String>(this.bannedEntities);
    }

    public void clearAll() {
        this.bannedEntities.clear();
        this.m_77762_();
    }
}

