/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.data.ScoreboardBindingData;

public class ScoreData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_scores";
    private boolean rankingListEnabled = true;
    private final ConcurrentHashMap<UUID, Integer> playerScores = new ConcurrentHashMap();
    private int cardComboKillDurationTime = 60;

    public ScoreData() {
    }

    public ScoreData(CompoundTag nbt) {
        ListTag scoreList = nbt.m_128437_("scores", 10);
        for (int i = 0; i < scoreList.size(); ++i) {
            CompoundTag scoreTag = scoreList.m_128728_(i);
            UUID playerId = scoreTag.m_128342_("playerId");
            int score = scoreTag.m_128451_("score");
            this.playerScores.put(playerId, score);
        }
        this.rankingListEnabled = nbt.m_128471_("rankingListEnabled");
        this.cardComboKillDurationTime = nbt.m_128451_("cardComboKillDurationTime");
        if (this.cardComboKillDurationTime < 0) {
            this.cardComboKillDurationTime = 60;
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag scoreList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            CompoundTag scoreTag = new CompoundTag();
            scoreTag.m_128362_("playerId", entry.getKey());
            scoreTag.m_128405_("score", entry.getValue().intValue());
            scoreList.add((Object)scoreTag);
        }
        compound.m_128365_("scores", (Tag)scoreList);
        compound.m_128379_("rankingListEnabled", this.rankingListEnabled);
        compound.m_128405_("cardComboKillDurationTime", this.cardComboKillDurationTime);
        return compound;
    }

    public static ScoreData get() {
        return (ScoreData)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)).m_8895_().m_164861_(new SavedData.Factory(ScoreData::new, ScoreData::new, null), DATA_NAME);
    }

    public int getScore(UUID playerId) {
        return this.playerScores.getOrDefault(playerId, 0);
    }

    public void addScore(UUID playerId, float points) {
        int roundedPoints = Math.round(points);
        this.playerScores.compute(playerId, (key, current) -> (current == null ? 0 : current) + roundedPoints);
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    public void reduceScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        int roundedPoints = Math.round(points);
        int newScore = Math.max(0, currentScore - roundedPoints);
        this.playerScores.put(playerId, newScore);
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    public void setScore(UUID playerId, int score) {
        int newScore = Math.max(0, score);
        this.playerScores.put(playerId, newScore);
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    private void syncToScoreboard(UUID playerId) {
        ServerPlayer player;
        ServerScoreboard scoreboard;
        Objective objective;
        ScoreboardBindingData bindingData;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (bindingData = ScoreboardBindingData.get()).isBound() && (objective = (scoreboard = server.m_129896_()).m_83477_(bindingData.getObjectiveName())) != null && (player = server.m_6846_().m_11259_(playerId)) != null) {
            int score = this.getScore(playerId);
            ScoreHolder scoreHolder = ScoreHolder.m_306660_((String)player.m_6302_());
            ScoreAccess scoreAccess = scoreboard.m_83471_(scoreHolder, objective);
            scoreAccess.m_305183_(score);
        }
    }

    public boolean getRankingListEnabled() {
        return !this.rankingListEnabled;
    }

    public void setRankingListEnabled(boolean enabled) {
        this.rankingListEnabled = enabled;
        this.m_77762_();
    }

    public int getCardComboKillDurationTime() {
        return this.cardComboKillDurationTime;
    }

    public void setCardComboKillDurationTime(int duration) {
        this.cardComboKillDurationTime = Math.max(0, Math.min(duration, 3600));
        this.m_77762_();
    }

    public Map<UUID, Integer> getAllScores() {
        return new HashMap<UUID, Integer>(this.playerScores);
    }
}

