/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.mods.gd656killicon.client.configmenu.RankingListScreen;

public class RankingDataResponsePacket {
    private final Map<UUID, Integer> rankingData;
    private final boolean rankingEnabled;

    public RankingDataResponsePacket(Map<UUID, Integer> rankingData, boolean rankingEnabled) {
        this.rankingData = rankingData;
        this.rankingEnabled = rankingEnabled;
    }

    public RankingDataResponsePacket(FriendlyByteBuf buf) {
        this.rankingEnabled = buf.readBoolean();
        int size = buf.readInt();
        this.rankingData = new HashMap<UUID, Integer>();
        for (int i = 0; i < size; ++i) {
            this.rankingData.put(buf.m_130259_(), buf.readInt());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.rankingEnabled);
        buf.writeInt(this.rankingData.size());
        this.rankingData.forEach((uuid, score) -> {
            buf.m_130077_(uuid);
            buf.writeInt(score.intValue());
        });
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            RankingListScreen screen = RankingListScreen.getInstance();
            if (screen != null) {
                screen.updateRankingData(this.rankingData, this.rankingEnabled);
            }
        });
        context.setPacketHandled(true);
    }
}

