/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ConfigScreen;
import org.mods.gd656killicon.client.ElementConfigScreen;
import org.mods.gd656killicon.client.MenuManager;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.ScoreRequestPacket;

public class ModConfigScreen
extends Screen {
    private static final long SCORE_UPDATE_INTERVAL = 5000L;
    private final Screen parent;
    private static final int TITLE_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int MENU_BUTTON_SIZE = 20;
    private static final int PADDING = 10;
    private static final int MODE_BUTTON_WIDTH = 60;
    private static final int MODE_BUTTON_HEIGHT = 20;
    private int currentScore = 0;
    private long lastScoreUpdateTime = 0L;
    private boolean isMenuExpanded = false;
    private Button menuButton;
    private final List<CustomButton> customMenuButtons = new ArrayList<CustomButton>();
    private EditMode currentEditMode = EditMode.SCROLL;
    private final List<DraggableElement> draggableElements = new ArrayList<DraggableElement>();
    private DraggableElement selectedElement = null;
    private final Button[] modeButtons = new Button[3];
    private Button resetButton;
    private boolean resetConfirmation = false;
    private long resetConfirmationTime = 0L;
    private static final long RESET_CONFIRMATION_TIMEOUT = 3000L;
    private static final int MAX_UNDO_HISTORY = 10;
    private final List<MoveOperation> undoHistory = new ArrayList<MoveOperation>();
    private Button undoButton;
    private boolean canUndo = false;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"gd656killicon.modconfig.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.requestScoreUpdate();
        this.initializeDraggableElements();
        this.menuButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2261"), button -> this.toggleMenu()).m_252987_(10, 10, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.menuButton);
        this.updateScoreText();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.modconfig.details"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new ConfigScreen(this));
            }
        }).m_252987_(this.f_96543_ - 80 - 10, 10, 80, 20).m_253136_());
        this.initCustomMenuButtons();
        int modeButtonsStartX = this.f_96543_ - 60 - 10;
        int modeButtonsStartY = 40;
        this.modeButtons[0] = Button.m_253074_((Component)Component.m_237113_((String)"\u6eda\u52a8"), button -> this.switchEditMode(EditMode.SCROLL)).m_252987_(modeButtonsStartX, modeButtonsStartY, 60, 20).m_253136_();
        this.modeButtons[1] = Button.m_253074_((Component)Component.m_237113_((String)"\u8fde\u6740"), button -> this.switchEditMode(EditMode.COMBO)).m_252987_(modeButtonsStartX, modeButtonsStartY + 20 + 5, 60, 20).m_253136_();
        this.modeButtons[2] = Button.m_253074_((Component)Component.m_237113_((String)"\u5361\u724c"), button -> this.switchEditMode(EditMode.CARD)).m_252987_(modeButtonsStartX, modeButtonsStartY + 50, 60, 20).m_253136_();
        this.updateModeButtons();
        for (Button button2 : this.modeButtons) {
            this.m_142416_((GuiEventListener)button2);
        }
        int bottomButtonY = this.f_96544_ - 20 - 10;
        int buttonSpacing = 10;
        int totalButtonsWidth = 240 + buttonSpacing * 2;
        int buttonsStartX = this.f_96543_ - totalButtonsWidth - 10;
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.modconfig.reset"), button -> this.handleResetButton()).m_252987_(buttonsStartX, bottomButtonY, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.resetButton);
        this.undoButton = Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.modconfig.undo"), button -> this.handleUndoButton()).m_252987_(buttonsStartX + 80 + buttonSpacing, bottomButtonY, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.undoButton);
        this.updateUndoButtonState();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.modconfig.save"), button -> {
            this.savePositionsToConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(buttonsStartX + (80 + buttonSpacing) * 2, bottomButtonY, 80, 20).m_253136_());
    }

    private void initCustomMenuButtons() {
        this.customMenuButtons.clear();
        int buttonY = 40;
        int buttonHeight = 20;
        int buttonWidth = buttonHeight * 5;
        String[] buttonLabels = new String[]{"\u6392\u884c\u699c", "\u5386\u53f2\u8bb0\u5f55", "\u8bbe\u7f6e", "\u5e2e\u52a9", "\u5173\u4e8e", "\u53cd\u9988"};
        for (int i = 0; i < buttonLabels.length; ++i) {
            int currentY = buttonY + i * buttonHeight;
            int finalI = i;
            CustomButton button = new CustomButton(buttonLabels[i], 10, currentY, buttonWidth, buttonHeight, () -> this.handleCustomMenuButtonClick(buttonLabels[finalI]));
            this.customMenuButtons.add(button);
        }
    }

    private void handleCustomMenuButtonClick(String buttonLabel) {
        MenuManager menuManager = MenuManager.getInstance();
        switch (buttonLabel) {
            case "\u6392\u884c\u699c": {
                menuManager.openRankingList(this);
                break;
            }
            case "\u5386\u53f2\u8bb0\u5f55": {
                menuManager.openHistoryRecord(this);
                break;
            }
            case "\u8bbe\u7f6e": {
                menuManager.openMoreSettings(this);
                break;
            }
            case "\u5e2e\u52a9": {
                menuManager.openHelp(this);
                break;
            }
            case "\u5173\u4e8e": {
                menuManager.openAbout(this);
                break;
            }
            case "\u53cd\u9988": {
                menuManager.openFeedback(this);
            }
        }
        this.toggleMenu();
    }

    private void updateModeButtons() {
        for (int i = 0; i < this.modeButtons.length; ++i) {
            Button button = this.modeButtons[i];
            EditMode buttonMode = this.getEditModeForIndex(i);
            if (buttonMode == this.currentEditMode) {
                button.setFGColor(-256);
                continue;
            }
            button.setFGColor(-1);
        }
    }

    private void toggleMenu() {
        boolean bl = this.isMenuExpanded = !this.isMenuExpanded;
        if (this.isMenuExpanded) {
            this.menuButton.m_93666_((Component)Component.m_237113_((String)"<"));
        } else {
            this.menuButton.m_93666_((Component)Component.m_237113_((String)"\u2261"));
        }
    }

    private void updateScoreText() {
        Component.m_237113_((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u4e0a\u7684\u5206\u6570: ").m_6881_().m_7220_((Component)Component.m_237113_((String)String.valueOf(this.currentScore)).m_130938_(style -> style.m_178520_(-65536).m_131136_(Boolean.valueOf(true))));
    }

    private void requestScoreUpdate() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            NetworkHandler.sendToServer(new ScoreRequestPacket());
            this.lastScoreUpdateTime = System.currentTimeMillis();
        }
    }

    private EditMode getEditModeForIndex(int index) {
        return switch (index) {
            case 1 -> EditMode.COMBO;
            case 2 -> EditMode.CARD;
            default -> EditMode.SCROLL;
        };
    }

    public void updateCurrentScore(int score) {
        this.currentScore = score;
    }

    private void initializeDraggableElements() {
        this.draggableElements.clear();
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        int iconWidth = (int)((float)iconBaseWidth * iconScale);
        int iconHeight = (int)((float)iconBaseHeight * iconScale);
        int subtitleWidth = (int)((float)subtitleBaseWidth * subtitleScale);
        int subtitleHeight = (int)((float)subtitleBaseHeight * subtitleScale);
        int scoreWidth = (int)((float)scoreBaseWidth * scoreScale);
        int scoreHeight = (int)((float)scoreBaseHeight * scoreScale);
        int bonusWidth = (int)((float)bonusBaseWidth * bonusScale);
        int bonusHeight = (int)((float)bonusBaseHeight * bonusScale);
        this.draggableElements.add(new DraggableElement("\u51fb\u6740\u56fe\u6807", ElementType.ICON, this.getCurrentPosition(ElementType.ICON, true), this.getCurrentPosition(ElementType.ICON, false), iconWidth, iconHeight, true));
        this.draggableElements.add(new DraggableElement("\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55", ElementType.SUBTITLE, this.getCurrentPosition(ElementType.SUBTITLE, true), this.getCurrentPosition(ElementType.SUBTITLE, false), subtitleWidth, subtitleHeight, true));
        this.draggableElements.add(new DraggableElement("\u5206\u6570\u5b57\u5e55", ElementType.SCORE, this.getCurrentPosition(ElementType.SCORE, true), this.getCurrentPosition(ElementType.SCORE, false), scoreWidth, scoreHeight, true));
        this.draggableElements.add(new DraggableElement("\u52a0\u5206\u9879\u5b57\u5e55", ElementType.BONUS, this.getCurrentPosition(ElementType.BONUS, true), this.getCurrentPosition(ElementType.BONUS, false), bonusWidth, bonusHeight, true));
        switch (Config.iconMode) {
            case SCROLLING: {
                this.currentEditMode = EditMode.SCROLL;
                break;
            }
            case COMBO: {
                this.currentEditMode = EditMode.COMBO;
                break;
            }
            case CARD: {
                this.currentEditMode = EditMode.CARD;
            }
        }
        this.loadPositionsFromConfig();
    }

    private int getCurrentPosition(ElementType type, boolean isX) {
        return switch (this.currentEditMode) {
            default -> throw new IncompatibleClassChangeError();
            case EditMode.SCROLL -> this.getScrollPosition(type, isX);
            case EditMode.COMBO -> this.getComboPosition(type, isX);
            case EditMode.CARD -> this.getCardPosition(type, isX);
        };
    }

    void updateElementSizes() {
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        for (DraggableElement element : this.draggableElements) {
            switch (element.type) {
                case ICON: {
                    element.width = (int)((float)iconBaseWidth * iconScale);
                    element.height = (int)((float)iconBaseHeight * iconScale);
                    break;
                }
                case SUBTITLE: {
                    element.width = (int)((float)subtitleBaseWidth * subtitleScale);
                    element.height = (int)((float)subtitleBaseHeight * subtitleScale);
                    break;
                }
                case SCORE: {
                    element.width = (int)((float)scoreBaseWidth * scoreScale);
                    element.height = (int)((float)scoreBaseHeight * scoreScale);
                    break;
                }
                case BONUS: {
                    element.width = (int)((float)bonusBaseWidth * bonusScale);
                    element.height = (int)((float)bonusBaseHeight * bonusScale);
                }
            }
        }
    }

    private void handleResetButton() {
        if (this.resetConfirmation) {
            Config.resetAllToDefaults();
            this.clearUndoHistory();
            this.initializeDraggableElements();
            this.resetConfirmation = false;
            this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.modconfig.reset"));
        } else {
            this.resetConfirmation = true;
            this.resetConfirmationTime = System.currentTimeMillis();
            this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.modconfig.reset_confirm"));
        }
    }

    private void switchEditMode(EditMode newMode) {
        if (this.currentEditMode != newMode) {
            this.savePositionsToConfig();
            this.currentEditMode = newMode;
            this.loadPositionsFromConfig();
            this.clearUndoHistory();
            switch (newMode) {
                case SCROLL: {
                    Config.ICON_MODE.set((Object)Config.IconMode.SCROLLING);
                    break;
                }
                case COMBO: {
                    Config.ICON_MODE.set((Object)Config.IconMode.COMBO);
                    break;
                }
                case CARD: {
                    Config.ICON_MODE.set((Object)Config.IconMode.CARD);
                }
            }
            Config.SPEC.save();
            Config.loadConfig();
        }
        boolean isCardMode = newMode == EditMode.CARD;
        for (DraggableElement element : this.draggableElements) {
            if (element.type == ElementType.ICON) continue;
            element.visibleInGame = !isCardMode;
        }
        this.updateElementSizes();
        this.updateModeButtons();
    }

    private void loadPositionsFromConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode) {
                case SCROLL: {
                    element.x = this.getScrollPosition(element.type, true);
                    element.y = this.getScrollPosition(element.type, false);
                    break;
                }
                case COMBO: {
                    element.x = this.getComboPosition(element.type, true);
                    element.y = this.getComboPosition(element.type, false);
                    break;
                }
                case CARD: {
                    element.x = this.getCardPosition(element.type, true);
                    element.y = this.getCardPosition(element.type, false);
                }
            }
        }
    }

    private void savePositionsToConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode) {
                case SCROLL: {
                    this.setScrollPosition(element.type, element.x, element.y);
                    break;
                }
                case COMBO: {
                    this.setComboPosition(element.type, element.x, element.y);
                    break;
                }
                case CARD: {
                    this.setCardPosition(element.type, element.x, element.y);
                }
            }
        }
        Config.SPEC.save();
        Config.loadConfig();
    }

    private int getScrollPosition(ElementType type, boolean isX) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.ICON -> {
                if (isX) {
                    yield Config.scrollIconX;
                }
                yield Config.scrollIconY;
            }
            case ElementType.SUBTITLE -> {
                if (isX) {
                    yield Config.scrollSubtitleX;
                }
                yield Config.scrollSubtitleY;
            }
            case ElementType.SCORE -> {
                if (isX) {
                    yield Config.scrollScoreX;
                }
                yield Config.scrollScoreY;
            }
            case ElementType.BONUS -> isX ? Config.scrollBonusX : Config.scrollBonusY;
        };
    }

    private int getComboPosition(ElementType type, boolean isX) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.ICON -> {
                if (isX) {
                    yield Config.comboIconX;
                }
                yield Config.comboIconY;
            }
            case ElementType.SUBTITLE -> {
                if (isX) {
                    yield Config.comboSubtitleX;
                }
                yield Config.comboSubtitleY;
            }
            case ElementType.SCORE -> {
                if (isX) {
                    yield Config.comboScoreX;
                }
                yield Config.comboScoreY;
            }
            case ElementType.BONUS -> isX ? Config.comboBonusX : Config.comboBonusY;
        };
    }

    private int getCardPosition(ElementType type, boolean isX) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.ICON -> {
                if (isX) {
                    yield Config.cardIconX;
                }
                yield Config.cardIconY;
            }
            case ElementType.SUBTITLE -> {
                if (isX) {
                    yield Config.cardSubtitleX;
                }
                yield Config.cardSubtitleY;
            }
            case ElementType.SCORE -> {
                if (isX) {
                    yield Config.cardScoreX;
                }
                yield Config.cardScoreY;
            }
            case ElementType.BONUS -> isX ? Config.cardBonusX : Config.cardBonusY;
        };
    }

    private void setScrollPosition(ElementType type, int x, int y) {
        switch (type) {
            case ICON: {
                Config.SCROLL_ICON_X.set((Object)x);
                Config.SCROLL_ICON_Y.set((Object)y);
                break;
            }
            case SUBTITLE: {
                Config.SCROLL_SUBTITLE_X.set((Object)x);
                Config.SCROLL_SUBTITLE_Y.set((Object)y);
                break;
            }
            case SCORE: {
                Config.SCROLL_SCORE_X.set((Object)x);
                Config.SCROLL_SCORE_Y.set((Object)y);
                break;
            }
            case BONUS: {
                Config.SCROLL_BONUS_X.set((Object)x);
                Config.SCROLL_BONUS_Y.set((Object)y);
            }
        }
    }

    private void setComboPosition(ElementType type, int x, int y) {
        switch (type) {
            case ICON: {
                Config.COMBO_ICON_X.set((Object)x);
                Config.COMBO_ICON_Y.set((Object)y);
                break;
            }
            case SUBTITLE: {
                Config.COMBO_SUBTITLE_X.set((Object)x);
                Config.COMBO_SUBTITLE_Y.set((Object)y);
                break;
            }
            case SCORE: {
                Config.COMBO_SCORE_X.set((Object)x);
                Config.COMBO_SCORE_Y.set((Object)y);
                break;
            }
            case BONUS: {
                Config.COMBO_BONUS_X.set((Object)x);
                Config.COMBO_BONUS_Y.set((Object)y);
            }
        }
    }

    private void setCardPosition(ElementType type, int x, int y) {
        switch (type) {
            case ICON: {
                Config.CARD_ICON_X.set((Object)x);
                Config.CARD_ICON_Y.set((Object)y);
                break;
            }
            case SUBTITLE: {
                Config.CARD_SUBTITLE_X.set((Object)x);
                Config.CARD_SUBTITLE_Y.set((Object)y);
                break;
            }
            case SCORE: {
                Config.CARD_SCORE_X.set((Object)x);
                Config.CARD_SCORE_Y.set((Object)y);
                break;
            }
            case BONUS: {
                Config.CARD_BONUS_X.set((Object)x);
                Config.CARD_BONUS_Y.set((Object)y);
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (System.currentTimeMillis() - this.lastScoreUpdateTime > 5000L) {
            this.requestScoreUpdate();
        }
        if (this.resetConfirmation && System.currentTimeMillis() - this.resetConfirmationTime > 3000L) {
            this.resetConfirmation = false;
            this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.modconfig.reset"));
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        String modeText = "\u5f53\u524d\u6a21\u5f0f: " + this.currentEditMode.displayName;
        guiGraphics.m_280056_(this.f_96547_, modeText, this.f_96543_ / 2 - this.f_96547_.m_92895_(modeText) / 2, 40, this.currentEditMode.color, true);
        MutableComponent label = Component.m_237113_((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u7684\u603b\u5206\u6570: ").m_130938_(style -> style.m_178520_(-1));
        String scoreText = String.valueOf(this.currentScore);
        int labelX = 40;
        int scoreX = labelX + this.f_96547_.m_92852_((FormattedText)label) + 5;
        guiGraphics.m_280614_(this.f_96547_, (Component)label, labelX, 16, -1, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)scoreText).m_130938_(style -> style.m_178520_(-65536).m_131136_(Boolean.valueOf(true))), scoreX, 16, -65536, false);
        if (this.isMenuExpanded) {
            this.renderCustomButtons(guiGraphics, mouseX, mouseY);
        }
        this.renderDraggableElements(guiGraphics, mouseX, mouseY);
        String versionText = "v1.0.0 \u516c\u6d4b\u7248RC2";
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280056_(this.f_96547_, versionText, 10, this.f_96544_ - 9 - 10, 0x888888, true);
        String instruction = "\u5de6\u952e\u62d6\u52a8\u8c03\u6574\u4f4d\u7f6e | \u53f3\u952e\u70b9\u51fb\u914d\u7f6e\u5143\u7d20";
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280056_(this.f_96547_, instruction, 10, this.f_96544_ - 9 * 2 - 10 - 5, 0xCCCCCC, true);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderCustomButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (CustomButton button : this.customMenuButtons) {
            button.render(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderDraggableElements(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (DraggableElement element : this.draggableElements) {
            int drawX = this.f_96543_ / 2 + element.x - element.width / 2;
            int drawY = this.f_96544_ + element.y - element.height / 2;
            int borderColor = this.currentEditMode.color;
            int fillColor = borderColor & 0xFFFFFF | Integer.MIN_VALUE;
            boolean isVisible = this.getElementVisible(element.type);
            if (!isVisible) {
                fillColor = borderColor & 0xFFFFFF | 0x40000000;
            }
            guiGraphics.m_280509_(drawX, drawY, drawX + element.width, drawY + element.height, fillColor);
            guiGraphics.m_280637_(drawX, drawY, element.width, element.height, borderColor);
            String nameText = element.name;
            String coordText = "(" + element.x + ", " + element.y + ")";
            int nameWidth = this.f_96547_.m_92895_(nameText);
            int coordWidth = this.f_96547_.m_92895_(coordText);
            Objects.requireNonNull(this.f_96547_);
            int totalTextHeight = 9 * 2 + 5;
            int textStartY = drawY + (element.height - totalTextHeight) / 2;
            guiGraphics.m_280056_(this.f_96547_, nameText, drawX + element.width / 2 - nameWidth / 2, textStartY, -1, true);
            int n = drawX + element.width / 2 - coordWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280056_(this.f_96547_, coordText, n, textStartY + 9 + 5, -1, true);
            this.drawEyeIcon(guiGraphics, drawX, drawY, element.width, isVisible);
            if (element.contains(mouseX, mouseY, this.f_96543_, this.f_96544_)) {
                guiGraphics.m_280637_(drawX - 1, drawY - 1, element.width + 2, element.height + 2, -1);
            }
            if (element == this.selectedElement) {
                guiGraphics.m_280637_(drawX - 2, drawY - 2, element.width + 4, element.height + 4, -256);
            }
            if (!this.isElementOutOfBounds(element, this.f_96543_, this.f_96544_)) continue;
            String warningText = "!";
            int warningWidth = this.f_96547_.m_92895_(warningText);
            guiGraphics.m_280056_(this.f_96547_, warningText, drawX + element.width - warningWidth - 2, drawY + 2, -65536, true);
        }
    }

    private void drawEyeIcon(GuiGraphics guiGraphics, int drawX, int drawY, int elementWidth, boolean isVisible) {
        ResourceLocation eyeIcon = isVisible ? ResourceLocation.withDefaultNamespace((String)"textures/mob_effect/conduit_power.png") : ResourceLocation.withDefaultNamespace((String)"textures/mob_effect/blindness.png");
        try {
            int iconSize = 16;
            int iconX = drawX + elementWidth - iconSize - 3;
            int iconY = drawY + 3;
            guiGraphics.m_280163_(eyeIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Exception e) {
            String eyeText = isVisible ? "\u25cb" : "\u00d7";
            int textWidth = this.f_96547_.m_92895_(eyeText);
            int textX = drawX + elementWidth - textWidth - 3;
            int textY = drawY + 3;
            int textColor = isVisible ? -16711936 : -65536;
            guiGraphics.m_280056_(this.f_96547_, eyeText, textX, textY, textColor, true);
        }
    }

    private boolean getElementVisible(ElementType type) {
        return switch (this.currentEditMode) {
            default -> throw new IncompatibleClassChangeError();
            case EditMode.SCROLL -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.scrollIconVisible;
                    }
                    case SUBTITLE: {
                        yield Config.scrollSubtitleVisible;
                    }
                    case SCORE: {
                        yield Config.scrollScoreVisible;
                    }
                    case BONUS: 
                }
                yield Config.scrollBonusVisible;
            }
            case EditMode.COMBO -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.comboIconVisible;
                    }
                    case SUBTITLE: {
                        yield Config.comboSubtitleVisible;
                    }
                    case SCORE: {
                        yield Config.comboScoreVisible;
                    }
                    case BONUS: 
                }
                yield Config.comboBonusVisible;
            }
            case EditMode.CARD -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.cardIconVisible;
                    }
                    case SUBTITLE: {
                        yield Config.cardSubtitleVisible;
                    }
                    case SCORE: {
                        yield Config.cardScoreVisible;
                    }
                    case BONUS: 
                }
                yield Config.cardBonusVisible;
            }
        };
    }

    private int getElementSize(ElementType type) {
        return switch (this.currentEditMode) {
            default -> throw new IncompatibleClassChangeError();
            case EditMode.SCROLL -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.scrollIconSize;
                    }
                    case SUBTITLE: {
                        yield Config.scrollSubtitleSize;
                    }
                    case SCORE: {
                        yield Config.scrollScoreSize;
                    }
                    case BONUS: 
                }
                yield Config.scrollBonusSize;
            }
            case EditMode.COMBO -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.comboIconSize;
                    }
                    case SUBTITLE: {
                        yield Config.comboSubtitleSize;
                    }
                    case SCORE: {
                        yield Config.comboScoreSize;
                    }
                    case BONUS: 
                }
                yield Config.comboBonusSize;
            }
            case EditMode.CARD -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ICON: {
                        yield Config.cardIconSize;
                    }
                    case SUBTITLE: {
                        yield Config.cardSubtitleSize;
                    }
                    case SCORE: {
                        yield Config.cardScoreSize;
                    }
                    case BONUS: 
                }
                yield Config.cardBonusSize;
            }
        };
    }

    private boolean isElementOutOfBounds(DraggableElement element, int screenWidth, int screenHeight) {
        int drawX = screenWidth / 2 + element.x - element.width / 2;
        int drawY = screenHeight + element.y - element.height / 2;
        return drawX < 0 || drawX + element.width > screenWidth || drawY < 0 || drawY + element.height > screenHeight;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMenuExpanded && button == 0) {
            boolean clickedOnButton = false;
            for (CustomButton customButton : this.customMenuButtons) {
                if (!customButton.contains((int)mouseX, (int)mouseY)) continue;
                customButton.onClick.run();
                clickedOnButton = true;
                break;
            }
            if (!clickedOnButton) {
                boolean clickedMenuButton;
                boolean bl = clickedMenuButton = mouseX >= 10.0 && mouseX <= 30.0 && mouseY >= 10.0 && mouseY <= 30.0;
                if (!clickedMenuButton) {
                    this.toggleMenu();
                    return true;
                }
            }
            if (clickedOnButton) {
                return true;
            }
        }
        if (button == 1) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.f_96543_, this.f_96544_)) continue;
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new ElementConfigScreen(this, element));
                }
                return true;
            }
        }
        if (button == 0) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.f_96543_, this.f_96544_)) continue;
                this.selectedElement = element;
                int oldX = element.x;
                int oldY = element.y;
                element.setDragOffset((int)mouseX, (int)mouseY, this.f_96543_, this.f_96544_);
                this.selectedElement.setUserData(new int[]{oldX, oldY});
                return true;
            }
            this.selectedElement = null;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selectedElement != null && button == 0) {
            this.selectedElement.setPositionFromMouse((int)mouseX, (int)mouseY, this.f_96543_, this.f_96544_);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.selectedElement != null && button == 0) {
            int[] oldPos = (int[])this.selectedElement.getUserData();
            if (oldPos != null) {
                int oldX = oldPos[0];
                int oldY = oldPos[1];
                int newX = this.selectedElement.x;
                int newY = this.selectedElement.y;
                this.recordMoveOperation(this.selectedElement.type, oldX, oldY, newX, newY);
                this.selectedElement.setUserData(null);
            }
            this.savePositionsToConfig();
            this.selectedElement = null;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        this.savePositionsToConfig();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void handleUndoButton() {
        if (this.canUndo && !this.undoHistory.isEmpty()) {
            this.undoLastMove();
        }
    }

    private void undoLastMove() {
        if (this.undoHistory.isEmpty()) {
            return;
        }
        MoveOperation lastOperation = this.undoHistory.remove(this.undoHistory.size() - 1);
        for (DraggableElement element : this.draggableElements) {
            if (element.type != lastOperation.elementType) continue;
            element.x = lastOperation.oldX;
            element.y = lastOperation.oldY;
            break;
        }
        this.savePositionsToConfig();
        this.updateUndoButtonState();
    }

    private void recordMoveOperation(ElementType elementType, int oldX, int oldY, int newX, int newY) {
        if (oldX == newX && oldY == newY) {
            return;
        }
        MoveOperation operation = new MoveOperation(this.currentEditMode, elementType, oldX, oldY, newX, newY);
        this.undoHistory.add(operation);
        if (this.undoHistory.size() > 10) {
            this.undoHistory.remove(0);
        }
        this.updateUndoButtonState();
    }

    private void updateUndoButtonState() {
        boolean bl = this.canUndo = !this.undoHistory.isEmpty();
        if (this.undoButton != null) {
            this.undoButton.f_93623_ = this.canUndo;
            if (this.canUndo) {
                this.undoButton.setFGColor(-1);
            } else {
                this.undoButton.setFGColor(-7829368);
            }
        }
    }

    private void clearUndoHistory() {
        this.undoHistory.clear();
        this.updateUndoButtonState();
    }

    private static enum EditMode {
        SCROLL("\u6eda\u52a8\u6a21\u5f0f", -65536),
        COMBO("\u8fde\u6740\u6a21\u5f0f", -16711936),
        CARD("\u5361\u724c\u6a21\u5f0f", -256);

        public final String displayName;
        public final int color;

        private EditMode(String displayName, int color) {
            this.displayName = displayName;
            this.color = color;
        }
    }

    public static class DraggableElement {
        public final String name;
        public final ElementType type;
        public int x;
        public int y;
        public final int defaultX;
        public final int defaultY;
        public int width;
        public int height;
        public boolean visibleInGame;
        public int dragOffsetX;
        public int dragOffsetY;
        private Object userData;

        public DraggableElement(String name, ElementType type, int defaultX, int defaultY, int width, int height, boolean visibleInGame) {
            this.name = name;
            this.type = type;
            this.x = defaultX;
            this.y = defaultY;
            this.defaultX = defaultX;
            this.defaultY = defaultY;
            this.width = width;
            this.height = height;
            this.visibleInGame = visibleInGame;
        }

        public boolean contains(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            return mouseX >= drawX && mouseX <= drawX + this.width && mouseY >= drawY && mouseY <= drawY + this.height;
        }

        public void setDragOffset(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            this.dragOffsetX = mouseX - drawX;
            this.dragOffsetY = mouseY - drawY;
        }

        public void setPositionFromMouse(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int newX = mouseX - screenWidth / 2 - this.dragOffsetX + this.width / 2;
            int newY = mouseY - screenHeight - this.dragOffsetY + this.height / 2;
            this.x = this.clampToScreenBounds(newX, screenWidth, true);
            this.y = this.clampToScreenBounds(newY, screenHeight, false);
        }

        private int clampToScreenBounds(int coordinate, int screenSize, boolean isX) {
            int margin = 20;
            if (isX) {
                int maxX = screenSize / 2 - this.width / 2 - margin;
                int minX = -screenSize / 2 + this.width / 2 + margin;
                return Mth.m_14045_((int)coordinate, (int)minX, (int)maxX);
            }
            int maxY = -this.height / 2 - margin;
            int minY = -screenSize + this.height / 2 + margin;
            return Mth.m_14045_((int)coordinate, (int)minY, (int)maxY);
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }
    }

    public static class CustomButton {
        public final String label;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final Runnable onClick;
        public boolean isHovered = false;

        public CustomButton(String label, int x, int y, int width, int height, Runnable onClick) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onClick = onClick;
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            this.isHovered = this.contains(mouseX, mouseY);
            int fillColor = this.isHovered ? -12566464 : -16777216;
            int borderColor = -8355712;
            guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
            guiGraphics.m_280637_(this.x, this.y, this.width, this.height, borderColor);
            Minecraft mc = Minecraft.m_91087_();
            int textWidth = mc.f_91062_.m_92895_(this.label);
            int textX = this.x + (this.width - textWidth) / 2;
            Objects.requireNonNull(mc.f_91062_);
            int textY = this.y + (this.height - 9) / 2 + 1;
            guiGraphics.m_280056_(mc.f_91062_, this.label, textX, textY, 0xFFFFFF, true);
        }
    }

    public static enum ElementType {
        ICON,
        SUBTITLE,
        SCORE,
        BONUS;

    }

    public static class MoveOperation {
        public final EditMode editMode;
        public final ElementType elementType;
        public final int oldX;
        public final int oldY;
        public final int newX;
        public final int newY;
        public final long timestamp;

        public MoveOperation(EditMode editMode, ElementType elementType, int oldX, int oldY, int newX, int newY) {
            this.editMode = editMode;
            this.elementType = elementType;
            this.oldX = oldX;
            this.oldY = oldY;
            this.newX = newX;
            this.newY = newY;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

