/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HelpScreen
extends Screen {
    private final Screen parent;
    private static final int CATEGORY_BUTTON_HEIGHT = 25;
    private static final int CATEGORY_BUTTON_WIDTH = 120;
    private static final int CONTENT_MARGIN = 15;
    private static final int SEARCH_HEIGHT = 30;
    private static final int TITLE_HEIGHT = 40;
    private List<CategoryButton> categoryButtons;
    private HelpContentArea contentArea;
    private HelpCategory currentCategory = HelpCategory.BASIC;
    private EditBox searchBox;

    public HelpScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"\u5e2e\u52a9\u4e2d\u5fc3"));
        this.parent = parent;
    }

    private void addAdvancedFeatures(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u9ad8\u7ea7\u529f\u80fd").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u5e2e\u52a9\u7cfb\u7edf").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        this.addCommandEntry(content, "/gdscore help", "\u67e5\u770b\u547d\u4ee4\u5e2e\u52a9", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore help");
        this.addCommandEntry(content, "/gdscore help <\u9875\u7801>", "\u67e5\u770b\u6307\u5b9a\u9875\u7801\u7684\u5e2e\u52a9", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore help 2");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u6743\u9650\u8bf4\u660e").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)"0: \u6240\u6709\u73a9\u5bb6").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"2: \u64cd\u4f5c\u5458/\u7ba1\u7406\u5458").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"3: \u670d\u52a1\u5668\u7ba1\u7406\u5458").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u6a21\u7ec4\u4fe1\u606f").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)"\u2022 \u6a21\u7ec4\u7248\u672c: 1.0.0 \u516c\u6d4b\u7248RC2").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u652f\u6301Minecraft: 1.20.1").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u5f00\u53d1\u8005: Minecraft_GD656").m_130940_(ChatFormatting.GRAY));
    }

    private void addBasicCommands(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u57fa\u7840\u67e5\u8be2\u547d\u4ee4").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore", "\u67e5\u770b\u81ea\u5df1\u7684\u5f53\u524d\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore");
        this.addCommandEntry(content, "/gdscore top", "\u67e5\u770b\u670d\u52a1\u5668\u5206\u6570\u6392\u884c\u699c", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore top");
        this.addCommandEntry(content, "/gdscore get <\u73a9\u5bb6>", "\u67e5\u770b\u6307\u5b9a\u73a9\u5bb6\u7684\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore get Steve");
        this.addCommandEntry(content, "/gdscore cardclear", "\u6e05\u9664\u5f53\u524d\u6240\u6709\u5361\u724c", "\u6743\u9650\u7b49\u7ea7: 0", "\u793a\u4f8b: /gdscore cardclear");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u63d0\u793a: \u6240\u6709\u73a9\u5bb6\u90fd\u53ef\u4ee5\u67e5\u770b\u81ea\u5df1\u7684\u5206\u6570\u548c\u6392\u884c\u699c").m_130940_(ChatFormatting.GRAY));
    }

    private void addBonusSystemContent(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u52a0\u5206\u9879\u7cfb\u7edf").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u7ba1\u7406\u547d\u4ee4").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        this.addCommandEntry(content, "/gdscore bonuspoints list", "\u5217\u51fa\u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f", "\u6743\u9650\u7b49\u7ea7: 2", "");
        this.addCommandEntry(content, "/gdscore bonuspoints reset", "\u91cd\u7f6e\u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u4e3a\u9ed8\u8ba4\u503c", "\u6743\u9650\u7b49\u7ea7: 2", "");
        this.addCommandEntry(content, "/gdscore bonuspoints edit <\u52a0\u5206\u9879> <\u8868\u8fbe\u5f0f>", "\u7f16\u8f91\u52a0\u5206\u9879\u7684\u8868\u8fbe\u5f0f", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore bonuspoints edit kill health * 5");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u53ef\u7528\u53d8\u91cf").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        this.addVariableEntry(content, "health", "\u76ee\u6807\u751f\u547d\u503c");
        this.addVariableEntry(content, "distance", "\u653b\u51fb\u8ddd\u79bb");
        this.addVariableEntry(content, "damage", "\u5355\u6b21\u4f24\u5bb3");
        this.addVariableEntry(content, "damagedealt", "\u603b\u4f24\u5bb3");
        this.addVariableEntry(content, "combo", "\u8fde\u6740\u6570");
        this.addVariableEntry(content, "killscore", "\u51fb\u6740\u57fa\u7840\u5206\u6570");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u8fd0\u7b97\u7b26: +  -  *  /").m_130940_(ChatFormatting.GRAY));
    }

    private void addCommandEntry(List<Component> content, String command, String description, String permission, String example) {
        content.add((Component)Component.m_237113_((String)command).m_130940_(ChatFormatting.AQUA));
        content.add((Component)Component.m_237113_((String)("  " + description)).m_130940_(ChatFormatting.WHITE));
        content.add((Component)Component.m_237113_((String)("  " + permission)).m_130940_(ChatFormatting.DARK_GRAY));
        if (!example.isEmpty()) {
            content.add((Component)Component.m_237113_((String)("  " + example)).m_130940_(ChatFormatting.DARK_GREEN));
        }
        content.add((Component)Component.m_237113_((String)""));
    }

    private void addEntityManagementCommands(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u5b9e\u4f53\u7ba1\u7406\u547d\u4ee4").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore ban <\u5b9e\u4f53ID>", "\u7981\u6b62\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore ban minecraft:zombie");
        this.addCommandEntry(content, "/gdscore allow <\u5b9e\u4f53ID>", "\u5141\u8bb8\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore allow minecraft:skeleton");
        this.addCommandEntry(content, "/gdscore banlist", "\u67e5\u770b\u7981\u6b62\u7206\u51fa\u5206\u6570\u7684\u5b9e\u4f53\u5217\u8868", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore banlist");
        this.addCommandEntry(content, "/gdscore ban all", "\u7981\u6b62\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u7279\u6b8a\u547d\u4ee4");
        this.addCommandEntry(content, "/gdscore allow all", "\u5141\u8bb8\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u7279\u6b8a\u547d\u4ee4");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u5b9e\u4f53ID\u683c\u5f0f: minecraft:\u5b9e\u4f53\u540d\u79f0").m_130940_(ChatFormatting.GRAY));
    }

    private void addRuleCommands(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u89c4\u5219\u8bbe\u7f6e").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore rule RankingList <true/false>", "\u5f00\u542f\u6216\u5173\u95ed\u6392\u884c\u699c\u529f\u80fd", "\u6743\u9650\u7b49\u7ea7: 3", "\u793a\u4f8b: /gdscore rule RankingList false");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u529f\u80fd\u8bf4\u660e").m_130940_(ChatFormatting.WHITE));
        content.add((Component)Component.m_237113_((String)"\u2022 \u63a7\u5236\u670d\u52a1\u5668\u6392\u884c\u699c\u7684\u663e\u793a\u72b6\u6001").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u5173\u95ed\u540e\u73a9\u5bb6\u65e0\u6cd5\u67e5\u770b/top\u6392\u884c\u699c").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u4e0d\u5f71\u54cd\u5b9e\u9645\u5206\u6570\u8ba1\u7b97").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u4f7f\u7528\u573a\u666f").m_130940_(ChatFormatting.WHITE));
        content.add((Component)Component.m_237113_((String)"\u2022 \u73a9\u5bb6\u8fc7\u591a\u907f\u514d\u8fc7\u591a\u8bbf\u95ee\u9020\u6210\u670d\u52a1\u5668\u5e26\u5bbd\u4e0d\u8db3").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore rule CardComboKillDurationTime < x >", "\u4fee\u6539\u5361\u724c\u8fde\u6740\u663e\u793a\u5224\u5b9a\u65f6\u95f4", "\u6743\u9650\u7b49\u7ea7: 3", "\u793a\u4f8b: /gdscore rule CardComboKillDurationTime 60\uff0860\u79d2\uff09");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u529f\u80fd\u8bf4\u660e").m_130940_(ChatFormatting.WHITE));
        content.add((Component)Component.m_237113_((String)"\u2022 \u9ed8\u8ba4\u503c\u4e3a60\u79d2\u5373\u4e00\u5206\u949f").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u5168\u670d\u73a9\u5bb6\u7edf\u4e00").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u4e0d\u5f71\u54cd\u5b9e\u9645\u5206\u6570\u8ba1\u7b97").m_130940_(ChatFormatting.GRAY));
    }

    private void addScoreManagementCommands(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u5206\u6570\u7ba1\u7406\u547d\u4ee4").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore add <\u73a9\u5bb6> <\u5206\u6570>", "\u7ed9\u6307\u5b9a\u73a9\u5bb6\u589e\u52a0\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore add Steve 100");
        this.addCommandEntry(content, "/gdscore reduce <\u73a9\u5bb6> <\u5206\u6570>", "\u7ed9\u6307\u5b9a\u73a9\u5bb6\u51cf\u5c11\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore reduce Steve 50");
        this.addCommandEntry(content, "/gdscore set <\u73a9\u5bb6> <\u5206\u6570>", "\u8bbe\u7f6e\u6307\u5b9a\u73a9\u5bb6\u7684\u5206\u6570", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore set Steve 1000");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u6ce8\u610f: \u8fd9\u4e9b\u547d\u4ee4\u9700\u8981\u64cd\u4f5c\u5458\u6743\u9650").m_130940_(ChatFormatting.RED));
    }

    private void addScoreboardCommands(List<Component> content) {
        content.add((Component)Component.m_237113_((String)"\u8ba1\u5206\u677f\u96c6\u6210").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        this.addCommandEntry(content, "/gdscore scoreboard binding <\u8ba1\u5206\u677fID> <\u663e\u793a\u540d\u79f0>", "\u5c06\u6a21\u7ec4\u5206\u6570\u7ed1\u5b9a\u5230\u539f\u7248\u8ba1\u5206\u677f", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore scoreboard binding killpoints \u51fb\u6740\u5206\u6570");
        this.addCommandEntry(content, "/gdscore scoreboard unbind", "\u89e3\u9664\u8ba1\u5206\u677f\u7ed1\u5b9a", "\u6743\u9650\u7b49\u7ea7: 2", "\u793a\u4f8b: /gdscore scoreboard unbind");
        content.add((Component)Component.m_237113_((String)""));
        content.add((Component)Component.m_237113_((String)"\u529f\u80fd\u8bf4\u660e").m_130940_(ChatFormatting.WHITE));
        content.add((Component)Component.m_237113_((String)"\u2022 \u81ea\u52a8\u540c\u6b65\u73a9\u5bb6\u5206\u6570\u5230\u539f\u7248\u8ba1\u5206\u677f").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u652f\u6301\u8ba1\u5206\u677f\u663e\u793a\u540d\u79f0\u81ea\u5b9a\u4e49").m_130940_(ChatFormatting.GRAY));
        content.add((Component)Component.m_237113_((String)"\u2022 \u5b9e\u65f6\u66f4\u65b0\u5206\u6570\u53d8\u5316").m_130940_(ChatFormatting.GRAY));
    }

    private void addVariableEntry(List<Component> content, String variable, String description) {
        content.add((Component)Component.m_237113_((String)("  " + variable)).m_130940_(ChatFormatting.GREEN));
        content.add((Component)Component.m_237113_((String)("    - " + description)).m_130940_(ChatFormatting.GRAY));
    }

    private List<Component> generateCategoryContent(HelpCategory category) {
        ArrayList<Component> content = new ArrayList<Component>();
        content.add((Component)Component.m_237113_((String)(category.displayName + "\u6307\u5357")).m_130944_(new ChatFormatting[]{category.color, ChatFormatting.BOLD}));
        content.add((Component)Component.m_237113_((String)""));
        switch (category) {
            case BASIC: {
                this.addBasicCommands(content);
                break;
            }
            case SCORE_MANAGEMENT: {
                this.addScoreManagementCommands(content);
                break;
            }
            case ENTITY_MANAGEMENT: {
                this.addEntityManagementCommands(content);
                break;
            }
            case BONUS_SYSTEM: {
                this.addBonusSystemContent(content);
                break;
            }
            case SCOREBOARD: {
                this.addScoreboardCommands(content);
                break;
            }
            case RULE: {
                this.addRuleCommands(content);
                break;
            }
            case ADVANCED: {
                this.addAdvancedFeatures(content);
                break;
            }
            default: {
                content.add((Component)Component.m_237113_((String)"\u6b64\u5206\u7c7b\u5185\u5bb9\u6b63\u5728\u5f00\u53d1\u4e2d...").m_130940_(ChatFormatting.YELLOW));
            }
        }
        return content;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initCategoryButtons();
        this.initSearchBox();
        this.initContentArea();
        this.initBackButton();
        this.updateContent();
    }

    private void initBackButton() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ - 80 - 15, 15, 80, 20).m_253136_());
    }

    private void initCategoryButtons() {
        this.categoryButtons = new ArrayList<CategoryButton>();
        int startY = 80;
        for (HelpCategory category : HelpCategory.values()) {
            CategoryButton button = new CategoryButton(15, startY, 120, 25, category);
            this.categoryButtons.add(button);
            startY += 30;
        }
    }

    private void initContentArea() {
        int contentX = 150;
        int contentY = 80;
        int contentWidth = this.f_96543_ - contentX - 15;
        int contentHeight = this.f_96544_ - contentY - 50;
        this.contentArea = new HelpContentArea(contentX, contentY, contentWidth, contentHeight);
    }

    private void initSearchBox() {
        int searchWidth = this.f_96543_ - 120 - 45;
        this.searchBox = new EditBox(this.f_96547_, 150, 40, searchWidth, 30, (Component)Component.m_237113_((String)"\u641c\u7d22\u547d\u4ee4\u6216\u529f\u80fd..."));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::onSearchTextChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void onSearchTextChanged(String searchText) {
        if (searchText.isEmpty()) {
            this.updateContent();
        } else {
            this.performSearch(searchText);
        }
    }

    private void performSearch(String searchText) {
        ArrayList<Component> searchResults = new ArrayList<Component>();
        String lowerSearch = searchText.toLowerCase();
        for (HelpCategory category : HelpCategory.values()) {
            List<Component> categoryContent = this.generateCategoryContent(category);
            for (Component line : categoryContent) {
                String lineText = line.getString().toLowerCase();
                if (!lineText.contains(lowerSearch)) continue;
                if (searchResults.isEmpty()) {
                    searchResults.add((Component)Component.m_237113_((String)("\u641c\u7d22\u7ed3\u679c: \"" + searchText + "\"")).m_130940_(ChatFormatting.GOLD));
                    searchResults.add((Component)Component.m_237113_((String)""));
                }
                searchResults.add(line);
            }
        }
        if (searchResults.isEmpty()) {
            searchResults.add((Component)Component.m_237113_((String)("\u672a\u627e\u5230\u5305\u542b \"" + searchText + "\" \u7684\u5185\u5bb9")).m_130940_(ChatFormatting.RED));
            searchResults.add((Component)Component.m_237113_((String)"\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u5173\u952e\u8bcd").m_130940_(ChatFormatting.GRAY));
        }
        this.contentArea.setContent(searchResults);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        this.renderCategoryButtons(guiGraphics, mouseX, mouseY);
        this.contentArea.render(guiGraphics);
        if (this.searchBox.m_94155_().isEmpty() && !this.searchBox.m_93696_()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"\u641c\u7d22\u547d\u4ee4\u6216\u529f\u80fd...").m_130940_(ChatFormatting.GRAY), this.searchBox.m_252754_() + 4, this.searchBox.m_252907_() + (this.searchBox.m_93694_() - 8) / 2, 0x808080, false);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderCategoryButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (CategoryButton button : this.categoryButtons) {
            button.render(guiGraphics, mouseX, mouseY, button.category == this.currentCategory);
        }
    }

    private void updateContent() {
        List<Component> content = this.generateCategoryContent(this.currentCategory);
        this.contentArea.setContent(content);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (CategoryButton catButton : this.categoryButtons) {
            if (!catButton.contains(mouseX, mouseY)) continue;
            this.currentCategory = catButton.category;
            this.updateContent();
            return true;
        }
        if (this.contentArea.contains(mouseX, mouseY) && this.contentArea.handleMouseClick(mouseX)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.contentArea.handleMouseDrag(dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.contentArea.handleMouseRelease();
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.contentArea.contains(mouseX, mouseY)) {
            this.contentArea.scroll(delta);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static enum HelpCategory {
        ADVANCED("\u9ad8\u7ea7\u529f\u80fd", ChatFormatting.DARK_PURPLE),
        BASIC("\u57fa\u7840\u6307\u4ee4", ChatFormatting.RED),
        SCORE_MANAGEMENT("\u5206\u6570\u7ba1\u7406", ChatFormatting.GOLD),
        ENTITY_MANAGEMENT("\u5b9e\u4f53\u7ba1\u7406", ChatFormatting.YELLOW),
        BONUS_SYSTEM("\u52a0\u5206\u7cfb\u7edf", ChatFormatting.GREEN),
        SCOREBOARD("\u8ba1\u5206\u677f", ChatFormatting.DARK_AQUA),
        RULE("\u89c4\u5219\u8bbe\u7f6e", ChatFormatting.BLUE);

        public final String displayName;
        public final ChatFormatting color;

        private HelpCategory(String displayName, ChatFormatting color) {
            this.displayName = displayName;
            this.color = color;
        }
    }

    private class CategoryButton {
        public final HelpCategory category;
        public final int height;
        public final int width;
        public final int x;
        public final int y;

        public CategoryButton(int x, int y, int width, int height, HelpCategory category) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.category = category;
        }

        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isSelected) {
            int fillColor = isSelected ? -12566464 : (this.contains(mouseX, mouseY) ? -13619152 : -14671840);
            int borderColor = isSelected ? -1 : -8355712;
            guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
            guiGraphics.m_280637_(this.x, this.y, this.width, this.height, borderColor);
            int textColor = isSelected ? (this.category.color.m_126665_() == null ? 0xFFFFFF : this.category.color.m_126665_()) : 0xFFFFFF;
            guiGraphics.m_280137_(HelpScreen.this.f_96547_, this.category.displayName, this.x + this.width / 2, this.y + (this.height - 8) / 2, textColor);
        }
    }

    private class HelpContentArea {
        private final int height;
        private final int width;
        private final int x;
        private final int y;
        private List<Component> content;
        private boolean isScrolling;
        private double maxScroll;
        private double scrollOffset;

        public HelpContentArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.content = new ArrayList<Component>();
            this.scrollOffset = 0.0;
            this.maxScroll = 0.0;
        }

        private void calculateMaxScroll() {
            int n = this.content.size();
            Objects.requireNonNull(HelpScreen.this.f_96547_);
            int totalHeight = n * (9 + 2) + 20;
            this.maxScroll = Math.max(0, totalHeight - this.height);
        }

        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public boolean handleMouseClick(double mouseX) {
            int scrollBarX = this.x + this.width - 8;
            if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 8)) {
                this.isScrolling = true;
                return true;
            }
            return false;
        }

        public boolean handleMouseDrag(double deltaY) {
            if (this.isScrolling) {
                double dragRatio = deltaY / (double)(this.height - 20);
                this.scroll(dragRatio * this.maxScroll * 2.0);
                return true;
            }
            return false;
        }

        public void handleMouseRelease() {
            this.isScrolling = false;
        }

        public void render(GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            guiGraphics.m_280637_(this.x, this.y, this.width, this.height, -12566464);
            guiGraphics.m_280588_(this.x, this.y, this.x + this.width, this.y + this.height);
            int textY = this.y + 10 - (int)this.scrollOffset;
            for (Component line : this.content) {
                Objects.requireNonNull(HelpScreen.this.f_96547_);
                if (textY + 9 >= this.y && textY <= this.y + this.height) {
                    guiGraphics.m_280614_(HelpScreen.this.f_96547_, line, this.x + 10, textY, 0xFFFFFF, false);
                }
                Objects.requireNonNull(HelpScreen.this.f_96547_);
                textY += 9 + 2;
            }
            guiGraphics.m_280618_();
            if (this.maxScroll > 0.0) {
                this.renderScrollBar(guiGraphics);
            }
        }

        private void renderScrollBar(GuiGraphics guiGraphics) {
            int scrollBarWidth = 6;
            int scrollBarX = this.x + this.width - scrollBarWidth - 2;
            double visibleRatio = (double)this.height / ((double)this.height + this.maxScroll);
            int scrollBarHeight = (int)((double)this.height * visibleRatio);
            scrollBarHeight = Math.max(20, Math.min(scrollBarHeight, this.height - 4));
            int scrollBarY = this.y + 2 + (int)((double)(this.height - 4 - scrollBarHeight) * (this.scrollOffset / this.maxScroll));
            guiGraphics.m_280509_(scrollBarX, this.y + 1, scrollBarX + scrollBarWidth, this.y + this.height - 1, -2143272896);
            guiGraphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + scrollBarWidth, scrollBarY + scrollBarHeight, -8355712);
            guiGraphics.m_280637_(scrollBarX, scrollBarY, scrollBarWidth, scrollBarHeight, -4144960);
        }

        public void scroll(double delta) {
            double newScroll = this.scrollOffset - delta * 10.0;
            this.scrollOffset = Math.max(0.0, Math.min(newScroll, this.maxScroll));
        }

        public void setContent(List<Component> content) {
            this.content = content;
            this.scrollOffset = 0.0;
            this.calculateMaxScroll();
        }
    }
}

