/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.util;

import java.util.Map;

public class ScoreExpressionCalculator {
    public static double calculate(String expression, Map<String, Double> variables) {
        if (expression == null || expression.trim().isEmpty()) {
            return 0.0;
        }
        String[] tokens = expression.split(" ");
        double result = ScoreExpressionCalculator.parseValue(tokens[0], variables);
        block12: for (int i = 1; i < tokens.length && i + 1 < tokens.length; i += 2) {
            String operator = tokens[i];
            double value = ScoreExpressionCalculator.parseValue(tokens[i + 1], variables);
            switch (operator) {
                case "+": {
                    result += value;
                    continue block12;
                }
                case "-": {
                    result -= value;
                    continue block12;
                }
                case "*": {
                    result *= value;
                    continue block12;
                }
                case "/": {
                    if (value == 0.0) {
                        return 0.0;
                    }
                    result /= value;
                    continue block12;
                }
            }
        }
        return result;
    }

    private static double parseValue(String token, Map<String, Double> variables) {
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            return variables.getOrDefault(token, 0.0);
        }
    }
}

