/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ConfigScreen;
import org.mods.gd656killicon.client.ElementConfigScreen;
import org.mods.gd656killicon.client.MenuManager;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.ScoreRequestPacket;

public class ModConfigScreen
extends Screen {
    private static final long SCORE_UPDATE_INTERVAL = 5000L;
    private final Screen parent;
    private static final int TITLE_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int MENU_BUTTON_SIZE = 20;
    private static final int PADDING = 10;
    private static final int MODE_BUTTON_WIDTH = 60;
    private static final int MODE_BUTTON_HEIGHT = 20;
    private int currentScore = 0;
    private long lastScoreUpdateTime = 0L;
    private boolean isMenuExpanded = false;
    private Button menuButton;
    private final List<CustomButton> customMenuButtons = new ArrayList<CustomButton>();
    private EditMode currentEditMode = EditMode.SCROLL;
    private final List<DraggableElement> draggableElements = new ArrayList<DraggableElement>();
    private DraggableElement selectedElement = null;
    private final Button[] modeButtons = new Button[3];
    private Button resetButton;
    private boolean resetConfirmation = false;
    private long resetConfirmationTime = 0L;
    private static final long RESET_CONFIRMATION_TIMEOUT = 3000L;
    private static final int MAX_UNDO_HISTORY = 10;
    private final List<MoveOperation> undoHistory = new ArrayList<MoveOperation>();
    private Button undoButton;
    private boolean canUndo = false;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"gd656killicon.modconfig.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.requestScoreUpdate();
        this.initializeDraggableElements();
        this.menuButton = Button.builder((Component)Component.literal((String)"\u2261"), button -> this.toggleMenu()).bounds(10, 10, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.menuButton);
        this.updateScoreText();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gd656killicon.modconfig.details"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new ConfigScreen(this));
            }
        }).bounds(this.width - 80 - 10, 10, 80, 20).build());
        this.initCustomMenuButtons();
        int modeButtonsStartX = this.width - 60 - 10;
        int modeButtonsStartY = 40;
        this.modeButtons[0] = Button.builder((Component)Component.literal((String)"\u6eda\u52a8"), button -> this.switchEditMode(EditMode.SCROLL)).bounds(modeButtonsStartX, modeButtonsStartY, 60, 20).build();
        this.modeButtons[1] = Button.builder((Component)Component.literal((String)"\u8fde\u6740"), button -> this.switchEditMode(EditMode.COMBO)).bounds(modeButtonsStartX, modeButtonsStartY + 20 + 5, 60, 20).build();
        this.modeButtons[2] = Button.builder((Component)Component.literal((String)"\u5361\u724c"), button -> this.switchEditMode(EditMode.CARD)).bounds(modeButtonsStartX, modeButtonsStartY + 50, 60, 20).build();
        this.updateModeButtons();
        for (Button button2 : this.modeButtons) {
            this.addRenderableWidget((GuiEventListener)button2);
        }
        int bottomButtonY = this.height - 20 - 10;
        int buttonSpacing = 10;
        int totalButtonsWidth = 240 + buttonSpacing * 2;
        int buttonsStartX = this.width - totalButtonsWidth - 10;
        this.resetButton = Button.builder((Component)Component.translatable((String)"gd656killicon.modconfig.reset"), button -> this.handleResetButton()).bounds(buttonsStartX, bottomButtonY, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.undoButton = Button.builder((Component)Component.translatable((String)"gd656killicon.modconfig.undo"), button -> this.handleUndoButton()).bounds(buttonsStartX + 80 + buttonSpacing, bottomButtonY, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.undoButton);
        this.updateUndoButtonState();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gd656killicon.modconfig.save"), button -> {
            this.savePositionsToConfig();
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(buttonsStartX + (80 + buttonSpacing) * 2, bottomButtonY, 80, 20).build());
    }

    private void initCustomMenuButtons() {
        this.customMenuButtons.clear();
        int buttonY = 40;
        int buttonHeight = 20;
        int buttonWidth = buttonHeight * 5;
        String[] buttonLabels = new String[]{"\u6392\u884c\u699c", "\u5386\u53f2\u8bb0\u5f55", "\u8bbe\u7f6e", "\u5e2e\u52a9", "\u5173\u4e8e", "\u53cd\u9988"};
        for (int i = 0; i < buttonLabels.length; ++i) {
            int currentY = buttonY + i * buttonHeight;
            int finalI = i;
            CustomButton button = new CustomButton(buttonLabels[i], 10, currentY, buttonWidth, buttonHeight, () -> this.handleCustomMenuButtonClick(buttonLabels[finalI]));
            this.customMenuButtons.add(button);
        }
    }

    private void handleCustomMenuButtonClick(String buttonLabel) {
        MenuManager menuManager = MenuManager.getInstance();
        switch (buttonLabel) {
            case "\u6392\u884c\u699c": {
                menuManager.openRankingList(this);
                break;
            }
            case "\u5386\u53f2\u8bb0\u5f55": {
                menuManager.openHistoryRecord(this);
                break;
            }
            case "\u8bbe\u7f6e": {
                menuManager.openMoreSettings(this);
                break;
            }
            case "\u5e2e\u52a9": {
                menuManager.openHelp(this);
                break;
            }
            case "\u5173\u4e8e": {
                menuManager.openAbout(this);
                break;
            }
            case "\u53cd\u9988": {
                menuManager.openFeedback(this);
            }
        }
        this.toggleMenu();
    }

    private void updateModeButtons() {
        for (int i = 0; i < this.modeButtons.length; ++i) {
            Button button = this.modeButtons[i];
            EditMode buttonMode = this.getEditModeForIndex(i);
            if (buttonMode == this.currentEditMode) {
                button.setFGColor(-256);
                continue;
            }
            button.setFGColor(-1);
        }
    }

    private void toggleMenu() {
        boolean bl = this.isMenuExpanded = !this.isMenuExpanded;
        if (this.isMenuExpanded) {
            this.menuButton.setMessage((Component)Component.literal((String)"<"));
        } else {
            this.menuButton.setMessage((Component)Component.literal((String)"\u2261"));
        }
    }

    private void updateScoreText() {
        Component.literal((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u4e0a\u7684\u5206\u6570: ").copy().append((Component)Component.literal((String)String.valueOf(this.currentScore)).withStyle(style -> style.withColor(-65536).withBold(Boolean.valueOf(true))));
    }

    private void requestScoreUpdate() {
        if (this.minecraft != null && this.minecraft.player != null) {
            NetworkHandler.sendToServer(new ScoreRequestPacket());
            this.lastScoreUpdateTime = System.currentTimeMillis();
        }
    }

    private EditMode getEditModeForIndex(int index) {
        return switch (index) {
            case 1 -> EditMode.COMBO;
            case 2 -> EditMode.CARD;
            default -> EditMode.SCROLL;
        };
    }

    public void updateCurrentScore(int score) {
        this.currentScore = score;
    }

    private void initializeDraggableElements() {
        this.draggableElements.clear();
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        int iconWidth = (int)((float)iconBaseWidth * iconScale);
        int iconHeight = (int)((float)iconBaseHeight * iconScale);
        int subtitleWidth = (int)((float)subtitleBaseWidth * subtitleScale);
        int subtitleHeight = (int)((float)subtitleBaseHeight * subtitleScale);
        int scoreWidth = (int)((float)scoreBaseWidth * scoreScale);
        int scoreHeight = (int)((float)scoreBaseHeight * scoreScale);
        int bonusWidth = (int)((float)bonusBaseWidth * bonusScale);
        int bonusHeight = (int)((float)bonusBaseHeight * bonusScale);
        this.draggableElements.add(new DraggableElement("\u51fb\u6740\u56fe\u6807", ElementType.ICON, this.getCurrentPosition(ElementType.ICON, true), this.getCurrentPosition(ElementType.ICON, false), iconWidth, iconHeight, true));
        this.draggableElements.add(new DraggableElement("\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55", ElementType.SUBTITLE, this.getCurrentPosition(ElementType.SUBTITLE, true), this.getCurrentPosition(ElementType.SUBTITLE, false), subtitleWidth, subtitleHeight, true));
        this.draggableElements.add(new DraggableElement("\u5206\u6570\u5b57\u5e55", ElementType.SCORE, this.getCurrentPosition(ElementType.SCORE, true), this.getCurrentPosition(ElementType.SCORE, false), scoreWidth, scoreHeight, true));
        this.draggableElements.add(new DraggableElement("\u52a0\u5206\u9879\u5b57\u5e55", ElementType.BONUS, this.getCurrentPosition(ElementType.BONUS, true), this.getCurrentPosition(ElementType.BONUS, false), bonusWidth, bonusHeight, true));
        switch (Config.iconMode) {
            case SCROLLING: {
                this.currentEditMode = EditMode.SCROLL;
                break;
            }
            case COMBO: {
                this.currentEditMode = EditMode.COMBO;
                break;
            }
            case CARD: {
                this.currentEditMode = EditMode.CARD;
            }
        }
        this.loadPositionsFromConfig();
    }

    private int getCurrentPosition(ElementType type, boolean isX) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getScrollPosition(type, isX);
            case 1 -> this.getComboPosition(type, isX);
            case 2 -> this.getCardPosition(type, isX);
        };
    }

    void updateElementSizes() {
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        for (DraggableElement element : this.draggableElements) {
            switch (element.type.ordinal()) {
                case 0: {
                    element.width = (int)((float)iconBaseWidth * iconScale);
                    element.height = (int)((float)iconBaseHeight * iconScale);
                    break;
                }
                case 1: {
                    element.width = (int)((float)subtitleBaseWidth * subtitleScale);
                    element.height = (int)((float)subtitleBaseHeight * subtitleScale);
                    break;
                }
                case 2: {
                    element.width = (int)((float)scoreBaseWidth * scoreScale);
                    element.height = (int)((float)scoreBaseHeight * scoreScale);
                    break;
                }
                case 3: {
                    element.width = (int)((float)bonusBaseWidth * bonusScale);
                    element.height = (int)((float)bonusBaseHeight * bonusScale);
                }
            }
        }
    }

    private void handleResetButton() {
        if (this.resetConfirmation) {
            Config.resetAllToDefaults();
            this.clearUndoHistory();
            this.initializeDraggableElements();
            this.resetConfirmation = false;
            this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.modconfig.reset"));
        } else {
            this.resetConfirmation = true;
            this.resetConfirmationTime = System.currentTimeMillis();
            this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.modconfig.reset_confirm"));
        }
    }

    private void switchEditMode(EditMode newMode) {
        if (this.currentEditMode != newMode) {
            this.savePositionsToConfig();
            this.currentEditMode = newMode;
            this.loadPositionsFromConfig();
            this.clearUndoHistory();
            switch (newMode.ordinal()) {
                case 0: {
                    Config.ICON_MODE.set((Object)Config.IconMode.SCROLLING);
                    break;
                }
                case 1: {
                    Config.ICON_MODE.set((Object)Config.IconMode.COMBO);
                    break;
                }
                case 2: {
                    Config.ICON_MODE.set((Object)Config.IconMode.CARD);
                }
            }
            Config.SPEC.save();
            Config.loadConfig();
        }
        boolean isCardMode = newMode == EditMode.CARD;
        for (DraggableElement element : this.draggableElements) {
            if (element.type == ElementType.ICON) continue;
            element.visibleInGame = !isCardMode;
        }
        this.updateElementSizes();
        this.updateModeButtons();
    }

    private void loadPositionsFromConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode.ordinal()) {
                case 0: {
                    element.x = this.getScrollPosition(element.type, true);
                    element.y = this.getScrollPosition(element.type, false);
                    break;
                }
                case 1: {
                    element.x = this.getComboPosition(element.type, true);
                    element.y = this.getComboPosition(element.type, false);
                    break;
                }
                case 2: {
                    element.x = this.getCardPosition(element.type, true);
                    element.y = this.getCardPosition(element.type, false);
                }
            }
        }
    }

    private void savePositionsToConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode.ordinal()) {
                case 0: {
                    this.setScrollPosition(element.type, element.x, element.y);
                    break;
                }
                case 1: {
                    this.setComboPosition(element.type, element.x, element.y);
                    break;
                }
                case 2: {
                    this.setCardPosition(element.type, element.x, element.y);
                }
            }
        }
        Config.SPEC.save();
        Config.loadConfig();
    }

    private int getScrollPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isX) {
                    yield Config.scrollIconX;
                }
                yield Config.scrollIconY;
            }
            case 1 -> {
                if (isX) {
                    yield Config.scrollSubtitleX;
                }
                yield Config.scrollSubtitleY;
            }
            case 2 -> {
                if (isX) {
                    yield Config.scrollScoreX;
                }
                yield Config.scrollScoreY;
            }
            case 3 -> isX ? Config.scrollBonusX : Config.scrollBonusY;
        };
    }

    private int getComboPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isX) {
                    yield Config.comboIconX;
                }
                yield Config.comboIconY;
            }
            case 1 -> {
                if (isX) {
                    yield Config.comboSubtitleX;
                }
                yield Config.comboSubtitleY;
            }
            case 2 -> {
                if (isX) {
                    yield Config.comboScoreX;
                }
                yield Config.comboScoreY;
            }
            case 3 -> isX ? Config.comboBonusX : Config.comboBonusY;
        };
    }

    private int getCardPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isX) {
                    yield Config.cardIconX;
                }
                yield Config.cardIconY;
            }
            case 1 -> {
                if (isX) {
                    yield Config.cardSubtitleX;
                }
                yield Config.cardSubtitleY;
            }
            case 2 -> {
                if (isX) {
                    yield Config.cardScoreX;
                }
                yield Config.cardScoreY;
            }
            case 3 -> isX ? Config.cardBonusX : Config.cardBonusY;
        };
    }

    private void setScrollPosition(ElementType type, int x, int y) {
        switch (type.ordinal()) {
            case 0: {
                Config.SCROLL_ICON_X.set((Object)x);
                Config.SCROLL_ICON_Y.set((Object)y);
                break;
            }
            case 1: {
                Config.SCROLL_SUBTITLE_X.set((Object)x);
                Config.SCROLL_SUBTITLE_Y.set((Object)y);
                break;
            }
            case 2: {
                Config.SCROLL_SCORE_X.set((Object)x);
                Config.SCROLL_SCORE_Y.set((Object)y);
                break;
            }
            case 3: {
                Config.SCROLL_BONUS_X.set((Object)x);
                Config.SCROLL_BONUS_Y.set((Object)y);
            }
        }
    }

    private void setComboPosition(ElementType type, int x, int y) {
        switch (type.ordinal()) {
            case 0: {
                Config.COMBO_ICON_X.set((Object)x);
                Config.COMBO_ICON_Y.set((Object)y);
                break;
            }
            case 1: {
                Config.COMBO_SUBTITLE_X.set((Object)x);
                Config.COMBO_SUBTITLE_Y.set((Object)y);
                break;
            }
            case 2: {
                Config.COMBO_SCORE_X.set((Object)x);
                Config.COMBO_SCORE_Y.set((Object)y);
                break;
            }
            case 3: {
                Config.COMBO_BONUS_X.set((Object)x);
                Config.COMBO_BONUS_Y.set((Object)y);
            }
        }
    }

    private void setCardPosition(ElementType type, int x, int y) {
        switch (type.ordinal()) {
            case 0: {
                Config.CARD_ICON_X.set((Object)x);
                Config.CARD_ICON_Y.set((Object)y);
                break;
            }
            case 1: {
                Config.CARD_SUBTITLE_X.set((Object)x);
                Config.CARD_SUBTITLE_Y.set((Object)y);
                break;
            }
            case 2: {
                Config.CARD_SCORE_X.set((Object)x);
                Config.CARD_SCORE_Y.set((Object)y);
                break;
            }
            case 3: {
                Config.CARD_BONUS_X.set((Object)x);
                Config.CARD_BONUS_Y.set((Object)y);
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundColor = -1728053248;
        guiGraphics.fillGradient(0, 0, this.width, this.height, backgroundColor, backgroundColor);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (System.currentTimeMillis() - this.lastScoreUpdateTime > 5000L) {
            this.requestScoreUpdate();
        }
        if (this.resetConfirmation && System.currentTimeMillis() - this.resetConfirmationTime > 3000L) {
            this.resetConfirmation = false;
            this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.modconfig.reset"));
        }
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        String modeText = "\u5f53\u524d\u6a21\u5f0f: " + this.currentEditMode.displayName;
        guiGraphics.drawString(this.font, modeText, this.width / 2 - this.font.width(modeText) / 2, 40, this.currentEditMode.color, true);
        MutableComponent label = Component.literal((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u7684\u603b\u5206\u6570: ").withStyle(style -> style.withColor(-1));
        String scoreText = String.valueOf(this.currentScore);
        int labelX = 40;
        int scoreX = labelX + this.font.width((FormattedText)label) + 5;
        guiGraphics.drawString(this.font, (Component)label, labelX, 16, -1, true);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)scoreText).withStyle(style -> style.withColor(-65536).withBold(Boolean.valueOf(true))), scoreX, 16, -65536, true);
        if (this.isMenuExpanded) {
            this.renderCustomButtons(guiGraphics, mouseX, mouseY);
        }
        this.renderDraggableElements(guiGraphics, mouseX, mouseY);
        String versionText = "v1.0.0 \u516c\u6d4b\u7248RC2";
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, versionText, 10, this.height - 9 - 10, 0x888888, true);
        String instruction = "\u5de6\u952e\u62d6\u52a8\u8c03\u6574\u4f4d\u7f6e | \u53f3\u952e\u70b9\u51fb\u914d\u7f6e\u5143\u7d20";
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, instruction, 10, this.height - 9 * 2 - 10 - 5, 0xCCCCCC, true);
    }

    private void renderCustomButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (CustomButton button : this.customMenuButtons) {
            button.render(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderDraggableElements(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (DraggableElement element : this.draggableElements) {
            int drawX = this.width / 2 + element.x - element.width / 2;
            int drawY = this.height + element.y - element.height / 2;
            int borderColor = this.currentEditMode.color;
            int fillColor = borderColor & 0xFFFFFF | Integer.MIN_VALUE;
            boolean isVisible = this.getElementVisible(element.type);
            if (!isVisible) {
                fillColor = borderColor & 0xFFFFFF | 0x40000000;
            }
            guiGraphics.fill(drawX, drawY, drawX + element.width, drawY + element.height, fillColor);
            guiGraphics.renderOutline(drawX, drawY, element.width, element.height, borderColor);
            String nameText = element.name;
            String coordText = "(" + element.x + ", " + element.y + ")";
            int nameWidth = this.font.width(nameText);
            int coordWidth = this.font.width(coordText);
            Objects.requireNonNull(this.font);
            int totalTextHeight = 9 * 2 + 5;
            int textStartY = drawY + (element.height - totalTextHeight) / 2;
            guiGraphics.drawString(this.font, nameText, drawX + element.width / 2 - nameWidth / 2, textStartY, -1, true);
            int n = drawX + element.width / 2 - coordWidth / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, coordText, n, textStartY + 9 + 5, -1, true);
            this.drawEyeIcon(guiGraphics, drawX, drawY, element.width, isVisible);
            if (element.contains(mouseX, mouseY, this.width, this.height)) {
                guiGraphics.renderOutline(drawX - 1, drawY - 1, element.width + 2, element.height + 2, -1);
            }
            if (element == this.selectedElement) {
                guiGraphics.renderOutline(drawX - 2, drawY - 2, element.width + 4, element.height + 4, -256);
            }
            if (!this.isElementOutOfBounds(element, this.width, this.height)) continue;
            String warningText = "!";
            int warningWidth = this.font.width(warningText);
            guiGraphics.drawString(this.font, warningText, drawX + element.width - warningWidth - 2, drawY + 2, -65536, true);
        }
    }

    private void drawEyeIcon(GuiGraphics guiGraphics, int drawX, int drawY, int elementWidth, boolean isVisible) {
        ResourceLocation eyeIcon = isVisible ? ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/mob_effect/conduit_power.png") : ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/mob_effect/blindness.png");
        try {
            int iconSize = 16;
            int iconX = drawX + elementWidth - iconSize - 3;
            int iconY = drawY + 3;
            guiGraphics.blit(eyeIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Exception e) {
            String eyeText = isVisible ? "\u25cb" : "\u00d7";
            int textWidth = this.font.width(eyeText);
            int textX = drawX + elementWidth - textWidth - 3;
            int textY = drawY + 3;
            int textColor = isVisible ? -16711936 : -65536;
            guiGraphics.drawString(this.font, eyeText, textX, textY, textColor, true);
        }
    }

    private boolean getElementVisible(ElementType type) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.scrollIconVisible;
                    }
                    case 1: {
                        yield Config.scrollSubtitleVisible;
                    }
                    case 2: {
                        yield Config.scrollScoreVisible;
                    }
                    case 3: 
                }
                yield Config.scrollBonusVisible;
            }
            case 1 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.comboIconVisible;
                    }
                    case 1: {
                        yield Config.comboSubtitleVisible;
                    }
                    case 2: {
                        yield Config.comboScoreVisible;
                    }
                    case 3: 
                }
                yield Config.comboBonusVisible;
            }
            case 2 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.cardIconVisible;
                    }
                    case 1: {
                        yield Config.cardSubtitleVisible;
                    }
                    case 2: {
                        yield Config.cardScoreVisible;
                    }
                    case 3: 
                }
                yield Config.cardBonusVisible;
            }
        };
    }

    private int getElementSize(ElementType type) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.scrollIconSize;
                    }
                    case 1: {
                        yield Config.scrollSubtitleSize;
                    }
                    case 2: {
                        yield Config.scrollScoreSize;
                    }
                    case 3: 
                }
                yield Config.scrollBonusSize;
            }
            case 1 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.comboIconSize;
                    }
                    case 1: {
                        yield Config.comboSubtitleSize;
                    }
                    case 2: {
                        yield Config.comboScoreSize;
                    }
                    case 3: 
                }
                yield Config.comboBonusSize;
            }
            case 2 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Config.cardIconSize;
                    }
                    case 1: {
                        yield Config.cardSubtitleSize;
                    }
                    case 2: {
                        yield Config.cardScoreSize;
                    }
                    case 3: 
                }
                yield Config.cardBonusSize;
            }
        };
    }

    private boolean isElementOutOfBounds(DraggableElement element, int screenWidth, int screenHeight) {
        int drawX = screenWidth / 2 + element.x - element.width / 2;
        int drawY = screenHeight + element.y - element.height / 2;
        return drawX < 0 || drawX + element.width > screenWidth || drawY < 0 || drawY + element.height > screenHeight;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMenuExpanded && button == 0) {
            boolean clickedOnButton = false;
            for (CustomButton customButton : this.customMenuButtons) {
                if (!customButton.contains((int)mouseX, (int)mouseY)) continue;
                customButton.onClick.run();
                clickedOnButton = true;
                break;
            }
            if (!clickedOnButton) {
                boolean clickedMenuButton;
                boolean bl = clickedMenuButton = mouseX >= 10.0 && mouseX <= 30.0 && mouseY >= 10.0 && mouseY <= 30.0;
                if (!clickedMenuButton) {
                    this.toggleMenu();
                    return true;
                }
            }
            if (clickedOnButton) {
                return true;
            }
        }
        if (button == 1) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.width, this.height)) continue;
                if (this.minecraft != null) {
                    this.minecraft.setScreen((Screen)new ElementConfigScreen(this, element));
                }
                return true;
            }
        }
        if (button == 0) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.width, this.height)) continue;
                this.selectedElement = element;
                int oldX = element.x;
                int oldY = element.y;
                element.setDragOffset((int)mouseX, (int)mouseY, this.width, this.height);
                this.selectedElement.setUserData(new int[]{oldX, oldY});
                return true;
            }
            this.selectedElement = null;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selectedElement != null && button == 0) {
            this.selectedElement.setPositionFromMouse((int)mouseX, (int)mouseY, this.width, this.height);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.selectedElement != null && button == 0) {
            int[] oldPos = (int[])this.selectedElement.getUserData();
            if (oldPos != null) {
                int oldX = oldPos[0];
                int oldY = oldPos[1];
                int newX = this.selectedElement.x;
                int newY = this.selectedElement.y;
                this.recordMoveOperation(this.selectedElement.type, oldX, oldY, newX, newY);
                this.selectedElement.setUserData(null);
            }
            this.savePositionsToConfig();
            this.selectedElement = null;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        this.savePositionsToConfig();
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    private void handleUndoButton() {
        if (this.canUndo && !this.undoHistory.isEmpty()) {
            this.undoLastMove();
        }
    }

    private void undoLastMove() {
        if (this.undoHistory.isEmpty()) {
            return;
        }
        MoveOperation lastOperation = this.undoHistory.removeLast();
        for (DraggableElement element : this.draggableElements) {
            if (element.type != lastOperation.elementType) continue;
            element.x = lastOperation.oldX;
            element.y = lastOperation.oldY;
            break;
        }
        this.savePositionsToConfig();
        this.updateUndoButtonState();
    }

    private void recordMoveOperation(ElementType elementType, int oldX, int oldY, int newX, int newY) {
        if (oldX == newX && oldY == newY) {
            return;
        }
        MoveOperation operation = new MoveOperation(this.currentEditMode, elementType, oldX, oldY, newX, newY);
        this.undoHistory.add(operation);
        if (this.undoHistory.size() > 10) {
            this.undoHistory.removeFirst();
        }
        this.updateUndoButtonState();
    }

    private void updateUndoButtonState() {
        boolean bl = this.canUndo = !this.undoHistory.isEmpty();
        if (this.undoButton != null) {
            this.undoButton.active = this.canUndo;
            if (this.canUndo) {
                this.undoButton.setFGColor(-1);
            } else {
                this.undoButton.setFGColor(-7829368);
            }
        }
    }

    private void clearUndoHistory() {
        this.undoHistory.clear();
        this.updateUndoButtonState();
    }

    private static enum EditMode {
        SCROLL("\u6eda\u52a8\u6a21\u5f0f", -65536),
        COMBO("\u8fde\u6740\u6a21\u5f0f", -16711936),
        CARD("\u5361\u724c\u6a21\u5f0f", -256);

        public final String displayName;
        public final int color;

        private EditMode(String displayName, int color) {
            this.displayName = displayName;
            this.color = color;
        }
    }

    public static class DraggableElement {
        public final String name;
        public final ElementType type;
        public int x;
        public int y;
        public final int defaultX;
        public final int defaultY;
        public int width;
        public int height;
        public boolean visibleInGame;
        public int dragOffsetX;
        public int dragOffsetY;
        private Object userData;

        public DraggableElement(String name, ElementType type, int defaultX, int defaultY, int width, int height, boolean visibleInGame) {
            this.name = name;
            this.type = type;
            this.x = defaultX;
            this.y = defaultY;
            this.defaultX = defaultX;
            this.defaultY = defaultY;
            this.width = width;
            this.height = height;
            this.visibleInGame = visibleInGame;
        }

        public boolean contains(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            return mouseX >= drawX && mouseX <= drawX + this.width && mouseY >= drawY && mouseY <= drawY + this.height;
        }

        public void setDragOffset(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            this.dragOffsetX = mouseX - drawX;
            this.dragOffsetY = mouseY - drawY;
        }

        public void setPositionFromMouse(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int newX = mouseX - screenWidth / 2 - this.dragOffsetX + this.width / 2;
            int newY = mouseY - screenHeight - this.dragOffsetY + this.height / 2;
            this.x = this.clampToScreenBounds(newX, screenWidth, true);
            this.y = this.clampToScreenBounds(newY, screenHeight, false);
        }

        private int clampToScreenBounds(int coordinate, int screenSize, boolean isX) {
            int margin = 20;
            if (isX) {
                int maxX = screenSize / 2 - this.width / 2 - margin;
                int minX = -screenSize / 2 + this.width / 2 + margin;
                return Mth.clamp((int)coordinate, (int)minX, (int)maxX);
            }
            int maxY = -this.height / 2 - margin;
            int minY = -screenSize + this.height / 2 + margin;
            return Mth.clamp((int)coordinate, (int)minY, (int)maxY);
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }
    }

    public static class CustomButton {
        public final String label;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final Runnable onClick;
        public boolean isHovered = false;

        public CustomButton(String label, int x, int y, int width, int height, Runnable onClick) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onClick = onClick;
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            this.isHovered = this.contains(mouseX, mouseY);
            int fillColor = this.isHovered ? -12566464 : -16777216;
            int borderColor = -8355712;
            guiGraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
            guiGraphics.renderOutline(this.x, this.y, this.width, this.height, borderColor);
            Minecraft mc = Minecraft.getInstance();
            int textWidth = mc.font.width(this.label);
            int textX = this.x + (this.width - textWidth) / 2;
            Objects.requireNonNull(mc.font);
            int textY = this.y + (this.height - 9) / 2 + 1;
            guiGraphics.drawString(mc.font, this.label, textX, textY, 0xFFFFFF, true);
        }
    }

    public static enum ElementType {
        ICON,
        SUBTITLE,
        SCORE,
        BONUS;

    }

    public static class MoveOperation {
        public final EditMode editMode;
        public final ElementType elementType;
        public final int oldX;
        public final int oldY;
        public final int newX;
        public final int newY;
        public final long timestamp;

        public MoveOperation(EditMode editMode, ElementType elementType, int oldX, int oldY, int newX, int newY) {
            this.editMode = editMode;
            this.elementType = elementType;
            this.oldX = oldX;
            this.oldY = oldY;
            this.newX = newX;
            this.newY = newY;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

