/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.ComboIconRenderer;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;

@OnlyIn(value=Dist.CLIENT)
public class ScrollingIconRenderer {
    private static ResourceLocation VANALLA_KILL_ICON;
    private static ResourceLocation VANALLA_ULTIMATE_ICON;
    private static ResourceLocation VANALLA_ASSIST_ICON;

    public void loadResources() {
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_KILL_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/rollingmode/kill_icon.png"));
        VANALLA_ULTIMATE_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/rollingmode/ultimate_icon.png"));
        VANALLA_ASSIST_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/rollingmode/assist_icon.png"));
    }

    public void handleScrollingMode(String weaponName, String targetName, boolean isCritical, boolean playUltimateSound, boolean isAssist) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int iconSize = ScrollingIconRenderer.getCurrentIconSize();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = screenHeight + pos.iconY;
        KillIconInstance newIcon = new KillIconInstance(System.currentTimeMillis(), targetX - (float)iconSize / 2.0f, targetY, isCritical);
        newIcon.isAssist = isAssist;
        newIcon.prevX = targetX - (float)iconSize / 2.0f;
        newIcon.currentX = targetX - (float)iconSize / 2.0f;
        newIcon.targetX = targetX - (float)iconSize / 2.0f;
        KillIconRenderer.latestIsCritical = isCritical;
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            SoundEvent sound = isAssist ? ScrollingIconRenderer.getAssistKillSound() : ScrollingIconRenderer.getKillSound(playUltimateSound);
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)volume));
        }
        KillIconRenderer.activeIcons.add(newIcon);
        KillIconRenderer.textAnimationStartTime = System.currentTimeMillis();
        KillIconRenderer.textHideTime = 0L;
        if (KillIconRenderer.activeIcons.size() > Config.forceHideCount) {
            this.startFadeOutSequence(System.currentTimeMillis());
        }
        this.checkMaxDisplayCount();
        this.updateAllIconTargetPositions();
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
        KillIconRenderer.isFadingOutAll = false;
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
    }

    private void checkMaxDisplayCount() {
        if (KillIconRenderer.activeIcons.size() > Config.maxDisplayCount) {
            KillIconRenderer.activeIcons.removeFirst();
            this.updateAllIconTargetPositions();
        }
    }

    public void updateAllIconTargetPositions() {
        if (KillIconRenderer.activeIcons.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int iconSize = ScrollingIconRenderer.getCurrentIconSize();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float iconSpacing = iconSize + Config.killIconSpacing;
        for (int i = 0; i < KillIconRenderer.activeIcons.size(); ++i) {
            KillIconInstance icon = KillIconRenderer.activeIcons.get(i);
            float position = (float)i - (float)(KillIconRenderer.activeIcons.size() - 1) / 2.0f;
            float newTargetX = centerX + position * iconSpacing - (float)iconSize / 2.0f;
            if (!(Math.abs(icon.targetX - newTargetX) > 1.0f)) continue;
            icon.prevX = icon.currentX;
            icon.targetX = newTargetX;
            icon.positionAnimationStart = System.currentTimeMillis();
        }
    }

    public void startFadeOutSequence(long currentTime) {
        KillIconRenderer.isFadingOutAll = true;
        int totalIcons = KillIconRenderer.activeIcons.size();
        long fadeDuration = 200L;
        float speedFactor = ScrollingIconRenderer.calculateFadeOutSpeedFactor(totalIcons);
        long baseDelay = (long)(80.0f / speedFactor);
        baseDelay = Math.max(baseDelay, 30L);
        for (int i = 0; i < totalIcons; ++i) {
            KillIconInstance icon = KillIconRenderer.activeIcons.get(i);
            icon.fadeStartTime = currentTime + (long)i * baseDelay;
            icon.fadeDuration = fadeDuration;
        }
    }

    private static float calculateFadeOutSpeedFactor(int iconCount) {
        if (iconCount <= 3) {
            return 0.4f;
        }
        if (iconCount <= 6) {
            return 0.5f;
        }
        if (iconCount <= 10) {
            return 0.8f;
        }
        if (iconCount <= 15) {
            return 1.0f;
        }
        if (iconCount <= 20) {
            return 2.0f;
        }
        return 3.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderIcons(GuiGraphics guiGraphics, PoseStack poseStack, long currentTime) {
        if (KillIconRenderer.activeIcons.isEmpty()) {
            return;
        }
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            Iterator<KillIconInstance> iterator = KillIconRenderer.activeIcons.iterator();
            int iconSize = ScrollingIconRenderer.getCurrentIconSize();
            while (iterator.hasNext()) {
                KillIconInstance icon = iterator.next();
                long elapsed = currentTime - icon.startTime;
                ScrollingIconRenderer.updateIconAnimation(icon, elapsed, currentTime);
                if (icon.alpha <= 0.0f) {
                    iterator.remove();
                    this.updateAllIconTargetPositions();
                    if (!KillIconRenderer.activeIcons.isEmpty()) continue;
                    KillIconRenderer.isGroupDisplaying = false;
                    KillIconRenderer.shouldStartFadeOut = false;
                    KillIconRenderer.isFadingOutAll = false;
                    continue;
                }
                ScrollingIconRenderer.updatePosition(icon, currentTime);
                if (icon.isCombo) {
                    ComboIconRenderer.renderComboIcon(guiGraphics, poseStack, icon, iconSize);
                    continue;
                }
                ScrollingIconRenderer.renderSingleIcon(guiGraphics, poseStack, icon);
            }
        }
        finally {
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    private static void updateIconAnimation(KillIconInstance icon, long elapsed, long currentTime) {
        if (elapsed < (long)Config.killIconAnimationDuration) {
            float progress = Mth.clamp((float)((float)elapsed / (float)Config.killIconAnimationDuration), (float)0.0f, (float)1.0f);
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            icon.scale = Mth.lerp((float)easedProgress, (float)1.5f, (float)1.0f);
            icon.brightness = Mth.lerp((float)easedProgress, (float)4.0f, (float)1.0f);
        }
        if (icon.fadeStartTime != -1L && currentTime >= icon.fadeStartTime) {
            long fadeElapsed = currentTime - icon.fadeStartTime;
            float fadeProgress = Math.min((float)fadeElapsed / (float)icon.fadeDuration, 1.0f);
            icon.alpha = 1.0f - fadeProgress;
        }
    }

    private static void updatePosition(KillIconInstance icon, long currentTime) {
        if (Math.abs(icon.currentX - icon.targetX) > 0.1f) {
            long moveElapsed = currentTime - icon.positionAnimationStart;
            float progress = Math.min((float)moveElapsed / 300.0f, 1.0f);
            float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            icon.currentX = Mth.lerp((float)easedProgress, (float)icon.prevX, (float)icon.targetX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderSingleIcon(GuiGraphics guiGraphics, PoseStack poseStack, KillIconInstance icon) {
        int currentIconSize = ScrollingIconRenderer.getCurrentIconSize();
        int scaledSize = (int)((float)currentIconSize * icon.scale);
        int offsetX = (currentIconSize - scaledSize) / 2;
        int offsetY = (currentIconSize - scaledSize) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        poseStack.pushPose();
        try {
            ResourceLocation iconTexture;
            poseStack.translate(icon.currentX + (float)offsetX, icon.baseY + (float)offsetY, 0.0f);
            poseStack.scale(icon.scale, icon.scale, 1.0f);
            IconType iconType = ScrollingIconRenderer.getIconType(icon);
            switch (iconType.ordinal()) {
                case 0: {
                    iconTexture = VANALLA_ASSIST_ICON;
                    break;
                }
                case 1: {
                    ComboIconRenderer.renderComboIcon(guiGraphics, poseStack, icon, currentIconSize);
                    return;
                }
                case 2: {
                    iconTexture = VANALLA_ULTIMATE_ICON;
                    break;
                }
                default: {
                    iconTexture = VANALLA_KILL_ICON;
                }
            }
            guiGraphics.blit(RenderType::guiTextured, iconTexture, 0, 0, 0.0f, 0.0f, currentIconSize, currentIconSize, currentIconSize, currentIconSize);
        }
        finally {
            poseStack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static int getCurrentIconSize() {
        return switch (Config.iconMode) {
            default -> throw new MatchException(null, null);
            case Config.IconMode.SCROLLING -> Config.scrollIconSize;
            case Config.IconMode.COMBO -> Config.comboIconSize;
            case Config.IconMode.CARD -> Config.cardIconSize;
        };
    }

    private static IconType getIconType(KillIconInstance icon) {
        if (icon.isAssist) {
            return IconType.ASSIST;
        }
        if (icon.isCombo) {
            return IconType.COMBO;
        }
        if (icon.isCritical) {
            return IconType.CRITICAL;
        }
        return IconType.NORMAL;
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
            }
        }
        return config;
    }

    private static SoundEvent getKillSound(boolean isUltimate) {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_VANILLA.get() : (SoundEvent)Gd656killicon.KILL_SOUND_VANILLA.get();
        }
        return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_MODERN.get() : (SoundEvent)Gd656killicon.KILL_SOUND_MODERN.get();
    }

    private static SoundEvent getAssistKillSound() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return (SoundEvent)Gd656killicon.ASSIST_KILL_VANILLA.get();
        }
        return (SoundEvent)Gd656killicon.ASSIST_KILL_MODERN.get();
    }

    public static class KillIconInstance {
        public long startTime;
        public float brightness;
        public float scale;
        public float alpha;
        public float prevX;
        public float currentX;
        public float targetX;
        public float baseY;
        public long positionAnimationStart;
        public long fadeStartTime = -1L;
        public long fadeDuration = 200L;
        public boolean isCritical;
        public boolean isCombo;
        public int comboIndex;
        public boolean isAssist;
        public float currentY;
        public float targetY;

        public KillIconInstance(long startTime, float initialX, float baseY, boolean isCritical) {
            this.startTime = startTime;
            this.baseY = baseY;
            this.currentY = baseY;
            this.targetY = baseY;
            this.brightness = 4.0f;
            this.scale = 1.5f;
            this.alpha = 1.0f;
            this.prevX = initialX;
            this.currentX = initialX;
            this.targetX = initialX;
            this.positionAnimationStart = System.currentTimeMillis();
            this.isCritical = isCritical;
            this.isAssist = false;
            this.isCombo = false;
            this.comboIndex = 0;
        }
    }

    private static enum IconType {
        ASSIST,
        COMBO,
        CRITICAL,
        NORMAL;

    }
}

