/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ScoreExpressionManager
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_score_expressions";
    private static final Map<String, String> expressions = new HashMap<String, String>();

    public ScoreExpressionManager() {
        this.resetToDefaults();
    }

    public ScoreExpressionManager(CompoundTag nbt) {
        CompoundTag expressionsTag = nbt.getCompound("expressions");
        for (String key : expressionsTag.getAllKeys()) {
            expressions.put(key, expressionsTag.getString(key));
        }
        if (expressions.isEmpty()) {
            this.resetToDefaults();
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag expressionsTag = new CompoundTag();
        for (Map.Entry<String, String> entry : expressions.entrySet()) {
            expressionsTag.putString(entry.getKey(), entry.getValue());
        }
        compound.put("expressions", (Tag)expressionsTag);
        return compound;
    }

    public static ScoreExpressionManager get() {
        ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD);
        if (overworld == null) {
            return new ScoreExpressionManager();
        }
        return (ScoreExpressionManager)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(ScoreExpressionManager::new, ScoreExpressionManager::loadFromNbt, DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES), DATA_NAME);
    }

    private static ScoreExpressionManager loadFromNbt(CompoundTag nbt, HolderLookup.Provider provider) {
        return new ScoreExpressionManager(nbt);
    }

    public void resetToDefaults() {
        expressions.clear();
        expressions.put("kill", "health * 5");
        expressions.put("critical", "killscore * 0.25");
        expressions.put("longrange", "distance");
        expressions.put("damage", "damage");
        expressions.put("magic", "damage");
        expressions.put("hand", "damage");
        expressions.put("assist", "damagedealt * 5");
        expressions.put("combobonus", "combo * 8");
        this.setDirty();
    }

    public static String getExpression(String scoreType) {
        return expressions.getOrDefault(scoreType, "");
    }

    public void setExpression(String scoreType, String expression) {
        expressions.put(scoreType, expression);
        this.setDirty();
    }

    public Map<String, String> getAllExpressions() {
        return new HashMap<String, String>(expressions);
    }
}

