/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.data.ScoreboardBindingData;

public class ScoreData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_scores";
    private boolean rankingListEnabled = true;
    private final ConcurrentHashMap<UUID, Integer> playerScores = new ConcurrentHashMap();
    private int cardComboKillDurationTime = 60;
    private int scoreLimit = 1024;

    public ScoreData() {
    }

    public ScoreData(CompoundTag nbt) {
        ListTag scoreList = nbt.m_128437_("scores", 10);
        for (int i = 0; i < scoreList.size(); ++i) {
            CompoundTag scoreTag = scoreList.m_128728_(i);
            UUID playerId = scoreTag.m_128342_("playerId");
            int score = scoreTag.m_128451_("score");
            this.playerScores.put(playerId, score);
        }
        this.rankingListEnabled = nbt.m_128471_("rankingListEnabled");
        this.cardComboKillDurationTime = nbt.m_128451_("cardComboKillDurationTime");
        if (this.cardComboKillDurationTime < 0) {
            this.cardComboKillDurationTime = 60;
        }
        this.scoreLimit = nbt.m_128451_("scoreLimit");
        if (this.scoreLimit < 1) {
            this.scoreLimit = 1024;
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag scoreList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            CompoundTag scoreTag = new CompoundTag();
            scoreTag.m_128362_("playerId", entry.getKey());
            scoreTag.m_128405_("score", entry.getValue().intValue());
            scoreList.add((Object)scoreTag);
        }
        compound.m_128365_("scores", (Tag)scoreList);
        compound.m_128379_("rankingListEnabled", this.rankingListEnabled);
        compound.m_128405_("cardComboKillDurationTime", this.cardComboKillDurationTime);
        compound.m_128405_("scoreLimit", this.scoreLimit);
        return compound;
    }

    public static ScoreData get() {
        return (ScoreData)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)).m_8895_().m_164861_(ScoreData::new, ScoreData::new, DATA_NAME);
    }

    public int getScore(UUID playerId) {
        return this.playerScores.getOrDefault(playerId, 0);
    }

    public void addScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        if (currentScore >= 0x3FFFFFFF) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        int roundedPoints = Math.round(points);
        if (roundedPoints > this.scoreLimit) {
            roundedPoints = this.scoreLimit;
        }
        int finalPoints = roundedPoints;
        this.playerScores.compute(playerId, (key, current) -> {
            int newScore = (current == null ? 0 : current) + finalPoints;
            if (newScore >= 0x3FFFFFFF) {
                ServerPlayer player;
                newScore = 0x3FFFFFFF;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && (player = server.m_6846_().m_11259_(playerId)) != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").m_130940_(ChatFormatting.RED));
                }
            }
            return newScore;
        });
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    public void reduceScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        int roundedPoints = Math.round(points);
        int newScore = Math.max(0, currentScore - roundedPoints);
        this.playerScores.put(playerId, newScore);
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    public void setScore(UUID playerId, int score) {
        int newScore = Math.max(0, score);
        this.playerScores.put(playerId, newScore);
        this.m_77762_();
        this.syncToScoreboard(playerId);
    }

    private void syncToScoreboard(UUID playerId) {
        ServerPlayer player;
        ServerScoreboard scoreboard;
        Objective objective;
        ScoreboardBindingData bindingData;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (bindingData = ScoreboardBindingData.get()).isBound() && (objective = (scoreboard = server.m_129896_()).m_83477_(bindingData.getObjectiveName())) != null && (player = server.m_6846_().m_11259_(playerId)) != null) {
            int score = this.getScore(playerId);
            scoreboard.m_83471_(player.m_6302_(), objective).m_83402_(score);
        }
    }

    public boolean getRankingListEnabled() {
        return !this.rankingListEnabled;
    }

    public void setRankingListEnabled(boolean enabled) {
        this.rankingListEnabled = enabled;
        this.m_77762_();
    }

    public int getCardComboKillDurationTime() {
        return this.cardComboKillDurationTime;
    }

    public void setCardComboKillDurationTime(int duration) {
        this.cardComboKillDurationTime = Math.max(0, Math.min(duration, 3600));
        this.m_77762_();
    }

    public void setScoreLimit(int limit) {
        this.scoreLimit = Math.max(1, Math.min(limit, 0x7FFFFFFE));
        this.m_77762_();
    }

    public Map<UUID, Integer> getAllScores() {
        return new HashMap<UUID, Integer>(this.playerScores);
    }
}

