/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BurstIconRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random RANDOM = new Random();
    private static ResourceLocation VANALLA_KILL_ICON;
    private static ResourceLocation VANALLA_ULTIMATE_ICON;
    private static ResourceLocation VANALLA_ASSIST_ICON;
    public static List<BurstIconInstance> activeIcons;
    public static List<FragmentInstance> activeFragments;

    public void loadResources() {
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_KILL_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/burstmode/kill_icon.png"));
        VANALLA_ULTIMATE_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/burstmode/ultimate_icon.png"));
        VANALLA_ASSIST_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/burstmode/assist_icon.png"));
    }

    public void handleBurstMode(String weaponName, String targetName, boolean isCritical, boolean playUltimateSound, boolean isAssist) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        this.createBurstEffect();
        int iconSize = BurstIconRenderer.getCurrentIconSize();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        float startX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float startY = screenHeight + 100;
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = (float)screenHeight / 2.0f + (float)pos.iconY;
        BurstIconInstance newIcon = new BurstIconInstance(System.currentTimeMillis(), startX - (float)iconSize / 2.0f, startY, targetX - (float)iconSize / 2.0f, targetY, isCritical, isAssist);
        activeIcons.add(newIcon);
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            SoundEvent sound = isAssist ? BurstIconRenderer.getAssistKillSound() : BurstIconRenderer.getKillSound(playUltimateSound);
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)volume));
        }
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
        KillIconRenderer.latestIsCritical = isCritical;
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
    }

    private void createBurstEffect() {
        if (!activeIcons.isEmpty()) {
            BurstIconInstance oldIcon = activeIcons.get(activeIcons.size() - 1);
            for (int i = 0; i < Config.burstFragmentCount; ++i) {
                FragmentInstance fragment = new FragmentInstance(System.currentTimeMillis(), oldIcon.currentX + oldIcon.scale * 16.0f, oldIcon.currentY + oldIcon.scale * 16.0f, oldIcon.texture, oldIcon.isCritical);
                activeFragments.add(fragment);
            }
            activeIcons.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderIcons(GuiGraphics guiGraphics, PoseStack poseStack, long currentTime) {
        if (activeIcons.isEmpty() && activeFragments.isEmpty()) {
            return;
        }
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            Iterator<BurstIconInstance> iconIterator = activeIcons.iterator();
            while (iconIterator.hasNext()) {
                BurstIconInstance icon = iconIterator.next();
                this.updateIconAnimation(icon, currentTime);
                if (icon.alpha <= 0.0f) {
                    iconIterator.remove();
                    continue;
                }
                this.renderBurstIcon(guiGraphics, poseStack, icon);
            }
            Iterator<FragmentInstance> fragmentIterator = activeFragments.iterator();
            while (fragmentIterator.hasNext()) {
                FragmentInstance fragment = fragmentIterator.next();
                this.updateFragmentAnimation(fragment, currentTime);
                if (fragment.alpha <= 0.0f) {
                    fragmentIterator.remove();
                    continue;
                }
                this.renderFragment(guiGraphics, poseStack, fragment);
            }
        }
        finally {
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    private void updateIconAnimation(BurstIconInstance icon, long currentTime) {
        long elapsed = currentTime - icon.startTime;
        float progress = Math.min((float)elapsed / (float)Config.burstAnimationDuration, 1.0f);
        float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        icon.currentX = Mth.m_14179_((float)easedProgress, (float)icon.currentX, (float)icon.targetX);
        icon.currentY = Mth.m_14179_((float)easedProgress, (float)icon.currentY, (float)icon.targetY);
        icon.scale = Mth.m_14179_((float)easedProgress, (float)1.5f, (float)1.0f);
        if (progress < 0.8f) {
            float shake = (float)(Math.sin(progress * 20.0f) * Config.burstShakeIntensity);
            icon.currentX += shake;
        }
    }

    private void updateFragmentAnimation(FragmentInstance fragment, long currentTime) {
        long elapsed = currentTime - fragment.startTime;
        float progress = Math.min((float)elapsed / 1000.0f, 1.0f);
        fragment.x += fragment.velocityX;
        fragment.y += fragment.velocityY;
        fragment.velocityY += 0.2f;
        fragment.rotation += fragment.rotationSpeed;
        if (progress > 0.5f) {
            fragment.alpha = 1.0f - (progress - 0.5f) * 2.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBurstIcon(GuiGraphics guiGraphics, PoseStack poseStack, BurstIconInstance icon) {
        int iconSize = BurstIconRenderer.getCurrentIconSize();
        int scaledSize = (int)((float)iconSize * icon.scale);
        int offsetX = (iconSize - scaledSize) / 2;
        int offsetY = (iconSize - scaledSize) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)icon.alpha);
        poseStack.m_85836_();
        try {
            poseStack.m_252880_(icon.currentX + (float)offsetX, icon.currentY + (float)offsetY, 0.0f);
            poseStack.m_85841_(icon.scale, icon.scale, 1.0f);
            guiGraphics.m_280163_(icon.texture, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        finally {
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFragment(GuiGraphics guiGraphics, PoseStack poseStack, FragmentInstance fragment) {
        int iconSize = BurstIconRenderer.getCurrentIconSize();
        int fragmentSize = (int)((float)iconSize * fragment.scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)fragment.alpha);
        poseStack.m_85836_();
        try {
            poseStack.m_252880_(fragment.x, fragment.y, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(fragment.rotation));
            poseStack.m_85841_(fragment.scale, fragment.scale, 1.0f);
            guiGraphics.m_280163_(fragment.texture, -fragmentSize / 2, -fragmentSize / 2, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        finally {
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static ResourceLocation getIconTexture(boolean isCritical, boolean isAssist) {
        if (isAssist) {
            return VANALLA_ASSIST_ICON;
        }
        if (isCritical) {
            return VANALLA_ULTIMATE_ICON;
        }
        return VANALLA_KILL_ICON;
    }

    private static int getCurrentIconSize() {
        return Config.burstIconSize;
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        config.iconX = Config.burstIconX;
        config.iconY = Config.burstIconY;
        config.subtitleX = Config.burstSubtitleX;
        config.subtitleY = Config.burstSubtitleY;
        config.scoreX = Config.burstScoreX;
        config.scoreY = Config.burstScoreY;
        config.bonusX = Config.burstBonusX;
        config.bonusY = Config.burstBonusY;
        return config;
    }

    private static SoundEvent getKillSound(boolean isUltimate) {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_VANILLA.get() : (SoundEvent)Gd656killicon.KILL_SOUND_VANILLA.get();
        }
        return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_MODERN.get() : (SoundEvent)Gd656killicon.KILL_SOUND_MODERN.get();
    }

    private static SoundEvent getAssistKillSound() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return (SoundEvent)Gd656killicon.ASSIST_KILL_VANILLA.get();
        }
        return (SoundEvent)Gd656killicon.ASSIST_KILL_MODERN.get();
    }

    static {
        activeIcons = new ArrayList<BurstIconInstance>();
        activeFragments = new ArrayList<FragmentInstance>();
    }

    public static class BurstIconInstance {
        public long startTime;
        public float currentX;
        public float currentY;
        public float targetX;
        public float targetY;
        public float scale;
        public float alpha;
        public boolean isCritical;
        public boolean isAssist;
        public ResourceLocation texture;

        public BurstIconInstance(long startTime, float startX, float startY, float targetX, float targetY, boolean isCritical, boolean isAssist) {
            this.startTime = startTime;
            this.currentX = startX;
            this.currentY = startY;
            this.targetX = targetX;
            this.targetY = targetY;
            this.isCritical = isCritical;
            this.isAssist = isAssist;
            this.scale = 1.5f;
            this.alpha = 1.0f;
            this.texture = BurstIconRenderer.getIconTexture(isCritical, isAssist);
        }
    }

    public static class FragmentInstance {
        public long startTime;
        public float x;
        public float y;
        public float velocityX;
        public float velocityY;
        public float rotation;
        public float rotationSpeed;
        public float scale;
        public float alpha;
        public ResourceLocation texture;
        public boolean isCritical;

        public FragmentInstance(long startTime, float x, float y, ResourceLocation texture, boolean isCritical) {
            this.startTime = startTime;
            this.x = x;
            this.y = y;
            this.texture = texture;
            this.isCritical = isCritical;
            this.alpha = 1.0f;
            this.scale = (float)(Config.burstFragmentSizeMin + (double)RANDOM.nextFloat() * (Config.burstFragmentSizeMax - Config.burstFragmentSizeMin));
            this.velocityX = (RANDOM.nextFloat() - 0.5f) * 10.0f;
            this.velocityY = (RANDOM.nextFloat() - 0.5f) * 10.0f;
            this.rotation = RANDOM.nextFloat() * 360.0f;
            this.rotationSpeed = (RANDOM.nextFloat() - 0.5f) * 10.0f;
        }
    }
}

