/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CardModeRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int killChainTimeout = 60000;
    private static long bottomBarFlashStartTime = 0L;
    private static boolean bottomBarFlashing = false;

    public static void setKillChainTimeout(int timeout) {
        killChainTimeout = timeout;
    }

    public static int getKillChainTimeout() {
        return killChainTimeout;
    }

    private void calculateCardPositions(int comboCount) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetBaseY = screenHeight + pos.iconY;
        comboCount = Math.min(comboCount, 5);
        for (CardInstance card : KillIconRenderer.activeCards) {
            card.startX = card.x;
            card.startY = card.y;
            card.startRotation = card.rotation;
            card.animationStartTime = System.currentTimeMillis();
            card.isAnimating = true;
            card.lightOffsetX = 0.0f;
            card.lightOffsetY = 0.0f;
            card.lightRotation = 0.0f;
            switch (comboCount) {
                case 1: {
                    card.targetX = centerX;
                    card.targetY = targetBaseY;
                    card.targetRotation = 0.0f;
                    card.lightOffsetX = 0.0f;
                    card.lightOffsetY = 0.0f;
                    card.lightRotation = 0.0f;
                    break;
                }
                case 2: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -5.0f;
                        card.lightOffsetX = -10.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = -5.0f;
                        break;
                    }
                    card.targetX = centerX + 10.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 5.0f;
                    card.lightOffsetX = 1.25f;
                    card.lightOffsetY = 0.0f;
                    card.lightRotation = 5.0f;
                    break;
                }
                case 3: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 15.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -10.0f;
                        card.lightOffsetX = -15.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = -10.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX;
                        card.targetY = targetBaseY;
                        card.targetRotation = 0.0f;
                        card.lightOffsetX = 0.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = 0.0f;
                        break;
                    }
                    card.targetX = centerX + 15.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 10.0f;
                    card.lightOffsetX = 2.25f;
                    card.lightOffsetY = 0.0f;
                    card.lightRotation = 10.0f;
                    break;
                }
                case 4: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 15.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -15.0f;
                        card.lightOffsetX = -15.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = -15.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX - 5.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -5.0f;
                        card.lightOffsetX = -5.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = -5.0f;
                        break;
                    }
                    if (card.comboPosition == 2) {
                        card.targetX = centerX + 5.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = 5.0f;
                        card.lightOffsetX = 5.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = 5.0f;
                        break;
                    }
                    card.targetX = centerX + 15.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 15.0f;
                    card.lightOffsetX = 2.75f;
                    card.lightOffsetY = 0.0f;
                    card.lightRotation = 15.0f;
                    break;
                }
                case 5: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 20.0f;
                        card.targetY = targetBaseY + 3.0f;
                        card.targetRotation = -30.0f;
                        card.lightOffsetX = -20.0f;
                        card.lightOffsetY = 3.0f;
                        card.lightRotation = -30.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX - 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -15.0f;
                        card.lightOffsetX = -10.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = -15.0f;
                        break;
                    }
                    if (card.comboPosition == 2) {
                        card.targetX = centerX;
                        card.targetY = targetBaseY;
                        card.targetRotation = 0.0f;
                        card.lightOffsetX = 0.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = 0.0f;
                        break;
                    }
                    if (card.comboPosition == 3) {
                        card.targetX = centerX + 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = 15.0f;
                        card.lightOffsetX = 10.0f;
                        card.lightOffsetY = 0.0f;
                        card.lightRotation = 15.0f;
                        break;
                    }
                    card.targetX = centerX + 20.0f;
                    card.targetY = targetBaseY + 3.0f;
                    card.targetRotation = 30.0f;
                    card.lightOffsetX = 3.0f;
                    card.lightOffsetY = 3.0f;
                    card.lightRotation = 30.0f;
                }
            }
            card.lightTargetX = card.targetX;
            card.lightTargetY = card.targetY;
        }
    }

    private CardInstance createCardInstance(float startX, float startY, long currentTime) {
        int cardWidth = 48;
        int cardHeight = 72;
        int cardTypeIndex = KillIconRenderer.cardComboCount - 1;
        CardInstance card = new CardInstance(currentTime, startX, startY, cardTypeIndex, cardWidth, cardHeight, KillIconRenderer.cardComboCount - 1);
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        card.targetX = (float)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0f + (float)pos.iconX;
        card.targetY = Minecraft.m_91087_().m_91268_().m_85446_() + pos.iconY;
        CardModeRenderer.updateCardLightTexture(card);
        return card;
    }

    private static float easeOutBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(x - 1.0f, 3.0) + c1 * (float)Math.pow(x - 1.0f, 2.0);
    }

    private static SoundEvent getCardKillSound() {
        return Gd656killicon.getCardKillSound();
    }

    private static ResourceLocation getCardTexture(int cardIndex) {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        Object cardFileName = cardIndex < 4 ? "killcard_" + (cardIndex + 1) + ".png" : "killcard_ace.png";
        return ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/" + (String)cardFileName));
    }

    private static ResourceLocation getBottomBarTexture() {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        return ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/bottom_bar.png"));
    }

    private static RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
            }
        }
        return config;
    }

    private void handleAceCardMode(long currentTime) {
        Minecraft mc = Minecraft.m_91087_();
        if (KillIconRenderer.cardComboCount == 6) {
            this.startAceFormationAnimation(currentTime);
        } else {
            this.handleNormalAceCard(currentTime);
        }
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            SoundEvent sound = CardModeRenderer.getCardKillSound();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)volume));
        }
        KillIconRenderer.latestWeaponName = "";
        KillIconRenderer.latestTargetName = "";
        KillIconRenderer.textAnimationStartTime = 0L;
    }

    public void handleCardMode() {
        long currentTime;
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        CardModeRenderer.getCurrentPosition();
        float startX = (float)screenWidth / 2.0f + (float)Config.cardIconX;
        float startY = screenHeight + Config.cardIconY;
        KillIconRenderer.lastKillTime = currentTime = System.currentTimeMillis();
        if (Config.cardBottombarVisible) {
            bottomBarFlashStartTime = currentTime;
            bottomBarFlashing = true;
        }
        for (CardInstance card : KillIconRenderer.activeCards) {
            if (!card.lightVisible) continue;
            this.startLightRemoveAnimation(card, currentTime);
        }
        if (++KillIconRenderer.cardComboCount == 6) {
            this.startAceFormationAnimation(currentTime);
        } else if (KillIconRenderer.cardComboCount >= 7) {
            this.handleAceCardMode(currentTime);
        } else {
            CardInstance newCard = this.createCardInstance(startX, startY, currentTime);
            KillIconRenderer.activeCards.add(newCard);
            this.calculateCardPositions(KillIconRenderer.cardComboCount);
        }
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            SoundEvent sound = CardModeRenderer.getCardKillSound();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)volume));
        }
        KillIconRenderer.latestWeaponName = "";
        KillIconRenderer.latestTargetName = "";
        KillIconRenderer.textAnimationStartTime = 0L;
    }

    private void handleNormalAceCard(long currentTime) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        float originX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float originY = screenHeight + pos.iconY;
        int cardWidth = 48;
        int cardHeight = 72;
        CardInstance aceCard = new CardInstance(currentTime, originX, originY, 4, cardWidth, cardHeight, 0);
        aceCard.isAceCard = true;
        aceCard.scale = 0.75f;
        aceCard.brightness = 1024.0f;
        aceCard.isAnimating = true;
        aceCard.animationStartTime = currentTime;
        aceCard.targetX = originX;
        aceCard.targetY = originY;
        aceCard.targetRotation = 0.0f;
        aceCard.startX = originX;
        aceCard.startY = originY;
        aceCard.startRotation = 0.0f;
        aceCard.lightOffsetX = 0.0f;
        aceCard.lightOffsetY = 0.0f;
        aceCard.lightRotation = 0.0f;
        CardModeRenderer.updateCardLightTexture(aceCard);
        KillIconRenderer.activeCards.add(aceCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderCards(GuiGraphics guiGraphics, PoseStack poseStack, long currentTime) {
        KillIconRenderer.resetComboIfNeeded();
        if (KillIconRenderer.activeCards.isEmpty()) {
            return;
        }
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        try {
            Iterator<CardInstance> iterator = KillIconRenderer.activeCards.iterator();
            boolean chainEnded = false;
            if (killChainTimeout > 0) {
                boolean bl = chainEnded = currentTime - KillIconRenderer.lastKillTime > (long)killChainTimeout;
            }
            if (chainEnded) {
                long fadeElapsed = currentTime - KillIconRenderer.lastKillTime - (long)killChainTimeout;
                float fadeProgress = Mth.m_14036_((float)((float)fadeElapsed / 1000.0f), (float)0.0f, (float)1.0f);
                for (CardInstance card : KillIconRenderer.activeCards) {
                    card.alpha = 1.0f - fadeProgress;
                }
                if (fadeProgress >= 1.0f) {
                    KillIconRenderer.activeCards.clear();
                    return;
                }
            } else {
                for (CardInstance card : KillIconRenderer.activeCards) {
                    if (!(card.alpha < 1.0f)) continue;
                    card.alpha = 1.0f;
                }
            }
            for (CardInstance card : KillIconRenderer.activeCards) {
                long elapsed = currentTime - card.startTime;
                CardModeRenderer.updateCardAnimation(card, elapsed, currentTime);
                if (!card.lightVisible || !(card.lightAlpha > 0.0f)) continue;
                CardModeRenderer.renderLightEffect(guiGraphics, poseStack, card);
            }
            for (CardInstance card : KillIconRenderer.activeCards) {
                CardModeRenderer.renderSingleCard(guiGraphics, poseStack, card);
            }
            if (Config.iconMode == Config.IconMode.CARD && Config.cardBottombarVisible) {
                CardModeRenderer.renderBottomBar(guiGraphics, poseStack);
            }
        }
        finally {
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderBottomBar(GuiGraphics guiGraphics, PoseStack poseStack) {
        if (!Config.cardBottombarVisible) {
            return;
        }
        float brightness = 1.0f;
        if (bottomBarFlashing) {
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - bottomBarFlashStartTime;
            if (elapsed < 100L) {
                progress = Mth.m_14036_((float)((float)elapsed / 100.0f), (float)0.0f, (float)1.0f);
                brightness = 1.0f + 1.5f * progress;
            } else if (elapsed < 200L) {
                progress = Mth.m_14036_((float)((float)(elapsed - 100L) / 100.0f), (float)0.0f, (float)1.0f);
                brightness = 2.5f - 1.5f * progress;
            } else {
                brightness = 1.0f;
                bottomBarFlashing = false;
            }
        }
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.9f);
            poseStack.m_85836_();
            try {
                Minecraft mc = Minecraft.m_91087_();
                int screenWidth = mc.m_91268_().m_85445_();
                int screenHeight = mc.m_91268_().m_85446_();
                RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
                float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
                float originY = screenHeight + pos.iconY + Config.cardBottombarOffsetY;
                float scale = (float)Config.cardBottombarSize / 100.0f * 0.25f;
                int width = (int)(256.0f * scale);
                int height = (int)(256.0f * scale);
                float renderX = centerX - (float)width / 2.0f;
                float renderY = originY - (float)height / 2.0f;
                ResourceLocation bottomBarTexture = CardModeRenderer.getBottomBarTexture();
                guiGraphics.m_280411_(bottomBarTexture, (int)renderX, (int)renderY, width, height, 0.0f, 0.0f, 2400, 256, 2400, 256);
            }
            finally {
                poseStack.m_85849_();
            }
        }
        finally {
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderLightEffect(GuiGraphics guiGraphics, PoseStack poseStack, CardInstance card) {
        if (card.lightTexture == null || card.lightAlpha <= 0.0f) {
            return;
        }
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)card.lightBrightness, (float)card.lightBrightness, (float)card.lightBrightness, (float)card.lightAlpha);
            poseStack.m_85836_();
            try {
                float scaleToCardWidth = (float)card.cardWidth * card.scale / 248.0f;
                float baseScale = card.lightScale;
                float scaledLightWidth = 248.0f * scaleToCardWidth * baseScale;
                float scaledLightHeight = 2048.0f * scaleToCardWidth * baseScale;
                float lightX = card.x + card.lightOffsetX - scaledLightWidth / 2.0f;
                float lightY = card.y + card.lightOffsetY + (float)card.lightYOffset - scaledLightHeight / 2.0f;
                poseStack.m_252880_(lightX, lightY, 0.0f);
                if (card.lightRotation != 0.0f) {
                    poseStack.m_252880_(scaledLightWidth / 2.0f, scaledLightHeight / 2.0f, 0.0f);
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(card.lightRotation));
                    poseStack.m_252880_(-scaledLightWidth / 2.0f, -scaledLightHeight / 2.0f, 0.0f);
                }
                guiGraphics.m_280411_(card.lightTexture, 0, 0, (int)scaledLightWidth, (int)scaledLightHeight, 0.0f, 0.0f, 248, 2048, 248, 2048);
            }
            finally {
                poseStack.m_85849_();
            }
        }
        finally {
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderSingleCard(GuiGraphics guiGraphics, PoseStack poseStack, CardInstance card) {
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float finalScale = card.scale;
            float finalBrightness = card.brightness;
            RenderSystem.setShaderColor((float)finalBrightness, (float)finalBrightness, (float)finalBrightness, (float)card.alpha);
            poseStack.m_85836_();
            try {
                float centerX = card.x - (float)card.cardWidth * finalScale / 2.0f;
                float centerY = card.y - (float)card.cardHeight * finalScale / 2.0f;
                poseStack.m_252880_(centerX + (float)card.cardWidth * finalScale / 2.0f, centerY + (float)card.cardHeight * finalScale / 2.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(card.rotation));
                poseStack.m_252880_(-((float)card.cardWidth * finalScale) / 2.0f, -((float)card.cardHeight * finalScale) / 2.0f, 0.0f);
                poseStack.m_85841_(finalScale, finalScale, 1.0f);
                ResourceLocation cardTexture = CardModeRenderer.getCardTexture(card.cardIndex);
                guiGraphics.m_280163_(cardTexture, 0, 0, 0.0f, 0.0f, card.cardWidth, card.cardHeight, card.cardWidth, card.cardHeight);
            }
            finally {
                poseStack.m_85849_();
            }
        }
        finally {
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    private void startAceFormationAnimation(long currentTime) {
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float centerY = screenHeight + pos.iconY;
        Iterator<CardInstance> iterator = KillIconRenderer.activeCards.iterator();
        while (iterator.hasNext()) {
            CardInstance card = iterator.next();
            if (!card.isAceCard) continue;
            iterator.remove();
        }
        for (CardInstance cardInstance : KillIconRenderer.activeCards) {
            cardInstance.isFormingAce = true;
            cardInstance.targetX = centerX;
            cardInstance.targetY = centerY;
            cardInstance.targetRotation = 0.0f;
            cardInstance.animationStartTime = currentTime;
            cardInstance.isAnimating = true;
            cardInstance.lightOffsetX = 0.0f;
            cardInstance.lightOffsetY = 0.0f;
            cardInstance.lightRotation = 0.0f;
            if (cardInstance.cardIndex == 4) continue;
            cardInstance.shouldRemoveAfterAce = true;
        }
        boolean hasAceCard = false;
        for (CardInstance card : KillIconRenderer.activeCards) {
            if (card.cardIndex != 4) continue;
            hasAceCard = true;
            card.isAceCard = true;
            card.alpha = 0.0f;
            card.lightStartTime = currentTime;
            card.lightVisible = true;
            card.lightAlpha = 0.0f;
            card.lightBrightness = 1.0f;
            card.lightYOffset = 200;
            card.lightScale = 1.0f;
            break;
        }
        if (!hasAceCard) {
            int n = 48;
            int cardHeight = 72;
            CardInstance aceCard = new CardInstance(currentTime, centerX, centerY, 4, n, cardHeight, 4);
            aceCard.isAceCard = true;
            aceCard.alpha = 0.0f;
            aceCard.isFormingAce = true;
            aceCard.lightStartTime = currentTime;
            aceCard.lightVisible = true;
            aceCard.lightAlpha = 0.0f;
            aceCard.lightBrightness = 1.0f;
            aceCard.lightYOffset = 200;
            aceCard.lightScale = 1.0f;
            KillIconRenderer.activeCards.add(aceCard);
        }
    }

    private void startLightRemoveAnimation(CardInstance card, long currentTime) {
        if (!card.lightVisible) {
            return;
        }
        long elapsedInCurrentPhase = currentTime - card.lightStartTime;
        if (elapsedInCurrentPhase < 500L) {
            card.lightStartTime = currentTime - 500L;
        } else if (elapsedInCurrentPhase < 3000L) {
            long remainingFadeTime = 3000L - elapsedInCurrentPhase;
            card.lightStartTime = currentTime - (3000L - Math.min(remainingFadeTime, 500L));
        }
    }

    private static void updateCardAnimation(CardInstance card, long elapsed, long currentTime) {
        float elapsedSeconds = (float)elapsed / 1000.0f;
        long animElapsed = currentTime - card.animationStartTime;
        float animProgress = Mth.m_14036_((float)((float)animElapsed / 500.0f), (float)0.0f, (float)1.0f);
        float easedProgress = 1.0f - (float)Math.pow(1.0f - animProgress, 3.0);
        if (card.isFormingAce) {
            card.x = Mth.m_14179_((float)easedProgress, (float)card.startX, (float)card.targetX);
            card.y = Mth.m_14179_((float)easedProgress, (float)card.startY, (float)card.targetY);
            card.rotation = Mth.m_14179_((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
            if (card.isAceCard) {
                card.alpha = Mth.m_14036_((float)(animProgress * 2.0f), (float)0.0f, (float)1.0f);
            }
            if (animProgress >= 1.0f) {
                card.isFormingAce = false;
                if (card.shouldRemoveAfterAce) {
                    card.alpha = 0.0f;
                }
            }
        } else if (card.isAceCard && KillIconRenderer.cardComboCount >= 7) {
            if (card.isAnimating) {
                card.x = Mth.m_14179_((float)easedProgress, (float)card.startX, (float)card.targetX);
                card.y = Mth.m_14179_((float)easedProgress, (float)card.startY, (float)card.targetY);
                card.rotation = Mth.m_14179_((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
                if (animProgress >= 1.0f) {
                    card.isAnimating = false;
                }
            }
        } else if (card.isAnimating) {
            card.x = Mth.m_14179_((float)easedProgress, (float)card.startX, (float)card.targetX);
            card.y = Mth.m_14179_((float)easedProgress, (float)card.startY, (float)card.targetY);
            card.rotation = Mth.m_14179_((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
            if (animProgress >= 1.0f) {
                card.isAnimating = false;
            }
        }
        if (elapsedSeconds < 0.5f) {
            card.brightness = 2.0f;
        } else if (elapsedSeconds < 0.8f) {
            float progress = Mth.m_14036_((float)((elapsedSeconds - 0.5f) / 0.3f), (float)0.0f, (float)1.0f);
            card.brightness = 2.0f * (1.0f - progress) + progress;
        } else {
            card.brightness = 1.0f;
        }
        CardModeRenderer.updateLightAnimation(card, currentTime);
    }

    private static void updateCardLightTexture(CardInstance card) {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        card.lightTexture = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/light.png"));
    }

    private static void updateLightAnimation(CardInstance card, long currentTime) {
        if (!card.lightVisible) {
            return;
        }
        long lightElapsed = currentTime - card.lightStartTime;
        if (lightElapsed < 500L) {
            float progress = Mth.m_14036_((float)((float)lightElapsed / 500.0f), (float)0.0f, (float)1.0f);
            float easedProgress = CardModeRenderer.easeOutBack(progress);
            card.lightYOffset = (int)Mth.m_14179_((float)easedProgress, (float)200.0f, (float)0.0f);
            if (lightElapsed < 100L) {
                float flashProgress = Mth.m_14036_((float)((float)lightElapsed / 100.0f), (float)0.0f, (float)1.0f);
                float easedFlash = flashProgress * flashProgress;
                card.lightBrightness = Mth.m_14179_((float)easedFlash, (float)1.0f, (float)2.5f);
            } else if (lightElapsed < 200L) {
                float flashProgress = Mth.m_14036_((float)((float)(lightElapsed - 100L) / 100.0f), (float)0.0f, (float)1.0f);
                float easedFlash = flashProgress * flashProgress;
                card.lightBrightness = Mth.m_14179_((float)easedFlash, (float)2.5f, (float)1.0f);
            } else {
                card.lightBrightness = 1.0f;
            }
            card.lightAlpha = easedProgress * 0.25f;
            card.lightScale = 1.0f;
        } else if (lightElapsed < 3000L) {
            card.lightYOffset = 0;
            card.lightBrightness = 1.0f;
            float scaleElapsed = lightElapsed - 500L;
            float scaleProgress = Mth.m_14036_((float)(scaleElapsed / 3000.0f), (float)0.0f, (float)1.0f);
            float easedScaleProgress = 1.0f - (float)Math.pow(1.0f - scaleProgress, 2.0);
            card.lightScale = 1.0f - easedScaleProgress * 0.2f;
            float fadeProgress = Mth.m_14036_((float)(scaleElapsed / 2500.0f), (float)0.0f, (float)1.0f);
            float easedFadeProgress = 1.0f - (float)Math.pow(1.0f - fadeProgress, 3.0);
            card.lightAlpha = 0.25f * (1.0f - easedFadeProgress);
        } else {
            card.lightAlpha = 0.0f;
            card.lightVisible = false;
        }
        CardModeRenderer.updateLightPosition(card);
    }

    private static void updateLightPosition(CardInstance card) {
        card.lightX = card.x;
        float cardBottomY = card.y + (float)card.cardHeight * card.scale / 2.0f;
        card.lightY = cardBottomY - card.lightOffsetY;
    }

    public static class CardInstance {
        public float alpha;
        public long animationStartTime;
        public float brightness;
        public int cardHeight;
        public int cardIndex;
        public int cardWidth;
        public int comboPosition;
        public boolean isAceCard = false;
        public boolean isAnimating;
        public boolean isFormingAce = false;
        public float rotation;
        public float scale;
        public boolean shouldRemoveAfterAce = false;
        public long startTime;
        public float startRotation;
        public float startX;
        public float startY;
        public float targetRotation;
        public float targetX;
        public float targetY;
        public float x;
        public float y;
        public float lightAlpha;
        public float lightBrightness;
        public float lightOffsetX = 0.0f;
        public float lightOffsetY;
        public float lightRotation = 0.0f;
        public float lightScale;
        public long lightStartTime;
        public ResourceLocation lightTexture;
        public float lightTargetX;
        public float lightTargetY;
        public boolean lightVisible;
        public float lightX;
        public float lightY;
        private int lightYOffset;

        public CardInstance(long startTime, float x, float y, int cardIndex, int width, int height, int comboPosition) {
            this.startTime = startTime;
            this.x = x;
            this.y = y;
            this.startX = x;
            this.startY = y;
            this.targetX = x;
            this.targetY = y - 30.0f;
            this.brightness = 1024.0f;
            this.scale = 0.75f;
            this.alpha = 1.0f;
            this.cardIndex = cardIndex;
            this.cardWidth = width;
            this.cardHeight = height;
            this.rotation = 0.0f;
            this.targetRotation = 0.0f;
            this.startRotation = 0.0f;
            this.animationStartTime = startTime;
            this.isAnimating = true;
            this.comboPosition = comboPosition;
            this.lightStartTime = startTime;
            this.lightVisible = true;
            this.lightAlpha = 0.0f;
            this.lightBrightness = 1.0f;
            this.lightOffsetY = height * 2;
            this.lightYOffset = 200;
            this.lightScale = 1.0f;
            this.updateLightTexture();
        }

        private void updateLightTexture() {
            String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
            this.lightTexture = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/light.png"));
        }
    }
}

