/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.BurstIconRenderer;
import org.mods.gd656killicon.client.CardModeRenderer;
import org.mods.gd656killicon.client.ComboIconRenderer;
import org.mods.gd656killicon.client.ComboScoreRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.ScoreItemRenderer;
import org.mods.gd656killicon.client.ScrollingIconRenderer;
import org.mods.gd656killicon.client.SubtitleRenderer;
import org.mods.gd656killicon.client.configmenu.HistoryRecordScreen;
import org.mods.gd656killicon.util.ClientUtil;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class KillIconRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int KILL_CHAIN_TIMEOUT = 3000;
    private static final long LONG_RANGE_DISPLAY_DURATION = 3000L;
    private static final int COMBO_KILL_BONUS_MULTIPLIER = 8;
    public static Config.IconStyle currentIconStyle = null;
    public static Config.IconStyle currentCardIconStyle = null;
    public static ResourceLocation[] currentCardIcons;
    public static final List<ScrollingIconRenderer.KillIconInstance> activeIcons;
    public static final List<CardModeRenderer.CardInstance> activeCards;
    public static final List<ScoreItemRenderer.ScoreItem> activeScoreItems;
    public static final Queue<ScoreItemRenderer.ScoreItem> scoreItems;
    public static String latestWeaponName;
    public static String latestTargetName;
    public static long textAnimationStartTime;
    public static long textHideTime;
    public static long lastKillTime;
    public static boolean isFadingOutAll;
    public static boolean latestIsCritical;
    public static int comboCount;
    public static long lastComboTime;
    public static int comboScore;
    public static int displayedComboScore;
    public static int targetComboScore;
    public static long lastScoreUpdateTime;
    public static long comboScoreShowTime;
    public static boolean isComboScoreVisible;
    public static int scoreAnimationStart;
    public static long lastDamageTime;
    public static boolean isFlashing;
    public static int flashCount;
    public static long lastFlashTime;
    public static boolean latestIsAssist;
    public static boolean DEBUG;
    private static boolean isRendering;
    public static int longRangeDistance;
    public static int longRangeBonus;
    public static long longRangeShowTime;
    public static ScoreItemRenderer.ScoreItem comboKillItem;
    public static int lastComboCount;
    public static final long comboKillAnimationStart = 0L;
    public static long renderTimeSum;
    public static int renderCount;
    public static float subtitleBrightness;
    public static float subtitleScale;
    public static long subtitleAnimationStartTime;
    public static int cardComboCount;
    public static long groupDisplayStartTime;
    public static boolean isGroupDisplaying;
    public static boolean shouldStartFadeOut;
    static ScrollingIconRenderer scrollingRenderer;
    static ComboIconRenderer comboRenderer;
    private static final CardModeRenderer cardRenderer;
    private static final BurstIconRenderer burstRenderer;
    private static final SubtitleRenderer subtitleRenderer;
    private static final ComboScoreRenderer comboScoreRenderer;
    private static final RenderHelper renderHelper;

    public static void triggerKillIcon(String weaponName, String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist) {
        String reason;
        if (Config.iconMode != Config.IconMode.CARD) {
            subtitleBrightness = 4.0f;
            subtitleScale = 1.5f;
            subtitleAnimationStartTime = System.currentTimeMillis();
        }
        long currentTime = System.currentTimeMillis();
        KillIconRenderer.addHistoryRecord(weaponName, targetName, isCritical, isAssist, killScore);
        if (currentTime - lastComboTime > (long)Config.comboTimeoutMs) {
            comboCount = 0;
            lastComboCount = 0;
            KillIconRenderer.resetComboIfNeeded();
            if (comboKillItem != null) {
                activeScoreItems.remove(comboKillItem);
                comboKillItem = null;
            }
        }
        lastComboTime = currentTime;
        if (++comboCount >= 2 && Config.iconMode != Config.IconMode.CARD) {
            int comboBonus = comboCount * 8;
            if (comboKillItem == null) {
                comboKillItem = new ScoreItemRenderer.ScoreItem("\u8fde\u6740 ! +", comboBonus, currentTime, false);
                KillIconRenderer.comboKillItem.isComboKill = true;
                KillIconRenderer.comboKillItem.comboNumber = comboCount;
                KillIconRenderer.comboKillItem.displayDuration = 3000L;
                activeScoreItems.add(0, comboKillItem);
            } else {
                KillIconRenderer.comboKillItem.targetPoints = comboBonus;
                KillIconRenderer.comboKillItem.animationStartTime = currentTime;
                KillIconRenderer.comboKillItem.initialPoints = KillIconRenderer.comboKillItem.currentPoints;
                KillIconRenderer.comboKillItem.comboNumber = comboCount;
                KillIconRenderer.comboKillItem.startTime = currentTime;
            }
        }
        latestIsAssist = isAssist;
        latestIsCritical = isCritical;
        String string = reason = isAssist ? "\u52a9\u653b\u51fb\u8d25" : "\u51fb\u8d25\u751f\u7269";
        if (Config.iconMode != Config.IconMode.CARD) {
            KillIconRenderer.addScore(killScore, reason, isCritical);
        }
        KillIconRenderer.resetGroupDisplayTimer();
        switch (Config.iconMode) {
            case SCROLLING: {
                scrollingRenderer.handleScrollingMode(weaponName, targetName, isCritical, playUltimateSound, isAssist);
                break;
            }
            case COMBO: {
                ComboIconRenderer.handleComboMode(weaponName, targetName, isCritical, isAssist);
                break;
            }
            case CARD: {
                cardRenderer.handleCardMode();
                break;
            }
            case BURST: {
                burstRenderer.handleBurstMode(weaponName, targetName, isCritical, playUltimateSound, isAssist);
            }
        }
        if (Config.iconMode == Config.IconMode.SCROLLING) {
            scrollingRenderer.updateAllIconTargetPositions();
        }
        lastKillTime = System.currentTimeMillis();
        isFadingOutAll = false;
        if (Config.iconMode != Config.IconMode.CARD) {
            latestWeaponName = weaponName;
            latestTargetName = targetName;
            textAnimationStartTime = currentTime;
        } else {
            latestWeaponName = "";
            latestTargetName = "";
            textAnimationStartTime = 0L;
        }
        textHideTime = 0L;
    }

    private static void resetGroupDisplayTimer() {
        groupDisplayStartTime = System.currentTimeMillis();
        isGroupDisplaying = true;
        shouldStartFadeOut = false;
        isFadingOutAll = false;
        for (ScrollingIconRenderer.KillIconInstance icon : activeIcons) {
            icon.fadeStartTime = -1L;
        }
    }

    private static void updateGroupDisplayTimer(long currentTime) {
        if (!isGroupDisplaying || activeIcons.isEmpty()) {
            return;
        }
        long displayDuration = (long)Config.killIconDuration * 50L;
        if (currentTime - groupDisplayStartTime > displayDuration && !shouldStartFadeOut) {
            shouldStartFadeOut = true;
            scrollingRenderer.startFadeOutSequence(currentTime);
        }
    }

    public static void addScore(float points, String reason, boolean isCritical) {
        long currentTime;
        if (points <= 0.0f) {
            return;
        }
        if (!Config.showComboScore) {
            return;
        }
        lastDamageTime = currentTime = System.currentTimeMillis();
        scoreAnimationStart = displayedComboScore == targetComboScore ? displayedComboScore : targetComboScore;
        int roundedPoints = Math.round(points);
        targetComboScore = comboScore += roundedPoints;
        lastScoreUpdateTime = currentTime;
        boolean isLongRange = reason.startsWith("\u8fdc\u8ddd\u79bb\u51fb\u8d25");
        String expectedBaseText = RenderHelper.getString(reason);
        boolean found = false;
        for (ScoreItemRenderer.ScoreItem item : activeScoreItems) {
            String[] parts;
            if (!item.baseText.equals(expectedBaseText) || (!item.isLongRange || !isLongRange) && (item.isLongRange || isLongRange)) continue;
            item.initialPoints = item.currentPoints;
            item.targetPoints += points;
            item.animationStartTime = currentTime;
            item.lastUpdateTime = currentTime;
            item.startTime = currentTime;
            if (isLongRange && (parts = reason.split(" ")).length >= 2) {
                item.distance = parts[1].replace("\u7c73", "m");
            }
            found = true;
            break;
        }
        if (!found) {
            String[] parts;
            ScoreItemRenderer.ScoreItem newItem = new ScoreItemRenderer.ScoreItem(expectedBaseText, points, currentTime, isLongRange);
            newItem.initialPoints = 0.0f;
            newItem.animationStartTime = currentTime;
            if (isLongRange && (parts = reason.split(" ")).length >= 2) {
                newItem.distance = parts[1].replace("\u7c73", "m");
            }
            activeScoreItems.add(newItem);
        }
        if (isCritical && (reason.equals("\u51fb\u8d25\u751f\u7269") || reason.equals("\u52a9\u653b\u51fb\u8d25"))) {
            float critBonus = points * 0.25f;
            int roundedCritBonus = Math.round(critBonus);
            targetComboScore = comboScore += roundedCritBonus;
            boolean critFound = false;
            for (ScoreItemRenderer.ScoreItem item : activeScoreItems) {
                if (!item.baseText.equals("\u66b4\u51fb\u52a0\u6210 +")) continue;
                item.initialPoints = item.currentPoints;
                item.targetPoints += critBonus;
                item.animationStartTime = currentTime;
                item.lastUpdateTime = currentTime;
                item.startTime = currentTime;
                critFound = true;
                break;
            }
            if (!critFound) {
                ScoreItemRenderer.ScoreItem critItem = new ScoreItemRenderer.ScoreItem("\u66b4\u51fb\u52a0\u6210 +", critBonus, currentTime, false);
                critItem.initialPoints = 0.0f;
                critItem.animationStartTime = currentTime;
                activeScoreItems.add(critItem);
            }
        }
        if (!isComboScoreVisible) {
            isComboScoreVisible = true;
            comboScoreShowTime = currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderKillIcon(RenderGuiOverlayEvent.Post event) {
        long startTime = System.nanoTime();
        if (currentIconStyle != Config.iconStyle || currentCardIconStyle != Config.cardIconStyle) {
            renderHelper.loadResources();
        }
        if (!ClientUtil.isClient()) {
            return;
        }
        if (isRendering) {
            return;
        }
        isRendering = true;
        try {
            boolean chainEnded;
            if (!(Config.showKillIcons || Config.showKillSubtitles || Config.showComboScore)) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            long currentTime = System.currentTimeMillis();
            KillIconRenderer.updateGroupDisplayTimer(currentTime);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (Config.iconMode == Config.IconMode.CARD) {
                if (Config.cardBottombarVisible) {
                    CardModeRenderer.renderBottomBar(guiGraphics, poseStack);
                }
                cardRenderer.renderCards(guiGraphics, poseStack, currentTime);
                if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
                    subtitleRenderer.renderSubtitles(guiGraphics, currentTime);
                }
                if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SCORE)) {
                    comboScoreRenderer.renderComboScore(guiGraphics, currentTime);
                    KillIconRenderer.renderLongRangeBonus(guiGraphics, currentTime);
                }
                if (Config.debugShowInfo) {
                    KillIconRenderer.addDebugInfo(guiGraphics);
                }
                RenderSystem.disableBlend();
                return;
            }
            boolean bl = chainEnded = currentTime - lastKillTime > 3000L;
            if (chainEnded && !isGroupDisplaying) {
                groupDisplayStartTime = currentTime;
                isGroupDisplaying = true;
            }
            if (activeIcons.isEmpty()) {
                latestWeaponName = "";
                latestTargetName = "";
                latestIsAssist = false;
                textAnimationStartTime = 0L;
            } else if (textAnimationStartTime > 0L) {
                long displayTime = (long)Config.killIconDuration * 80L;
                if (currentTime - textAnimationStartTime > displayTime && textHideTime == 0L) {
                    textHideTime = currentTime + 500L;
                }
                if (textHideTime > 0L && currentTime >= textHideTime) {
                    latestWeaponName = "";
                    latestTargetName = "";
                    latestIsAssist = false;
                    textAnimationStartTime = 0L;
                    textHideTime = 0L;
                }
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.ICON)) {
                if (Config.iconMode == Config.IconMode.SCROLLING) {
                    scrollingRenderer.renderIcons(guiGraphics, poseStack, currentTime);
                } else if (Config.iconMode == Config.IconMode.COMBO) {
                    scrollingRenderer.renderIcons(guiGraphics, poseStack, currentTime);
                }
            }
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
                subtitleRenderer.renderSubtitles(guiGraphics, currentTime);
            }
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SCORE)) {
                comboScoreRenderer.renderComboScore(guiGraphics, currentTime);
                KillIconRenderer.renderLongRangeBonus(guiGraphics, currentTime);
            }
            if (Config.debugShowInfo) {
                KillIconRenderer.addDebugInfo(guiGraphics);
            }
            RenderSystem.disableBlend();
        }
        finally {
            isRendering = false;
        }
        long endTime = System.nanoTime();
        long renderTime = endTime - startTime;
        renderTimeSum += renderTime;
        if (DEBUG && ++renderCount % 60 == 0) {
            long avgRenderTime = renderTimeSum / (long)renderCount;
            renderTimeSum = 0L;
            renderCount = 0;
        }
    }

    private static void renderLongRangeBonus(GuiGraphics guiGraphics, long currentTime) {
        if (currentTime - longRangeShowTime > 3000L) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        float progress = (float)(currentTime - longRangeShowTime) / 3000.0f;
        float alpha = 1.0f;
        if (progress > 0.8f) {
            alpha = 1.0f - (progress - 0.8f) / 0.2f;
        }
        int textY = screenHeight - 100;
        String text = "\u8fdc\u8ddd\u79bb\u51fb\u8d25";
        String distanceText = longRangeDistance + "m";
        String bonusText = " +" + longRangeBonus;
        int textWidth = font.m_92895_(text);
        int distanceWidth = font.m_92895_(distanceText);
        int bonusWidth = font.m_92895_(bonusText);
        int totalWidth = textWidth + distanceWidth + bonusWidth;
        int textX = screenWidth / 2 - totalWidth / 2;
        int whiteColor = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        guiGraphics.m_280056_(font, text, textX, textY, whiteColor, true);
        int goldColor = -10496;
        goldColor = goldColor & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        guiGraphics.m_280056_(font, distanceText, textX += textWidth, textY, goldColor, true);
        guiGraphics.m_280056_(font, bonusText, textX += distanceWidth, textY, whiteColor, true);
    }

    private static void addDebugInfo(GuiGraphics guiGraphics) {
        if (!Config.debugShowInfo) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        List<String> debugInfo = Arrays.asList("GD656Killicon \u8c03\u8bd5\u4fe1\u606f", "\u6d3b\u52a8\u56fe\u6807: " + activeIcons.size(), "\u8fde\u51fb\u5206\u6570: " + displayedComboScore + "/" + targetComboScore, "\u8fde\u51fb\u8ba1\u6570: " + comboCount, "\u6700\u540e\u4f24\u5bb3: " + (System.currentTimeMillis() - lastDamageTime) + "ms\u524d", "\u6d3b\u52a8\u5206\u6570\u9879: " + activeScoreItems.size());
        int y = 10;
        for (String info : debugInfo) {
            guiGraphics.m_280056_(mc.f_91062_, info, 10, y, 0xFFFFFF, false);
            y += 10;
        }
        for (int i = 0; i < activeScoreItems.size(); ++i) {
            ScoreItemRenderer.ScoreItem item = activeScoreItems.get(i);
            String itemInfo = String.format("\u9879 %d: %.1f/%.1f (%s)", i, Float.valueOf(item.currentPoints), Float.valueOf(item.targetPoints), item.baseText);
            guiGraphics.m_280056_(mc.f_91062_, itemInfo, 10, y, 0xFFFFFF, false);
            y += 10;
        }
    }

    public static void showLongRangeBonus(int distance, int bonusPoints) {
        longRangeDistance = distance;
        longRangeBonus = bonusPoints;
        longRangeShowTime = System.currentTimeMillis();
    }

    private static void addHistoryRecord(String weaponName, String targetName, boolean isCritical, boolean isAssist, int killScore) {
        try {
            Object damageInfo = isAssist ? "\u52a9\u653b" : (isCritical ? "\u66b4\u51fb\u51fb\u6740" : "\u51fb\u6740");
            if (killScore > 0) {
                damageInfo = (String)damageInfo + " +" + killScore;
            }
            boolean isPlayer = KillIconRenderer.isPlayerTarget(targetName);
            HistoryRecordScreen.addHistoryRecord(targetName, (String)damageInfo, weaponName, isPlayer, !isAssist);
        }
        catch (Exception e) {
            LOGGER.warn("[\u516d\u4e94\u516d] \u6dfb\u52a0\u5386\u53f2\u8bb0\u5f55\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private static boolean isPlayerTarget(String targetName) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null) {
                if (targetName.equals(mc.f_91074_.m_36316_().getName())) {
                    return true;
                }
                List players = mc.f_91073_.m_6907_();
                for (AbstractClientPlayer player : players) {
                    if (!targetName.equals(player.m_36316_().getName())) continue;
                    return true;
                }
            }
            return targetName.length() <= 16 && !targetName.contains(" ") && !targetName.contains(".") && !targetName.contains("_" + UUID.randomUUID().toString().substring(0, 8));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void clearCardCombo() {
        activeCards.clear();
        cardComboCount = 0;
        lastKillTime = 0L;
    }

    public static boolean shouldResetCombo() {
        if (Config.iconMode == Config.IconMode.CARD) {
            if (CardModeRenderer.getKillChainTimeout() == 0) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            return currentTime - lastKillTime > (long)CardModeRenderer.getKillChainTimeout();
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - lastKillTime > 3000L;
    }

    public static void resetComboIfNeeded() {
        if (KillIconRenderer.shouldResetCombo()) {
            cardComboCount = 0;
            lastKillTime = 0L;
        }
    }

    static {
        activeIcons = new ArrayList<ScrollingIconRenderer.KillIconInstance>();
        activeCards = new ArrayList<CardModeRenderer.CardInstance>();
        activeScoreItems = new ArrayList<ScoreItemRenderer.ScoreItem>();
        scoreItems = new LinkedList<ScoreItemRenderer.ScoreItem>();
        latestWeaponName = "";
        latestTargetName = "";
        textAnimationStartTime = 0L;
        textHideTime = 0L;
        lastKillTime = 0L;
        isFadingOutAll = false;
        latestIsCritical = false;
        comboCount = 0;
        lastComboTime = 0L;
        comboScore = 0;
        displayedComboScore = 0;
        targetComboScore = 0;
        lastScoreUpdateTime = 0L;
        comboScoreShowTime = 0L;
        isComboScoreVisible = false;
        scoreAnimationStart = 0;
        lastDamageTime = 0L;
        isFlashing = false;
        flashCount = 0;
        lastFlashTime = 0L;
        latestIsAssist = false;
        DEBUG = false;
        isRendering = false;
        longRangeDistance = 0;
        longRangeBonus = 0;
        longRangeShowTime = 0L;
        comboKillItem = null;
        lastComboCount = 0;
        renderTimeSum = 0L;
        renderCount = 0;
        subtitleBrightness = 1.0f;
        subtitleScale = 1.0f;
        subtitleAnimationStartTime = 0L;
        cardComboCount = 0;
        groupDisplayStartTime = 0L;
        isGroupDisplaying = false;
        shouldStartFadeOut = false;
        scrollingRenderer = new ScrollingIconRenderer();
        comboRenderer = new ComboIconRenderer();
        cardRenderer = new CardModeRenderer();
        burstRenderer = new BurstIconRenderer();
        subtitleRenderer = new SubtitleRenderer();
        comboScoreRenderer = new ComboScoreRenderer();
        renderHelper = new RenderHelper();
    }
}

